/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.communityprofile.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.server.CommunityRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.CommunitiesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.CommunityResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.PersonRolesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ReferenceableRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelationshipRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/community-profile/users/{userId}"})
@Tag(name="Metadata Access Server: Community Profile OMAS", description="The Community Profile OMAS provides APIs and events for tools and applications that are managing information about people and the way they work together.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omas/community-profile/overview/"))
public class CommunityResource {
    private final CommunityRESTServices restAPI = new CommunityRESTServices();

    @PostMapping(path={"/communities"})
    public GUIDResponse createCommunity(@PathVariable String serverName, @PathVariable String userId, @RequestBody ReferenceableRequestBody requestBody) {
        return this.restAPI.createCommunity(serverName, userId, requestBody);
    }

    @PostMapping(path={"/communities/from-template/{templateGUID}"})
    public GUIDResponse createCommunityFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String templateGUID, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createCommunityFromTemplate(serverName, userId, templateGUID, requestBody);
    }

    @PostMapping(path={"/communities/{communityGUID}"})
    public VoidResponse updateCommunity(@PathVariable String serverName, @PathVariable String userId, @PathVariable String communityGUID, @RequestParam boolean isMergeUpdate, @RequestBody ReferenceableRequestBody requestBody) {
        return this.restAPI.updateCommunity(serverName, userId, communityGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/communities/{communityGUID}/community-roles/{communityRoleGUID}"})
    public VoidResponse setupCommunityRole(@PathVariable String serverName, @PathVariable String userId, @PathVariable String communityGUID, @PathVariable String communityRoleGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupCommunityRole(serverName, userId, communityGUID, communityRoleGUID, requestBody);
    }

    @PostMapping(path={"/communities/{communityGUID}/community-roles/{communityRoleGUID}/delete"})
    public VoidResponse clearCommunityRole(@PathVariable String serverName, @PathVariable String userId, @PathVariable String communityGUID, @PathVariable String communityRoleGUID, @RequestBody ExternalSourceRequestBody requestBody) {
        return this.restAPI.clearCommunityRole(serverName, userId, communityGUID, communityRoleGUID, requestBody);
    }

    @PostMapping(path={"/communities/{communityGUID}/delete"})
    public VoidResponse removeCommunity(@PathVariable String serverName, @PathVariable String userId, @PathVariable String communityGUID, @RequestBody ExternalSourceRequestBody requestBody) {
        return this.restAPI.removeCommunity(serverName, userId, communityGUID, requestBody);
    }

    @PostMapping(path={"/communities/by-search-string"})
    public CommunitiesResponse findCommunities(@PathVariable String serverName, @PathVariable String userId, @RequestBody SearchStringRequestBody requestBody, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.findCommunities(serverName, userId, requestBody, startFrom, pageSize);
    }

    @PostMapping(path={"/communities/by-name"})
    public CommunitiesResponse getCommunitiesByName(@PathVariable String serverName, @PathVariable String userId, @RequestBody NameRequestBody requestBody, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getCommunitiesByName(serverName, userId, requestBody, startFrom, pageSize);
    }

    @GetMapping(path={"/person-roles/by-community/{communityGUID}"})
    public PersonRolesResponse getRolesForCommunity(@PathVariable String serverName, @PathVariable String userId, @PathVariable String communityGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getRolesForCommunity(serverName, userId, communityGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/communities"})
    public CommunitiesResponse getCommunitiesByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getCommunities(serverName, userId, startFrom, pageSize);
    }

    @GetMapping(path={"/communities/{guid}"})
    public CommunityResponse getCommunityByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getCommunityByGUID(serverName, userId, guid);
    }
}

