/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.communityprofile.rest.TemplateRequestBody;
import org.odpi.openmetadata.accessservices.communityprofile.server.LocationRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.ClassificationRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.LocationResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.LocationsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ReferenceableRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelationshipRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/community-profile/users/{userId}"})
@Tag(name="Metadata Access Server: Community Profile OMAS", description="The Community Profile OMAS provides APIs and events for tools and applications that are managing information about people and the way they work together.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omas/community-profile/overview/"))
public class LocationManagementResource {
    private final LocationRESTServices restAPI = new LocationRESTServices();

    @PostMapping(path={"/locations"})
    public GUIDResponse createLocation(@PathVariable String serverName, @PathVariable String userId, @RequestBody ReferenceableRequestBody locationProperties) {
        return this.restAPI.createLocation(serverName, userId, locationProperties);
    }

    @PostMapping(path={"/locations/from-template/{templateGUID}"})
    public GUIDResponse createLocationFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String templateGUID, @RequestBody TemplateRequestBody templateProperties) {
        return this.restAPI.createLocationFromTemplate(serverName, userId, templateGUID, templateProperties);
    }

    @PostMapping(path={"/locations/{locationGUID}/update"})
    public VoidResponse updateLocation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String locationGUID, @RequestParam boolean isMergeUpdate, @RequestBody ReferenceableRequestBody locationProperties) {
        return this.restAPI.updateLocation(serverName, userId, locationGUID, isMergeUpdate, locationProperties);
    }

    @PostMapping(path={"/locations/{locationGUID}/classify-as-fixed-location"})
    public VoidResponse setLocationAsFixedPhysical(@PathVariable String serverName, @PathVariable String userId, @PathVariable String locationGUID, @RequestBody ClassificationRequestBody requestBody) {
        return this.restAPI.setLocationAsFixedPhysical(serverName, userId, locationGUID, requestBody);
    }

    @PostMapping(path={"/locations/{locationGUID}/classify-as-fixed-location/delete"})
    public VoidResponse clearLocationAsFixedPhysical(@PathVariable String serverName, @PathVariable String userId, @PathVariable String locationGUID, @RequestBody(required=false) ExternalSourceRequestBody requestBody) {
        return this.restAPI.clearLocationAsFixedPhysical(serverName, userId, locationGUID, requestBody);
    }

    @PostMapping(path={"/locations/{locationGUID}/classify-as-secure-location"})
    public VoidResponse setLocationAsSecure(@PathVariable String serverName, @PathVariable String userId, @PathVariable String locationGUID, @RequestBody ClassificationRequestBody requestBody) {
        return this.restAPI.setLocationAsSecure(serverName, userId, locationGUID, requestBody);
    }

    @PostMapping(path={"/locations/{locationGUID}/classify-as-secure-location/delete"})
    public VoidResponse clearLocationAsSecure(@PathVariable String serverName, @PathVariable String userId, @PathVariable String locationGUID, @RequestBody(required=false) ExternalSourceRequestBody requestBody) {
        return this.restAPI.clearLocationAsSecure(serverName, userId, locationGUID, requestBody);
    }

    @PostMapping(path={"/locations/{locationGUID}/classify-as-digital-location"})
    public VoidResponse setLocationAsDigital(@PathVariable String serverName, @PathVariable String userId, @PathVariable String locationGUID, @RequestBody ClassificationRequestBody requestBody) {
        return this.restAPI.setLocationAsDigital(serverName, userId, locationGUID, requestBody);
    }

    @PostMapping(path={"/locations/{locationGUID}/classify-as-digital-location/delete"})
    public VoidResponse clearLocationAsDigital(@PathVariable String serverName, @PathVariable String userId, @PathVariable String locationGUID, @RequestBody(required=false) ExternalSourceRequestBody requestBody) {
        return this.restAPI.clearLocationAsDigital(serverName, userId, locationGUID, requestBody);
    }

    @PostMapping(path={"/locations/{locationGUID}/delete"})
    public VoidResponse removeLocation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String locationGUID, @RequestBody(required=false) ExternalSourceRequestBody requestBody) {
        return this.restAPI.removeLocation(serverName, userId, locationGUID, requestBody);
    }

    @PostMapping(path={"/locations/{parentLocationGUID}/has-nested-location/{childLocationGUID}"})
    public VoidResponse setupNestedLocation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String parentLocationGUID, @PathVariable String childLocationGUID, @RequestBody(required=false) RelationshipRequestBody requestBody) {
        return this.restAPI.setupNestedLocation(serverName, userId, parentLocationGUID, childLocationGUID, requestBody);
    }

    @PostMapping(path={"/locations/{parentLocationGUID}/has-nested-location/{childLocationGUID}/delete"})
    public VoidResponse clearNestedLocation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String parentLocationGUID, @PathVariable String childLocationGUID, @RequestBody(required=false) ExternalSourceRequestBody requestBody) {
        return this.restAPI.clearNestedLocation(serverName, userId, parentLocationGUID, childLocationGUID, requestBody);
    }

    @PostMapping(path={"/locations/{locationOneGUID}/linked-to-peer-location/{locationTwoGUID}"})
    public VoidResponse setupAdjacentLocation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String locationOneGUID, @PathVariable String locationTwoGUID, @RequestBody(required=false) RelationshipRequestBody requestBody) {
        return this.restAPI.setupAdjacentLocation(serverName, userId, locationOneGUID, locationTwoGUID, requestBody);
    }

    @PostMapping(path={"/locations/{locationOneGUID}/linked-to-peer-location/{locationTwoGUID}/delete"})
    public VoidResponse clearAdjacentLocation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String locationOneGUID, @PathVariable String locationTwoGUID, @RequestBody(required=false) ExternalSourceRequestBody requestBody) {
        return this.restAPI.clearAdjacentLocation(serverName, userId, locationOneGUID, locationTwoGUID, requestBody);
    }

    @PostMapping(path={"/locations/{locationGUID}/linked-to-actor-profiles/{actorProfileGUID}"})
    public VoidResponse setupProfileLocation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String actorProfileGUID, @PathVariable String locationGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupProfileLocation(serverName, userId, actorProfileGUID, locationGUID, requestBody);
    }

    @PostMapping(path={"/locations/{locationGUID}/linked-to-actor-profiles/{actorProfileGUID}/delete"})
    public VoidResponse clearProfileLocation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String actorProfileGUID, @PathVariable String locationGUID, @RequestBody(required=false) ExternalSourceRequestBody requestBody) {
        return this.restAPI.clearProfileLocation(serverName, userId, actorProfileGUID, locationGUID, requestBody);
    }

    @PostMapping(path={"/locations/{locationGUID}/linked-to-assets/{assetGUID}"})
    public VoidResponse setupAssetLocation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String locationGUID, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupAssetLocation(serverName, userId, assetGUID, locationGUID, requestBody);
    }

    @PostMapping(path={"/locations/{locationGUID}/linked-to-assets/{assetGUID}/delete"})
    public VoidResponse clearAssetLocation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String locationGUID, @RequestBody(required=false) ExternalSourceRequestBody requestBody) {
        return this.restAPI.clearAssetLocation(serverName, userId, assetGUID, locationGUID, requestBody);
    }

    @PostMapping(path={"/locations/by-search-string"})
    public LocationsResponse findLocations(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findLocations(serverName, userId, requestBody, startFrom, pageSize);
    }

    @PostMapping(path={"/locations/by-name"})
    public LocationsResponse getLocationsByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getLocationsByName(serverName, userId, requestBody, startFrom, pageSize);
    }

    @GetMapping(path={"/locations/{locationGUID}/has-peer-locations"})
    public LocationsResponse getAdjacentLocations(@PathVariable String serverName, @PathVariable String userId, @PathVariable String locationGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getAdjacentLocations(serverName, userId, locationGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/locations/{locationGUID}/has-nested-locations"})
    public LocationsResponse getNestedLocations(@PathVariable String serverName, @PathVariable String userId, @PathVariable String locationGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getNestedLocations(serverName, userId, locationGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/locations/{locationGUID}/has-grouping-locations"})
    public LocationsResponse getGroupingLocations(@PathVariable String serverName, @PathVariable String userId, @PathVariable String locationGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getGroupingLocations(serverName, userId, locationGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/locations/by-actor-profile/{actorProfileGUID}"})
    public LocationsResponse getLocationsByProfile(@PathVariable String serverName, @PathVariable String userId, @PathVariable String actorProfileGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getLocationsByProfile(serverName, userId, actorProfileGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/locations/by-asset/{assetGUID}"})
    public LocationsResponse getKnownLocationsForAsset(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getKnownLocationsForAsset(serverName, userId, assetGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/locations"})
    public LocationsResponse getLocations(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getLocations(serverName, userId, startFrom, pageSize);
    }

    @GetMapping(path={"/locations/{locationGUID}"})
    public LocationResponse getLocationByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String locationGUID) {
        return this.restAPI.getLocationByGUID(serverName, userId, locationGUID);
    }
}

