/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.communityprofile.connectors.outtopic;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.communityprofile.api.CommunityProfileEventInterface;
import org.odpi.openmetadata.accessservices.communityprofile.api.CommunityProfileEventListener;
import org.odpi.openmetadata.accessservices.communityprofile.events.CommunityProfileOutboundEvent;
import org.odpi.openmetadata.accessservices.communityprofile.ffdc.CommunityProfileErrorCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicListenerConnectorBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommunityProfileOutTopicClientConnector
extends OpenMetadataTopicListenerConnectorBase
implements CommunityProfileEventInterface {
    private static final Logger log = LoggerFactory.getLogger(CommunityProfileOutTopicClientConnector.class);
    private final List<CommunityProfileEventListener> internalEventListeners = new ArrayList<CommunityProfileEventListener>();

    public synchronized void registerListener(String userId, CommunityProfileEventListener listener) throws InvalidParameterException {
        String methodName = "registerListener";
        String parameterName = "listener";
        if (listener == null) {
            throw new InvalidParameterException(CommunityProfileErrorCode.NULL_LISTENER.getMessageDefinition(new String[]{userId, "registerListener"}), ((Object)((Object)this)).getClass().getName(), "registerListener", "listener");
        }
        this.internalEventListeners.add(listener);
    }

    public synchronized void processEvent(String event) {
        if (event != null) {
            try {
                CommunityProfileOutboundEvent eventObject = (CommunityProfileOutboundEvent)super.getEventBean(event, CommunityProfileOutboundEvent.class);
                for (CommunityProfileEventListener listener : this.internalEventListeners) {
                    try {
                        listener.processEvent(eventObject);
                    }
                    catch (Exception error) {
                        log.error("Listener: " + listener.getClass().getName() + " is unable to process event: " + event, (Throwable)error);
                    }
                }
            }
            catch (Exception error) {
                log.error("Unable to read event: " + event, (Throwable)error);
            }
        }
    }
}

