/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.reports.componentid;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.EngineServiceDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.ViewServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogReportingComponent;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.frameworks.connectors.ConnectorProviderBase;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.registration.IntegrationServiceDescription;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditingComponent;

public class ComponentIdReport {
    private static String reportFileName = "component-id-report.md";
    private static String licenseString = "<!-- SPDX-License-Identifier: CC-BY-4.0 -->\n";
    private static String copyrightString = "<!-- Copyright Contributors to the Egeria project. -->\n\n";
    private static String reportHeader = "| ComponentId | ComponentName | ComponentDescription | Component Home Page | \n| :--- | :--- | :--- | :--- |\n";
    private static String snippetString = "\n--8<-- \"snippets/abbr.md\"";
    private static String fileCohortRegistryConnector = "org.odpi.openmetadata.adapters.repositoryservices.cohortregistrystore.file.FileBasedRegistryStoreProvider";
    private static String directoryMetadataArchiveConnector = "org.odpi.openmetadata.adapters.repositoryservices.archiveconnector.directory.DirectoryBasedOpenMetadataArchiveStoreProvider";
    private static String fileMetadataArchiveConnector = "org.odpi.openmetadata.adapters.repositoryservices.archiveconnector.file.FileBasedOpenMetadataArchiveStoreProvider";
    private static String inMemRepositoryConnector = "org.odpi.openmetadata.adapters.repositoryservices.inmemory.repositoryconnector.InMemoryOMRSRepositoryConnectorProvider";
    private static String readOnlyRepositoryConnector = "org.odpi.openmetadata.adapters.repositoryservices.readonly.repositoryconnector.ReadOnlyOMRSRepositoryConnectorProvider";
    private static String restRepositoryConnector = "org.odpi.openmetadata.adapters.repositoryservices.rest.repositoryconnector.OMRSRESTRepositoryConnectorProvider";
    private static String platformSecurityConnectorProviderClassName = "org.odpi.openmetadata.metadatasecurity.samples.CocoPharmaPlatformSecurityProvider";
    private static String serverSecurityConnectorProviderClassName = "org.odpi.openmetadata.metadatasecurity.samples.CocoPharmaServerSecurityProvider";

    private ComponentDescription getConnectorDescription(String connectorProviderClassName) {
        try {
            Class<?> connectorProviderClass = Class.forName(connectorProviderClassName);
            Object potentialConnectorProvider = connectorProviderClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (potentialConnectorProvider instanceof ConnectorProviderBase) {
                ConnectorProviderBase connectorProvider = (ConnectorProviderBase)potentialConnectorProvider;
                return connectorProvider.getConnectorComponentDescription();
            }
        }
        catch (Exception error) {
            System.out.println("Exception: " + error.getClass().getName() + " with message " + error.getMessage());
        }
        return null;
    }

    private void addConnectorDescription(String connectorProviderClassName, Map<Integer, ComponentDescription> report) {
        ComponentDescription existingComponentDescription;
        ComponentDescription connectorComponentDescription = this.getConnectorDescription(connectorProviderClassName);
        if (connectorComponentDescription != null && (existingComponentDescription = report.put(connectorComponentDescription.getComponentId(), connectorComponentDescription)) != null) {
            System.out.println("Error - componentId conflict between: " + existingComponentDescription.getComponentName() + " and: " + connectorComponentDescription.getComponentName());
        }
    }

    public void run() throws IOException {
        ComponentDescription existingComponentDescription;
        AuditLogReportingComponent componentDescription;
        TreeMap<Integer, ComponentDescription> report = new TreeMap<Integer, ComponentDescription>();
        for (AccessServiceDescription accessServiceDescription : AccessServiceDescription.values()) {
            componentDescription = new AuditLogReportingComponent(accessServiceDescription.getAccessServiceCode(), accessServiceDescription.getAccessServiceDevelopmentStatus(), accessServiceDescription.getAccessServiceName(), accessServiceDescription.getAccessServiceDescription(), accessServiceDescription.getAccessServiceWiki());
            existingComponentDescription = (ComponentDescription)report.put(componentDescription.getComponentId(), (ComponentDescription)componentDescription);
            if (existingComponentDescription == null) continue;
            System.out.println("Error - componentId conflict between: " + existingComponentDescription.getComponentName() + " and: " + componentDescription.getComponentName());
        }
        for (AccessServiceDescription accessServiceDescription : EngineServiceDescription.values()) {
            componentDescription = new AuditLogReportingComponent(accessServiceDescription.getEngineServiceCode(), accessServiceDescription.getEngineServiceDevelopmentStatus(), accessServiceDescription.getEngineServiceName(), accessServiceDescription.getEngineServiceDescription(), accessServiceDescription.getEngineServiceWiki());
            existingComponentDescription = (ComponentDescription)report.put(componentDescription.getComponentId(), (ComponentDescription)componentDescription);
            if (existingComponentDescription == null) continue;
            System.out.println("Error - componentId conflict between: " + existingComponentDescription.getComponentName() + " and: " + componentDescription.getComponentName());
        }
        for (AccessServiceDescription accessServiceDescription : IntegrationServiceDescription.values()) {
            componentDescription = new AuditLogReportingComponent(accessServiceDescription.getIntegrationServiceCode(), accessServiceDescription.getIntegrationServiceDevelopmentStatus(), accessServiceDescription.getIntegrationServiceName(), accessServiceDescription.getIntegrationServiceDescription(), accessServiceDescription.getIntegrationServiceWiki());
            existingComponentDescription = (ComponentDescription)report.put(componentDescription.getComponentId(), (ComponentDescription)componentDescription);
            if (existingComponentDescription == null) continue;
            System.out.println("Error - componentId conflict between: " + existingComponentDescription.getComponentName() + " and: " + componentDescription.getComponentName());
        }
        for (AccessServiceDescription accessServiceDescription : ViewServiceDescription.values()) {
            componentDescription = new AuditLogReportingComponent(accessServiceDescription.getViewServiceCode(), accessServiceDescription.getViewServiceDevelopmentStatus(), accessServiceDescription.getViewServiceName(), accessServiceDescription.getViewServiceDescription(), accessServiceDescription.getViewServiceWiki());
            existingComponentDescription = report.put(componentDescription.getComponentId(), (ComponentDescription)componentDescription);
            if (existingComponentDescription == null) continue;
            System.out.println("Error - componentId conflict between: " + existingComponentDescription.getComponentName() + " and: " + componentDescription.getComponentName());
        }
        for (AccessServiceDescription accessServiceDescription : OMRSAuditingComponent.values()) {
            componentDescription = new AuditLogReportingComponent(accessServiceDescription.getComponentId(), accessServiceDescription.getComponentDevelopmentStatus(), accessServiceDescription.getComponentName(), accessServiceDescription.getComponentDescription(), accessServiceDescription.getComponentWikiURL());
            existingComponentDescription = report.put(componentDescription.getComponentId(), (ComponentDescription)componentDescription);
            if (existingComponentDescription == null) continue;
            System.out.println("Error - componentId conflict between: " + existingComponentDescription.getComponentName() + " and: " + componentDescription.getComponentName());
        }
        this.addConnectorDescription(fileCohortRegistryConnector, report);
        this.addConnectorDescription(directoryMetadataArchiveConnector, report);
        this.addConnectorDescription(fileMetadataArchiveConnector, report);
        this.addConnectorDescription(inMemRepositoryConnector, report);
        this.addConnectorDescription(readOnlyRepositoryConnector, report);
        this.addConnectorDescription(restRepositoryConnector, report);
        this.addConnectorDescription(platformSecurityConnectorProviderClassName, report);
        this.addConnectorDescription(serverSecurityConnectorProviderClassName, report);
        File reportFile = new File(reportFileName);
        if (reportFile.exists()) {
            reportFile.delete();
        }
        FileOutputStream fileOutStream = new FileOutputStream(reportFile);
        fileOutStream.write(licenseString.getBytes());
        fileOutStream.write(copyrightString.getBytes());
        fileOutStream.write(reportHeader.getBytes());
        for (Integer n : report.keySet()) {
            componentDescription = (ComponentDescription)report.get(n);
            String reportLine = "| " + componentDescription.getComponentId() + " | " + componentDescription.getComponentName() + " | " + componentDescription.getComponentDescription() + " | " + componentDescription.getComponentDevelopmentStatus().getName() + " | " + componentDescription.getComponentWikiURL() + " |\n";
            fileOutStream.write(reportLine.getBytes());
            System.out.print(reportLine);
        }
        fileOutStream.write(snippetString.getBytes());
    }

    public static void main(String[] args) {
        try {
            ComponentIdReport report = new ComponentIdReport();
            report.run();
        }
        catch (Exception error) {
            System.out.println("Exception: " + error.getClass().getName() + " with message " + error.getMessage());
            System.exit(-1);
        }
    }
}

