/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.adminservices.configurationstore.file;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.store.OMAGServerConfigStoreConnectorBase;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedServerConfigStoreConnector
extends OMAGServerConfigStoreConnectorBase {
    private static final String defaultFilename = "omag.server.config";
    private String configStoreName = null;
    private static final Logger log = LoggerFactory.getLogger(FileBasedServerConfigStoreConnector.class);

    public void initialize(String connectorInstanceId, ConnectionProperties connectionProperties) {
        super.initialize(connectorInstanceId, connectionProperties);
        EndpointProperties endpoint = connectionProperties.getEndpoint();
        if (endpoint != null) {
            this.configStoreName = endpoint.getAddress();
        }
        if (this.configStoreName == null) {
            this.configStoreName = defaultFilename;
        }
    }

    public void saveServerConfig(OMAGServerConfig omagServerConfig) {
        File configStoreFile = new File(this.configStoreName);
        try {
            log.debug("Writing server config store properties: " + omagServerConfig);
            if (omagServerConfig == null) {
                configStoreFile.delete();
            } else {
                ObjectMapper objectMapper = new ObjectMapper();
                String configStoreFileContents = objectMapper.writeValueAsString((Object)omagServerConfig);
                FileUtils.writeStringToFile((File)configStoreFile, (String)configStoreFileContents, (boolean)false);
            }
        }
        catch (IOException ioException) {
            log.debug("Unusable Server config Store :(", (Throwable)ioException);
        }
    }

    public OMAGServerConfig retrieveServerConfig() {
        OMAGServerConfig newConfigProperties;
        File configStoreFile = new File(this.configStoreName);
        try {
            if (log.isDebugEnabled()) {
                log.debug("Retrieving server configuration properties");
            }
            String configStoreFileContents = FileUtils.readFileToString((File)configStoreFile, (String)"UTF-8");
            ObjectMapper objectMapper = new ObjectMapper();
            newConfigProperties = (OMAGServerConfig)objectMapper.readValue(configStoreFileContents, OMAGServerConfig.class);
        }
        catch (IOException ioException) {
            log.debug("New server config Store", (Throwable)ioException);
            newConfigProperties = new OMAGServerConfig();
        }
        return newConfigProperties;
    }

    public void removeServerConfig() {
        File configStoreFile = new File(this.configStoreName);
        configStoreFile.delete();
    }

    public void disconnect() {
        log.debug("Closing Config Store.");
    }
}

