/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.adminservices.configurationstore.file;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.odpi.openmetadata.adapters.adminservices.configurationstore.file.DocStoreErrorCode;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.store.OMAGServerConfigStoreConnectorBase;
import org.odpi.openmetadata.adminservices.store.OMAGServerConfigStoreRetrieveAll;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFRuntimeException;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedServerConfigStoreConnector
extends OMAGServerConfigStoreConnectorBase
implements OMAGServerConfigStoreRetrieveAll {
    private static final String defaultFilenameTemplate = "data/servers/{0}/config/{0}.config";
    private String configStoreName = null;
    private static final Logger log = LoggerFactory.getLogger(FileBasedServerConfigStoreConnector.class);

    public void start() throws ConnectorCheckedException {
        super.start();
        String configStoreTemplateName = this.getStoreTemplateName();
        this.configStoreName = super.getStoreName(configStoreTemplateName, new String[]{this.serverName});
    }

    private String getStoreTemplateName() {
        EndpointProperties endpoint = this.connectionProperties.getEndpoint();
        String configStoreTemplateName = null;
        if (endpoint != null) {
            configStoreTemplateName = endpoint.getAddress();
        }
        if (configStoreTemplateName == null) {
            configStoreTemplateName = defaultFilenameTemplate;
        }
        return configStoreTemplateName;
    }

    public void saveServerConfig(OMAGServerConfig omagServerConfig) {
        File configStoreFile = new File(this.configStoreName);
        try {
            log.debug("Writing server config store properties: " + omagServerConfig);
            if (omagServerConfig == null) {
                configStoreFile.delete();
            } else {
                ObjectMapper objectMapper = new ObjectMapper();
                String configStoreFileContents = objectMapper.writeValueAsString((Object)omagServerConfig);
                FileUtils.writeStringToFile((File)configStoreFile, (String)configStoreFileContents, (String)null, (boolean)false);
            }
        }
        catch (IOException ioException) {
            log.debug("Unusable Server config Store :(", (Throwable)ioException);
        }
    }

    public OMAGServerConfig retrieveServerConfig() {
        OMAGServerConfig newConfigProperties;
        File configStoreFile = new File(this.configStoreName);
        try {
            log.debug("Retrieving server configuration properties");
            String configStoreFileContents = FileUtils.readFileToString((File)configStoreFile, (String)"UTF-8");
            ObjectMapper objectMapper = new ObjectMapper();
            newConfigProperties = (OMAGServerConfig)objectMapper.readValue(configStoreFileContents, OMAGServerConfig.class);
        }
        catch (IOException ioException) {
            log.debug("New server config Store", (Throwable)ioException);
            newConfigProperties = null;
        }
        return newConfigProperties;
    }

    public void removeServerConfig() {
        File configStoreFile = new File(this.configStoreName);
        configStoreFile.delete();
    }

    public Set<OMAGServerConfig> retrieveAllServerConfigs() {
        String methodName = "retrieveAllServerConfigs";
        HashSet<OMAGServerConfig> omagServerConfigSet = new HashSet<OMAGServerConfig>();
        try (Stream<Path> list = Files.list(Paths.get(".", new String[0]));){
            String templateString = this.getStoreTemplateName();
            Set fileNames = list.map(x -> x.toString()).filter(f -> FileBasedServerConfigStoreConnector.isFileNameAConfig(f, templateString)).collect(Collectors.toSet());
            Iterator iterator = fileNames.iterator();
            while (iterator.hasNext()) {
                String fileName;
                this.configStoreName = fileName = (String)iterator.next();
                OMAGServerConfig config = this.retrieveServerConfig();
                omagServerConfigSet.add(config);
            }
        }
        catch (IOException e) {
            throw new OCFRuntimeException(DocStoreErrorCode.CONFIG_RETRIEVE_ALL_ERROR.getMessageDefinition(e.getClass().getName(), e.getMessage(), this.configStoreName), ((Object)((Object)this)).getClass().getName(), "retrieveAllServerConfigs", (Throwable)e);
        }
        return omagServerConfigSet;
    }

    static boolean isFileNameAConfig(String textToCheck, String templateString) {
        boolean isConfig = false;
        MessageFormat mf = new MessageFormat(templateString);
        try {
            mf.parse(textToCheck);
            isConfig = true;
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return isConfig;
    }

    public void disconnect() {
        log.debug("Closing Config Store.");
    }
}

