/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.adminservices.configurationstore.file;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.odpi.openmetadata.adapters.adminservices.configurationstore.file.DocStoreErrorCode;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.store.OMAGServerConfigStoreConnectorBase;
import org.odpi.openmetadata.adminservices.store.OMAGServerConfigStoreRetrieveAll;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointDetails;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.OMFRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedServerConfigStoreConnector
extends OMAGServerConfigStoreConnectorBase
implements OMAGServerConfigStoreRetrieveAll {
    private static final String INSERT_FOR_FILENAME_TEMPLATE = "{0}";
    private static final String DEFAULT_FILENAME_TEMPLATE = "./data/servers/{0}/config/{0}.config";
    private String configStoreName = null;
    private static final Logger log = LoggerFactory.getLogger(FileBasedServerConfigStoreConnector.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final ObjectWriter OBJECT_WRITER = OBJECT_MAPPER.writer();
    private static final ObjectReader OBJECT_READER = OBJECT_MAPPER.reader();

    public void start() throws ConnectorCheckedException {
        super.start();
        String configStoreTemplateName = this.getStoreTemplateName();
        this.configStoreName = super.getStoreName(configStoreTemplateName, new String[]{this.serverName});
    }

    private String getStoreTemplateName() {
        EndpointDetails endpoint = this.connectionDetails.getEndpoint();
        String configStoreTemplateName = null;
        if (endpoint != null) {
            configStoreTemplateName = endpoint.getAddress();
        }
        if (configStoreTemplateName == null) {
            configStoreTemplateName = DEFAULT_FILENAME_TEMPLATE;
        }
        return configStoreTemplateName;
    }

    public void saveServerConfig(OMAGServerConfig omagServerConfig) {
        File configStoreFile = new File(this.configStoreName);
        try {
            log.debug("Writing server config store properties: " + String.valueOf(omagServerConfig));
            if (omagServerConfig == null) {
                configStoreFile.delete();
            } else {
                String configStoreFileContents = OBJECT_WRITER.writeValueAsString((Object)omagServerConfig);
                FileUtils.writeStringToFile((File)configStoreFile, (String)configStoreFileContents, (String)null, (boolean)false);
            }
        }
        catch (IOException ioException) {
            log.debug("Unusable Server config Store :(", (Throwable)ioException);
        }
    }

    public OMAGServerConfig retrieveServerConfig() {
        OMAGServerConfig newConfigProperties;
        File configStoreFile = new File(this.configStoreName);
        try {
            log.debug("Retrieving server configuration properties");
            String configStoreFileContents = FileUtils.readFileToString((File)configStoreFile, (String)"UTF-8");
            newConfigProperties = (OMAGServerConfig)OBJECT_READER.readValue(configStoreFileContents, OMAGServerConfig.class);
        }
        catch (IOException ioException) {
            log.debug("New server config Store", (Throwable)ioException);
            newConfigProperties = null;
        }
        return newConfigProperties;
    }

    public void removeServerConfig() {
        File configStoreFile = new File(this.configStoreName);
        configStoreFile.delete();
    }

    public Set<OMAGServerConfig> retrieveAllServerConfigs() {
        String methodName = "retrieveAllServerConfigs";
        HashSet<OMAGServerConfig> omagServerConfigSet = new HashSet<OMAGServerConfig>();
        String templateString = this.getStoreTemplateName();
        Set<String> fileNames = this.getFileNames(templateString, "retrieveAllServerConfigs");
        Iterator<String> iterator = fileNames.iterator();
        while (iterator.hasNext()) {
            String fileName;
            this.configStoreName = fileName = iterator.next();
            OMAGServerConfig config = this.retrieveServerConfig();
            omagServerConfigSet.add(config);
        }
        return omagServerConfigSet;
    }

    protected Set<String> getFileNames(String templateString, String methodName) {
        if (!this.isTemplateValid(templateString)) {
            throw new OMFRuntimeException(DocStoreErrorCode.CONFIG_RETRIEVE_ALL_ERROR_INVALID_TEMPLATE.getMessageDefinition(templateString), ((Object)((Object)this)).getClass().getName(), methodName);
        }
        HashSet<String> fileNames = new HashSet();
        int firstIndex = templateString.indexOf(INSERT_FOR_FILENAME_TEMPLATE);
        int secondIndex = -1;
        if (firstIndex != -1 && templateString.length() > firstIndex + 3) {
            String textAfter1stIndex = templateString.substring(firstIndex + 3);
            secondIndex = textAfter1stIndex.indexOf(INSERT_FOR_FILENAME_TEMPLATE);
        }
        if (log.isDebugEnabled()) {
            log.debug("templateString " + templateString + ",firstIndex=" + firstIndex + ",secondIndex=" + secondIndex);
        }
        try {
            if (firstIndex != -1 && secondIndex == -1) {
                firstPartOfTemplate = templateString.substring(0, firstIndex);
                String secondPartOfTemplate = templateString.substring(firstIndex + 3);
                int lastSlashIndex = firstPartOfTemplate.lastIndexOf(47);
                int nextSlashIndex = -1;
                if (templateString.length() > lastSlashIndex + 1) {
                    nextSlashIndex = templateString.substring(lastSlashIndex + 1).indexOf("/");
                }
                Stream<Path> listOfFolders = Files.list(Paths.get(firstPartOfTemplate.substring(0, lastSlashIndex + 1), new String[0]));
                String pre = templateString.substring(0, firstIndex);
                if (nextSlashIndex == -1) {
                    String post = templateString.substring(firstIndex + 3);
                    fileNames = listOfFolders.map(x -> x.toString()).filter(f -> this.doesStringStartAndEndMatch((String)f, pre, post)).collect(Collectors.toSet());
                } else {
                    nextSlashIndex = lastSlashIndex + nextSlashIndex + 1;
                    String restOfFolderName = templateString.substring(firstIndex + 3, nextSlashIndex);
                    Set folderNames = listOfFolders.map(x -> x.toString()).filter(f -> this.doesStringStartAndEndMatch((String)f, pre, restOfFolderName)).collect(Collectors.toSet());
                    for (String folderName : folderNames) {
                        String fileName = folderName.substring(0, folderName.length() - restOfFolderName.length()) + secondPartOfTemplate;
                        File f2 = new File(fileName);
                        if (!f2.exists() || f2.isDirectory()) continue;
                        fileNames.add(fileName);
                    }
                }
            } else {
                secondIndex = firstIndex + 3 + secondIndex;
                firstPartOfTemplate = templateString.substring(0, firstIndex);
                String secondPartOfTemplate = templateString.substring(firstIndex + 3, secondIndex);
                String thirdPartOfTemplate = templateString.substring(secondIndex + 3);
                int lastSlashIndex = firstPartOfTemplate.lastIndexOf(47);
                int nextSlashIndex = -1;
                if (templateString.length() > lastSlashIndex + 1) {
                    nextSlashIndex = templateString.substring(lastSlashIndex + 1).indexOf("/");
                    nextSlashIndex = nextSlashIndex + lastSlashIndex + 1;
                }
                Stream<Path> listOfFolders = Files.list(Paths.get(templateString.substring(0, lastSlashIndex), new String[0]));
                String pre = templateString.substring(0, firstIndex);
                String restOfFolderName = "";
                if (nextSlashIndex > firstIndex) {
                    restOfFolderName = templateString.substring(firstIndex + 3, nextSlashIndex);
                }
                String post = restOfFolderName;
                int postLength = post.length();
                Set matchedFolderNames = listOfFolders.map(x -> x.toString()).filter(f -> this.doesStringStartAndEndMatch((String)f, pre, post)).collect(Collectors.toSet());
                int lastSlashIndexFromWholeTemplate = templateString.lastIndexOf(47);
                HashSet<String> serverNames = new HashSet<String>();
                if (lastSlashIndexFromWholeTemplate >= nextSlashIndex) {
                    for (String matchedFolderName : matchedFolderNames) {
                        String serverName = matchedFolderName.substring(firstIndex, matchedFolderName.length() - postLength);
                        if (log.isDebugEnabled()) {
                            log.debug("serverName " + serverName);
                        }
                        serverNames.add(serverName);
                    }
                }
                for (String serverName : serverNames) {
                    String fileName = firstPartOfTemplate + serverName + secondPartOfTemplate + serverName + thirdPartOfTemplate;
                    if (log.isDebugEnabled()) {
                        log.debug("getFileNames with 2 inserts testing fileName " + fileName);
                    }
                    File f3 = new File(fileName);
                    if (log.isDebugEnabled()) {
                        log.debug("see if fileName " + fileName + " exists");
                    }
                    if (!f3.exists() || f3.isDirectory()) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("fileName " + fileName + " exists");
                    }
                    fileNames.add(fileName);
                }
            }
        }
        catch (IOException error) {
            throw new OMFRuntimeException(DocStoreErrorCode.CONFIG_RETRIEVE_ALL_ERROR.getMessageDefinition(error.getClass().getName(), error.getMessage(), this.configStoreName), ((Object)((Object)this)).getClass().getName(), methodName, (Exception)error);
        }
        return fileNames;
    }

    private boolean doesStringStartAndEndMatch(String stringToTest, String pre, String post) {
        if (log.isDebugEnabled()) {
            log.debug("doesStringStartAndEndMatch " + stringToTest + ",pre=" + pre + ",post=" + post);
        }
        boolean isMatch = false;
        if (stringToTest.startsWith(pre) && stringToTest.endsWith(post)) {
            isMatch = true;
        }
        return isMatch;
    }

    private boolean isTemplateValid(String templateString) {
        boolean isValid = true;
        int lastIndex = 0;
        int count = 0;
        int indexOfSecondInsert = -1;
        while (lastIndex != -1) {
            if ((lastIndex = templateString.indexOf(INSERT_FOR_FILENAME_TEMPLATE, lastIndex)) == -1) continue;
            lastIndex += INSERT_FOR_FILENAME_TEMPLATE.length();
            if (++count != 2) continue;
            indexOfSecondInsert = lastIndex;
        }
        if (count == 0 || count > 2) {
            isValid = false;
        } else if (count == 2 && templateString.lastIndexOf(47) > indexOfSecondInsert) {
            isValid = false;
        } else if (templateString.contains("{0}{0}")) {
            isValid = false;
        }
        return isValid;
    }

    public void disconnect() {
        log.debug("Closing Config Store.");
    }
}

