/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.connectedasset.auditlog;

import java.text.MessageFormat;
import java.util.Arrays;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ConnectedAssetAuditCode {
    SERVICE_INITIALIZING("OMAS-CONNECTED-ASSET-0001", OMRSAuditLogRecordSeverity.INFO, "The Connected Asset Open Metadata Access Service (OMAS) is initializing", "The local server has started up the Connected Asset OMAS.", "No action is required.  This is part of the normal operation of the server."),
    SERVICE_REGISTERED_WITH_TOPIC("OMAS-CONNECTED-ASSET-0002", OMRSAuditLogRecordSeverity.INFO, "The Connected Asset Open Metadata Access Service (OMAS) is registering a listener with the OMRS Topic", "The Connected Asset OMAS is registering to receive events from the connected open metadata repositories.", "No action is required.  This is part of the normal operation of the server."),
    SERVICE_INITIALIZED("OMAS-CONNECTED-ASSET-0003", OMRSAuditLogRecordSeverity.INFO, "The Connected Asset Open Metadata Access Service (OMAS) is initialized", "The Connected Asset OMAS has completed initialization.", "No action is required.  This is part of the normal operation of the server."),
    SERVICE_SHUTDOWN("OMAS-CONNECTED-ASSET-0004", OMRSAuditLogRecordSeverity.INFO, "The Connected Asset Open Metadata Access Service (OMAS) is shutting down", "The local server has requested shut down of the Connected Asset OMAS.", "No action is required.  This is part of the normal operation of the server.");

    private String logMessageId;
    private OMRSAuditLogRecordSeverity severity;
    private String logMessage;
    private String systemAction;
    private String userAction;
    private static final Logger log;

    private ConnectedAssetAuditCode(String messageId, OMRSAuditLogRecordSeverity severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public String getLogMessageId() {
        return this.logMessageId;
    }

    public OMRSAuditLogRecordSeverity getSeverity() {
        return this.severity;
    }

    public String getFormattedLogMessage(String ... params) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("<== OMRS Audit Code.getMessage(%s)", Arrays.toString(params)));
        }
        MessageFormat mf = new MessageFormat(this.logMessage);
        String result = mf.format(params);
        if (log.isDebugEnabled()) {
            log.debug(String.format("==> OMRS Audit Code.getMessage(%s): %s", Arrays.toString(params), result));
        }
        return result;
    }

    public String getSystemAction() {
        return this.systemAction;
    }

    public String getUserAction() {
        return this.userAction;
    }

    static {
        log = LoggerFactory.getLogger(ConnectedAssetAuditCode.class);
    }
}

