/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.connectedasset.admin;

import org.odpi.openmetadata.accessservices.connectedasset.auditlog.ConnectedAssetAuditCode;
import org.odpi.openmetadata.accessservices.connectedasset.listener.ConnectedAssetOMRSTopicListener;
import org.odpi.openmetadata.accessservices.connectedasset.server.ConnectedAssetServicesInstance;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceAdmin;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class ConnectedAssetAdmin
implements AccessServiceAdmin {
    private OMRSRepositoryConnector repositoryConnector = null;
    private OMRSTopicConnector omrsTopicConnector = null;
    private AccessServiceConfig accessServiceConfig = null;
    private OMRSAuditLog auditLog = null;
    private ConnectedAssetServicesInstance instance = null;
    private String serverName = null;
    private String serverUserName = null;
    private ConnectedAssetOMRSTopicListener omrsTopicListener = null;

    public void initialize(AccessServiceConfig accessServiceConfigurationProperties, OMRSTopicConnector enterpriseOMRSTopicConnector, OMRSRepositoryConnector enterpriseOMRSRepositoryConnector, OMRSAuditLog auditLog, String serverUserName) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        ConnectedAssetAuditCode auditCode = ConnectedAssetAuditCode.SERVICE_INITIALIZING;
        auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
        try {
            this.repositoryConnector = enterpriseOMRSRepositoryConnector;
            this.instance = new ConnectedAssetServicesInstance(enterpriseOMRSRepositoryConnector);
            this.serverName = this.instance.getServerName();
            this.accessServiceConfig = accessServiceConfigurationProperties;
            this.omrsTopicConnector = enterpriseOMRSTopicConnector;
            if (this.omrsTopicConnector != null) {
                auditCode = ConnectedAssetAuditCode.SERVICE_REGISTERED_WITH_ENTERPRISE_TOPIC;
                auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.serverName), null, auditCode.getSystemAction(), auditCode.getUserAction());
                this.omrsTopicListener = new ConnectedAssetOMRSTopicListener(this.accessServiceConfig.getAccessServiceOutTopic(), this.repositoryConnector.getRepositoryHelper(), this.repositoryConnector.getRepositoryValidator(), this.accessServiceConfig.getAccessServiceName());
                this.omrsTopicConnector.registerListener((OMRSTopicListener)this.omrsTopicListener);
            }
            this.auditLog = auditLog;
            this.serverUserName = serverUserName;
            auditCode = ConnectedAssetAuditCode.SERVICE_INITIALIZED;
            auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.serverName), null, auditCode.getSystemAction(), auditCode.getUserAction());
        }
        catch (Throwable error) {
            auditCode = ConnectedAssetAuditCode.SERVICE_INSTANCE_FAILURE;
            auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(error.getMessage()), null, auditCode.getSystemAction(), auditCode.getUserAction());
        }
    }

    public void shutdown() {
        String actionDescription = "shutdown";
        if (this.instance != null) {
            this.instance.shutdown();
        }
        ConnectedAssetAuditCode auditCode = ConnectedAssetAuditCode.SERVICE_SHUTDOWN;
        this.auditLog.logRecord("shutdown", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.serverName), null, auditCode.getSystemAction(), auditCode.getUserAction());
    }
}

