/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.connectedasset.converters;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.connectedasset.converters.TypeConverter;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ConnectedAssetElementConverter {
    EntityDetail entity;
    Relationship relationship = null;
    OMRSRepositoryHelper repositoryHelper;
    String serviceName;

    ConnectedAssetElementConverter(EntityDetail entity, OMRSRepositoryHelper repositoryHelper, String serviceName) {
        this.entity = entity;
        this.repositoryHelper = repositoryHelper;
        this.serviceName = serviceName;
    }

    ConnectedAssetElementConverter(EntityDetail entity, Relationship relationship, OMRSRepositoryHelper repositoryHelper, String serviceName) {
        this.entity = entity;
        this.relationship = relationship;
        this.repositoryHelper = repositoryHelper;
        this.serviceName = serviceName;
    }

    void updateBean(ElementHeader bean) {
        if (this.entity != null) {
            TypeConverter typeConverter = new TypeConverter();
            bean.setType(typeConverter.getElementType(this.entity.getType(), this.entity.getInstanceProvenanceType(), this.entity.getMetadataCollectionId(), this.entity.getMetadataCollectionName(), this.entity.getInstanceLicense()));
            bean.setGUID(this.entity.getGUID());
            bean.setURL(this.entity.getInstanceURL());
            bean.setClassifications(this.getClassificationsFromEntity());
        }
    }

    private List<org.odpi.openmetadata.frameworks.connectors.properties.beans.Classification> getClassificationsFromEntity() {
        List entityClassifications;
        ArrayList classifications = null;
        if (this.entity != null && (entityClassifications = this.entity.getClassifications()) != null) {
            classifications = new ArrayList();
            for (Classification entityClassification : entityClassifications) {
                if (entityClassification == null) continue;
                org.odpi.openmetadata.frameworks.connectors.properties.beans.Classification beanClassification = new org.odpi.openmetadata.frameworks.connectors.properties.beans.Classification();
                beanClassification.setClassificationName(entityClassification.getName());
                beanClassification.setClassificationProperties(this.repositoryHelper.getInstancePropertiesAsMap(entityClassification.getProperties()));
            }
        }
        return classifications;
    }
}

