/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.connectedasset.converters;

import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementOrigin;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;

public class TypeConverter {
    public ElementType getElementType(InstanceType instanceType, InstanceProvenanceType instanceProvenanceType, String metadataCollectionId, String metadataCollectionName, String elementLicense) {
        ElementType elementType = new ElementType();
        if (instanceType != null) {
            elementType.setElementTypeId(instanceType.getTypeDefGUID());
            elementType.setElementTypeName(instanceType.getTypeDefName());
            elementType.setElementTypeVersion(instanceType.getTypeDefVersion());
            elementType.setElementTypeDescription(instanceType.getTypeDefDescription());
        }
        elementType.setElementHomeMetadataCollectionId(metadataCollectionId);
        elementType.setElementOrigin(this.getElementOrigin(instanceProvenanceType));
        elementType.setElementSourceServer(metadataCollectionName);
        elementType.setElementLicense(elementLicense);
        return elementType;
    }

    private ElementOrigin getElementOrigin(InstanceProvenanceType instanceProvenanceType) {
        if (instanceProvenanceType != null) {
            switch (instanceProvenanceType) {
                case DEREGISTERED_REPOSITORY: {
                    return ElementOrigin.DEREGISTERED_REPOSITORY;
                }
                case EXTERNAL_ENGINE: {
                    return ElementOrigin.EXTERNAL_ENGINE;
                }
                case EXPORT_ARCHIVE: {
                    return ElementOrigin.EXPORT_ARCHIVE;
                }
                case EXTERNAL_TOOL: {
                    return ElementOrigin.EXTERNAL_TOOL;
                }
                case LOCAL_COHORT: {
                    return ElementOrigin.LOCAL_COHORT;
                }
                case CONTENT_PACK: {
                    return ElementOrigin.CONTENT_PACK;
                }
                case DATA_PLATFORM: {
                    return ElementOrigin.DATA_PLATFORM;
                }
                case CONFIGURATION: {
                    return ElementOrigin.CONFIGURATION;
                }
                case UNKNOWN: {
                    return ElementOrigin.UNKNOWN;
                }
            }
        }
        return ElementOrigin.UNKNOWN;
    }
}

