/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.connectedasset.handlers;

import java.util.Iterator;
import java.util.List;
import org.odpi.openmetadata.accessservices.connectedasset.converters.TypeConverter;
import org.odpi.openmetadata.accessservices.connectedasset.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.connectedasset.ffdc.exceptions.UnrecognizedAssetGUIDException;
import org.odpi.openmetadata.accessservices.connectedasset.ffdc.exceptions.UnrecognizedConnectionGUIDException;
import org.odpi.openmetadata.accessservices.connectedasset.ffdc.exceptions.UnrecognizedGUIDException;
import org.odpi.openmetadata.accessservices.connectedasset.handlers.ErrorHandler;
import org.odpi.openmetadata.accessservices.connectedasset.handlers.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Asset;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class AssetHandler {
    private static final String connectionTypeGUID = "114e9f8f-5ff3-4c32-bd37-a7eb42712253";
    private static final String connectionConnectorTypeRelationshipGUID = "e542cfc1-0b4b-42b9-9921-f0a5a88aaf96";
    private static final String connectionEndpointRelationshipGUID = "887a7132-d6bc-4b92-a483-e80b60c86fb2";
    private static final String connectionToAssetRelationshipGUID = "e777d660-8dbe-453e-8b83-903771f054c0";
    private static final String qualifiedNamePropertyName = "qualifiedName";
    private static final String displayNamePropertyName = "displayName";
    private static final String additionalPropertiesName = "additionalProperties";
    private static final String securePropertiesName = "securedProperties";
    private static final String descriptionPropertyName = "description";
    private static final String connectorProviderPropertyName = "connectorProviderClassName";
    private static final String ownerPropertyName = "owner";
    private static final String shortDescriptionPropertyName = "assetSummary";
    private static final String endpointProtocolPropertyName = "protocol";
    private static final String endpointEncryptionPropertyName = "encryptionMethod";
    private static final int MAX_PAGE_SIZE = 25;
    private String serviceName;
    private OMRSRepositoryHelper repositoryHelper = null;
    private String serverName = null;
    private ErrorHandler errorHandler;
    private TypeConverter typeHandler = new TypeConverter();
    private EntityDetail assetEntity;
    private String connectionGUID;
    private RepositoryHandler repositoryHandler;
    private int annotationCount = 0;
    private int certificationCount = 0;
    private int commentCount = 0;
    private int connectionCount = 0;
    private int externalIdentifierCount = 0;
    private int externalReferencesCount = 0;
    private int informalTagCount = 0;
    private int licenseCount = 0;
    private int likeCount = 0;
    private int knownLocationsCount = 0;
    private int noteLogsCount = 0;
    private int ratingsCount = 0;
    private int relatedAssetCount = 0;
    private int relatedMediaReferenceCount = 0;
    private SchemaType schemaType = null;

    public AssetHandler(String serviceName, String serverName, OMRSRepositoryConnector repositoryConnector, String userId, String assetGUID) throws InvalidParameterException, UnrecognizedAssetGUIDException, PropertyServerException, UserNotAuthorizedException {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.repositoryHelper = repositoryConnector.getRepositoryHelper();
        this.errorHandler = new ErrorHandler(repositoryConnector);
        this.repositoryHandler = new RepositoryHandler(serviceName, serverName, repositoryConnector);
        try {
            this.assetEntity = this.repositoryHandler.retrieveEntity(userId, "Asset", assetGUID);
            this.countAssetAttachments(userId, assetGUID);
        }
        catch (UnrecognizedGUIDException error) {
            throw new UnrecognizedAssetGUIDException(error.getReportedHTTPCode(), error.getReportingClassName(), error.getReportingActionDescription(), error.getErrorMessage(), error.getReportedSystemAction(), error.getReportedUserAction(), assetGUID);
        }
    }

    public AssetHandler(String serviceName, String serverName, OMRSRepositoryConnector repositoryConnector, String userId, String assetGUID, String connectionGUID) throws InvalidParameterException, UnrecognizedAssetGUIDException, UnrecognizedConnectionGUIDException, PropertyServerException, UserNotAuthorizedException {
        this(serviceName, serverName, repositoryConnector, userId, assetGUID);
        this.connectionGUID = connectionGUID;
    }

    public Asset getAsset() {
        String methodName = "getAsset";
        if (this.assetEntity != null) {
            Asset asset = new Asset();
            asset.setType(this.typeHandler.getElementType(this.assetEntity.getType(), this.assetEntity.getInstanceProvenanceType(), this.assetEntity.getMetadataCollectionId(), this.serverName, this.assetEntity.getInstanceLicense()));
            asset.setGUID(this.assetEntity.getGUID());
            asset.setURL(this.assetEntity.getInstanceURL());
            InstanceProperties instanceProperties = this.assetEntity.getProperties();
            if (instanceProperties != null) {
                Iterator propertyNames = instanceProperties.getPropertyNames();
                while (propertyNames.hasNext()) {
                    String propertyName = (String)propertyNames.next();
                    if (propertyName == null) continue;
                    asset.setQualifiedName(this.repositoryHelper.getStringProperty(this.serviceName, qualifiedNamePropertyName, instanceProperties, "getAsset"));
                    asset.setDisplayName(this.repositoryHelper.getStringProperty(this.serviceName, displayNamePropertyName, instanceProperties, "getAsset"));
                    asset.setDescription(this.repositoryHelper.getStringProperty(this.serviceName, descriptionPropertyName, instanceProperties, "getAsset"));
                    asset.setOwner(this.repositoryHelper.getStringProperty(this.serviceName, ownerPropertyName, instanceProperties, "getAsset"));
                    asset.setAdditionalProperties(this.repositoryHelper.getMapFromProperty(this.serviceName, additionalPropertiesName, instanceProperties, "getAsset"));
                    asset.setZoneMembership(this.repositoryHelper.getStringArrayProperty(this.serviceName, ownerPropertyName, instanceProperties, "getAsset"));
                }
            }
            return asset;
        }
        return null;
    }

    private void countAssetAttachments(String userId, String assetGUID) throws InvalidParameterException, UnrecognizedGUIDException, PropertyServerException, UserNotAuthorizedException {
        List<Relationship> retrievedRelationships;
        int elementCount = 0;
        do {
            if ((retrievedRelationships = this.repositoryHandler.retrieveAllRelationships(userId, "Asset", assetGUID, elementCount, 25)) == null) continue;
            if (retrievedRelationships.isEmpty()) {
                retrievedRelationships = null;
                continue;
            }
            this.certificationCount += this.countRelationshipsOfACertainType(retrievedRelationships, "Dummy");
            this.commentCount += this.countRelationshipsOfACertainType(retrievedRelationships, "AttachedComment");
            this.connectionCount += this.countRelationshipsOfACertainType(retrievedRelationships, "Dummy");
            this.externalIdentifierCount += this.countRelationshipsOfACertainType(retrievedRelationships, "Dummy");
            this.externalReferencesCount += this.countRelationshipsOfACertainType(retrievedRelationships, "Dummy");
            this.informalTagCount += this.countRelationshipsOfACertainType(retrievedRelationships, "AttachedTag");
            this.licenseCount += this.countRelationshipsOfACertainType(retrievedRelationships, "Dummy");
            this.likeCount += this.countRelationshipsOfACertainType(retrievedRelationships, "AttachedLike");
            this.knownLocationsCount += this.countRelationshipsOfACertainType(retrievedRelationships, "Dummy");
            this.noteLogsCount += this.countRelationshipsOfACertainType(retrievedRelationships, "Dummy");
            this.ratingsCount += this.countRelationshipsOfACertainType(retrievedRelationships, "AttachedRating");
            this.relatedAssetCount += this.countRelationshipsOfACertainType(retrievedRelationships, "Dummy");
            this.relatedMediaReferenceCount += this.countRelationshipsOfACertainType(retrievedRelationships, "Dummy");
            if (this.schemaType == null) {
                this.schemaType = this.getSchemaType(userId, retrievedRelationships);
            }
            if (retrievedRelationships.size() != 25) continue;
            elementCount += 25;
        } while (retrievedRelationships != null);
    }

    private int countRelationshipsOfACertainType(List<Relationship> relationships, String relationshipTypeName) {
        List<Relationship> classifiedRelationships = this.repositoryHandler.getRelationshipsOfACertainType(relationships, relationshipTypeName);
        if (classifiedRelationships == null) {
            return 0;
        }
        return classifiedRelationships.size();
    }

    private SchemaType getSchemaType(String userId, List<Relationship> relationships) {
        return null;
    }

    public int getCertificationCount() {
        return this.certificationCount;
    }

    public int getCommentCount() {
        return this.commentCount;
    }

    public int getConnectionCount() {
        return this.connectionCount;
    }

    public int getExternalIdentifierCount() {
        return this.externalIdentifierCount;
    }

    public int getExternalReferencesCount() {
        return this.externalReferencesCount;
    }

    public int getInformalTagCount() {
        return this.informalTagCount;
    }

    public int getLicenseCount() {
        return this.licenseCount;
    }

    public int getLikeCount() {
        return this.likeCount;
    }

    public int getKnownLocationsCount() {
        return this.knownLocationsCount;
    }

    public int getNoteLogsCount() {
        return this.noteLogsCount;
    }

    public int getRatingsCount() {
        return this.ratingsCount;
    }

    public int getRelatedAssetCount() {
        return this.relatedAssetCount;
    }

    public int getRelatedMediaReferenceCount() {
        return this.relatedMediaReferenceCount;
    }

    public SchemaType getSchemaType() {
        return this.schemaType;
    }
}

