/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.connectedasset.handlers;

import org.odpi.openmetadata.accessservices.connectedasset.ffdc.ConnectedAssetErrorCode;
import org.odpi.openmetadata.accessservices.connectedasset.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.connectedasset.ffdc.exceptions.UnrecognizedGUIDException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

class ErrorHandler {
    private OMRSRepositoryConnector repositoryConnector;

    ErrorHandler(OMRSRepositoryConnector repositoryConnector) {
        this.repositoryConnector = repositoryConnector;
    }

    void validateUserId(String userId, String methodName) throws InvalidParameterException {
        if (userId == null) {
            ConnectedAssetErrorCode errorCode = ConnectedAssetErrorCode.NULL_USER_ID;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "userId");
        }
    }

    void validateGUID(String guid, String parameterName, String methodName) throws InvalidParameterException {
        if (guid == null) {
            ConnectedAssetErrorCode errorCode = ConnectedAssetErrorCode.NULL_GUID;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{parameterName, methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), parameterName);
        }
    }

    void validateEnum(Object enumValue, String parameterName, String methodName) throws InvalidParameterException {
        if (enumValue == null) {
            ConnectedAssetErrorCode errorCode = ConnectedAssetErrorCode.NULL_ENUM;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{parameterName, methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), parameterName);
        }
    }

    void validateName(String name, String parameterName, String methodName) throws InvalidParameterException {
        if (name == null) {
            ConnectedAssetErrorCode errorCode = ConnectedAssetErrorCode.NULL_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{parameterName, methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), parameterName);
        }
    }

    void validatePaging(int startFrom, int pageSize, String methodName) throws InvalidParameterException {
        String startFromParameterName = "startFrom";
        String pageSizeParameterName = "pageSize";
        if (startFrom < 0) {
            ConnectedAssetErrorCode errorCode = ConnectedAssetErrorCode.NEGATIVE_START_FROM;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"startFrom", methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "startFrom");
        }
        if (pageSize < 1) {
            ConnectedAssetErrorCode errorCode = ConnectedAssetErrorCode.EMPTY_PAGE_SIZE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"pageSize", methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "pageSize");
        }
    }

    OMRSMetadataCollection validateRepositoryConnector(String methodName) throws PropertyServerException {
        if (this.repositoryConnector == null) {
            ConnectedAssetErrorCode errorCode = ConnectedAssetErrorCode.OMRS_NOT_INITIALIZED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
            throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (!this.repositoryConnector.isActive()) {
            ConnectedAssetErrorCode errorCode = ConnectedAssetErrorCode.OMRS_NOT_AVAILABLE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
            throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        try {
            return this.repositoryConnector.getMetadataCollection();
        }
        catch (Throwable error) {
            ConnectedAssetErrorCode errorCode = ConnectedAssetErrorCode.NO_METADATA_COLLECTION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
            throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    void handleUnauthorizedUser(String userId, String methodName, String serverName, String serviceName) throws UserNotAuthorizedException {
        ConnectedAssetErrorCode errorCode = ConnectedAssetErrorCode.USER_NOT_AUTHORIZED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{userId, methodName, serviceName, serverName});
        throw new UserNotAuthorizedException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), userId);
    }

    void handleUnauthorizedUser(String userId, String methodName, String serverName, String serviceName, String exceptionMessage) throws UserNotAuthorizedException {
        ConnectedAssetErrorCode errorCode = ConnectedAssetErrorCode.USER_NOT_AUTHORIZED_BY_REPOSITORY;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{userId, methodName, serviceName, serverName, exceptionMessage});
        throw new UserNotAuthorizedException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), userId);
    }

    void handleRepositoryError(Throwable error, String methodName, String serverName, String serviceName) throws PropertyServerException {
        ConnectedAssetErrorCode errorCode = ConnectedAssetErrorCode.PROPERTY_SERVER_ERROR;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{error.getMessage(), methodName, serviceName, serverName});
        throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    void handleUnknownAsset(Throwable error, String assetGUID, String methodName, String serverName, String serviceName) throws InvalidParameterException {
        ConnectedAssetErrorCode errorCode = ConnectedAssetErrorCode.UNKNOWN_ASSET;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{assetGUID, methodName, serviceName, serverName, error.getMessage()});
        throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "assetGUID");
    }

    void handleUnrecognizedGUIDException(String userId, String methodName, String serverName, String expectedType, String guid, String exceptionMessage) throws UnrecognizedGUIDException {
        ConnectedAssetErrorCode errorCode = ConnectedAssetErrorCode.INSTANCE_NOT_FOUND_BY_GUID;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, expectedType, guid, userId, serverName, exceptionMessage});
        throw new UnrecognizedGUIDException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), expectedType, guid);
    }

    void handleEntityProxyGUIDException(String userId, String methodName, String serverName, String expectedType, String guid, String exceptionMessage) throws UnrecognizedGUIDException {
        ConnectedAssetErrorCode errorCode = ConnectedAssetErrorCode.ENTITY_PROXY_FOUND;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, expectedType, guid, userId, serverName, exceptionMessage});
        throw new UnrecognizedGUIDException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), expectedType, guid);
    }
}

