/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.connectedasset.handlers;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.connectedasset.converters.LikeConverter;
import org.odpi.openmetadata.accessservices.connectedasset.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.connectedasset.ffdc.exceptions.UnrecognizedGUIDException;
import org.odpi.openmetadata.accessservices.connectedasset.handlers.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Like;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class LikesHandler {
    List<Like> returnedList = null;

    public LikesHandler(String serviceName, String serverName, OMRSRepositoryConnector repositoryConnector, String userId, String assetGUID, int elementStart, int maxElements) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        RepositoryHandler repositoryHandler = new RepositoryHandler(serviceName, serverName, repositoryConnector);
        try {
            List<Relationship> retrievedRelationships = repositoryHandler.retrieveRelationships(userId, "Asset", assetGUID, "AttachedLike", elementStart, maxElements);
            this.returnedList = new ArrayList<Like>();
            if (retrievedRelationships != null) {
                for (Relationship relationship : retrievedRelationships) {
                    EntityProxy entityProxy;
                    EntityDetail elementEntity;
                    LikeConverter converter;
                    Like bean;
                    if (relationship == null || (bean = (converter = new LikeConverter(elementEntity = repositoryHandler.retrieveEntity(userId, "Like", (entityProxy = relationship.getEntityTwoProxy()).getGUID()), relationship, repositoryConnector.getRepositoryHelper(), serviceName)).getBean()) == null) continue;
                    this.returnedList.add(bean);
                }
            }
        }
        catch (UnrecognizedGUIDException error) {
            throw new InvalidParameterException(error.getReportedHTTPCode(), error.getReportingClassName(), error.getReportingActionDescription(), error.getErrorMessage(), error.getReportedSystemAction(), error.getReportedUserAction(), assetGUID);
        }
    }

    public List<Like> getList() {
        if (this.returnedList == null) {
            return null;
        }
        if (this.returnedList.isEmpty()) {
            return null;
        }
        return this.returnedList;
    }
}

