/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.connectedasset.handlers;

import java.util.List;
import org.odpi.openmetadata.accessservices.connectedasset.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.connectedasset.ffdc.exceptions.UnrecognizedGUIDException;
import org.odpi.openmetadata.accessservices.connectedasset.handlers.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Rating;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class RatingsHandler {
    List<Rating> returnedList = null;

    public RatingsHandler(String serviceName, String serverName, OMRSRepositoryConnector repositoryConnector, String userId, String assetGUID, int elementStart, int maxElements) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        RepositoryHandler repositoryHandler = new RepositoryHandler(serviceName, serverName, repositoryConnector);
        try {
            List<Relationship> list = repositoryHandler.retrieveRelationships(userId, "Asset", assetGUID, "AttachedRating", elementStart, maxElements);
        }
        catch (UnrecognizedGUIDException error) {
            throw new InvalidParameterException(error.getReportedHTTPCode(), error.getReportingClassName(), error.getReportingActionDescription(), error.getErrorMessage(), error.getReportedSystemAction(), error.getReportedUserAction(), assetGUID);
        }
    }

    public List<Rating> getList() {
        if (this.returnedList == null) {
            return null;
        }
        if (this.returnedList.isEmpty()) {
            return null;
        }
        return this.returnedList;
    }
}

