/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.connectedasset.handlers;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.connectedasset.converters.TypeConverter;
import org.odpi.openmetadata.accessservices.connectedasset.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.connectedasset.ffdc.exceptions.UnrecognizedGUIDException;
import org.odpi.openmetadata.accessservices.connectedasset.handlers.ErrorHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;

public class RepositoryHandler {
    private String serviceName;
    private OMRSRepositoryHelper repositoryHelper;
    private String serverName;
    private ErrorHandler errorHandler;
    private TypeConverter typeHandler = new TypeConverter();

    public RepositoryHandler(String serviceName, String serverName, OMRSRepositoryConnector repositoryConnector) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.repositoryHelper = repositoryConnector.getRepositoryHelper();
        this.errorHandler = new ErrorHandler(repositoryConnector);
    }

    public List<Relationship> getRelationshipsOfACertainType(List<Relationship> retrievedRelationships, String typeName) {
        ArrayList<Relationship> results = new ArrayList<Relationship>();
        if (typeName != null && retrievedRelationships != null) {
            for (Relationship relationship : retrievedRelationships) {
                InstanceType instanceType;
                if (relationship == null || (instanceType = relationship.getType()) == null || !this.repositoryHelper.isTypeOf(this.serviceName, typeName, instanceType.getTypeDefName())) continue;
                results.add(relationship);
            }
        }
        return results;
    }

    public EntityDetail retrieveEntity(String userId, String typeName, String guid) throws InvalidParameterException, UnrecognizedGUIDException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "retrieveEntity";
        String guidParameter = "guid";
        String typeNameParameter = "typeName";
        this.errorHandler.validateUserId(userId, "retrieveEntity");
        this.errorHandler.validateGUID(guid, "guid", "retrieveEntity");
        this.errorHandler.validateName(typeName, "typeName", "retrieveEntity");
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector("retrieveEntity");
        try {
            return metadataCollection.getEntityDetail(userId, guid);
        }
        catch (EntityNotKnownException error) {
            this.errorHandler.handleUnrecognizedGUIDException(userId, "retrieveEntity", this.serverName, typeName, guid, error.getErrorMessage());
        }
        catch (EntityProxyOnlyException error) {
            this.errorHandler.handleEntityProxyGUIDException(userId, "retrieveEntity", this.serverName, typeName, guid, error.getErrorMessage());
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, "retrieveEntity", this.serverName, this.serviceName, error.getErrorMessage());
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, "retrieveEntity", this.serverName, this.serviceName);
        }
        return null;
    }

    public List<Relationship> retrieveAllRelationships(String userId, String entityTypeName, String entityGUID, int startingElement, int pageSize) throws InvalidParameterException, UnrecognizedGUIDException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "retrieveAllRelationships";
        String guidParameter = "entityGUID";
        this.errorHandler.validateUserId(userId, "retrieveAllRelationships");
        this.errorHandler.validateGUID(entityGUID, "entityGUID", "retrieveAllRelationships");
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector("retrieveAllRelationships");
        try {
            return metadataCollection.getRelationshipsForEntity(userId, entityGUID, null, startingElement, null, null, null, null, pageSize);
        }
        catch (EntityNotKnownException error) {
            this.errorHandler.handleUnrecognizedGUIDException(userId, "retrieveAllRelationships", this.serverName, entityTypeName, entityGUID, error.getErrorMessage());
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, "retrieveAllRelationships", this.serverName, this.serviceName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, "retrieveAllRelationships", this.serverName, this.serviceName);
        }
        return null;
    }

    public List<Relationship> retrieveRelationships(String userId, String entityTypeName, String entityGUID, String relationshipTypeGUID, int startingElement, int pageSize) throws InvalidParameterException, UnrecognizedGUIDException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "retrieveAllRelationships";
        String guidParameter = "entityGUID";
        this.errorHandler.validateUserId(userId, "retrieveAllRelationships");
        this.errorHandler.validateGUID(entityGUID, "entityGUID", "retrieveAllRelationships");
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector("retrieveAllRelationships");
        try {
            return metadataCollection.getRelationshipsForEntity(userId, entityGUID, relationshipTypeGUID, startingElement, null, null, null, null, pageSize);
        }
        catch (EntityNotKnownException error) {
            this.errorHandler.handleUnrecognizedGUIDException(userId, "retrieveAllRelationships", this.serverName, entityTypeName, entityGUID, error.getErrorMessage());
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, "retrieveAllRelationships", this.serverName, this.serviceName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, "retrieveAllRelationships", this.serverName, this.serviceName);
        }
        return null;
    }
}

