/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.connectedasset.server;

import org.odpi.openmetadata.accessservices.connectedasset.ffdc.ConnectedAssetErrorCode;
import org.odpi.openmetadata.accessservices.connectedasset.server.ConnectedAssetRegistration;
import org.odpi.openmetadata.accessservices.connectedasset.server.ConnectedAssetServicesInstance;
import org.odpi.openmetadata.accessservices.connectedasset.server.ConnectedAssetServicesInstanceMap;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

class ConnectedAssetInstanceHandler {
    private static ConnectedAssetServicesInstanceMap instanceMap = new ConnectedAssetServicesInstanceMap();
    private static AccessServiceDescription myDescription = AccessServiceDescription.CONNECTED_ASSET_OMAS;

    ConnectedAssetInstanceHandler() {
        ConnectedAssetRegistration.registerAccessService();
    }

    public String getAccessServiceName() {
        return myDescription.getAccessServiceName();
    }

    OMRSMetadataCollection getMetadataCollection(String serverName) throws PropertyServerException {
        ConnectedAssetServicesInstance instance = instanceMap.getInstance(serverName);
        if (instance != null) {
            return instance.getMetadataCollection();
        }
        String methodName = "getMetadataCollection";
        ConnectedAssetErrorCode errorCode = ConnectedAssetErrorCode.SERVICE_NOT_INITIALIZED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, "getMetadataCollection"});
        throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getMetadataCollection", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    OMRSRepositoryConnector getRepositoryConnector(String serverName) throws PropertyServerException {
        ConnectedAssetServicesInstance instance = instanceMap.getInstance(serverName);
        if (instance != null) {
            return instance.getRepositoryConnector();
        }
        String methodName = "getRepositoryConnector";
        ConnectedAssetErrorCode errorCode = ConnectedAssetErrorCode.SERVICE_NOT_INITIALIZED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, "getRepositoryConnector"});
        throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getRepositoryConnector", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }
}

