/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.connectedasset.server;

import java.util.HashMap;
import java.util.Map;
import org.odpi.openmetadata.accessservices.connectedasset.ffdc.exceptions.ConnectedAssetCheckedExceptionBase;
import org.odpi.openmetadata.accessservices.connectedasset.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.connectedasset.ffdc.exceptions.UnrecognizedAssetGUIDException;
import org.odpi.openmetadata.accessservices.connectedasset.ffdc.exceptions.UnrecognizedConnectionGUIDException;
import org.odpi.openmetadata.accessservices.connectedasset.handlers.AssetHandler;
import org.odpi.openmetadata.accessservices.connectedasset.handlers.CertificationsHandler;
import org.odpi.openmetadata.accessservices.connectedasset.handlers.CommentRepliesHandler;
import org.odpi.openmetadata.accessservices.connectedasset.handlers.CommentsHandler;
import org.odpi.openmetadata.accessservices.connectedasset.handlers.ConnectionsHandler;
import org.odpi.openmetadata.accessservices.connectedasset.handlers.ExternalIdentifiersHandler;
import org.odpi.openmetadata.accessservices.connectedasset.handlers.ExternalReferencesHandler;
import org.odpi.openmetadata.accessservices.connectedasset.handlers.InformalTagsHandler;
import org.odpi.openmetadata.accessservices.connectedasset.handlers.LicensesHandler;
import org.odpi.openmetadata.accessservices.connectedasset.handlers.LikesHandler;
import org.odpi.openmetadata.accessservices.connectedasset.handlers.LocationsHandler;
import org.odpi.openmetadata.accessservices.connectedasset.handlers.NoteLogsHandler;
import org.odpi.openmetadata.accessservices.connectedasset.handlers.NotesHandler;
import org.odpi.openmetadata.accessservices.connectedasset.handlers.RatingsHandler;
import org.odpi.openmetadata.accessservices.connectedasset.handlers.RelatedAssetsHandler;
import org.odpi.openmetadata.accessservices.connectedasset.handlers.RelatedMediaReferencesHandler;
import org.odpi.openmetadata.accessservices.connectedasset.handlers.SchemaAttributesHandler;
import org.odpi.openmetadata.accessservices.connectedasset.rest.AssetResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.CertificationsResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.CommentsResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.ConnectedAssetOMASAPIResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.ConnectionsResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.ExternalIdentifiersResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.ExternalReferencesResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.InformalTagsResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.LicensesResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.LikesResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.LocationsResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.NoteLogsResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.NotesResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.RatingsResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.RelatedAssetsResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.RelatedMediaReferencesResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.SchemaAttributesResponse;
import org.odpi.openmetadata.accessservices.connectedasset.server.ConnectedAssetInstanceHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectedAssetRESTServices {
    private static ConnectedAssetInstanceHandler instanceHandler = new ConnectedAssetInstanceHandler();
    private static final Logger log = LoggerFactory.getLogger(ConnectedAssetRESTServices.class);

    public AssetResponse getConnectedAssetSummary(String serverName, String userId, String assetGUID, String connectionGUID) {
        String methodName = "getConnectedAssetSummary";
        AssetResponse response = new AssetResponse();
        try {
            AssetHandler assetHandler = new AssetHandler(instanceHandler.getAccessServiceName(), serverName, instanceHandler.getRepositoryConnector(serverName), userId, assetGUID, connectionGUID);
            response.setAsset(assetHandler.getAsset());
            response.setCertificationCount(assetHandler.getCertificationCount());
            response.setCommentCount(assetHandler.getCommentCount());
            response.setConnectionCount(assetHandler.getConnectionCount());
            response.setExternalIdentifierCount(assetHandler.getExternalIdentifierCount());
            response.setExternalReferencesCount(assetHandler.getExternalReferencesCount());
            response.setInformalTagCount(assetHandler.getInformalTagCount());
            response.setLicenseCount(assetHandler.getLicenseCount());
            response.setLikeCount(assetHandler.getLikeCount());
            response.setKnownLocationsCount(assetHandler.getKnownLocationsCount());
            response.setNoteLogsCount(assetHandler.getNoteLogsCount());
            response.setRatingsCount(assetHandler.getRatingsCount());
            response.setRelatedAssetCount(assetHandler.getRelatedAssetCount());
            response.setRelatedMediaReferenceCount(assetHandler.getRelatedMediaReferenceCount());
            response.setSchemaType(assetHandler.getSchemaType());
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((ConnectedAssetOMASAPIResponse)response, error);
        }
        catch (UnrecognizedAssetGUIDException error) {
            this.captureUnrecognizedAssetGUIDException((ConnectedAssetOMASAPIResponse)response, error);
        }
        catch (UnrecognizedConnectionGUIDException error) {
            this.captureUnrecognizedConnectionGUIDException((ConnectedAssetOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((ConnectedAssetOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((ConnectedAssetOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: getConnectedAssetSummary for server " + serverName + " with response: " + response.toString());
        return response;
    }

    public AssetResponse getAssetSummary(String serverName, String userId, String assetGUID) {
        String methodName = "getAssetSummary";
        log.debug("Calling method: getAssetSummary for server " + serverName);
        AssetResponse response = new AssetResponse();
        try {
            AssetHandler assetHandler = new AssetHandler(instanceHandler.getAccessServiceName(), serverName, instanceHandler.getRepositoryConnector(serverName), userId, assetGUID);
            response.setAsset(assetHandler.getAsset());
            response.setCertificationCount(assetHandler.getCertificationCount());
            response.setCommentCount(assetHandler.getCommentCount());
            response.setConnectionCount(assetHandler.getConnectionCount());
            response.setExternalIdentifierCount(assetHandler.getExternalIdentifierCount());
            response.setExternalReferencesCount(assetHandler.getExternalReferencesCount());
            response.setInformalTagCount(assetHandler.getInformalTagCount());
            response.setLicenseCount(assetHandler.getLicenseCount());
            response.setLikeCount(assetHandler.getLikeCount());
            response.setKnownLocationsCount(assetHandler.getKnownLocationsCount());
            response.setNoteLogsCount(assetHandler.getNoteLogsCount());
            response.setRatingsCount(assetHandler.getRatingsCount());
            response.setRelatedAssetCount(assetHandler.getRelatedAssetCount());
            response.setRelatedMediaReferenceCount(assetHandler.getRelatedMediaReferenceCount());
            response.setSchemaType(assetHandler.getSchemaType());
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((ConnectedAssetOMASAPIResponse)response, error);
        }
        catch (UnrecognizedAssetGUIDException error) {
            this.captureUnrecognizedAssetGUIDException((ConnectedAssetOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((ConnectedAssetOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((ConnectedAssetOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: getAssetSummary for server " + serverName + " with response: " + response.toString());
        return response;
    }

    public CertificationsResponse getCertifications(String serverName, String userId, String assetGUID, int elementStart, int maxElements) {
        String methodName = "getCertifications";
        log.debug("Calling method: getCertifications for server " + serverName);
        CertificationsResponse response = new CertificationsResponse();
        try {
            CertificationsHandler handler = new CertificationsHandler(instanceHandler.getAccessServiceName(), serverName, instanceHandler.getRepositoryConnector(serverName), userId, assetGUID, elementStart, maxElements);
            response.setList(handler.getList());
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((ConnectedAssetOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((ConnectedAssetOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((ConnectedAssetOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: getCertifications for server " + serverName + " with response: " + response.toString());
        return response;
    }

    public CommentsResponse getComments(String serverName, String userId, String assetGUID, int elementStart, int maxElements) {
        String methodName = "getComments";
        log.debug("Calling method: getComments for server " + serverName);
        CommentsResponse response = new CommentsResponse();
        try {
            CommentsHandler handler = new CommentsHandler(instanceHandler.getAccessServiceName(), serverName, instanceHandler.getRepositoryConnector(serverName), userId, assetGUID, elementStart, maxElements);
            response.setList(handler.getList());
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((ConnectedAssetOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((ConnectedAssetOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((ConnectedAssetOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: getComments for server " + serverName + " with response: " + response.toString());
        return response;
    }

    public CommentsResponse getCommentReplies(String serverName, String userId, String commentGUID, int elementStart, int maxElements) {
        String methodName = "getCommentReplies";
        log.debug("Calling method: getCommentReplies for server " + serverName);
        CommentsResponse response = new CommentsResponse();
        try {
            CommentRepliesHandler handler = new CommentRepliesHandler(instanceHandler.getAccessServiceName(), serverName, instanceHandler.getRepositoryConnector(serverName), userId, commentGUID, elementStart, maxElements);
            response.setList(handler.getList());
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((ConnectedAssetOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((ConnectedAssetOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((ConnectedAssetOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: getCommentReplies for server " + serverName + " with response: " + response.toString());
        return response;
    }

    public ConnectionsResponse getConnections(String serverName, String userId, String assetGUID, int elementStart, int maxElements) {
        String methodName = "getConnections";
        log.debug("Calling method: getConnections for server " + serverName);
        ConnectionsResponse response = new ConnectionsResponse();
        try {
            ConnectionsHandler handler = new ConnectionsHandler(instanceHandler.getAccessServiceName(), serverName, instanceHandler.getRepositoryConnector(serverName), userId, assetGUID, elementStart, maxElements);
            response.setList(handler.getList());
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((ConnectedAssetOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((ConnectedAssetOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((ConnectedAssetOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: getConnections for server " + serverName + " with response: " + response.toString());
        return response;
    }

    public ExternalIdentifiersResponse getExternalIdentifiers(String serverName, String userId, String assetGUID, int elementStart, int maxElements) {
        String methodName = "getExternalIdentifiers";
        log.debug("Calling method: getExternalIdentifiers for server " + serverName);
        ExternalIdentifiersResponse response = new ExternalIdentifiersResponse();
        try {
            ExternalIdentifiersHandler handler = new ExternalIdentifiersHandler(instanceHandler.getAccessServiceName(), serverName, instanceHandler.getRepositoryConnector(serverName), userId, assetGUID, elementStart, maxElements);
            response.setList(handler.getList());
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((ConnectedAssetOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((ConnectedAssetOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((ConnectedAssetOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: getExternalIdentifiers for server " + serverName + " with response: " + response.toString());
        return response;
    }

    public ExternalReferencesResponse getExternalReferences(String serverName, String userId, String assetGUID, int elementStart, int maxElements) {
        String methodName = "getExternalReferences";
        log.debug("Calling method: getExternalReferences for server " + serverName);
        ExternalReferencesResponse response = new ExternalReferencesResponse();
        try {
            ExternalReferencesHandler handler = new ExternalReferencesHandler(instanceHandler.getAccessServiceName(), serverName, instanceHandler.getRepositoryConnector(serverName), userId, assetGUID, elementStart, maxElements);
            response.setList(handler.getList());
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((ConnectedAssetOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((ConnectedAssetOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((ConnectedAssetOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: getExternalReferences for server " + serverName + " with response: " + response.toString());
        return response;
    }

    public InformalTagsResponse getInformalTags(String serverName, String userId, String assetGUID, int elementStart, int maxElements) {
        String methodName = "getInformalTags";
        log.debug("Calling method: getInformalTags for server " + serverName);
        InformalTagsResponse response = new InformalTagsResponse();
        try {
            InformalTagsHandler handler = new InformalTagsHandler(instanceHandler.getAccessServiceName(), serverName, instanceHandler.getRepositoryConnector(serverName), userId, assetGUID, elementStart, maxElements);
            response.setList(handler.getList());
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((ConnectedAssetOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((ConnectedAssetOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((ConnectedAssetOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: getInformalTags for server " + serverName + " with response: " + response.toString());
        return response;
    }

    public LicensesResponse getLicenses(String serverName, String userId, String assetGUID, int elementStart, int maxElements) {
        String methodName = "getLicenses";
        log.debug("Calling method: getLicenses for server " + serverName);
        LicensesResponse response = new LicensesResponse();
        try {
            LicensesHandler handler = new LicensesHandler(instanceHandler.getAccessServiceName(), serverName, instanceHandler.getRepositoryConnector(serverName), userId, assetGUID, elementStart, maxElements);
            response.setList(handler.getList());
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((ConnectedAssetOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((ConnectedAssetOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((ConnectedAssetOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: getLicenses for server " + serverName + " with response: " + response.toString());
        return response;
    }

    public LikesResponse getLikes(String serverName, String userId, String assetGUID, int elementStart, int maxElements) {
        String methodName = "getLikes";
        log.debug("Calling method: getLikes for server " + serverName);
        LikesResponse response = new LikesResponse();
        try {
            LikesHandler handler = new LikesHandler(instanceHandler.getAccessServiceName(), serverName, instanceHandler.getRepositoryConnector(serverName), userId, assetGUID, elementStart, maxElements);
            response.setList(handler.getList());
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((ConnectedAssetOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((ConnectedAssetOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((ConnectedAssetOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: getLikes for server " + serverName + " with response: " + response.toString());
        return response;
    }

    public LocationsResponse getKnownLocations(String serverName, String userId, String assetGUID, int elementStart, int maxElements) {
        String methodName = "getKnownLocations";
        log.debug("Calling method: getKnownLocations for server " + serverName);
        LocationsResponse response = new LocationsResponse();
        try {
            LocationsHandler handler = new LocationsHandler(instanceHandler.getAccessServiceName(), serverName, instanceHandler.getRepositoryConnector(serverName), userId, assetGUID, elementStart, maxElements);
            response.setList(handler.getList());
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((ConnectedAssetOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((ConnectedAssetOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((ConnectedAssetOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: getKnownLocations for server " + serverName + " with response: " + response.toString());
        return response;
    }

    public NoteLogsResponse getNoteLogs(String serverName, String userId, String assetGUID, int elementStart, int maxElements) {
        String methodName = "getNoteLogs";
        log.debug("Calling method: getNoteLogs for server " + serverName);
        NoteLogsResponse response = new NoteLogsResponse();
        try {
            NoteLogsHandler handler = new NoteLogsHandler(instanceHandler.getAccessServiceName(), serverName, instanceHandler.getRepositoryConnector(serverName), userId, assetGUID, elementStart, maxElements);
            response.setList(handler.getList());
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((ConnectedAssetOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((ConnectedAssetOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((ConnectedAssetOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: getNoteLogs for server " + serverName + " with response: " + response.toString());
        return response;
    }

    public NotesResponse getNotes(String serverName, String userId, String noteLogGUID, int elementStart, int maxElements) {
        String methodName = "getNotes";
        log.debug("Calling method: getNotes for server " + serverName);
        NotesResponse response = new NotesResponse();
        try {
            NotesHandler handler = new NotesHandler(instanceHandler.getAccessServiceName(), serverName, instanceHandler.getRepositoryConnector(serverName), userId, noteLogGUID, elementStart, maxElements);
            response.setList(handler.getList());
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((ConnectedAssetOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((ConnectedAssetOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((ConnectedAssetOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: getNotes for server " + serverName + " with response: " + response.toString());
        return response;
    }

    public RatingsResponse getRatings(String serverName, String userId, String assetGUID, int elementStart, int maxElements) {
        String methodName = "getRatings";
        log.debug("Calling method: getRatings for server " + serverName);
        RatingsResponse response = new RatingsResponse();
        try {
            RatingsHandler handler = new RatingsHandler(instanceHandler.getAccessServiceName(), serverName, instanceHandler.getRepositoryConnector(serverName), userId, assetGUID, elementStart, maxElements);
            response.setList(handler.getList());
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((ConnectedAssetOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((ConnectedAssetOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((ConnectedAssetOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: getRatings for server " + serverName + " with response: " + response.toString());
        return response;
    }

    public RelatedAssetsResponse getRelatedAssets(String serverName, String userId, String assetGUID, int elementStart, int maxElements) {
        String methodName = "getRelatedAssets";
        log.debug("Calling method: getRelatedAssets for server " + serverName);
        RelatedAssetsResponse response = new RelatedAssetsResponse();
        try {
            RelatedAssetsHandler handler = new RelatedAssetsHandler(instanceHandler.getAccessServiceName(), serverName, instanceHandler.getRepositoryConnector(serverName), userId, assetGUID, elementStart, maxElements);
            response.setList(handler.getList());
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((ConnectedAssetOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((ConnectedAssetOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((ConnectedAssetOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: getRelatedAssets for server " + serverName + " with response: " + response.toString());
        return response;
    }

    public RelatedMediaReferencesResponse getRelatedMediaReferences(String serverName, String userId, String assetGUID, int elementStart, int maxElements) {
        String methodName = "getRelatedMediaReferences";
        log.debug("Calling method: getRelatedMediaReferences for server " + serverName);
        RelatedMediaReferencesResponse response = new RelatedMediaReferencesResponse();
        try {
            RelatedMediaReferencesHandler handler = new RelatedMediaReferencesHandler(instanceHandler.getAccessServiceName(), serverName, instanceHandler.getRepositoryConnector(serverName), userId, assetGUID, elementStart, maxElements);
            response.setList(handler.getList());
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((ConnectedAssetOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((ConnectedAssetOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((ConnectedAssetOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: getRelatedMediaReferences for server " + serverName + " with response: " + response.toString());
        return response;
    }

    public SchemaAttributesResponse getSchemaAttributes(String serverName, String userId, String schemaTypeGUID, int elementStart, int maxElements) {
        String methodName = "getSchemaAttributes";
        log.debug("Calling method: getSchemaAttributes for server " + serverName);
        SchemaAttributesResponse response = new SchemaAttributesResponse();
        try {
            SchemaAttributesHandler handler = new SchemaAttributesHandler(instanceHandler.getAccessServiceName(), serverName, instanceHandler.getRepositoryConnector(serverName), userId, schemaTypeGUID, elementStart, maxElements);
            response.setList(handler.getList());
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((ConnectedAssetOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((ConnectedAssetOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((ConnectedAssetOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: getSchemaAttributes for server " + serverName + " with response: " + response.toString());
        return response;
    }

    private void captureCheckedException(ConnectedAssetOMASAPIResponse response, ConnectedAssetCheckedExceptionBase error, String exceptionClassName) {
        response.setRelatedHTTPCode(error.getReportedHTTPCode());
        response.setExceptionClassName(exceptionClassName);
        response.setExceptionErrorMessage(error.getErrorMessage());
        response.setExceptionSystemAction(error.getReportedSystemAction());
        response.setExceptionUserAction(error.getReportedUserAction());
    }

    private void captureCheckedException(ConnectedAssetOMASAPIResponse response, ConnectedAssetCheckedExceptionBase error, String exceptionClassName, Map<String, Object> exceptionProperties) {
        response.setRelatedHTTPCode(error.getReportedHTTPCode());
        response.setExceptionClassName(exceptionClassName);
        response.setExceptionErrorMessage(error.getErrorMessage());
        response.setExceptionSystemAction(error.getReportedSystemAction());
        response.setExceptionUserAction(error.getReportedUserAction());
        response.setExceptionProperties(exceptionProperties);
    }

    private void captureInvalidParameterException(ConnectedAssetOMASAPIResponse response, InvalidParameterException error) {
        String parameterName = error.getParameterName();
        if (parameterName != null) {
            HashMap<String, Object> exceptionProperties = new HashMap<String, Object>();
            exceptionProperties.put("parameterName", parameterName);
            this.captureCheckedException(response, (ConnectedAssetCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName(), exceptionProperties);
        } else {
            this.captureCheckedException(response, (ConnectedAssetCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
        }
    }

    private void captureUnrecognizedAssetGUIDException(ConnectedAssetOMASAPIResponse response, UnrecognizedAssetGUIDException error) {
        String assetGUID = error.getAssetGUID();
        if (assetGUID != null) {
            HashMap<String, Object> exceptionProperties = new HashMap<String, Object>();
            exceptionProperties.put("assetGUID", assetGUID);
            this.captureCheckedException(response, (ConnectedAssetCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName(), exceptionProperties);
        } else {
            this.captureCheckedException(response, (ConnectedAssetCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
        }
    }

    private void captureUnrecognizedConnectionGUIDException(ConnectedAssetOMASAPIResponse response, UnrecognizedConnectionGUIDException error) {
        String connectionGUID = error.getConnectionGUID();
        if (connectionGUID != null) {
            HashMap<String, Object> exceptionProperties = new HashMap<String, Object>();
            exceptionProperties.put("connectionGUID", connectionGUID);
            this.captureCheckedException(response, (ConnectedAssetCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName(), exceptionProperties);
        } else {
            this.captureCheckedException(response, (ConnectedAssetCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
        }
    }

    private void capturePropertyServerException(ConnectedAssetOMASAPIResponse response, PropertyServerException error) {
        response.setRelatedHTTPCode(error.getReportedHTTPCode());
        response.setExceptionClassName(PropertyServerException.class.getName());
        response.setExceptionErrorMessage(error.getErrorMessage());
        response.setExceptionSystemAction(error.getReportedSystemAction());
        response.setExceptionUserAction(error.getReportedUserAction());
    }

    private void captureUserNotAuthorizedException(ConnectedAssetOMASAPIResponse response, UserNotAuthorizedException error) {
        String userId = error.getUserId();
        if (userId != null) {
            HashMap<String, String> exceptionProperties = new HashMap<String, String>();
            exceptionProperties.put("userId", userId);
            response.setExceptionProperties(exceptionProperties);
        }
        response.setRelatedHTTPCode(error.getReportedHTTPCode());
        response.setExceptionClassName(UserNotAuthorizedException.class.getName());
        response.setExceptionErrorMessage(error.getErrorMessage());
        response.setExceptionSystemAction(error.getReportedSystemAction());
        response.setExceptionUserAction(error.getReportedUserAction());
    }
}

