/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.connectedasset.server.spring;

import org.odpi.openmetadata.accessservices.connectedasset.rest.AnnotationsResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.AssetResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.CertificationsResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.CommentsResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.ConnectionsResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.CountResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.ExternalIdentifiersResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.ExternalReferencesResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.InformalTagsResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.LicensesResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.LikesResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.LocationsResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.MeaningsResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.NoteLogsResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.NotesResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.RatingsResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.RelatedAssetsResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.RelatedMediaReferencesResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.SchemaResponse;
import org.odpi.openmetadata.accessservices.connectedasset.server.ConnectedAssetRESTServices;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/access-services/connected-asset/users/{userId}"})
public class ConnectedAssetOMASResource {
    private ConnectedAssetRESTServices restAPI = new ConnectedAssetRESTServices();

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}"})
    public AssetResponse getAssetSummary(@PathVariable String userId, @PathVariable String assetGUID) {
        return this.restAPI.getAssetSummary(userId, assetGUID);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/annotations"})
    public AnnotationsResponse getAnnotations(@PathVariable String userId, @PathVariable String assetGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getAnnotations(userId, assetGUID, elementStart, maxElements);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/annotations/count"})
    public CountResponse countAnnotations(@PathVariable String userId, @PathVariable String assetGUID) {
        return this.restAPI.countAnnotations(userId, assetGUID);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/certifications"})
    public CertificationsResponse getCertifications(@PathVariable String userId, @PathVariable String assetGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getCertifications(userId, assetGUID, elementStart, maxElements);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/certifications/count"})
    public CountResponse countCertifications(@PathVariable String userId, @PathVariable String assetGUID) {
        return this.restAPI.countCertifications(userId, assetGUID);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/comments"})
    public CommentsResponse getComments(@PathVariable String userId, @PathVariable String assetGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getComments(userId, assetGUID, elementStart, maxElements);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/comments/count"})
    public CountResponse countComments(@PathVariable String userId, @PathVariable String assetGUID) {
        return this.restAPI.countComments(userId, assetGUID);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/connections"})
    public ConnectionsResponse getConnections(@PathVariable String userId, @PathVariable String assetGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getConnections(userId, assetGUID, elementStart, maxElements);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/connections/count"})
    public CountResponse countConnections(@PathVariable String userId, @PathVariable String assetGUID) {
        return this.restAPI.countConnections(userId, assetGUID);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/external-identifiers"})
    public ExternalIdentifiersResponse getExternalIdentifiers(@PathVariable String userId, @PathVariable String assetGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getExternalIdentifiers(userId, assetGUID, elementStart, maxElements);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/external-identifiers/count"})
    public CountResponse countExternalIdentifiers(@PathVariable String userId, @PathVariable String assetGUID) {
        return this.restAPI.countExternalIdentifiers(userId, assetGUID);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/external-references"})
    public ExternalReferencesResponse getExternalReferences(@PathVariable String userId, @PathVariable String assetGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getExternalReferences(userId, assetGUID, elementStart, maxElements);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/external-references/count"})
    public CountResponse countExternalReferences(@PathVariable String userId, @PathVariable String assetGUID) {
        return this.restAPI.countExternalReferences(userId, assetGUID);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/informal-tags"})
    public InformalTagsResponse getInformalTags(@PathVariable String userId, @PathVariable String assetGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getInformalTags(userId, assetGUID, elementStart, maxElements);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/informal-tags/count"})
    public CountResponse countInformalTags(@PathVariable String userId, @PathVariable String assetGUID) {
        return this.restAPI.countInformalTags(userId, assetGUID);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/licenses"})
    public LicensesResponse getLicenses(@PathVariable String userId, @PathVariable String assetGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getLicenses(userId, assetGUID, elementStart, maxElements);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/licenses/count"})
    public CountResponse getLicenses(@PathVariable String userId, @PathVariable String assetGUID) {
        return this.restAPI.countLicenses(userId, assetGUID);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/likes"})
    public LikesResponse getLikes(@PathVariable String userId, @PathVariable String assetGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getLikes(userId, assetGUID, elementStart, maxElements);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/likes/count"})
    public CountResponse countLikes(@PathVariable String userId, @PathVariable String assetGUID) {
        return this.restAPI.countLikes(userId, assetGUID);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/known-locations"})
    public LocationsResponse getKnownLocations(@PathVariable String userId, @PathVariable String assetGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getKnownLocations(userId, assetGUID, elementStart, maxElements);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/known-locations/count"})
    public CountResponse countKnownLocations(@PathVariable String userId, @PathVariable String assetGUID) {
        return this.restAPI.countKnownLocations(userId, assetGUID);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/meanings"})
    public MeaningsResponse getMeanings(@PathVariable String userId, @PathVariable String assetGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getMeanings(userId, assetGUID, elementStart, maxElements);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/meanings/count"})
    public CountResponse countMeanings(@PathVariable String userId, @PathVariable String assetGUID) {
        return this.restAPI.countMeanings(userId, assetGUID);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/note-logs"})
    public NoteLogsResponse getNoteLogs(@PathVariable String userId, @PathVariable String assetGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getNoteLogs(userId, assetGUID, elementStart, maxElements);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/note-logs/count"})
    public CountResponse countNoteLogs(@PathVariable String userId, @PathVariable String assetGUID) {
        return this.restAPI.countNoteLogs(userId, assetGUID);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/notes"})
    public NotesResponse getNotes(@PathVariable String userId, @PathVariable String assetGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getNotes(userId, assetGUID, elementStart, maxElements);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/notes/count"})
    public CountResponse countNotes(@PathVariable String userId, @PathVariable String assetGUID) {
        return this.restAPI.countNotes(userId, assetGUID);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/ratings"})
    public RatingsResponse getRatings(@PathVariable String userId, @PathVariable String assetGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getRatings(userId, assetGUID, elementStart, maxElements);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/ratings/count"})
    public CountResponse countRatings(@PathVariable String userId, @PathVariable String assetGUID) {
        return this.restAPI.countRatings(userId, assetGUID);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/related-assets"})
    public RelatedAssetsResponse getRelatedAssets(@PathVariable String userId, @PathVariable String assetGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getRelatedAssets(userId, assetGUID, elementStart, maxElements);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/related-assets/count"})
    public CountResponse countRelatedAssets(@PathVariable String userId, @PathVariable String assetGUID) {
        return this.restAPI.countRelatedAssets(userId, assetGUID);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/related-media-references"})
    public RelatedMediaReferencesResponse getRelatedMediaReferences(@PathVariable String userId, @PathVariable String assetGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getRelatedMediaReferences(userId, assetGUID, elementStart, maxElements);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/related-media-references/count"})
    public CountResponse countRelatedMediaReferences(@PathVariable String userId, @PathVariable String assetGUID) {
        return this.restAPI.countRelatedMediaReferences(userId, assetGUID);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/schema"})
    public SchemaResponse getSchema(@PathVariable String userId, @PathVariable String assetGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getSchema(userId, assetGUID, elementStart, maxElements);
    }
}

