/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.connectedasset.server.spring;

import org.odpi.openmetadata.accessservices.connectedasset.rest.AssetResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.CertificationsResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.CommentsResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.ConnectionsResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.ExternalIdentifiersResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.ExternalReferencesResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.InformalTagsResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.LicensesResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.LikesResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.LocationsResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.NoteLogsResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.NotesResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.RatingsResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.RelatedAssetsResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.RelatedMediaReferencesResponse;
import org.odpi.openmetadata.accessservices.connectedasset.rest.SchemaAttributesResponse;
import org.odpi.openmetadata.accessservices.connectedasset.server.ConnectedAssetRESTServices;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/connected-asset/users/{userId}"})
public class ConnectedAssetResource {
    private ConnectedAssetRESTServices restAPI = new ConnectedAssetRESTServices();

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/via-connection/{connectionGUID}"})
    public AssetResponse getConnectedAssetSummary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String connectionGUID) {
        return this.restAPI.getConnectedAssetSummary(serverName, userId, assetGUID, connectionGUID);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}"})
    public AssetResponse getAssetSummary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID) {
        return this.restAPI.getAssetSummary(serverName, userId, assetGUID);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/certifications"})
    public CertificationsResponse getCertifications(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getCertifications(serverName, userId, assetGUID, elementStart, maxElements);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/comments"})
    public CommentsResponse getComments(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getComments(serverName, userId, assetGUID, elementStart, maxElements);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/comments/{commentGUID}/replies"})
    public CommentsResponse getCommentReplies(@PathVariable String serverName, @PathVariable String userId, @PathVariable String commentGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getCommentReplies(serverName, userId, commentGUID, elementStart, maxElements);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/connections"})
    public ConnectionsResponse getConnections(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getConnections(serverName, userId, assetGUID, elementStart, maxElements);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/external-identifiers"})
    public ExternalIdentifiersResponse getExternalIdentifiers(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getExternalIdentifiers(serverName, userId, assetGUID, elementStart, maxElements);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/external-references"})
    public ExternalReferencesResponse getExternalReferences(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getExternalReferences(serverName, userId, assetGUID, elementStart, maxElements);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/informal-tags"})
    public InformalTagsResponse getInformalTags(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getInformalTags(serverName, userId, assetGUID, elementStart, maxElements);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/licenses"})
    public LicensesResponse getLicenses(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getLicenses(serverName, userId, assetGUID, elementStart, maxElements);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/likes"})
    public LikesResponse getLikes(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getLikes(serverName, userId, assetGUID, elementStart, maxElements);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/known-locations"})
    public LocationsResponse getKnownLocations(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getKnownLocations(serverName, userId, assetGUID, elementStart, maxElements);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/note-logs"})
    public NoteLogsResponse getNoteLogs(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getNoteLogs(serverName, userId, assetGUID, elementStart, maxElements);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/note-log/{noteLogGUID}/notes"})
    public NotesResponse getNotes(@PathVariable String serverName, @PathVariable String userId, @PathVariable String noteLogGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getNotes(serverName, userId, noteLogGUID, elementStart, maxElements);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/ratings"})
    public RatingsResponse getRatings(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getRatings(serverName, userId, assetGUID, elementStart, maxElements);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/related-assets"})
    public RelatedAssetsResponse getRelatedAssets(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getRelatedAssets(serverName, userId, assetGUID, elementStart, maxElements);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{assetGUID}/related-media-references"})
    public RelatedMediaReferencesResponse getRelatedMediaReferences(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getRelatedMediaReferences(serverName, userId, assetGUID, elementStart, maxElements);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets/{schemaTypeGUID}/schema-attributes"})
    public SchemaAttributesResponse getSchemaAttributes(@PathVariable String serverName, @PathVariable String userId, @PathVariable String schemaTypeGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getSchemaAttributes(serverName, userId, schemaTypeGUID, elementStart, maxElements);
    }
}

