/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.odpi.openmetadata.adapters.adminservices.configurationstore.file.FileBasedServerConfigStoreProvider;
import org.odpi.openmetadata.adapters.adminservices.configurationstore.file.FileBasedUIServerConfigStoreProvider;
import org.odpi.openmetadata.adapters.connectors.cassandra.CassandraStoreProvider;
import org.odpi.openmetadata.adapters.eventbus.topic.inmemory.InMemoryOpenMetadataTopicProvider;
import org.odpi.openmetadata.adapters.eventbus.topic.kafka.KafkaOpenMetadataTopicProvider;
import org.odpi.openmetadata.adapters.repositoryservices.archiveconnector.file.FileBasedOpenMetadataArchiveStoreProvider;
import org.odpi.openmetadata.adapters.repositoryservices.auditlogstore.console.ConsoleAuditLogStoreProvider;
import org.odpi.openmetadata.adapters.repositoryservices.auditlogstore.file.FileBasedAuditLogStoreProvider;
import org.odpi.openmetadata.adapters.repositoryservices.cohortregistrystore.file.FileBasedRegistryStoreProvider;
import org.odpi.openmetadata.adapters.repositoryservices.graphrepository.repositoryconnector.GraphOMRSRepositoryConnectorProvider;
import org.odpi.openmetadata.adapters.repositoryservices.inmemory.repositoryconnector.InMemoryOMRSRepositoryConnectorProvider;
import org.odpi.openmetadata.adapters.repositoryservices.rest.repositoryconnector.OMRSRESTRepositoryConnectorProvider;
import org.odpi.openmetadata.frameworks.connectors.ConnectorProvider;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementOrigin;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.EmbeddedConnection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.VirtualConnection;
import org.odpi.openmetadata.openconnector.governancedarmonconnectors.securityofficerconnectors.securitytagconnector.SecurityTagConnectorProvider;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.securitysync.rangerconnector.RangerSecurityServiceConnectorProvider;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorConfigurationFactory {
    private static final String defaultTopicRootName = "openmetadata.repositoryservices.";
    private static final String defaultOMRSTopicLeafName = ".OMRSTopic";
    private static final String defaultEnterpriseTopicConnectorRootName = "openmetadata.repositoryservices.enterprise.";
    private static final String defaultCohortTopicConnectorRootName = "openmetadata.repositoryservices.cohort.";
    private static final Logger log = LoggerFactory.getLogger(ConnectorConfigurationFactory.class);

    public Connection getServerConfigConnection(String serverName) {
        Endpoint endpoint = new Endpoint();
        endpoint.setAddress("omag.server." + serverName + ".config");
        Connection connection = new Connection();
        connection.setEndpoint(endpoint);
        connection.setConnectorType(this.getConnectorType(FileBasedServerConfigStoreProvider.class.getName()));
        connection.setQualifiedName(endpoint.getAddress());
        return connection;
    }

    public Connection getUIServerConfigConnection(String serverName) {
        Endpoint endpoint = new Endpoint();
        endpoint.setAddress("ui.server." + serverName + ".config");
        Connection connection = new Connection();
        connection.setEndpoint(endpoint);
        connection.setConnectorType(this.getConnectorType(FileBasedUIServerConfigStoreProvider.class.getName()));
        connection.setQualifiedName(endpoint.getAddress());
        return connection;
    }

    public Connection getFileBasedAuditLogConnection(String localServerName) {
        String endpointGUID = "836efeae-ab34-4425-89f0-6adf2faa1f2e";
        String connectionGUID = "5390bf3e-6b38-4eda-b34a-de55ac4252a7";
        String endpointDescription = "OMRS default audit log endpoint.";
        String endpointAddress = localServerName + ".auditlog";
        String endpointName = "DefaultAuditLog.Endpoint." + endpointAddress;
        Endpoint endpoint = new Endpoint();
        endpoint.setType(this.getEndpointType());
        endpoint.setGUID("836efeae-ab34-4425-89f0-6adf2faa1f2e");
        endpoint.setQualifiedName(endpointName);
        endpoint.setDisplayName(endpointName);
        endpoint.setDescription("OMRS default audit log endpoint.");
        endpoint.setAddress(endpointAddress);
        String connectionDescription = "OMRS default audit log connection.";
        String connectionName = "DefaultAuditLog.Connection." + localServerName;
        Connection connection = new Connection();
        connection.setType(this.getConnectionType());
        connection.setGUID("5390bf3e-6b38-4eda-b34a-de55ac4252a7");
        connection.setQualifiedName(connectionName);
        connection.setDisplayName(connectionName);
        connection.setDescription("OMRS default audit log connection.");
        connection.setEndpoint(endpoint);
        connection.setConnectorType(this.getConnectorType(FileBasedAuditLogStoreProvider.class.getName()));
        return connection;
    }

    public Connection getDefaultAuditLogConnection(String localServerName) {
        String endpointGUID = "836efeae-ab34-4425-89f0-6adf2faa1f2e";
        String connectionGUID = "5390bf3e-6b38-4eda-b34a-de55ac4252a7";
        String endpointDescription = "OMRS default audit log endpoint.";
        String endpointAddress = localServerName + ".auditlog";
        String endpointName = "DefaultAuditLog.Endpoint." + endpointAddress;
        Endpoint endpoint = new Endpoint();
        endpoint.setType(this.getEndpointType());
        endpoint.setGUID("836efeae-ab34-4425-89f0-6adf2faa1f2e");
        endpoint.setQualifiedName(endpointName);
        endpoint.setDisplayName(endpointName);
        endpoint.setDescription("OMRS default audit log endpoint.");
        endpoint.setAddress(endpointAddress);
        String connectionDescription = "OMRS default audit log connection.";
        String connectionName = "DefaultAuditLog.Connection." + localServerName;
        Connection connection = new Connection();
        connection.setType(this.getConnectionType());
        connection.setGUID("5390bf3e-6b38-4eda-b34a-de55ac4252a7");
        connection.setQualifiedName(connectionName);
        connection.setDisplayName(connectionName);
        connection.setDescription("OMRS default audit log connection.");
        connection.setEndpoint(endpoint);
        connection.setConnectorType(this.getConnectorType(ConsoleAuditLogStoreProvider.class.getName()));
        return connection;
    }

    public Connection getOpenMetadataArchiveFileConnection(String fileName) {
        String endpointGUID = "45877b9c-9192-44ba-a2b7-6817bc753969";
        String connectionGUID = "447bbb33-84f9-4a56-a712-addeebdcd764";
        String endpointDescription = "Open metadata archive for " + fileName;
        String endpointName = "OpenMetadataArchiveFile.Endpoint" + fileName;
        Endpoint endpoint = new Endpoint();
        endpoint.setType(this.getEndpointType());
        endpoint.setGUID("45877b9c-9192-44ba-a2b7-6817bc753969");
        endpoint.setQualifiedName(endpointName);
        endpoint.setDisplayName(endpointName);
        endpoint.setDescription(endpointDescription);
        endpoint.setAddress(fileName);
        String connectionDescription = "Open metadata archive connection.";
        String connectionName = "OpenMetadataArchive.Connection." + fileName;
        Connection connection = new Connection();
        connection.setType(this.getConnectionType());
        connection.setGUID("447bbb33-84f9-4a56-a712-addeebdcd764");
        connection.setQualifiedName(connectionName);
        connection.setDisplayName(connectionName);
        connection.setDescription("Open metadata archive connection.");
        connection.setConnectorType(this.getConnectorType(FileBasedOpenMetadataArchiveStoreProvider.class.getName()));
        connection.setEndpoint(endpoint);
        return connection;
    }

    public Connection getDefaultCohortRegistryConnection(String localServerName, String cohortName) {
        String endpointGUID = "8bf8f5fa-b5d8-40e1-a00e-e4a0c59fd6c0";
        String connectionGUID = "b9af734f-f005-4085-9975-bf46c67a099a";
        String endpointDescription = "OMRS default cohort registry endpoint.";
        String endpointAddress = localServerName + "." + cohortName + ".registrystore";
        String endpointName = "DefaultCohortRegistry.Endpoint." + endpointAddress;
        Endpoint endpoint = new Endpoint();
        endpoint.setType(this.getEndpointType());
        endpoint.setGUID("8bf8f5fa-b5d8-40e1-a00e-e4a0c59fd6c0");
        endpoint.setQualifiedName(endpointName);
        endpoint.setDisplayName(endpointName);
        endpoint.setDescription("OMRS default cohort registry endpoint.");
        endpoint.setAddress(endpointAddress);
        String connectionDescription = "OMRS default cohort registry connection.";
        String connectionName = "DefaultCohortRegistry.Connection." + localServerName + "." + cohortName;
        Connection connection = new Connection();
        connection.setType(this.getConnectionType());
        connection.setGUID("b9af734f-f005-4085-9975-bf46c67a099a");
        connection.setQualifiedName(connectionName);
        connection.setDisplayName(connectionName);
        connection.setDescription("OMRS default cohort registry connection.");
        connection.setEndpoint(endpoint);
        connection.setConnectorType(this.getConnectorType(FileBasedRegistryStoreProvider.class.getName()));
        return connection;
    }

    public Connection getDefaultLocalRepositoryLocalConnection() {
        return null;
    }

    public Connection getDefaultLocalRepositoryRemoteConnection(String repositoryName, String localServerName, String localServerURL) {
        String endpointGUID = "cee85898-43aa-4af5-9bbd-2bed809d1acb";
        String connectionGUID = "858be98b-49d2-4ccf-9b23-01085a5f473f";
        String endpointDescription = "OMRS default repository REST API endpoint.";
        String endpointName = "DefaultRepositoryRESTAPI.Endpoint." + localServerName;
        Endpoint endpoint = new Endpoint();
        endpoint.setType(this.getEndpointType());
        endpoint.setGUID("cee85898-43aa-4af5-9bbd-2bed809d1acb");
        endpoint.setQualifiedName(endpointName);
        endpoint.setDisplayName(localServerName);
        endpoint.setDescription("OMRS default repository REST API endpoint.");
        endpoint.setAddress(localServerURL + "/servers/" + localServerName);
        String connectionDescription = "OMRS default repository REST API connection.";
        String connectionName = "Remote connection to " + repositoryName + "@" + localServerName;
        Connection connection = new Connection();
        connection.setType(this.getConnectionType());
        connection.setGUID("858be98b-49d2-4ccf-9b23-01085a5f473f");
        connection.setQualifiedName(connectionName);
        connection.setDisplayName(repositoryName + "@" + localServerName);
        connection.setDescription("OMRS default repository REST API connection.");
        connection.setEndpoint(endpoint);
        connection.setConnectorType(this.getConnectorType(OMRSRESTRepositoryConnectorProvider.class.getName()));
        return connection;
    }

    public Connection getLocalGraphRepositoryLocalConnection(String repositoryName, String localServerName) {
        String connectionGUID = "3f1fd4fc-90f9-436a-8e2c-2120d590f5e4";
        String connectionDescription = "OMRS default local graph repository connection.";
        String connectionName = "Local connection to " + repositoryName + "@" + localServerName;
        Connection connection = new Connection();
        connection.setType(this.getConnectionType());
        connection.setGUID("3f1fd4fc-90f9-436a-8e2c-2120d590f5e4");
        connection.setQualifiedName(connectionName);
        connection.setDisplayName(repositoryName + "@" + localServerName);
        connection.setDescription("OMRS default local graph repository connection.");
        connection.setConnectorType(this.getConnectorType(GraphOMRSRepositoryConnectorProvider.class.getName()));
        return connection;
    }

    public Connection getInMemoryLocalRepositoryLocalConnection(String repositoryName, String localServerName) {
        String connectionGUID = "6a3c07b0-0e04-42dc-bcc6-392609bf1d02";
        String connectionDescription = "OMRS default in memory local repository connection.";
        String connectionName = "Local connection to " + repositoryName + "@" + localServerName;
        Connection connection = new Connection();
        connection.setType(this.getConnectionType());
        connection.setGUID("6a3c07b0-0e04-42dc-bcc6-392609bf1d02");
        connection.setQualifiedName(connectionName);
        connection.setDisplayName(repositoryName + "@" + localServerName);
        connection.setDescription("OMRS default in memory local repository connection.");
        connection.setConnectorType(this.getConnectorType(InMemoryOMRSRepositoryConnectorProvider.class.getName()));
        return connection;
    }

    public Connection getRepositoryProxyConnection(String serverName, String connectorProviderClassName, String url, Map<String, Object> configurationProperties) {
        String endpointGUID = UUID.randomUUID().toString();
        String connectionGUID = UUID.randomUUID().toString();
        String endpointDescription = "Metadata repository native endpoint.";
        String connectionDescription = "Metadata repository native connection.";
        String endpointName = "MetadataRepositoryNative.Endpoint." + serverName;
        Endpoint endpoint = new Endpoint();
        endpoint.setType(this.getEndpointType());
        endpoint.setGUID(endpointGUID);
        endpoint.setQualifiedName(endpointName);
        endpoint.setDisplayName(endpointName);
        endpoint.setDescription("Metadata repository native endpoint.");
        endpoint.setAddress(url);
        String connectionName = "MetadataRepositoryNative.Connection." + serverName;
        Connection connection = new Connection();
        connection.setType(this.getConnectionType());
        connection.setGUID(connectionGUID);
        connection.setQualifiedName(connectionName);
        connection.setDisplayName(connectionName);
        connection.setDescription("Metadata repository native connection.");
        connection.setEndpoint(endpoint);
        connection.setConnectorType(this.getConnectorType(connectorProviderClassName));
        connection.setConfigurationProperties(configurationProperties);
        return connection;
    }

    public Connection getDefaultEventMapperConnection() {
        return null;
    }

    private List<EmbeddedConnection> getEmbeddedEventBusConnection(String eventSource, Map<String, Object> arguments, String eventBusConnectorProviderClassName, String topicURLRoot, String topicName, String serverId, Map<String, Object> eventBusConfigurationProperties) {
        EmbeddedConnection embeddedConnection = new EmbeddedConnection();
        Connection connection = this.getDefaultEventBusConnection(eventSource, eventBusConnectorProviderClassName, topicURLRoot, topicName, serverId, eventBusConfigurationProperties);
        embeddedConnection.setDisplayName(eventSource);
        embeddedConnection.setArguments(arguments);
        embeddedConnection.setEmbeddedConnection(connection);
        ArrayList<EmbeddedConnection> embeddedConnections = new ArrayList<EmbeddedConnection>();
        embeddedConnections.add(embeddedConnection);
        return embeddedConnections;
    }

    public Connection getDefaultEventBusConnection(String connectionName, String connectorProviderClassName, String topicURLRoot, String topicName, String serverId, Map<String, Object> configurationProperties) {
        Endpoint endpoint = null;
        if (topicName != null) {
            endpoint = new Endpoint();
            endpoint.setType(this.getEndpointType());
            endpoint.setGUID(UUID.randomUUID().toString());
            endpoint.setQualifiedName(topicName);
            endpoint.setDisplayName(topicName);
            endpoint.setDescription(connectionName);
            if (topicURLRoot == null) {
                endpoint.setAddress(topicName);
            } else {
                endpoint.setAddress(topicURLRoot + "." + topicName);
            }
        }
        String connectorTypeJavaClassName = KafkaOpenMetadataTopicProvider.class.getName();
        if (connectorProviderClassName != null) {
            connectorTypeJavaClassName = connectorProviderClassName;
        }
        if (configurationProperties == null) {
            configurationProperties = new HashMap<String, Object>();
        }
        configurationProperties.put("local.server.id", serverId);
        Connection connection = new Connection();
        connection.setType(this.getConnectionType());
        connection.setGUID(UUID.randomUUID().toString());
        connection.setQualifiedName(connectionName);
        connection.setDisplayName(connectionName);
        connection.setDescription(connectionName);
        connection.setEndpoint(endpoint);
        connection.setConnectorType(this.getConnectorType(connectorTypeJavaClassName));
        connection.setConfigurationProperties(configurationProperties);
        return connection;
    }

    public Connection getDefaultEnterpriseOMRSTopicConnection(String localServerName, String serverId) {
        String connectionGUID = "2084ee90-717b-49a1-938e-8f9d49567b8e";
        String connectionDescription = "OMRS default enterprise topic connection.";
        String topicName = defaultEnterpriseTopicConnectorRootName + localServerName + defaultOMRSTopicLeafName;
        String connectionName = "EnterpriseTopicConnector.Server." + localServerName;
        VirtualConnection connection = new VirtualConnection();
        connection.setType(this.getVirtualConnectionType());
        connection.setGUID("2084ee90-717b-49a1-938e-8f9d49567b8e");
        connection.setQualifiedName(connectionName);
        connection.setDisplayName(connectionName);
        connection.setDescription("OMRS default enterprise topic connection.");
        connection.setConnectorType(this.getConnectorType(OMRSTopicProvider.class.getName()));
        connection.setEmbeddedConnections(this.getEmbeddedEventBusConnection("Enterprise OMRS Events", null, InMemoryOpenMetadataTopicProvider.class.getName(), localServerName, topicName, serverId, null));
        return connection;
    }

    public Connection getDefaultCohortOMRSTopicConnection(String cohortName, Map<String, Object> configurationProperties, String eventBusConnectorProvider, String topicURLRoot, String serverId, Map<String, Object> eventBusConfigurationProperties) {
        String connectionGUID = "023bb1f3-03dd-47ae-b3bc-dce62e9c11cb";
        String connectionDescription = "OMRS default cohort topic connection.";
        String topicName = defaultCohortTopicConnectorRootName + cohortName + defaultOMRSTopicLeafName;
        String connectionName = "TopicConnector.Cohort." + cohortName;
        VirtualConnection connection = new VirtualConnection();
        connection.setType(this.getVirtualConnectionType());
        connection.setGUID("023bb1f3-03dd-47ae-b3bc-dce62e9c11cb");
        connection.setQualifiedName(connectionName);
        connection.setDisplayName(connectionName);
        connection.setDescription("OMRS default cohort topic connection.");
        connection.setConnectorType(this.getConnectorType(OMRSTopicProvider.class.getName()));
        connection.setConfigurationProperties(configurationProperties);
        connection.setEmbeddedConnections(this.getEmbeddedEventBusConnection(cohortName + " OMRS Topic", null, eventBusConnectorProvider, topicURLRoot, topicName, serverId, eventBusConfigurationProperties));
        return connection;
    }

    public Connection getRepositoryEventMapperConnection(String serverName, String connectorProviderClassName, Map<String, Object> configurationProperties, String eventSource) {
        String endpointGUID = UUID.randomUUID().toString();
        String connectionGUID = UUID.randomUUID().toString();
        String endpointDescription = "Repository event mapper endpoint.";
        String connectionDescription = "Repository event mapper connection.";
        String endpointName = "EventMapper.Endpoint." + serverName;
        Endpoint endpoint = new Endpoint();
        endpoint.setType(this.getEndpointType());
        endpoint.setGUID(endpointGUID);
        endpoint.setQualifiedName(endpointName);
        endpoint.setDisplayName(endpointName);
        endpoint.setDescription("Repository event mapper endpoint.");
        endpoint.setAddress(eventSource);
        String connectionName = "EventMapper.Connection." + serverName;
        Connection connection = new Connection();
        connection.setType(this.getConnectionType());
        connection.setGUID(connectionGUID);
        connection.setQualifiedName(connectionName);
        connection.setDisplayName(connectionName);
        connection.setDescription("Repository event mapper connection.");
        connection.setEndpoint(endpoint);
        connection.setConnectorType(this.getConnectorType(connectorProviderClassName));
        connection.setConfigurationProperties(configurationProperties);
        return connection;
    }

    public Connection getSecuritySyncServerConnection(String serverName, String url, Map<String, Object> configurationProperties) {
        String endpointGUID = "edc55b7b-344f-77c8-7871-e42f08a858fd";
        String endpointDescription = "OMRS repository endpoint for Security Sync Server.";
        String endpointName = "SecuritySyncServer.Endpoint." + serverName;
        Endpoint endpoint = this.getEndpoint(url, endpointName, "edc55b7b-344f-77c8-7871-e42f08a858fd", "OMRS repository endpoint for Security Sync Server.");
        String connectionName = "SecuritySyncServer.Connection." + serverName;
        String connectionGUID = "caa5be1e-d51f-8306-fe81-d3853dc7e415";
        String connectionDescription = "OMRS repository connection to Security Sync Server.";
        return this.getConnection(configurationProperties, endpoint, connectionName, "caa5be1e-d51f-8306-fe81-d3853dc7e415", "OMRS repository connection to Security Sync Server.", RangerSecurityServiceConnectorProvider.class.getName());
    }

    public Connection getSecurityOfficerServerConnection(String serverName, String url, Map<String, Object> configurationProperties) {
        String endpointGUID = "4e53023d-a3ec-73ae-d4d4-0302147f7834";
        String endpointDescription = "OMRS repository endpoint for Security Officer Server.";
        String endpointName = "SecurityOfficerServer.Endpoint." + serverName;
        Endpoint endpoint = this.getEndpoint(url, endpointName, "4e53023d-a3ec-73ae-d4d4-0302147f7834", "OMRS repository endpoint for Security Officer Server.");
        String connectionName = "SecurityOfficerServer.Connection." + serverName;
        String connectionGUID = "05cfb02d-3e40-ef76-ce93-02f492ce4c4d";
        String connectionDescription = "OMRS repository connection to Security Officer Server.";
        return this.getConnection(configurationProperties, endpoint, connectionName, "05cfb02d-3e40-ef76-ce93-02f492ce4c4d", "OMRS repository connection to Security Officer Server.", SecurityTagConnectorProvider.class.getName());
    }

    public Connection getVirtualizationSolutionConnection(String serverName, String connectorProviderClassName, Map<String, Object> virtualizationSolutionConfig) {
        Connection connection = new Connection();
        HashMap<String, String> additionalProperties = new HashMap<String, String>();
        Endpoint endpoint = new Endpoint();
        String endpointGUID = UUID.randomUUID().toString();
        String connectionGUID = UUID.randomUUID().toString();
        String endpointDescription = "Virualization solution endpoint.";
        String connectionDescription = "Virualization solution connection.";
        String endpointName = "Virtualizer.Endpoint." + serverName;
        if ("org.odpi.openmetadata.openconnectors.governancedaemonconnectors.viewgenerator.derby".equals(connectorProviderClassName)) {
            endpoint.setType(Endpoint.getEndpointType());
            endpoint.setGUID(endpointGUID);
            endpoint.setQualifiedName(endpointName);
            endpoint.setDisplayName(endpointName);
            endpoint.setDescription("Virualization solution endpoint.");
            endpoint.setAddress(virtualizationSolutionConfig.get("serverAddress").toString());
            HashMap<String, String> endpointProperties = new HashMap<String, String>();
            endpointProperties.put("timeoutInSecond", virtualizationSolutionConfig.get("timeoutInSecond").toString());
            endpointProperties.put("create", virtualizationSolutionConfig.get("create").toString());
            endpointProperties.put("connectorProviderName", connectorProviderClassName);
            endpoint.setAdditionalProperties(endpointProperties);
            String connectionName = "Vitualizer.Connection." + serverName;
            connection.setType(Connection.getConnectionType());
            connection.setGUID(connectionGUID);
            connection.setQualifiedName(connectionName);
            connection.setDisplayName(connectionName);
            connection.setDescription("Virualization solution connection.");
            connection.setUserId(virtualizationSolutionConfig.get("username").toString());
            connection.setClearPassword(virtualizationSolutionConfig.get("password").toString());
            connection.setEndpoint(endpoint);
            additionalProperties.put("gdbNode", virtualizationSolutionConfig.get("gdbNode").toString());
            additionalProperties.put("logicTableName", virtualizationSolutionConfig.get("logicTableName").toString());
            additionalProperties.put("logicTableDefinition", virtualizationSolutionConfig.get("logicTableDefinition").toString());
            additionalProperties.put("getLogicTables", virtualizationSolutionConfig.get("getLogicTables").toString());
            additionalProperties.put("frontendName", virtualizationSolutionConfig.get("frontendName").toString());
            additionalProperties.put("dataSchema", virtualizationSolutionConfig.get("schema").toString());
            additionalProperties.put("databaseName", virtualizationSolutionConfig.get("databaseName").toString());
            connection.setAdditionalProperties(additionalProperties);
        }
        return connection;
    }

    public Connection getDataPlatformConnection(String serverName, String connectorProviderClassName, Map<String, Object> dataPlatformConfigurationProperties) {
        String endpointGUID = UUID.randomUUID().toString();
        String connectionGUID = UUID.randomUUID().toString();
        String endpointDescription = "Data Platform Server endpoint.";
        String connectionDescription = "Data Platform connection.";
        String endpointName = "DataPlatform.Endpoint." + serverName;
        Endpoint endpoint = new Endpoint();
        Connection connection = new Connection();
        endpoint.setType(this.getEndpointType());
        endpoint.setGUID(endpointGUID);
        endpoint.setQualifiedName(endpointName);
        endpoint.setDisplayName(endpointName);
        endpoint.setDescription("Data Platform Server endpoint.");
        endpoint.setAddress(dataPlatformConfigurationProperties.get("serverAddress").toString());
        HashMap<String, String> endpointProperties = new HashMap<String, String>();
        endpointProperties.put("connectorProviderName", connectorProviderClassName);
        endpoint.setAdditionalProperties(endpointProperties);
        String connectionName = "Cassandra.Connection." + serverName;
        connection.setType(this.getConnectionType());
        connection.setGUID(connectionGUID);
        connection.setQualifiedName(connectionName);
        connection.setDisplayName(connectionName);
        connection.setDescription("Data Platform connection.");
        connection.setEndpoint(endpoint);
        CassandraStoreProvider cassandraStoreProvider = new CassandraStoreProvider();
        connection.setConnectorType(cassandraStoreProvider.getConnectorType());
        return connection;
    }

    public Connection getOpenLineageServerConfiguration(String serverName, String connectorProviderClassName, String url, Map<String, Object> configurationProperties) {
        String endpointGUID = UUID.randomUUID().toString();
        String connectionGUID = UUID.randomUUID().toString();
        String endpointDescription = "OpenLineage native endpoint.";
        String connectionDescription = "Open Lineage native connection.";
        String endpointName = "OpenLineage.Endpoint." + serverName;
        String connectionName = "OpenLineage.Connection." + serverName;
        Endpoint endpoint = this.getEndpoint(url, endpointName, endpointGUID, "OpenLineage native endpoint.");
        return this.getConnection(configurationProperties, endpoint, connectionName, connectionGUID, "Open Lineage native connection.", connectorProviderClassName);
    }

    private ConnectorType getConnectorType(String connectorProviderClassName) {
        ConnectorType connectorType = null;
        if (connectorProviderClassName != null) {
            try {
                Class<?> connectorProviderClass = Class.forName(connectorProviderClassName);
                Object potentialConnectorProvider = connectorProviderClass.newInstance();
                ConnectorProvider connectorProvider = (ConnectorProvider)potentialConnectorProvider;
                connectorType = connectorProvider.getConnectorType();
                if (connectorType == null) {
                    connectorType = new ConnectorType();
                    connectorType.setType(this.getConnectorTypeType());
                    connectorType.setGUID(UUID.randomUUID().toString());
                    connectorType.setQualifiedName(connectorProviderClassName);
                    connectorType.setDisplayName(connectorProviderClass.getSimpleName());
                    connectorType.setDescription("ConnectorType for " + connectorType.getDisplayName());
                    connectorType.setConnectorProviderClassName(connectorProviderClassName);
                }
            }
            catch (Throwable classException) {
                log.error("Bad connectorProviderClassName: " + classException.getMessage());
            }
        }
        return connectorType;
    }

    private ElementType getEndpointType() {
        ElementType elementType = Endpoint.getEndpointType();
        elementType.setElementOrigin(ElementOrigin.CONFIGURATION);
        return elementType;
    }

    private ElementType getConnectorTypeType() {
        ElementType elementType = ConnectorType.getConnectorTypeType();
        elementType.setElementOrigin(ElementOrigin.CONFIGURATION);
        return elementType;
    }

    private ElementType getConnectionType() {
        ElementType elementType = Connection.getConnectionType();
        elementType.setElementOrigin(ElementOrigin.CONFIGURATION);
        return elementType;
    }

    private ElementType getVirtualConnectionType() {
        ElementType elementType = VirtualConnection.getVirtualConnectionType();
        elementType.setElementOrigin(ElementOrigin.CONFIGURATION);
        return elementType;
    }

    private Endpoint getEndpoint(String url, String endpointName, String endpointGUID, String endpointDescription) {
        Endpoint endpoint = new Endpoint();
        endpoint.setType(this.getEndpointType());
        endpoint.setGUID(endpointGUID);
        endpoint.setQualifiedName(endpointName);
        endpoint.setDisplayName(endpointName);
        endpoint.setDescription(endpointDescription);
        endpoint.setAddress(url);
        return endpoint;
    }

    private Connection getConnection(Map<String, Object> configurationProperties, Endpoint endpoint, String connectionName, String connectionGUID, String connectionDescription, String className) {
        Connection connection = new Connection();
        connection.setType(this.getConnectionType());
        connection.setEndpoint(endpoint);
        connection.setGUID(connectionGUID);
        connection.setQualifiedName(connectionName);
        connection.setDisplayName(connectionName);
        connection.setDescription(connectionDescription);
        connection.setConnectorType(this.getConnectorType(className));
        connection.setConfigurationProperties(configurationProperties);
        return connection;
    }
}

