/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices;

import java.text.MessageFormat;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ConnectorConfigurationFactoryErrorCode {
    INVALID_CONNECTOR_PROVIDER(400, "CONNECTOR-CONFIGURATION-FACTORY-400-001 ", "Invalid Connector Provider class {0}; class loader exception was {1} with message {2}", "The system is unable to create the requested connector type because the Connector Provider's class is failing to initialize in the JVM.  This has resulted in an exception in the class loader.", "Update the configuration to include a valid Java class name for the connector provider in the connectorProviderClassName property of the connection's connectorType. Then retry the request.");

    private int httpErrorCode;
    private String errorMessageId;
    private String errorMessage;
    private String systemAction;
    private String userAction;
    private static final Logger log;

    private ConnectorConfigurationFactoryErrorCode(int httpErrorCode, String errorMessageId, String errorMessage, String systemAction, String userAction) {
        this.httpErrorCode = httpErrorCode;
        this.errorMessageId = errorMessageId;
        this.errorMessage = errorMessage;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public int getHTTPErrorCode() {
        return this.httpErrorCode;
    }

    public String getErrorMessageId() {
        return this.errorMessageId;
    }

    public String getFormattedErrorMessage(String ... params) {
        MessageFormat mf = new MessageFormat(this.errorMessage);
        String result = mf.format(params);
        log.debug(String.format("ConnectorConfigurationFactoryErrorCode.getMessage(%s): %s", Arrays.toString(params), result));
        return result;
    }

    public String getSystemAction() {
        return this.systemAction;
    }

    public String getUserAction() {
        return this.userAction;
    }

    static {
        log = LoggerFactory.getLogger(ConnectorConfigurationFactoryErrorCode.class);
    }
}

