/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.adminservices.configurationstore.encryptedfile.EncryptedFileBasedServerConfigStoreProvider;
import org.odpi.openmetadata.adapters.eventbus.topic.inmemory.InMemoryOpenMetadataTopicProvider;
import org.odpi.openmetadata.adapters.eventbus.topic.kafka.KafkaOpenMetadataTopicProvider;
import org.odpi.openmetadata.adapters.repositoryservices.ConnectorConfigurationFactoryErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.archiveconnector.file.FileBasedOpenMetadataArchiveStoreProvider;
import org.odpi.openmetadata.adapters.repositoryservices.auditlogstore.console.ConsoleAuditLogStoreProvider;
import org.odpi.openmetadata.adapters.repositoryservices.auditlogstore.eventtopic.EventTopicAuditLogStoreProvider;
import org.odpi.openmetadata.adapters.repositoryservices.auditlogstore.file.FileBasedAuditLogStoreProvider;
import org.odpi.openmetadata.adapters.repositoryservices.auditlogstore.slf4j.SLF4JAuditLogStoreProvider;
import org.odpi.openmetadata.adapters.repositoryservices.cohortregistrystore.file.FileBasedRegistryStoreProvider;
import org.odpi.openmetadata.adapters.repositoryservices.graphrepository.repositoryconnector.GraphOMRSRepositoryConnectorProvider;
import org.odpi.openmetadata.adapters.repositoryservices.inmemory.repositoryconnector.InMemoryOMRSRepositoryConnectorProvider;
import org.odpi.openmetadata.adapters.repositoryservices.readonly.repositoryconnector.ReadOnlyOMRSRepositoryConnectorProvider;
import org.odpi.openmetadata.adapters.repositoryservices.rest.repositoryconnector.OMRSRESTRepositoryConnectorProvider;
import org.odpi.openmetadata.frameworks.connectors.ConnectorProvider;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFRuntimeException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.EmbeddedConnection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.VirtualConnection;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorConfigurationFactory {
    private static final String defaultTopicRootName = "openmetadata.repositoryservices.";
    private static final String defaultOMRSTopicLeafName = ".OMRSTopic";
    private static final String defaultEnterpriseTopicConnectorRootName = "openmetadata.repositoryservices.enterprise.";
    private static final String defaultCohortTopicConnectorRootName = "openmetadata.repositoryservices.cohort.";
    private static final Logger log = LoggerFactory.getLogger(ConnectorConfigurationFactory.class);

    public Connection getServerConfigConnection(String serverName) {
        Endpoint endpoint = new Endpoint();
        endpoint.setAddress("data/servers/" + serverName + "/config/" + serverName + ".config");
        Connection connection = new Connection();
        connection.setEndpoint(endpoint);
        connection.setConnectorType(this.getConnectorType(EncryptedFileBasedServerConfigStoreProvider.class.getName()));
        connection.setQualifiedName(endpoint.getAddress());
        return connection;
    }

    public Connection getServerConfigConnectionForRetrieveAll() {
        Connection connection = new Connection();
        connection.setConnectorType(this.getConnectorType(EncryptedFileBasedServerConfigStoreProvider.class.getName()));
        return connection;
    }

    public Connection getDefaultAuditLogConnection() {
        List<OMRSAuditLogRecordSeverity> supportedSeverityDefinitions = Arrays.asList(OMRSAuditLogRecordSeverity.values());
        ArrayList<String> supportedSeverities = new ArrayList<String>();
        for (OMRSAuditLogRecordSeverity severityDefinition : supportedSeverityDefinitions) {
            if (OMRSAuditLogRecordSeverity.TRACE.equals((Object)severityDefinition) || OMRSAuditLogRecordSeverity.PERFMON.equals((Object)severityDefinition)) continue;
            supportedSeverities.add(severityDefinition.getName());
        }
        return this.getConsoleAuditLogConnection(supportedSeverities);
    }

    private void setSupportedAuditLogSeverities(List<String> supportedSeverities, Connection auditLogDestination) {
        if (supportedSeverities != null) {
            HashMap<String, List<String>> configurationProperties = new HashMap<String, List<String>>();
            configurationProperties.put("supportedSeverities", supportedSeverities);
            auditLogDestination.setConfigurationProperties(configurationProperties);
        }
    }

    public Connection getConsoleAuditLogConnection(List<String> supportedSeverities) {
        String destinationName = "Console";
        Connection connection = new Connection();
        connection.setDisplayName("Console");
        connection.setConnectorType(this.getConnectorType(ConsoleAuditLogStoreProvider.class.getName()));
        this.setSupportedAuditLogSeverities(supportedSeverities, connection);
        return connection;
    }

    public Connection getFileBasedAuditLogConnection(String localServerName, List<String> supportedSeverities) {
        String destinationName = "Files";
        String endpointAddress = "data/servers/" + localServerName + "/logs/auditlog";
        Endpoint endpoint = new Endpoint();
        endpoint.setAddress(endpointAddress);
        Connection connection = new Connection();
        connection.setDisplayName("Files in " + endpointAddress);
        connection.setEndpoint(endpoint);
        connection.setConnectorType(this.getConnectorType(FileBasedAuditLogStoreProvider.class.getName()));
        this.setSupportedAuditLogSeverities(supportedSeverities, connection);
        return connection;
    }

    public Connection getSLF4JAuditLogConnection(List<String> supportedSeverities) {
        String destinationName = "SLF4J";
        Connection connection = new Connection();
        connection.setDisplayName("SLF4J");
        connection.setConnectorType(this.getConnectorType(SLF4JAuditLogStoreProvider.class.getName()));
        this.setSupportedAuditLogSeverities(supportedSeverities, connection);
        return connection;
    }

    public Connection getEventTopicAuditLogConnection(String localServerName, List<String> supportedSeverities, String eventBusConnectorProviderClassName, String topicURLRoot, String serverId, Map<String, Object> eventBusConfigurationProperties) {
        String destinationName = "EventTopic";
        String topicName = defaultTopicRootName + localServerName + ".auditlog";
        VirtualConnection connection = new VirtualConnection();
        connection.setDisplayName("EventTopic " + topicName);
        connection.setConnectorType(this.getConnectorType(EventTopicAuditLogStoreProvider.class.getName()));
        connection.setEmbeddedConnections(this.getEmbeddedEventBusConnection(localServerName + " Audit Log Event Topic Destination", null, eventBusConnectorProviderClassName, topicURLRoot, topicName, serverId, eventBusConfigurationProperties));
        this.setSupportedAuditLogSeverities(supportedSeverities, (Connection)connection);
        return connection;
    }

    public Connection getOpenMetadataArchiveFileConnection(String fileName) {
        Endpoint endpoint = new Endpoint();
        endpoint.setAddress(fileName);
        Connection connection = new Connection();
        connection.setConnectorType(this.getConnectorType(FileBasedOpenMetadataArchiveStoreProvider.class.getName()));
        connection.setEndpoint(endpoint);
        return connection;
    }

    public Connection getDefaultCohortRegistryConnection(String localServerName, String cohortName) {
        String endpointAddress = "./data/servers/" + localServerName + "/cohorts/" + cohortName + ".registrystore";
        Endpoint endpoint = new Endpoint();
        endpoint.setAddress(endpointAddress);
        Connection connection = new Connection();
        connection.setEndpoint(endpoint);
        connection.setConnectorType(this.getConnectorType(FileBasedRegistryStoreProvider.class.getName()));
        return connection;
    }

    public Connection getDefaultLocalRepositoryLocalConnection() {
        return null;
    }

    public Connection getDefaultLocalRepositoryRemoteConnection(String localServerName, String localServerURL) {
        Endpoint endpoint = new Endpoint();
        endpoint.setAddress(localServerURL + "/servers/" + localServerName);
        Connection connection = new Connection();
        connection.setEndpoint(endpoint);
        connection.setConnectorType(this.getConnectorType(OMRSRESTRepositoryConnectorProvider.class.getName()));
        return connection;
    }

    public Connection getLocalGraphRepositoryLocalConnection(Map<String, Object> storageProperties) {
        Connection connection = new Connection();
        connection.setConnectorType(this.getConnectorType(GraphOMRSRepositoryConnectorProvider.class.getName()));
        connection.setConfigurationProperties(storageProperties);
        return connection;
    }

    public Connection getInMemoryLocalRepositoryLocalConnection() {
        Connection connection = new Connection();
        connection.setConnectorType(this.getConnectorType(InMemoryOMRSRepositoryConnectorProvider.class.getName()));
        return connection;
    }

    public Connection getReadOnlyLocalRepositoryLocalConnection() {
        Connection connection = new Connection();
        connection.setConnectorType(this.getConnectorType(ReadOnlyOMRSRepositoryConnectorProvider.class.getName()));
        return connection;
    }

    public Connection getRepositoryProxyConnection(String connectorProviderClassName, String url, Map<String, Object> configurationProperties) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Endpoint endpoint = new Endpoint();
        endpoint.setAddress(url);
        Connection connection = new Connection();
        connection.setEndpoint(endpoint);
        connection.setConnectorType(this.getDynamicConnectorType(connectorProviderClassName));
        connection.setConfigurationProperties(configurationProperties);
        return connection;
    }

    public Connection getDefaultEventMapperConnection() {
        return null;
    }

    private List<EmbeddedConnection> getEmbeddedEventBusConnection(String eventSource, Map<String, Object> arguments, String eventBusConnectorProviderClassName, String topicURLRoot, String topicName, String serverId, Map<String, Object> eventBusConfigurationProperties) {
        EmbeddedConnection embeddedConnection = new EmbeddedConnection();
        Connection connection = this.getDefaultEventBusConnection(eventBusConnectorProviderClassName, topicURLRoot, topicName, serverId, eventBusConfigurationProperties);
        embeddedConnection.setDisplayName(eventSource);
        embeddedConnection.setArguments(arguments);
        embeddedConnection.setEmbeddedConnection(connection);
        ArrayList<EmbeddedConnection> embeddedConnections = new ArrayList<EmbeddedConnection>();
        embeddedConnections.add(embeddedConnection);
        return embeddedConnections;
    }

    public Connection getDefaultEventBusConnection(String connectorProviderClassName, String topicURLRoot, String topicName, String serverId, Map<String, Object> configurationProperties) {
        Endpoint endpoint = null;
        if (topicName != null) {
            endpoint = new Endpoint();
            if (topicURLRoot == null) {
                endpoint.setAddress(topicName);
            } else {
                endpoint.setAddress(topicURLRoot + "." + topicName);
            }
        }
        String connectorTypeJavaClassName = KafkaOpenMetadataTopicProvider.class.getName();
        if (connectorProviderClassName != null && !"".equals(connectorProviderClassName)) {
            connectorTypeJavaClassName = connectorProviderClassName;
        }
        if (configurationProperties == null) {
            configurationProperties = new HashMap<String, Object>();
        }
        configurationProperties.put("local.server.id", serverId);
        Connection connection = new Connection();
        connection.setEndpoint(endpoint);
        connection.setConnectorType(this.getConnectorType(connectorTypeJavaClassName));
        connection.setConfigurationProperties(configurationProperties);
        return connection;
    }

    public Connection getDefaultEnterpriseOMRSTopicConnection(String localServerName, String serverId) {
        String topicName = defaultEnterpriseTopicConnectorRootName + localServerName + defaultOMRSTopicLeafName;
        VirtualConnection connection = new VirtualConnection();
        connection.setConnectorType(this.getConnectorType(OMRSTopicProvider.class.getName()));
        connection.setEmbeddedConnections(this.getEmbeddedEventBusConnection("Enterprise OMRS Events", null, InMemoryOpenMetadataTopicProvider.class.getName(), localServerName, topicName, serverId, null));
        return connection;
    }

    public Connection getDefaultCohortOMRSTopicConnection(String cohortName, Map<String, Object> configurationProperties, String eventBusConnectorProvider, String topicURLRoot, String serverId, Map<String, Object> eventBusConfigurationProperties) {
        String topicName = defaultCohortTopicConnectorRootName + cohortName + defaultOMRSTopicLeafName;
        VirtualConnection connection = new VirtualConnection();
        connection.setConnectorType(this.getConnectorType(OMRSTopicProvider.class.getName()));
        connection.setConfigurationProperties(configurationProperties);
        connection.setEmbeddedConnections(this.getEmbeddedEventBusConnection(cohortName + " OMRS Topic", null, eventBusConnectorProvider, topicURLRoot, topicName, serverId, eventBusConfigurationProperties));
        return connection;
    }

    public Connection getRepositoryEventMapperConnection(String connectorProviderClassName, Map<String, Object> configurationProperties, String eventSource) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Endpoint endpoint = new Endpoint();
        endpoint.setAddress(eventSource);
        Connection connection = new Connection();
        connection.setEndpoint(endpoint);
        connection.setConnectorType(this.getDynamicConnectorType(connectorProviderClassName));
        connection.setConfigurationProperties(configurationProperties);
        return connection;
    }

    private ConnectorType getConnectorType(String connectorProviderClassName) {
        String methodName = "getConnectorType";
        try {
            return this.getDynamicConnectorType(connectorProviderClassName);
        }
        catch (Exception classException) {
            log.error("Bad connectorProviderClassName: " + classException.getMessage());
            throw new OCFRuntimeException(ConnectorConfigurationFactoryErrorCode.INVALID_CONNECTOR_PROVIDER.getMessageDefinition(connectorProviderClassName, classException.getClass().getName(), classException.getMessage()), this.getClass().getName(), "getConnectorType", (Throwable)classException);
        }
    }

    private ConnectorType getDynamicConnectorType(String connectorProviderClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> connectorProviderClass;
        Object potentialConnectorProvider;
        ConnectorProvider connectorProvider;
        ConnectorType connectorType = null;
        if (connectorProviderClassName != null && (connectorType = (connectorProvider = (ConnectorProvider)(potentialConnectorProvider = (connectorProviderClass = Class.forName(connectorProviderClassName)).newInstance())).getConnectorType()) == null) {
            connectorType = new ConnectorType();
            connectorType.setConnectorProviderClassName(connectorProviderClassName);
        }
        return connectorType;
    }
}

