/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.odpi.openmetadata.adapters.repositoryservices.ConnectorConfigurationFactoryErrorCode;
import org.odpi.openmetadata.frameworks.connectors.ConnectorProvider;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFRuntimeException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.EmbeddedConnection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.VirtualConnection;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorConfigurationFactory {
    private static final String defaultTopicRootName = "openmetadata.repositoryservices.";
    private static final String defaultSingleOMRSTopicLeafName = ".OMRSTopic";
    private static final String defaultRegistrationOMRSTopicLeafName = ".OMRSTopic.registration";
    private static final String defaultTypesOMRSTopicLeafName = ".OMRSTopic.types";
    private static final String defaultInstancesOMRSTopicLeafName = ".OMRSTopic.instances";
    private static final String defaultEnterpriseTopicConnectorRootName = "openmetadata.repositoryservices.enterprise.";
    private static final String defaultCohortTopicConnectorRootName = "openmetadata.repositoryservices.cohort.";
    private static final String ENCRYPTED_FILE_BASED_SERVER_CONFIG_STORE_PROVIDER = "org.odpi.openmetadata.adapters.adminservices.configurationstore.encryptedfile.EncryptedFileBasedServerConfigStoreProvider";
    private static final String IN_MEMORY_OPEN_METADATA_TOPIC_PROVIDER = "org.odpi.openmetadata.adapters.eventbus.topic.inmemory.InMemoryOpenMetadataTopicProvider";
    private static final String KAFKA_OPEN_METADATA_TOPIC_PROVIDER = "org.odpi.openmetadata.adapters.eventbus.topic.kafka.KafkaOpenMetadataTopicProvider";
    private static final String FILE_BASED_OPEN_METADATA_ARCHIVE_STORE_PROVIDER = "org.odpi.openmetadata.adapters.repositoryservices.archiveconnector.file.FileBasedOpenMetadataArchiveStoreProvider";
    private static final String CONSOLE_AUDIT_LOG_STORE_PROVIDER = "org.odpi.openmetadata.adapters.repositoryservices.auditlogstore.console.ConsoleAuditLogStoreProvider";
    private static final String EVENT_TOPIC_AUDIT_LOG_STORE_PROVIDER = "org.odpi.openmetadata.adapters.repositoryservices.auditlogstore.eventtopic.EventTopicAuditLogStoreProvider";
    private static final String FILE_BASED_AUDIT_LOG_STORE_PROVIDER = "org.odpi.openmetadata.adapters.repositoryservices.auditlogstore.file.FileBasedAuditLogStoreProvider";
    private static final String SLF_4_J_AUDIT_LOG_STORE_PROVIDER = "org.odpi.openmetadata.adapters.repositoryservices.auditlogstore.slf4j.SLF4JAuditLogStoreProvider";
    private static final String FILE_BASED_REGISTRY_STORE_PROVIDER = "org.odpi.openmetadata.adapters.repositoryservices.cohortregistrystore.file.FileBasedRegistryStoreProvider";
    private static final String GRAPH_OMRS_REPOSITORY_CONNECTOR_PROVIDER = "org.odpi.openmetadata.adapters.repositoryservices.graphrepository.repositoryconnector.GraphOMRSRepositoryConnectorProvider";
    private static final String IN_MEMORY_OMRS_REPOSITORY_CONNECTOR_PROVIDER = "org.odpi.openmetadata.adapters.repositoryservices.inmemory.repositoryconnector.InMemoryOMRSRepositoryConnectorProvider";
    private static final String READ_ONLY_OMRS_REPOSITORY_CONNECTOR_PROVIDER = "org.odpi.openmetadata.adapters.repositoryservices.readonly.repositoryconnector.ReadOnlyOMRSRepositoryConnectorProvider";
    private static final String OMRSREST_REPOSITORY_CONNECTOR_PROVIDER = "org.odpi.openmetadata.adapters.repositoryservices.rest.repositoryconnector.OMRSRESTRepositoryConnectorProvider";
    private static final String OMRS_TOPIC_PROVIDER = "org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicProvider";
    private static final Logger log = LoggerFactory.getLogger(ConnectorConfigurationFactory.class);

    public Connection getServerConfigConnection(String serverName) {
        Endpoint endpoint = new Endpoint();
        endpoint.setAddress("data/servers/" + serverName + "/config/" + serverName + ".config");
        Connection connection = new Connection();
        connection.setEndpoint(endpoint);
        connection.setConnectorType(this.getConnectorType(ENCRYPTED_FILE_BASED_SERVER_CONFIG_STORE_PROVIDER));
        connection.setQualifiedName(endpoint.getAddress());
        return connection;
    }

    public Connection getServerConfigConnectionForRetrieveAll() {
        Connection connection = new Connection();
        connection.setConnectorType(this.getConnectorType(ENCRYPTED_FILE_BASED_SERVER_CONFIG_STORE_PROVIDER));
        return connection;
    }

    public Connection getDefaultAuditLogConnection() {
        List<OMRSAuditLogRecordSeverity> supportedSeverityDefinitions = Arrays.asList(OMRSAuditLogRecordSeverity.values());
        ArrayList<String> supportedSeverities = new ArrayList<String>();
        for (OMRSAuditLogRecordSeverity severityDefinition : supportedSeverityDefinitions) {
            if (OMRSAuditLogRecordSeverity.TRACE.equals((Object)severityDefinition) || OMRSAuditLogRecordSeverity.PERFMON.equals((Object)severityDefinition)) continue;
            supportedSeverities.add(severityDefinition.getName());
        }
        return this.getConsoleAuditLogConnection(supportedSeverities);
    }

    private void setSupportedAuditLogSeverities(List<String> supportedSeverities, Connection auditLogDestination) {
        if (supportedSeverities != null) {
            HashMap<String, List<String>> configurationProperties = new HashMap<String, List<String>>();
            configurationProperties.put("supportedSeverities", supportedSeverities);
            auditLogDestination.setConfigurationProperties(configurationProperties);
        }
    }

    public Connection getConsoleAuditLogConnection(List<String> supportedSeverities) {
        String destinationName = "Console";
        Connection connection = new Connection();
        connection.setDisplayName("Console");
        connection.setConnectorType(this.getConnectorType(CONSOLE_AUDIT_LOG_STORE_PROVIDER));
        this.setSupportedAuditLogSeverities(supportedSeverities, connection);
        return connection;
    }

    public Connection getFileBasedAuditLogConnection(String localServerName, List<String> supportedSeverities) {
        String destinationName = "Files";
        String endpointAddress = "data/servers/" + localServerName + "/logs/auditlog";
        Endpoint endpoint = new Endpoint();
        endpoint.setAddress(endpointAddress);
        Connection connection = new Connection();
        connection.setDisplayName("Files in " + endpointAddress);
        connection.setEndpoint(endpoint);
        connection.setConnectorType(this.getConnectorType(FILE_BASED_AUDIT_LOG_STORE_PROVIDER));
        this.setSupportedAuditLogSeverities(supportedSeverities, connection);
        return connection;
    }

    public Connection getSLF4JAuditLogConnection(List<String> supportedSeverities) {
        String destinationName = "SLF4J";
        Connection connection = new Connection();
        connection.setDisplayName("SLF4J");
        connection.setConnectorType(this.getConnectorType(SLF_4_J_AUDIT_LOG_STORE_PROVIDER));
        this.setSupportedAuditLogSeverities(supportedSeverities, connection);
        return connection;
    }

    public Connection getEventTopicAuditLogConnection(String localServerName, List<String> supportedSeverities, String eventBusConnectorProviderClassName, String topicURLRoot, String serverId, Map<String, Object> eventBusConfigurationProperties) {
        String destinationName = "EventTopic";
        String topicName = defaultTopicRootName + localServerName + ".auditlog";
        VirtualConnection connection = new VirtualConnection();
        connection.setDisplayName("EventTopic " + topicName);
        connection.setConnectorType(this.getConnectorType(EVENT_TOPIC_AUDIT_LOG_STORE_PROVIDER));
        connection.setEmbeddedConnections(this.getEmbeddedEventBusConnection(localServerName + " Audit Log Event Topic Destination", null, eventBusConnectorProviderClassName, topicURLRoot, topicName, serverId, eventBusConfigurationProperties));
        this.setSupportedAuditLogSeverities(supportedSeverities, (Connection)connection);
        return connection;
    }

    public Connection getOpenMetadataArchiveFileConnection(String fileName) {
        Endpoint endpoint = new Endpoint();
        endpoint.setAddress(fileName);
        Connection connection = new Connection();
        connection.setConnectorType(this.getConnectorType(FILE_BASED_OPEN_METADATA_ARCHIVE_STORE_PROVIDER));
        connection.setEndpoint(endpoint);
        return connection;
    }

    public Connection getDefaultCohortRegistryConnection(String localServerName, String cohortName) {
        String endpointAddress = "./data/servers/" + localServerName + "/cohorts/" + cohortName + ".registrystore";
        Endpoint endpoint = new Endpoint();
        endpoint.setAddress(endpointAddress);
        Connection connection = new Connection();
        connection.setEndpoint(endpoint);
        connection.setConnectorType(this.getConnectorType(FILE_BASED_REGISTRY_STORE_PROVIDER));
        return connection;
    }

    public Connection getDefaultLocalRepositoryLocalConnection() {
        return null;
    }

    public Connection getDefaultLocalRepositoryRemoteConnection(String localServerName, String localServerURL) {
        Endpoint endpoint = new Endpoint();
        endpoint.setAddress(localServerURL + "/servers/" + localServerName);
        Connection connection = new Connection();
        connection.setEndpoint(endpoint);
        connection.setConnectorType(this.getConnectorType(OMRSREST_REPOSITORY_CONNECTOR_PROVIDER));
        return connection;
    }

    public Connection getLocalGraphRepositoryLocalConnection(Map<String, Object> storageProperties) {
        Connection connection = new Connection();
        connection.setConnectorType(this.getConnectorType(GRAPH_OMRS_REPOSITORY_CONNECTOR_PROVIDER));
        connection.setConfigurationProperties(storageProperties);
        return connection;
    }

    public Connection getInMemoryLocalRepositoryLocalConnection() {
        Connection connection = new Connection();
        connection.setConnectorType(this.getConnectorType(IN_MEMORY_OMRS_REPOSITORY_CONNECTOR_PROVIDER));
        return connection;
    }

    public Connection getReadOnlyLocalRepositoryLocalConnection() {
        Connection connection = new Connection();
        connection.setConnectorType(this.getConnectorType(READ_ONLY_OMRS_REPOSITORY_CONNECTOR_PROVIDER));
        return connection;
    }

    public Connection getRepositoryConnection(String connectorProviderClassName, String url, Map<String, Object> configurationProperties) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Endpoint endpoint = new Endpoint();
        endpoint.setAddress(url);
        Connection connection = new Connection();
        connection.setEndpoint(endpoint);
        connection.setConnectorType(this.getDynamicConnectorType(connectorProviderClassName));
        connection.setConfigurationProperties(configurationProperties);
        return connection;
    }

    public Connection getDefaultEventMapperConnection() {
        return null;
    }

    private List<EmbeddedConnection> getEmbeddedEventBusConnection(String eventSource, Map<String, Object> arguments, String eventBusConnectorProviderClassName, String topicURLRoot, String topicName, String serverId, Map<String, Object> eventBusConfigurationProperties) {
        EmbeddedConnection embeddedConnection = new EmbeddedConnection();
        Connection connection = this.getDefaultEventBusConnection(eventBusConnectorProviderClassName, topicURLRoot, topicName, serverId, eventBusConfigurationProperties);
        embeddedConnection.setDisplayName(eventSource);
        embeddedConnection.setArguments(arguments);
        embeddedConnection.setEmbeddedConnection(connection);
        ArrayList<EmbeddedConnection> embeddedConnections = new ArrayList<EmbeddedConnection>();
        embeddedConnections.add(embeddedConnection);
        return embeddedConnections;
    }

    public Connection getDefaultEventBusConnection(String connectorProviderClassName, String topicURLRoot, String topicName, String serverId, Map<String, Object> configurationProperties) {
        Endpoint endpoint = null;
        if (topicName != null) {
            endpoint = new Endpoint();
            if (topicURLRoot == null) {
                endpoint.setAddress(topicName);
            } else {
                endpoint.setAddress(topicURLRoot + "." + topicName);
            }
        }
        String connectorTypeJavaClassName = KAFKA_OPEN_METADATA_TOPIC_PROVIDER;
        if (connectorProviderClassName != null && connectorProviderClassName.length() > 0) {
            connectorTypeJavaClassName = connectorProviderClassName;
        }
        if (configurationProperties == null) {
            configurationProperties = new HashMap<String, Object>();
        }
        configurationProperties.put("local.server.id", serverId);
        Connection connection = new Connection();
        connection.setEndpoint(endpoint);
        connection.setConnectorType(this.getConnectorType(connectorTypeJavaClassName));
        connection.setConfigurationProperties(configurationProperties);
        return connection;
    }

    public Connection getDefaultEnterpriseOMRSTopicConnection(String localServerName, String serverId) {
        String topicName = defaultEnterpriseTopicConnectorRootName + localServerName + defaultSingleOMRSTopicLeafName;
        VirtualConnection connection = new VirtualConnection();
        connection.setConnectorType(this.getConnectorType(OMRS_TOPIC_PROVIDER));
        connection.setEmbeddedConnections(this.getEmbeddedEventBusConnection("Enterprise OMRS Events", null, IN_MEMORY_OPEN_METADATA_TOPIC_PROVIDER, localServerName, topicName, serverId, null));
        return connection;
    }

    public Connection getDefaultSingleCohortOMRSTopicConnection(String cohortName, Map<String, Object> configurationProperties, String eventBusConnectorProvider, String topicURLRoot, String serverId, Map<String, Object> eventBusConfigurationProperties) {
        String topicName = defaultCohortTopicConnectorRootName + cohortName + defaultSingleOMRSTopicLeafName;
        String eventSource = cohortName + " OMRS Topic";
        return this.getDefaultCohortOMRSTopicConnection(topicName, configurationProperties, eventSource, eventBusConnectorProvider, topicURLRoot, serverId, eventBusConfigurationProperties);
    }

    public Connection getDefaultRegistrationCohortOMRSTopicConnection(String cohortName, Map<String, Object> configurationProperties, String eventBusConnectorProvider, String topicURLRoot, Map<String, Object> eventBusConfigurationProperties) {
        String topicName = defaultCohortTopicConnectorRootName + cohortName + defaultRegistrationOMRSTopicLeafName;
        String eventSource = cohortName + " OMRS Topic for registrations";
        return this.getDefaultCohortOMRSTopicConnection(topicName, configurationProperties, eventSource, eventBusConnectorProvider, topicURLRoot, UUID.randomUUID().toString(), eventBusConfigurationProperties);
    }

    public Connection getDefaultTypesCohortOMRSTopicConnection(String cohortName, Map<String, Object> configurationProperties, String eventBusConnectorProvider, String topicURLRoot, Map<String, Object> eventBusConfigurationProperties) {
        String topicName = defaultCohortTopicConnectorRootName + cohortName + defaultTypesOMRSTopicLeafName;
        String eventSource = cohortName + " OMRS Topic for types";
        return this.getDefaultCohortOMRSTopicConnection(topicName, configurationProperties, eventSource, eventBusConnectorProvider, topicURLRoot, UUID.randomUUID().toString(), eventBusConfigurationProperties);
    }

    public Connection getDefaultInstancesCohortOMRSTopicConnection(String cohortName, Map<String, Object> configurationProperties, String eventBusConnectorProvider, String topicURLRoot, String serverId, Map<String, Object> eventBusConfigurationProperties) {
        String topicName = defaultCohortTopicConnectorRootName + cohortName + defaultInstancesOMRSTopicLeafName;
        String eventSource = cohortName + " OMRS Topic for instances";
        return this.getDefaultCohortOMRSTopicConnection(topicName, configurationProperties, eventSource, eventBusConnectorProvider, topicURLRoot, serverId, eventBusConfigurationProperties);
    }

    public Connection getDefaultCohortOMRSTopicConnection(String topicName, Map<String, Object> configurationProperties, String eventSourceName, String eventBusConnectorProvider, String topicURLRoot, String consumerGroupId, Map<String, Object> eventBusConfigurationProperties) {
        VirtualConnection connection = new VirtualConnection();
        connection.setConnectorType(this.getConnectorType(OMRS_TOPIC_PROVIDER));
        connection.setConfigurationProperties(configurationProperties);
        connection.setEmbeddedConnections(this.getEmbeddedEventBusConnection(eventSourceName, null, eventBusConnectorProvider, topicURLRoot, topicName, consumerGroupId, eventBusConfigurationProperties));
        return connection;
    }

    public Connection getRepositoryEventMapperConnection(String connectorProviderClassName, Map<String, Object> configurationProperties, String eventSource) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Endpoint endpoint = new Endpoint();
        endpoint.setAddress(eventSource);
        Connection connection = new Connection();
        connection.setEndpoint(endpoint);
        connection.setConnectorType(this.getDynamicConnectorType(connectorProviderClassName));
        connection.setConfigurationProperties(configurationProperties);
        return connection;
    }

    private ConnectorType getConnectorType(String connectorProviderClassName) {
        String methodName = "getConnectorType";
        try {
            return this.getDynamicConnectorType(connectorProviderClassName);
        }
        catch (Exception classException) {
            log.error("Bad connectorProviderClassName: " + classException.getMessage());
            throw new OCFRuntimeException(ConnectorConfigurationFactoryErrorCode.INVALID_CONNECTOR_PROVIDER.getMessageDefinition(connectorProviderClassName, classException.getClass().getName(), classException.getMessage()), this.getClass().getName(), "getConnectorType", (Throwable)classException);
        }
    }

    private ConnectorType getDynamicConnectorType(String connectorProviderClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Class<?> connectorProviderClass;
        Object potentialConnectorProvider;
        ConnectorProvider connectorProvider;
        ConnectorType connectorType = null;
        if (connectorProviderClassName != null && (connectorType = (connectorProvider = (ConnectorProvider)(potentialConnectorProvider = (connectorProviderClass = Class.forName(connectorProviderClassName)).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]))).getConnectorType()) == null) {
            connectorType = new ConnectorType();
            connectorType.setConnectorProviderClassName(connectorProviderClassName);
        }
        return connectorType;
    }
}

