/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices;

import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.controls.JDBCConfigurationProperty;
import org.odpi.openmetadata.adapters.repositoryservices.ConnectorConfigurationFactoryErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.controls.PostgresConfigurationProperty;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogRecordSeverityLevel;
import org.odpi.openmetadata.frameworks.connectors.ConnectorProvider;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFRuntimeException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.EmbeddedConnection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.VirtualConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorConfigurationFactory {
    private static final String defaultTopicRootName = "openmetadata.repositoryservices.";
    private static final String defaultSingleOMRSTopicLeafName = ".OMRSTopic";
    private static final String defaultRegistrationOMRSTopicLeafName = ".OMRSTopic.registration";
    private static final String defaultTypesOMRSTopicLeafName = ".OMRSTopic.types";
    private static final String defaultInstancesOMRSTopicLeafName = ".OMRSTopic.instances";
    private static final String defaultEnterpriseTopicConnectorRootName = "openmetadata.repositoryservices.enterprise.";
    private static final String defaultCohortTopicConnectorRootName = "openmetadata.repositoryservices.cohort.";
    private static final String FILE_BASED_SERVER_CONFIG_STORE_PROVIDER = "org.odpi.openmetadata.adapters.adminservices.configurationstore.file.FileBasedServerConfigStoreProvider";
    private static final String IN_MEMORY_OPEN_METADATA_TOPIC_PROVIDER = "org.odpi.openmetadata.adapters.eventbus.topic.inmemory.InMemoryOpenMetadataTopicProvider";
    private static final String KAFKA_OPEN_METADATA_TOPIC_PROVIDER = "org.odpi.openmetadata.adapters.eventbus.topic.kafka.KafkaOpenMetadataTopicProvider";
    private static final String FILE_BASED_OPEN_METADATA_ARCHIVE_STORE_PROVIDER = "org.odpi.openmetadata.adapters.repositoryservices.archiveconnector.file.FileBasedOpenMetadataArchiveStoreProvider";
    private static final String CONSOLE_AUDIT_LOG_STORE_PROVIDER = "org.odpi.openmetadata.adapters.repositoryservices.auditlogstore.console.ConsoleAuditLogStoreProvider";
    private static final String EVENT_TOPIC_AUDIT_LOG_STORE_PROVIDER = "org.odpi.openmetadata.adapters.repositoryservices.auditlogstore.eventtopic.EventTopicAuditLogStoreProvider";
    private static final String FILE_BASED_AUDIT_LOG_STORE_PROVIDER = "org.odpi.openmetadata.adapters.repositoryservices.auditlogstore.file.FileBasedAuditLogStoreProvider";
    private static final String POSTGRES_BASED_AUDIT_LOG_STORE_PROVIDER = "org.odpi.openmetadata.adapters.repositoryservices.auditlogstore.postgres.PostgreSQLAuditLogDestinationProvider";
    private static final String SLF_4_J_AUDIT_LOG_STORE_PROVIDER = "org.odpi.openmetadata.adapters.repositoryservices.auditlogstore.slf4j.SLF4JAuditLogStoreProvider";
    private static final String FILE_BASED_REGISTRY_STORE_PROVIDER = "org.odpi.openmetadata.adapters.repositoryservices.cohortregistrystore.file.FileBasedRegistryStoreProvider";
    private static final String GRAPH_OMRS_REPOSITORY_CONNECTOR_PROVIDER = "org.odpi.openmetadata.adapters.repositoryservices.graphrepository.repositoryconnector.GraphOMRSRepositoryConnectorProvider";
    private static final String POSTGRES_OMRS_REPOSITORY_CONNECTOR_PROVIDER = "org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.PostgresOMRSRepositoryConnectorProvider";
    private static final String YAML_SECRETS_STORE_CONNECTOR_PROVIDER = "org.odpi.openmetadata.adapters.connectors.secretsstore.yaml.YAMLSecretsStoreProvider";
    private static final String JDBC_RESOURCE_CONNECTOR_PROVIDER = "org.odpi.openmetadata.adapters.connectors.resource.jdbc.JDBCResourceConnectorProvider";
    private static final String XTDB_OMRS_REPOSITORY_CONNECTOR_PROVIDER = "org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.XTDBOMRSRepositoryConnectorProvider";
    private static final String IN_MEMORY_OMRS_REPOSITORY_CONNECTOR_PROVIDER = "org.odpi.openmetadata.adapters.repositoryservices.inmemory.repositoryconnector.InMemoryOMRSRepositoryConnectorProvider";
    private static final String READ_ONLY_OMRS_REPOSITORY_CONNECTOR_PROVIDER = "org.odpi.openmetadata.adapters.repositoryservices.readonly.repositoryconnector.ReadOnlyOMRSRepositoryConnectorProvider";
    private static final String OMRS_REST_REPOSITORY_CONNECTOR_PROVIDER = "org.odpi.openmetadata.adapters.repositoryservices.rest.repositoryconnector.OMRSRESTRepositoryConnectorProvider";
    private static final String OMRS_TOPIC_PROVIDER = "org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicProvider";
    private static final Logger log = LoggerFactory.getLogger(ConnectorConfigurationFactory.class);

    public Connection getServerConfigConnection(String serverName) {
        Endpoint endpoint = new Endpoint();
        endpoint.setAddress("data/servers/" + serverName + "/config/" + serverName + ".config");
        Connection connection = new Connection();
        connection.setDisplayName("File Config Store Connection");
        connection.setEndpoint(endpoint);
        connection.setConnectorType(this.getConnectorType(FILE_BASED_SERVER_CONFIG_STORE_PROVIDER));
        connection.setQualifiedName(endpoint.getAddress());
        return connection;
    }

    public Connection getServerConfigConnectionForRetrieveAll() {
        Connection connection = new Connection();
        connection.setDisplayName("File Config Store Connection");
        connection.setConnectorType(this.getConnectorType(FILE_BASED_SERVER_CONFIG_STORE_PROVIDER));
        return connection;
    }

    public Connection getDefaultAuditLogConnection() {
        AuditLogRecordSeverityLevel[] supportedSeverityDefinitions = AuditLogRecordSeverityLevel.values();
        ArrayList<String> supportedSeverities = new ArrayList<String>();
        for (AuditLogRecordSeverityLevel severityDefinition : supportedSeverityDefinitions) {
            if (AuditLogRecordSeverityLevel.TRACE.equals((Object)severityDefinition) || AuditLogRecordSeverityLevel.ACTIVITY.equals((Object)severityDefinition) || AuditLogRecordSeverityLevel.TYPES.equals((Object)severityDefinition) || AuditLogRecordSeverityLevel.EVENT.equals((Object)severityDefinition) || AuditLogRecordSeverityLevel.PERFMON.equals((Object)severityDefinition)) continue;
            supportedSeverities.add(severityDefinition.getName());
        }
        return this.getConsoleAuditLogConnection("- default", supportedSeverities);
    }

    private void setSupportedAuditLogSeverities(List<String> supportedSeverities, Connection auditLogDestination) {
        if (supportedSeverities != null) {
            HashMap<String, List<String>> configurationProperties = new HashMap<String, List<String>>();
            configurationProperties.put("supportedSeverities", supportedSeverities);
            auditLogDestination.setConfigurationProperties(configurationProperties);
        }
    }

    public Connection getConsoleAuditLogConnection(String qualifier, List<String> supportedSeverities) {
        String destinationName = "Console";
        Connection connection = new Connection();
        connection.setQualifiedName("Console" + qualifier);
        connection.setDisplayName("Console");
        connection.setConnectorType(this.getConnectorType(CONSOLE_AUDIT_LOG_STORE_PROVIDER));
        this.setSupportedAuditLogSeverities(supportedSeverities, connection);
        return connection;
    }

    public Connection getFileBasedAuditLogConnection(String localServerName, String directoryName, List<String> supportedSeverities) {
        String destinationName = "Files";
        Object endpointAddress = "data/servers/" + localServerName + "/logs/ffdc";
        if (directoryName != null) {
            endpointAddress = directoryName;
        }
        Endpoint endpoint = new Endpoint();
        endpoint.setAddress((String)endpointAddress);
        Connection connection = new Connection();
        connection.setQualifiedName("Files in " + (String)endpointAddress);
        connection.setDisplayName("Files in " + (String)endpointAddress);
        connection.setEndpoint(endpoint);
        connection.setConnectorType(this.getConnectorType(FILE_BASED_AUDIT_LOG_STORE_PROVIDER));
        this.setSupportedAuditLogSeverities(supportedSeverities, connection);
        return connection;
    }

    public Connection getPostgreSQLBasedAuditLogConnection(Map<String, Object> storageProperties) {
        Connection secretsStoreConnection = new Connection();
        Endpoint endpoint = new Endpoint();
        if (storageProperties.containsKey(JDBCConfigurationProperty.SECRETS_STORE.getName())) {
            endpoint.setAddress(storageProperties.get(JDBCConfigurationProperty.SECRETS_STORE.getName()).toString());
        } else {
            endpoint.setAddress(JDBCConfigurationProperty.SECRETS_STORE.getExample());
        }
        secretsStoreConnection.setEndpoint(endpoint);
        secretsStoreConnection.setConnectorType(this.getConnectorType(YAML_SECRETS_STORE_CONNECTOR_PROVIDER));
        secretsStoreConnection.setConfigurationProperties(storageProperties);
        ArrayList<EmbeddedConnection> embeddedConnections = new ArrayList<EmbeddedConnection>();
        EmbeddedConnection embeddedConnection = new EmbeddedConnection();
        embeddedConnection.setEmbeddedConnection(secretsStoreConnection);
        embeddedConnections.add(embeddedConnection);
        VirtualConnection jdbcResourceConnection = new VirtualConnection();
        jdbcResourceConnection.setEmbeddedConnections(embeddedConnections);
        jdbcResourceConnection.setConnectorType(this.getConnectorType(JDBC_RESOURCE_CONNECTOR_PROVIDER));
        jdbcResourceConnection.setConfigurationProperties(storageProperties);
        endpoint = new Endpoint();
        if (storageProperties.containsKey(JDBCConfigurationProperty.DATABASE_URL.getName())) {
            endpoint.setAddress(storageProperties.get(JDBCConfigurationProperty.DATABASE_URL.getName()).toString());
        } else {
            endpoint.setAddress(JDBCConfigurationProperty.DATABASE_URL.getExample());
        }
        jdbcResourceConnection.setEndpoint(endpoint);
        embeddedConnections = new ArrayList();
        embeddedConnection = new EmbeddedConnection();
        embeddedConnection.setEmbeddedConnection((Connection)jdbcResourceConnection);
        embeddedConnections.add(embeddedConnection);
        VirtualConnection jdbcAuditLogConnection = new VirtualConnection();
        jdbcAuditLogConnection.setDisplayName("PostgreSQL Database Schema for Audit Log events");
        jdbcAuditLogConnection.setConnectorType(this.getConnectorType(POSTGRES_BASED_AUDIT_LOG_STORE_PROVIDER));
        jdbcAuditLogConnection.setConfigurationProperties(storageProperties);
        jdbcAuditLogConnection.setEmbeddedConnections(embeddedConnections);
        return jdbcAuditLogConnection;
    }

    public Connection getSLF4JAuditLogConnection(String qualifier, List<String> supportedSeverities) {
        String destinationName = "SLF4J";
        Connection connection = new Connection();
        connection.setQualifiedName("SLF4J" + qualifier);
        connection.setDisplayName("SLF4J");
        connection.setConnectorType(this.getConnectorType(SLF_4_J_AUDIT_LOG_STORE_PROVIDER));
        this.setSupportedAuditLogSeverities(supportedSeverities, connection);
        return connection;
    }

    public Connection getEventTopicAuditLogConnection(String localServerName, List<String> supportedSeverities, String eventBusConnectorProviderClassName, String topicURLRoot, String suppliedTopicName, String serverId, Map<String, Object> eventBusConfigurationProperties) {
        String destinationName = "EventTopic";
        Object topicName = defaultTopicRootName + localServerName + ".ffdc";
        if (suppliedTopicName != null) {
            topicName = suppliedTopicName;
        }
        VirtualConnection connection = new VirtualConnection();
        connection.setQualifiedName("EventTopic " + (String)topicName);
        connection.setDisplayName("EventTopic " + (String)topicName);
        connection.setConnectorType(this.getConnectorType(EVENT_TOPIC_AUDIT_LOG_STORE_PROVIDER));
        connection.setEmbeddedConnections(this.getEmbeddedEventBusConnection(localServerName + " Audit Log Event Topic Destination", null, eventBusConnectorProviderClassName, topicURLRoot, (String)topicName, serverId, "outOnly", eventBusConfigurationProperties));
        this.setSupportedAuditLogSeverities(supportedSeverities, (Connection)connection);
        return connection;
    }

    public Connection getOpenMetadataArchiveFileConnection(String fileName) {
        Endpoint endpoint = new Endpoint();
        endpoint.setAddress(fileName);
        Connection connection = new Connection();
        connection.setDisplayName("Open Metadata Archive File " + fileName + " Connection");
        connection.setConnectorType(this.getConnectorType(FILE_BASED_OPEN_METADATA_ARCHIVE_STORE_PROVIDER));
        connection.setEndpoint(endpoint);
        return connection;
    }

    public Connection getDefaultCohortRegistryConnection(String localServerName, String cohortName) {
        String endpointAddress = "./data/servers/" + localServerName + "/cohorts/" + cohortName + ".registrystore";
        Endpoint endpoint = new Endpoint();
        endpoint.setAddress(endpointAddress);
        Connection connection = new Connection();
        connection.setDisplayName("Cohort Registry Connection");
        connection.setEndpoint(endpoint);
        connection.setConnectorType(this.getConnectorType(FILE_BASED_REGISTRY_STORE_PROVIDER));
        return connection;
    }

    public Connection getDefaultLocalRepositoryLocalConnection() {
        return null;
    }

    public Connection getDefaultLocalRepositoryRemoteConnection(String localServerName, String localServerURL) {
        Endpoint endpoint = new Endpoint();
        endpoint.setAddress(localServerURL + "/servers/" + localServerName);
        Connection connection = new Connection();
        connection.setDisplayName("Local Repository Remote Connection");
        connection.setEndpoint(endpoint);
        connection.setConnectorType(this.getConnectorType(OMRS_REST_REPOSITORY_CONNECTOR_PROVIDER));
        return connection;
    }

    public Connection getLocalGraphRepositoryLocalConnection(Map<String, Object> storageProperties) {
        Connection connection = new Connection();
        connection.setDisplayName("Local Graph Repository");
        connection.setConnectorType(this.getConnectorType(GRAPH_OMRS_REPOSITORY_CONNECTOR_PROVIDER));
        connection.setConfigurationProperties(storageProperties);
        return connection;
    }

    public Connection getPostgresRepositoryLocalConnection(String localServerName, Map<String, Object> storageProperties) {
        Connection secretsStoreConnection = new Connection();
        Endpoint endpoint = new Endpoint();
        if (storageProperties.containsKey(PostgresConfigurationProperty.SECRETS_STORE.getName())) {
            endpoint.setAddress(storageProperties.get(PostgresConfigurationProperty.SECRETS_STORE.getName()).toString());
        } else {
            endpoint.setAddress(PostgresConfigurationProperty.SECRETS_STORE.getExample());
        }
        secretsStoreConnection.setEndpoint(endpoint);
        secretsStoreConnection.setConnectorType(this.getConnectorType(YAML_SECRETS_STORE_CONNECTOR_PROVIDER));
        secretsStoreConnection.setConfigurationProperties(storageProperties);
        ArrayList<EmbeddedConnection> embeddedConnections = new ArrayList<EmbeddedConnection>();
        EmbeddedConnection embeddedConnection = new EmbeddedConnection();
        embeddedConnection.setEmbeddedConnection(secretsStoreConnection);
        embeddedConnections.add(embeddedConnection);
        VirtualConnection jdbcResourceConnection = new VirtualConnection();
        jdbcResourceConnection.setEmbeddedConnections(embeddedConnections);
        jdbcResourceConnection.setConnectorType(this.getConnectorType(JDBC_RESOURCE_CONNECTOR_PROVIDER));
        jdbcResourceConnection.setConfigurationProperties(storageProperties);
        endpoint = new Endpoint();
        if (storageProperties.containsKey(PostgresConfigurationProperty.DATABASE_URL.getName())) {
            endpoint.setAddress(storageProperties.get(PostgresConfigurationProperty.DATABASE_URL.getName()).toString());
        } else {
            endpoint.setAddress(PostgresConfigurationProperty.DATABASE_URL.getExample());
        }
        jdbcResourceConnection.setEndpoint(endpoint);
        embeddedConnections = new ArrayList();
        embeddedConnection = new EmbeddedConnection();
        embeddedConnection.setEmbeddedConnection((Connection)jdbcResourceConnection);
        embeddedConnections.add(embeddedConnection);
        VirtualConnection postgresConnection = new VirtualConnection();
        postgresConnection.setDisplayName("PostgreSQL Database Schema Repository for " + localServerName);
        postgresConnection.setConnectorType(this.getConnectorType(POSTGRES_OMRS_REPOSITORY_CONNECTOR_PROVIDER));
        postgresConnection.setConfigurationProperties(storageProperties);
        postgresConnection.setEmbeddedConnections(embeddedConnections);
        return postgresConnection;
    }

    public Connection getXTDBInMemLocalRepositoryLocalConnection() {
        Connection connection = new Connection();
        connection.setDisplayName("Local In Memory XTDB Repository");
        connection.setConnectorType(this.getConnectorType(XTDB_OMRS_REPOSITORY_CONNECTOR_PROVIDER));
        return connection;
    }

    public Connection getXTDBKVLocalRepositoryLocalConnection(String serverName) {
        String repositoryDirectory = "data/servers/" + serverName + "/repository/xtdb-kv";
        HashMap<String, CallSite> luceneProperties = new HashMap<String, CallSite>();
        luceneProperties.put("db-dir", (CallSite)((Object)(repositoryDirectory + "/lucene")));
        HashMap<String, Object> indexStoreKVProperties = new HashMap<String, Object>();
        indexStoreKVProperties.put("xtdb/module", "xtdb.rocksdb/->kv-store");
        indexStoreKVProperties.put("db-dir", repositoryDirectory + "/rdb-index");
        HashMap<String, HashMap<String, Object>> indexStoreProperties = new HashMap<String, HashMap<String, Object>>();
        indexStoreProperties.put("kv-store", indexStoreKVProperties);
        HashMap<String, Object> documentStoreKVProperties = new HashMap<String, Object>();
        documentStoreKVProperties.put("xtdb/module", "xtdb.rocksdb/->kv-store");
        documentStoreKVProperties.put("db-dir", repositoryDirectory + "/rdb-docs");
        HashMap<String, HashMap<String, Object>> documentStoreProperties = new HashMap<String, HashMap<String, Object>>();
        documentStoreProperties.put("kv-store", documentStoreKVProperties);
        HashMap<String, Object> txLogKVProperties = new HashMap<String, Object>();
        txLogKVProperties.put("xtdb/module", "xtdb.rocksdb/->kv-store");
        txLogKVProperties.put("db-dir", repositoryDirectory + "/rdb-tx");
        HashMap<String, HashMap<String, Object>> txLogProperties = new HashMap<String, HashMap<String, Object>>();
        txLogProperties.put("kv-store", txLogKVProperties);
        HashMap<String, HashMap<String, Object>> xtdbConfigProperties = new HashMap<String, HashMap<String, Object>>();
        xtdbConfigProperties.put("xtdb.lucene/lucene-store", luceneProperties);
        xtdbConfigProperties.put("xtdb/index-store", indexStoreProperties);
        xtdbConfigProperties.put("xtdb/document-store", documentStoreProperties);
        xtdbConfigProperties.put("xtdb/tx-log", txLogProperties);
        HashMap<String, HashMap<String, HashMap<String, Object>>> storageProperties = new HashMap<String, HashMap<String, HashMap<String, Object>>>();
        storageProperties.put("xtdbConfig", xtdbConfigProperties);
        Connection connection = new Connection();
        connection.setDisplayName("Local KV XTDB Repository");
        connection.setConnectorType(this.getConnectorType(XTDB_OMRS_REPOSITORY_CONNECTOR_PROVIDER));
        connection.setConfigurationProperties(storageProperties);
        return connection;
    }

    public Connection getXTDBLocalRepositoryLocalConnection(Map<String, Object> storageProperties) {
        Connection connection = new Connection();
        connection.setDisplayName("Local XTDB Repository");
        connection.setConnectorType(this.getConnectorType(XTDB_OMRS_REPOSITORY_CONNECTOR_PROVIDER));
        connection.setConfigurationProperties(storageProperties);
        return connection;
    }

    public Connection getInMemoryLocalRepositoryLocalConnection() {
        Connection connection = new Connection();
        connection.setDisplayName("In Memory Local Repository Connection");
        connection.setConnectorType(this.getConnectorType(IN_MEMORY_OMRS_REPOSITORY_CONNECTOR_PROVIDER));
        return connection;
    }

    public Connection getReadOnlyLocalRepositoryLocalConnection() {
        Connection connection = new Connection();
        connection.setDisplayName("Read-only Local Repository Connection");
        connection.setConnectorType(this.getConnectorType(READ_ONLY_OMRS_REPOSITORY_CONNECTOR_PROVIDER));
        return connection;
    }

    public Connection getRepositoryConnection(String connectorProviderClassName, String url, Map<String, Object> configurationProperties) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Endpoint endpoint = new Endpoint();
        endpoint.setAddress(url);
        Connection connection = new Connection();
        connection.setDisplayName("Plugin Local Repository Connection");
        connection.setEndpoint(endpoint);
        connection.setConnectorType(this.getDynamicConnectorType(connectorProviderClassName));
        connection.setConfigurationProperties(configurationProperties);
        return connection;
    }

    public Connection getDefaultEventMapperConnection() {
        return null;
    }

    private List<EmbeddedConnection> getEmbeddedEventBusConnection(String eventSource, Map<String, Object> arguments, String eventBusConnectorProviderClassName, String topicURLRoot, String topicName, String serverId, String eventDirection, Map<String, Object> eventBusConfigurationProperties) {
        EmbeddedConnection embeddedConnection = new EmbeddedConnection();
        Connection connection = this.getDefaultEventBusConnection(eventBusConnectorProviderClassName, topicURLRoot, topicName, serverId, eventDirection, eventBusConfigurationProperties);
        embeddedConnection.setDisplayName(eventSource);
        embeddedConnection.setArguments(arguments);
        embeddedConnection.setEmbeddedConnection(connection);
        ArrayList<EmbeddedConnection> embeddedConnections = new ArrayList<EmbeddedConnection>();
        embeddedConnections.add(embeddedConnection);
        return embeddedConnections;
    }

    public Connection getDefaultEventBusConnection(String connectorProviderClassName, String topicURLRoot, String topicName, String serverId, String eventDirection, Map<String, Object> configurationProperties) {
        if (topicName != null) {
            Endpoint endpoint = new Endpoint();
            if (topicURLRoot == null) {
                endpoint.setAddress(topicName);
            } else {
                endpoint.setAddress(topicURLRoot + "." + topicName);
            }
            String connectorTypeJavaClassName = KAFKA_OPEN_METADATA_TOPIC_PROVIDER;
            if (connectorProviderClassName != null && connectorProviderClassName.length() > 0) {
                connectorTypeJavaClassName = connectorProviderClassName;
            }
            if (configurationProperties == null) {
                configurationProperties = new HashMap<String, Object>();
            }
            if (eventDirection != null && configurationProperties.get("eventDirection") == null) {
                configurationProperties.put("eventDirection", eventDirection);
            }
            if (StringUtils.isEmpty((CharSequence)((String)configurationProperties.get("local.server.id")))) {
                configurationProperties.put("local.server.id", serverId);
            }
            Connection connection = new Connection();
            connection.setDisplayName("Kafka Event Bus Connection");
            connection.setEndpoint(endpoint);
            connection.setConnectorType(this.getConnectorType(connectorTypeJavaClassName));
            connection.setConfigurationProperties(configurationProperties);
            return connection;
        }
        return null;
    }

    public Connection getDefaultEnterpriseOMRSTopicConnection(String localServerName, String serverId) {
        String topicName = defaultEnterpriseTopicConnectorRootName + localServerName + defaultSingleOMRSTopicLeafName;
        VirtualConnection connection = new VirtualConnection();
        connection.setDisplayName("Enterprise OMRS Topic Connection");
        connection.setConnectorType(this.getConnectorType(OMRS_TOPIC_PROVIDER));
        connection.setEmbeddedConnections(this.getEmbeddedEventBusConnection("Enterprise OMRS Events", null, IN_MEMORY_OPEN_METADATA_TOPIC_PROVIDER, localServerName, topicName, serverId, "inOut", null));
        return connection;
    }

    public Connection getDefaultRemoteEnterpriseOMRSTopicConnection(String localServerName, Map<String, Object> configurationProperties, String eventBusConnectorProvider, String topicURLRoot, String serverId, Map<String, Object> eventBusConfigurationProperties) {
        String topicName = defaultEnterpriseTopicConnectorRootName + localServerName + defaultSingleOMRSTopicLeafName;
        VirtualConnection connection = new VirtualConnection();
        connection.setDisplayName("Remote Enterprise OMRS Topic Connection");
        connection.setConnectorType(this.getConnectorType(OMRS_TOPIC_PROVIDER));
        connection.setConfigurationProperties(configurationProperties);
        connection.setEmbeddedConnections(this.getEmbeddedEventBusConnection("Remote Enterprise OMRS Events", null, eventBusConnectorProvider, topicURLRoot, topicName, serverId, "outOnly", eventBusConfigurationProperties));
        return connection;
    }

    public Connection getDefaultSingleCohortOMRSTopicConnection(String cohortName, Map<String, Object> configurationProperties, String eventBusConnectorProvider, String topicURLRoot, String serverId, Map<String, Object> eventBusConfigurationProperties) {
        String topicName = defaultCohortTopicConnectorRootName + cohortName + defaultSingleOMRSTopicLeafName;
        String eventSource = cohortName + " OMRS Topic";
        return this.getDefaultCohortOMRSTopicConnection(topicName, configurationProperties, eventSource, eventBusConnectorProvider, topicURLRoot, serverId, eventBusConfigurationProperties);
    }

    public Connection getDefaultRegistrationCohortOMRSTopicConnection(String cohortName, Map<String, Object> configurationProperties, String eventBusConnectorProvider, String topicURLRoot, Map<String, Object> eventBusConfigurationProperties) {
        String topicName = defaultCohortTopicConnectorRootName + cohortName + defaultRegistrationOMRSTopicLeafName;
        String eventSource = cohortName + " OMRS Topic for registrations";
        return this.getDefaultCohortOMRSTopicConnection(topicName, configurationProperties, eventSource, eventBusConnectorProvider, topicURLRoot, UUID.randomUUID().toString(), eventBusConfigurationProperties);
    }

    public Connection getDefaultTypesCohortOMRSTopicConnection(String cohortName, Map<String, Object> configurationProperties, String eventBusConnectorProvider, String topicURLRoot, Map<String, Object> eventBusConfigurationProperties) {
        String topicName = defaultCohortTopicConnectorRootName + cohortName + defaultTypesOMRSTopicLeafName;
        String eventSource = cohortName + " OMRS Topic for types";
        return this.getDefaultCohortOMRSTopicConnection(topicName, configurationProperties, eventSource, eventBusConnectorProvider, topicURLRoot, UUID.randomUUID().toString(), eventBusConfigurationProperties);
    }

    public Connection getDefaultInstancesCohortOMRSTopicConnection(String cohortName, Map<String, Object> configurationProperties, String eventBusConnectorProvider, String topicURLRoot, String serverId, Map<String, Object> eventBusConfigurationProperties) {
        String topicName = defaultCohortTopicConnectorRootName + cohortName + defaultInstancesOMRSTopicLeafName;
        String eventSource = cohortName + " OMRS Topic for instances";
        return this.getDefaultCohortOMRSTopicConnection(topicName, configurationProperties, eventSource, eventBusConnectorProvider, topicURLRoot, serverId, eventBusConfigurationProperties);
    }

    public Connection getDefaultCohortOMRSTopicConnection(String topicName, Map<String, Object> configurationProperties, String eventSourceName, String eventBusConnectorProvider, String topicURLRoot, String consumerGroupId, Map<String, Object> eventBusConfigurationProperties) {
        VirtualConnection connection = new VirtualConnection();
        connection.setDisplayName("Cohort OMRS Topic Connection for " + eventSourceName);
        connection.setConnectorType(this.getConnectorType(OMRS_TOPIC_PROVIDER));
        connection.setConfigurationProperties(configurationProperties);
        connection.setEmbeddedConnections(this.getEmbeddedEventBusConnection(eventSourceName, null, eventBusConnectorProvider, topicURLRoot, topicName, consumerGroupId, "inOut", eventBusConfigurationProperties));
        return connection;
    }

    public Connection getRepositoryEventMapperConnection(String connectorProviderClassName, Map<String, Object> configurationProperties, String eventSource) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Endpoint endpoint = new Endpoint();
        endpoint.setAddress(eventSource);
        Connection connection = new Connection();
        connection.setDisplayName("Repository Event Mapper Connection");
        connection.setEndpoint(endpoint);
        connection.setConnectorType(this.getDynamicConnectorType(connectorProviderClassName));
        connection.setConfigurationProperties(configurationProperties);
        return connection;
    }

    private ConnectorType getConnectorType(String connectorProviderClassName) {
        String methodName = "getConnectorType";
        try {
            return this.getDynamicConnectorType(connectorProviderClassName);
        }
        catch (Exception classException) {
            log.error("Bad connectorProviderClassName: " + classException.getMessage());
            throw new OCFRuntimeException(ConnectorConfigurationFactoryErrorCode.UNKNOWN_CONNECTOR_PROVIDER.getMessageDefinition(connectorProviderClassName, classException.getClass().getName(), classException.getMessage()), this.getClass().getName(), "getConnectorType", (Throwable)classException);
        }
    }

    private ConnectorType getDynamicConnectorType(String connectorProviderClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        String methodName = "getDynamicConnectorType";
        ConnectorType connectorType = null;
        if (connectorProviderClassName != null) {
            Class<?> connectorProviderClass = Class.forName(connectorProviderClassName);
            Object potentialConnectorProvider = connectorProviderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (potentialConnectorProvider instanceof ConnectorProvider) {
                connectorType = new ConnectorType();
                connectorType.setConnectorProviderClassName(connectorProviderClassName);
            } else {
                throw new OCFRuntimeException(ConnectorConfigurationFactoryErrorCode.INVALID_CONNECTOR_PROVIDER.getMessageDefinition(connectorProviderClassName), this.getClass().getName(), "getDynamicConnectorType");
            }
        }
        return connectorType;
    }
}

