/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveGUIDMap;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.OpenMetadataArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumElementDef;

public class SimpleCatalogArchiveHelper {
    protected static final String guidMapFileNamePostFix = "GUIDMap.json";
    private static final String ANCHORS_CLASSIFICATION_NAME = "Anchors";
    private static final String ANCHOR_GUID_PROPERTY = "anchorGUID";
    private static final String CONNECTION_TYPE_NAME = "Connection";
    private static final String CONNECTOR_TYPE_TYPE_NAME = "ConnectorType";
    private static final String ENDPOINT_TYPE_NAME = "Endpoint";
    private static final String CONNECTION_CONNECTOR_TYPE_TYPE_NAME = "ConnectionConnectorType";
    private static final String CONNECTION_ENDPOINT_TYPE_NAME = "ConnectionEndpoint";
    private static final String CONNECTOR_CATEGORY_TYPE_NAME = "ConnectorCategory";
    private static final String CONNECTOR_TYPE_DIRECTORY_TYPE_NAME = "ConnectorTypeDirectory";
    private static final String CONNECTOR_IMPL_CHOICE_TYPE_NAME = "ConnectorImplementationChoice";
    private static final String COLLECTION_TYPE_NAME = "Collection";
    private static final String COLLECTION_MEMBER_TYPE_NAME = "CollectionMembership";
    private static final String SEARCH_KEYWORD_TYPE_NAME = "SearchKeyword";
    private static final String SEARCH_KEYWORD_LINK_RELATIONSHIP_NAME = "SearchKeywordLink";
    private static final String EXTERNAL_REFERENCE_TYPE_NAME = "ExternalReference";
    public static final String EXTERNAL_GLOSSARY_LINK_TYPE_NAME = "ExternalGlossaryLink";
    public static final String RELATED_MEDIA_TYPE_NAME = "RelatedMedia";
    private static final String EXTERNAL_REFERENCE_LINK_RELATIONSHIP_NAME = "ExternalReferenceLink";
    private static final String MEDIA_REFERENCE_RELATIONSHIP_NAME = "MediaReference";
    private static final String MEDIA_USAGE_ENUM_NAME = "MediaUsage";
    public static final int MEDIA_USAGE_ICON = 0;
    public static final int MEDIA_USAGE_THUMBNAIL = 1;
    public static final int MEDIA_USAGE_ILLUSTRATION = 2;
    public static final int MEDIA_USAGE_USAGE_GUIDANCE = 3;
    public static final int MEDIA_USAGE_OTHER = 99;
    private static final String MEDIA_TYPE_ENUM_NAME = "MediaType";
    public static final int MEDIA_TYPE_IMAGE = 0;
    public static final int MEDIA_TYPE_AUDIO = 1;
    public static final int MEDIA_TYPE_DOCUMENT = 2;
    public static final int MEDIA_TYPE_VIDEO = 3;
    public static final int MEDIA_TYPE_OTHER = 99;
    private static final String EXTERNALLY_SOURCED_GLOSSARY_RELATIONSHIP_NAME = "ExternallySourcedGlossary";
    private static final String LIBRARY_CATEGORY_REFERENCE_RELATIONSHIP_NAME = "LibraryCategoryReference";
    private static final String LIBRARY_TERM_REFERENCE_RELATIONSHIP_NAME = "LibraryTermReference";
    private static final String SUBJECT_AREA_DEFINITION_TYPE_NAME = "SubjectAreaDefinition";
    private static final String SUBJECT_AREA_HIERARCHY_RELATIONSHIP_NAME = "SubjectAreaHierarchy";
    private static final String SUBJECT_AREA_CLASSIFICATION_NAME = "SubjectArea";
    private static final String GLOSSARY_TYPE_NAME = "Glossary";
    private static final String CANONICAL_VOCABULARY_TYPE_NAME = "CanonicalVocabulary";
    private static final String GLOSSARY_CATEGORY_TYPE_NAME = "GlossaryCategory";
    private static final String CATEGORY_ANCHOR_TYPE_NAME = "CategoryAnchor";
    private static final String CATEGORY_HIERARCHY_LINK_TYPE_NAME = "CategoryHierarchyLink";
    private static final String GLOSSARY_TERM_TYPE_NAME = "GlossaryTerm";
    private static final String TERM_ANCHOR_TYPE_NAME = "TermAnchor";
    private static final String TERM_CATEGORIZATION_TYPE_NAME = "TermCategorization";
    private static final String SEMANTIC_ASSIGNMENT_TYPE_NAME = "TermAnchor";
    private static final String MORE_INFORMATION_TYPE_NAME = "MoreInformation";
    private static final String SPINE_OBJECT_NAME = "SpineObject";
    private static final String SPINE_ATTRIBUTE_NAME = "SpineAttribute";
    private static final String IS_A_TYPE_OF_RELATIONSHIP_NAME = "IsATypeOfRelationship";
    private static final String HAS_A_RELATIONSHIP_NAME = "TermHASARelationship";
    private static final String RELATED_TERM_RELATIONSHIP_NAME = "RelatedTerm";
    private static final String TERM_RELATIONSHIP_STATUS_ENUM_NAME = "TermRelationshipStatus";
    public static final int TERM_RELATIONSHIP_STATUS_DRAFT = 0;
    public static final int TERM_RELATIONSHIP_STATUS_ACTIVE = 1;
    public static final int TERM_RELATIONSHIP_STATUS_DEPRECATED = 2;
    public static final int TERM_RELATIONSHIP_STATUS_OBSOLETE = 3;
    public static final int TERM_RELATIONSHIP_STATUS_OTHER = 4;
    private static final String CONTEXT_DEFINITION_CLASSIFICATION_NAME = "ContextDefinition";
    private static final String USED_IN_CONTEXT_RELATIONSHIP_NAME = "UsedInContext";
    private static final String DESIGN_MODEL_TYPE_NAME = "DesignModel";
    private static final String CONCEPT_MODEL_CLASSIFICATION_NAME = "ConceptModel";
    private static final String DESIGN_MODEL_SCOPE_TYPE_NAME = "DesignModelScope";
    private static final String DESIGN_MODEL_ELEMENTS_IN_SCOPE_TYPE_NAME = "DesignModelElementsInScope";
    private static final String DESIGN_MODEL_ELEMENT_TYPE_NAME = "DesignModelElement";
    private static final String DESIGN_MODEL_GROUP_TYPE_NAME = "DesignModelGroup";
    private static final String DESIGN_MODEL_GROUP_MEMBERSHIP_NAME = "DesignModelGroupMembership";
    private static final String DESIGN_MODEL_OWNERSHIP_RELATIONSHIP_NAME = "DesignModelOwnership";
    private static final String DESIGN_MODEL_IMPL_RELATIONSHIP_NAME = "DesignModelImplementation";
    private static final String METAMODEL_INSTANCE_CLASSIFICATION_NAME = "MetamodelInstance";
    private static final String METAMODEL_ELEMENT_GUID_PROPERTY_NAME = "metamodelElementGUID";
    private static final String CONCEPT_BEAD_TYPE_NAME = "ConceptBead";
    private static final String CONCEPT_BEAD_LINK_TYPE_NAME = "ConceptBeadLink";
    private static final String CONCEPT_BEAD_ATTRIBUTE_TYPE_NAME = "ConceptBeadAttribute";
    private static final String CONCEPT_BEAD_RELATIONSHIP_END_NAME = "ConceptBeadRelationshipEnd";
    private static final String CONCEPT_BEAD_ATTRIBUTE_LINK_TYPE_NAME = "ConceptBeadAttributeLink";
    private static final String CONCEPT_MODEL_DECORATION_ENUM_NAME = "ConceptModelDecoration";
    public static final int CONCEPT_MODEL_DECORATION_NONE = 0;
    public static final int CONCEPT_MODEL_DECORATION_AGGREGATION = 1;
    public static final int CONCEPT_MODEL_DECORATION_COMPOSITION = 2;
    public static final int CONCEPT_MODEL_DECORATION_EXTENSION = 3;
    private static final String CONCEPT_BEAD_COVERAGE_CATEGORY_ENUM_NAME = "ConceptBeadAttributeCoverageCategory";
    public static final int CONCEPT_BEAD_COVERAGE_UNKNOWN = 0;
    public static final int CONCEPT_BEAD_COVERAGE_UNIQUE_IDENTIFIER = 1;
    public static final int CONCEPT_BEAD_COVERAGE_IDENTIFIER = 2;
    public static final int CONCEPT_BEAD_COVERAGE_CORE_DETAIL = 3;
    public static final int CONCEPT_BEAD_COVERAGE_EXTENDED_DETAIL = 4;
    private static final String CONCEPT_BEAD_COVERAGE_CLASSIFICATION_NAME = "ConceptBeadAttributeCoverage";
    private static final String CONCEPT_BEAD_COVERAGE_CATEGORY_PROPERTY = "coverageCategory";
    private static final String SOFTWARE_CAPABILITY_TYPE_NAME = "SoftwareCapability";
    private static final String ASSET_TYPE_NAME = "Asset";
    private static final String CONNECTION_TO_ASSET_TYPE_NAME = "ConnectionToAsset";
    private static final String DATA_CONTENT_FOR_DATA_SET_TYPE_NAME = "DataContentForDataSet";
    private static final String ASSET_SCHEMA_TYPE_TYPE_NAME = "AssetSchemaType";
    private static final String ASSET_ZONE_MEMBERSHIP_TYPE_NAME = "AssetZoneMembership";
    private static final String SCHEMA_TYPE_TYPE_NAME = "SchemaType";
    private static final String PRIMITIVE_SCHEMA_TYPE_TYPE_NAME = "PrimitiveSchemaType";
    private static final String SCHEMA_TYPE_OPTION_TYPE_NAME = "SchemaTypeOption";
    private static final String SCHEMA_ATTRIBUTE_TYPE_NAME = "SchemaAttribute";
    private static final String ATTRIBUTE_FOR_SCHEMA_TYPE_NAME = "AttributeForSchema";
    private static final String NESTED_SCHEMA_ATTRIBUTE_TYPE_NAME = "NestedSchemaAttribute";
    private static final String TYPE_EMBEDDED_ATTRIBUTE_TYPE_NAME = "TypeEmbeddedAttribute";
    private static final String CALCULATED_VALUE_TYPE_NAME = "CalculatedValue";
    private static final String DERIVED_QUERY_TARGET_TYPE_NAME = "DerivedSchemaTypeQueryTarget";
    private static final String PRIMARY_KEY_TYPE_NAME = "PrimaryKey";
    private static final String FOREIGN_KEY_TYPE_NAME = "ForeignKey";
    private static final String API_OPERATION_TYPE_NAME = "APIOperation";
    private static final String API_OPERATIONS_TYPE_NAME = "APIOperations";
    public static final String API_HEADER_TYPE_NAME = "APIHeader";
    public static final String API_REQUEST_TYPE_NAME = "APIRequest";
    public static final String API_RESPONSE_TYPE_NAME = "APIResponse";
    private static final String API_PARAMETER_TYPE_NAME = "APIParameter";
    private static final String API_PARAMETER_LIST_TYPE_NAME = "APIParameterList";
    private static final String QUALIFIED_NAME_PROPERTY = "qualifiedName";
    private static final String ADDITIONAL_PROPERTIES_PROPERTY = "additionalProperties";
    private static final String NAME_PROPERTY = "name";
    private static final String ATTRIBUTE_NAME_PROPERTY = "attributeName";
    private static final String DISPLAY_NAME_PROPERTY = "displayName";
    private static final String TECHNICAL_NAME_PROPERTY = "technicalName";
    private static final String DESCRIPTION_PROPERTY = "description";
    private static final String DECORATION_PROPERTY = "decoration";
    private static final String VERSION_NUMBER_PROPERTY = "versionNumber";
    private static final String AUTHOR_PROPERTY = "author";
    private static final String POSITION_PROPERTY = "position";
    private static final String MIN_CARDINALITY_PROPERTY = "minCardinality";
    private static final String MAX_CARDINALITY_PROPERTY = "maxCardinality";
    private static final String UNIQUE_VALUES_PROPERTY = "uniqueValues";
    private static final String ORDERED_VALUES_PROPERTY = "orderedValues";
    private static final String NAVIGABLE_PROPERTY = "navigable";
    private static final String ASSET_SUMMARY_PROPERTY = "assetSummary";
    private static final String ZONE_MEMBERSHIP_PROPERTY = "zoneMembership";
    private static final String CAPABILITY_TYPE_PROPERTY = "capabilityType";
    private static final String CAPABILITY_VERSION_PROPERTY = "capabilityVersion";
    private static final String PATCH_LEVEL_PROPERTY = "patchLevel";
    private static final String SUPPORTED_ASSET_TYPE_PROPERTY = "supportedAssetTypeName";
    private static final String EXPECTED_DATA_FORMAT_PROPERTY = "expectedDataFormat";
    private static final String CONNECTOR_PROVIDER_PROPERTY = "connectorProviderClassName";
    private static final String CONNECTOR_FRAMEWORK_PROPERTY = "connectorFrameworkNameName";
    private static final String CONNECTOR_FRAMEWORK_DEFAULT = "Open Connector Framework (OCF)";
    private static final String CONNECTOR_INTERFACE_LANGUAGE_PROPERTY = "connectorInterfaceLanguage";
    private static final String CONNECTOR_INTERFACE_LANGUAGE_DEFAULT = "Java";
    private static final String CONNECTOR_INTERFACES_PROPERTY = "connectorInterfaces";
    private static final String TARGET_TECHNOLOGY_SOURCE_PROPERTY = "targetTechnologySource";
    private static final String TARGET_TECHNOLOGY_NAME_PROPERTY = "targetTechnologyName";
    private static final String TARGET_TECHNOLOGY_INTERFACES_PROPERTY = "targetTechnologyInterfaces";
    private static final String TARGET_TECHNOLOGY_VERSIONS_PROPERTY = "targetTechnologyVersions";
    private static final String SECURED_PROPERTIES_PROPERTY = "securedProperties";
    private static final String CONFIGURATION_PROPERTIES_PROPERTY = "configurationProperties";
    private static final String USER_ID_PROPERTY = "userId";
    private static final String CLEAR_PASSWORD_PROPERTY = "clearPassword";
    private static final String ENCRYPTED_PASSWORD_PROPERTY = "encryptedPassword";
    private static final String RECOGNIZED_ADDITIONAL_PROPERTIES_PROPERTY = "recognizedAdditionalProperties";
    private static final String RECOGNIZED_SECURED_PROPERTIES_PROPERTY = "recognizedSecuredProperties";
    private static final String RECOGNIZED_CONFIGURATION_PROPERTIES_PROPERTY = "recognizedConfigurationProperties";
    private static final String NETWORK_ADDRESS_PROPERTY = "networkAddress";
    private static final String PROTOCOL_PROPERTY = "protocol";
    private static final String REQUIRED_PROPERTY = "required";
    private static final String PARAMETER_TYPE_PROPERTY = "parameterType";
    private static final String PATH_TYPE_PROPERTY = "path";
    private static final String COMMAND_TYPE_PROPERTY = "command";
    private static final String CONFIDENCE_TYPE_PROPERTY = "confidence";
    private static final String SCOPE_PROPERTY = "scope";
    private static final String STATUS_PROPERTY = "status";
    private static final String STEWARD_PROPERTY = "steward";
    private static final String STEWARD_TYPE_NAME_PROPERTY = "stewardTypeName";
    private static final String STEWARD_PROPERTY_NAME_PROPERTY = "stewardPropertyName";
    private static final String SOURCE_PROPERTY = "source";
    private static final String EXPRESSION_PROPERTY = "expression";
    private static final String NOTES_PROPERTY = "notes";
    private static final String FORMULA_PROPERTY = "formula";
    private static final String QUERY_ID_PROPERTY = "queryId";
    private static final String QUERY_PROPERTY = "query";
    private static final String ALLOWS_DUPLICATE_VALUES_PROPERTY = "allowsDuplicateValues";
    private static final String DEFAULT_VALUE_OVERRIDE_PROPERTY = "defaultValueOverride";
    private static final String MINIMUM_LENGTH_PROPERTY = "minimumLength";
    private static final String LENGTH_PROPERTY = "length";
    private static final String PRECISION_PROPERTY = "precision";
    private static final String SIGNIFICANT_DIGITS_PROPERTY = "significantDigits";
    private static final String IS_NULLABLE_PROPERTY = "isNullable";
    private static final String NATIVE_CLASS_PROPERTY = "nativeClass";
    private static final String ALIASES_PROPERTY = "aliases";
    private static final String SORT_ORDER_PROPERTY = "sortOrder";
    private static final String SCHEMA_TYPE_NAME_PROPERTY = "schemaTypeName";
    private static final String IS_DEPRECATED_PROPERTY = "isDeprecated";
    private static final String USAGE_PROPERTY = "usage";
    private static final String ENCODING_STANDARD_PROPERTY = "encodingStandard";
    private static final String NAMESPACE_PROPERTY = "namespace";
    private static final String DATA_TYPE_PROPERTY = "dataType";
    private static final String DEFAULT_VALUE_PROPERTY = "defaultValue";
    private static final String FIXED_VALUE_PROPERTY = "fixedValue";
    private static final String DOMAIN_IDENTIFIER_PROPERTY = "domainIdentifier";
    private static final String EXAMPLES_PROPERTY = "examples";
    private static final String LANGUAGE_PROPERTY = "language";
    private static final String IDENTIFIER_PROPERTY = "identifier";
    private static final String LAST_VERIFIED_PROPERTY = "lastVerified";
    private static final String REFERENCE_ID_PROPERTY = "referenceId";
    private static final String PAGES_PROPERTY = "pages";
    private static final String MEDIA_ID_PROPERTY = "mediaId";
    private static final String MEDIA_USAGE_PROPERTY = "mediaUsage";
    private static final String MEDIA_USAGE_OTHER_ID_PROPERTY = "mediaUsageOtherId";
    private static final String KEYWORD_PROPERTY = "keyword";
    private static final String REFERENCE_TITLE_PROPERTY = "referenceTitle";
    private static final String REFERENCE_ABSTRACT_PROPERTY = "referenceAbstract";
    private static final String AUTHORS_PROPERTY = "authors";
    private static final String NUMBER_OF_PAGES_PROPERTY = "numberOfPages";
    private static final String PAGE_RANGE_PROPERTY = "pageRange";
    private static final String ORGANIZATION_PROPERTY = "organization";
    private static final String PUBLICATION_SERIES_PROPERTY = "publicationSeries";
    private static final String PUBLICATION_SERIES_VOLUME_PROPERTY = "publicationSeriesVolume";
    private static final String EDITION_PROPERTY = "edition";
    private static final String REFERENCE_VERSION_PROPERTY = "referenceVersion";
    private static final String URL_PROPERTY = "url";
    private static final String PUBLISHER_PROPERTY = "publisher";
    private static final String FIRST_PUBLICATION_DATE_PROPERTY = "firstPublicationDate";
    private static final String PUBLICATION_DATE_PROPERTY = "publicationDate";
    private static final String PUBLICATION_CITY_PROPERTY = "publicationCity";
    private static final String PUBLICATION_YEAR_PROPERTY = "publicationYear";
    private static final String PUBLICATION_NUMBERS_PROPERTY = "publicationNumbers";
    private static final String LICENSE_PROPERTY = "license";
    private static final String COPYRIGHT_PROPERTY = "copyright";
    private static final String ATTRIBUTION_PROPERTY = "attribution";
    private static final String MEDIA_TYPE_PROPERTY = "mediaType";
    private static final String MEDIA_TYPE_OTHER_ID_PROPERTY = "mediaTypeOtherId";
    private static final String DEFAULT_MEDIA_USAGE_PROPERTY = "defaultMediaUsage";
    private static final String DEFAULT_MEDIA_USAGE_OTHER_ID_PROPERTY = "defaultMediaUsageOtherId";
    private static final String STATUS_IDENTIFIER_PROPERTY = "statusIdentifier";
    private static final String CONFIDENCE_PROPERTY = "confidence";
    private static final String ATTRIBUTE_PROPERTY = "attribute";
    protected OpenMetadataArchiveBuilder archiveBuilder;
    protected OMRSArchiveHelper archiveHelper;
    protected OMRSArchiveGUIDMap idToGUIDMap;
    protected String archiveRootName;
    protected String originatorName;
    protected String versionName;
    protected EnumElementDef activeStatus;

    public SimpleCatalogArchiveHelper(OpenMetadataArchiveBuilder archiveBuilder, String archiveGUID, String archiveRootName, String originatorName, Date creationDate, long versionNumber, String versionName) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, versionNumber, versionName);
        this.idToGUIDMap = new OMRSArchiveGUIDMap(archiveRootName + guidMapFileNamePostFix);
        this.archiveRootName = archiveRootName;
        this.originatorName = originatorName;
        this.versionName = versionName;
        this.activeStatus = this.archiveHelper.getEnumElement(TERM_RELATIONSHIP_STATUS_ENUM_NAME, 1);
    }

    public String getGUID(String qualifiedName) {
        return this.idToGUIDMap.getGUID(qualifiedName);
    }

    public void saveGUIDs() {
        System.out.println("GUIDs map size: " + this.idToGUIDMap.getSize());
        this.idToGUIDMap.saveGUIDs();
    }

    public String addExternalReference(String typeName, String qualifiedName, String displayName, String referenceTitle, String referenceAbstract, String description, List<String> authors, int numberOfPages, String pageRange, String authorOrganization, String publicationSeries, String publicationSeriesVolume, String edition, String versionNumber, String referenceURL, String publisher, Date firstPublicationDate, Date publicationDate, String publicationCity, String publicationYear, List<String> publicationNumbers, String license, String copyright, String attribution, List<String> searchKeywords, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) {
        String methodName = "addExternalReference";
        String elementTypeName = EXTERNAL_REFERENCE_TYPE_NAME;
        if (typeName != null) {
            elementTypeName = typeName;
        }
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, REFERENCE_TITLE_PROPERTY, referenceTitle, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, REFERENCE_ABSTRACT_PROPERTY, referenceAbstract, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addExternalReference");
        properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, properties, AUTHORS_PROPERTY, authors, "addExternalReference");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, NUMBER_OF_PAGES_PROPERTY, numberOfPages, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, PAGE_RANGE_PROPERTY, pageRange, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, ORGANIZATION_PROPERTY, authorOrganization, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, REFERENCE_VERSION_PROPERTY, versionNumber, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, PUBLICATION_SERIES_PROPERTY, publicationSeries, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, PUBLICATION_SERIES_VOLUME_PROPERTY, publicationSeriesVolume, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, EDITION_PROPERTY, edition, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, URL_PROPERTY, referenceURL, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, PUBLISHER_PROPERTY, publisher, "addExternalReference");
        properties = this.archiveHelper.addDatePropertyToInstance(this.archiveRootName, properties, FIRST_PUBLICATION_DATE_PROPERTY, firstPublicationDate, "addExternalReference");
        properties = this.archiveHelper.addDatePropertyToInstance(this.archiveRootName, properties, PUBLICATION_DATE_PROPERTY, publicationDate, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, PUBLICATION_CITY_PROPERTY, publicationCity, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, PUBLICATION_YEAR_PROPERTY, publicationYear, "addExternalReference");
        properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, properties, PUBLICATION_NUMBERS_PROPERTY, publicationNumbers, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, LICENSE_PROPERTY, license, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, COPYRIGHT_PROPERTY, copyright, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, ATTRIBUTION_PROPERTY, attribution, "addExternalReference");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addExternalReference");
        properties = this.archiveHelper.addPropertyMapToInstance(this.archiveRootName, properties, extendedProperties, "addExternalReference");
        EntityDetail externalReferenceEntity = this.archiveHelper.getEntityDetail(elementTypeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(externalReferenceEntity);
        if (searchKeywords != null) {
            for (String keyword : searchKeywords) {
                String keywordGUID;
                EntityDetail keywordEntity;
                if (keyword == null || (keywordEntity = (keywordGUID = this.idToGUIDMap.queryGUID("SearchKeyword:" + keyword)) != null ? this.archiveBuilder.getEntity(keywordGUID) : this.archiveHelper.getEntityDetail(SEARCH_KEYWORD_TYPE_NAME, this.idToGUIDMap.getGUID("SearchKeyword:" + keyword), properties, InstanceStatus.ACTIVE, null)) == null) continue;
                EntityProxy end1 = this.archiveHelper.getEntityProxy(externalReferenceEntity);
                EntityProxy end2 = this.archiveHelper.getEntityProxy(keywordEntity);
                this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(SEARCH_KEYWORD_LINK_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(externalReferenceEntity.getGUID() + "_to_" + keywordGUID + "_search_keyword_link_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
            }
        }
        return externalReferenceEntity.getGUID();
    }

    public void addExternalReferenceLink(String referenceableGUID, String externalReferenceGUID, String referenceId, String description, String pages) {
        String methodName = "addExternalReferenceLink";
        EntityDetail referenceableEntity = this.archiveBuilder.getEntity(referenceableGUID);
        EntityDetail externalReferenceEntity = this.archiveBuilder.getEntity(externalReferenceGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(referenceableEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(externalReferenceEntity);
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, REFERENCE_ID_PROPERTY, referenceId, "addExternalReferenceLink");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addExternalReferenceLink");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, PAGES_PROPERTY, pages, "addExternalReferenceLink");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(EXTERNAL_GLOSSARY_LINK_TYPE_NAME, this.idToGUIDMap.getGUID(referenceableGUID + "_to_" + externalReferenceGUID + "_external_reference_link_relationship" + referenceId), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public String addSubjectAreaDefinition(String qualifiedName, String displayName, String description, String scope, String usage, int domainIdentifier, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) {
        String methodName = "addSubjectAreaDefinition";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addSubjectAreaDefinition");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addSubjectAreaDefinition");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addSubjectAreaDefinition");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, SCOPE_PROPERTY, scope, "addSubjectAreaDefinition");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, USAGE_PROPERTY, usage, "addSubjectAreaDefinition");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, DOMAIN_IDENTIFIER_PROPERTY, domainIdentifier, "addSubjectAreaDefinition");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addSubjectAreaDefinition");
        properties = this.archiveHelper.addPropertyMapToInstance(this.archiveRootName, properties, extendedProperties, "addSubjectAreaDefinition");
        EntityDetail newEntity = this.archiveHelper.getEntityDetail(SUBJECT_AREA_DEFINITION_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(newEntity);
        return newEntity.getGUID();
    }

    public void addSubjectAreaHierarchy(String broaderSubjectAreaGUID, String nestedSubjectAreaGUID) {
        EntityDetail referenceableEntity = this.archiveBuilder.getEntity(broaderSubjectAreaGUID);
        EntityDetail externalReferenceEntity = this.archiveBuilder.getEntity(nestedSubjectAreaGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(referenceableEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(externalReferenceEntity);
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(SUBJECT_AREA_HIERARCHY_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(broaderSubjectAreaGUID + "_to_" + nestedSubjectAreaGUID + "_subject_area_hierarchy_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addSubjectAreaClassification(String referenceableGUID, String subjectAreaQualifiedName) {
        String methodName = "addSubjectAreaClassification";
        EntityDetail referenceableEntity = this.archiveBuilder.getEntity(referenceableGUID);
        EntityProxy referenceableEntityProxy = this.archiveHelper.getEntityProxy(referenceableEntity);
        Classification subjectAreaClassification = this.archiveHelper.getClassification(SUBJECT_AREA_CLASSIFICATION_NAME, this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, NAME_PROPERTY, subjectAreaQualifiedName, "addSubjectAreaClassification"), InstanceStatus.ACTIVE);
        this.archiveBuilder.addClassification(this.archiveHelper.getClassificationEntityExtension(referenceableEntityProxy, subjectAreaClassification));
    }

    public String addDesignModel(String typeName, String classificationName, String qualifiedName, String displayName, String technicalName, String description, String versionNumber, String author, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) {
        String methodName = "addDesignModel";
        String elementTypeName = DESIGN_MODEL_TYPE_NAME;
        if (typeName != null) {
            elementTypeName = typeName;
        }
        ArrayList<Classification> entityClassifications = null;
        if (classificationName != null) {
            entityClassifications = new ArrayList<Classification>();
            Classification classification = this.archiveHelper.getClassification(classificationName, null, InstanceStatus.ACTIVE);
            entityClassifications.add(classification);
        }
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addDesignModel");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, NAME_PROPERTY, displayName, "addDesignModel");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, TECHNICAL_NAME_PROPERTY, technicalName, "addDesignModel");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addDesignModel");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, VERSION_NUMBER_PROPERTY, versionNumber, "addDesignModel");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, AUTHOR_PROPERTY, author, "addDesignModel");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addDesignModel");
        properties = this.archiveHelper.addPropertyMapToInstance(this.archiveRootName, properties, extendedProperties, "addDesignModel");
        EntityDetail newEntity = this.archiveHelper.getEntityDetail(elementTypeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, entityClassifications);
        this.archiveBuilder.addEntity(newEntity);
        return newEntity.getGUID();
    }

    public String addDesignModelElement(String designModelGUID, String typeName, String qualifiedName, String displayName, String technicalName, String description, String versionNumber, String author, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, List<Classification> classifications) {
        String methodName = "addDesignModelElement";
        String elementTypeName = DESIGN_MODEL_ELEMENT_TYPE_NAME;
        if (typeName != null) {
            elementTypeName = typeName;
        }
        List<Classification> entityClassifications = classifications;
        if (designModelGUID != null) {
            if (entityClassifications == null) {
                entityClassifications = new ArrayList<Classification>();
            }
            InstanceProperties classificationProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, ANCHOR_GUID_PROPERTY, designModelGUID, "addDesignModelElement");
            Classification classification = this.archiveHelper.getClassification(ANCHORS_CLASSIFICATION_NAME, classificationProperties, InstanceStatus.ACTIVE);
            entityClassifications.add(classification);
        }
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addDesignModelElement");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addDesignModelElement");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, TECHNICAL_NAME_PROPERTY, technicalName, "addDesignModelElement");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addDesignModelElement");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, VERSION_NUMBER_PROPERTY, versionNumber, "addDesignModelElement");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, AUTHOR_PROPERTY, author, "addDesignModelElement");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addDesignModelElement");
        properties = this.archiveHelper.addPropertyMapToInstance(this.archiveRootName, properties, extendedProperties, "addDesignModelElement");
        EntityDetail newEntity = this.archiveHelper.getEntityDetail(elementTypeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, entityClassifications);
        this.archiveBuilder.addEntity(newEntity);
        if (designModelGUID != null) {
            EntityDetail designModelEntity = this.archiveBuilder.getEntity(designModelGUID);
            EntityDetail designModelElementEntity = this.archiveBuilder.getEntity(newEntity.getGUID());
            EntityProxy end1 = this.archiveHelper.getEntityProxy(designModelEntity);
            EntityProxy end2 = this.archiveHelper.getEntityProxy(designModelElementEntity);
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(DESIGN_MODEL_GROUP_MEMBERSHIP_NAME, this.idToGUIDMap.getGUID(designModelGUID + "_to_" + newEntity.getGUID() + "_design_model_group_membership_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        }
        return newEntity.getGUID();
    }

    public void addDesignModelGroupMembership(String groupGUID, String memberGUID) {
        EntityDetail designModelGroupEntity = this.archiveBuilder.getEntity(groupGUID);
        EntityDetail designModelElementEntity = this.archiveBuilder.getEntity(memberGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(designModelGroupEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(designModelElementEntity);
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(DESIGN_MODEL_GROUP_MEMBERSHIP_NAME, this.idToGUIDMap.getGUID(groupGUID + "_to_" + memberGUID + "_design_model_group_membership_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addConceptBeadRelationshipEnd(String conceptBeadLinkGUID, String conceptBeadGUID, String attributeName, int conceptModelDecoration, int position, int minCardinality, int maxCardinality, boolean uniqueValues, boolean orderedValues, boolean navigable) {
        String methodName = "addConceptBeadRelationshipEnd";
        EntityDetail entityOne = this.archiveBuilder.getEntity(conceptBeadLinkGUID);
        EntityDetail entityTwo = this.archiveBuilder.getEntity(conceptBeadGUID);
        EnumElementDef conceptModelDecorationEnum = this.archiveHelper.getEnumElement(CONCEPT_MODEL_DECORATION_ENUM_NAME, conceptModelDecoration);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(entityOne);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(entityTwo);
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, ATTRIBUTE_NAME_PROPERTY, attributeName, "addConceptBeadRelationshipEnd");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, POSITION_PROPERTY, position, "addConceptBeadRelationshipEnd");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, MIN_CARDINALITY_PROPERTY, minCardinality, "addConceptBeadRelationshipEnd");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, MAX_CARDINALITY_PROPERTY, maxCardinality, "addConceptBeadRelationshipEnd");
        properties = this.archiveHelper.addEnumPropertyToInstance(this.archiveRootName, properties, DECORATION_PROPERTY, conceptModelDecorationEnum.getOrdinal(), conceptModelDecorationEnum.getValue(), conceptModelDecorationEnum.getDescription(), "addConceptBeadRelationshipEnd");
        properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, properties, UNIQUE_VALUES_PROPERTY, uniqueValues, "addConceptBeadRelationshipEnd");
        properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, properties, ORDERED_VALUES_PROPERTY, orderedValues, "addConceptBeadRelationshipEnd");
        properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, properties, NAVIGABLE_PROPERTY, navigable, "addConceptBeadRelationshipEnd");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(DESIGN_MODEL_GROUP_MEMBERSHIP_NAME, this.idToGUIDMap.getGUID(conceptBeadLinkGUID + "_to_" + conceptBeadGUID + "_concept_bead_relationship_end_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addConceptBeadAttributeLink(String conceptBeadGUID, String conceptBeadAttributeGUID, int position, int minCardinality, int maxCardinality, boolean uniqueValues, boolean orderedValues) {
        String methodName = "addConceptBeadAttributeLink";
        EntityDetail entityOne = this.archiveBuilder.getEntity(conceptBeadGUID);
        EntityDetail entityTwo = this.archiveBuilder.getEntity(conceptBeadAttributeGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(entityOne);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(entityTwo);
        InstanceProperties properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, null, POSITION_PROPERTY, position, "addConceptBeadAttributeLink");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, MIN_CARDINALITY_PROPERTY, minCardinality, "addConceptBeadAttributeLink");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, MAX_CARDINALITY_PROPERTY, maxCardinality, "addConceptBeadAttributeLink");
        properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, properties, UNIQUE_VALUES_PROPERTY, uniqueValues, "addConceptBeadAttributeLink");
        properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, properties, ORDERED_VALUES_PROPERTY, orderedValues, "addConceptBeadAttributeLink");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(DESIGN_MODEL_GROUP_MEMBERSHIP_NAME, this.idToGUIDMap.getGUID(conceptBeadGUID + "_to_" + conceptBeadAttributeGUID + "_concept_bead_attribute_link_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public String addAsset(String typeName, String qualifiedName, String displayName, String description, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, List<Classification> classifications) {
        String methodName = "addAsset";
        String assetTypeName = ASSET_TYPE_NAME;
        if (typeName != null) {
            assetTypeName = typeName;
        }
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addAsset");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, NAME_PROPERTY, displayName, "addAsset");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addAsset");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addAsset");
        properties = this.archiveHelper.addPropertyMapToInstance(this.archiveRootName, properties, extendedProperties, "addAsset");
        EntityDetail assetEntity = this.archiveHelper.getEntityDetail(assetTypeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(assetEntity);
        return assetEntity.getGUID();
    }

    public String addAsset(String typeName, String qualifiedName, String displayName, String description, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) {
        return this.addAsset(typeName, qualifiedName, displayName, description, additionalProperties, extendedProperties, null);
    }

    public String addAsset(String typeName, String qualifiedName, String displayName, String description, List<String> governanceZones, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) {
        String methodName = "addAsset (with governance zones)";
        if (governanceZones == null) {
            return this.addAsset(typeName, qualifiedName, displayName, description, additionalProperties, extendedProperties, null);
        }
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        InstanceProperties properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, null, ZONE_MEMBERSHIP_PROPERTY, governanceZones, "addAsset (with governance zones)");
        Classification classification = this.archiveHelper.getClassification(ASSET_ZONE_MEMBERSHIP_TYPE_NAME, properties, InstanceStatus.ACTIVE);
        classifications.add(classification);
        return this.addAsset(typeName, qualifiedName, displayName, description, additionalProperties, extendedProperties, classifications);
    }

    public String addSoftwareCapability(String typeName, String qualifiedName, String displayName, String description, String capabilityType, String capabilityVersion, String patchLevel, String source, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) {
        String methodName = "addSoftwareCapability";
        String assetTypeName = SOFTWARE_CAPABILITY_TYPE_NAME;
        if (typeName != null) {
            assetTypeName = typeName;
        }
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addSoftwareCapability");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, NAME_PROPERTY, displayName, "addSoftwareCapability");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addSoftwareCapability");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, CAPABILITY_TYPE_PROPERTY, capabilityType, "addSoftwareCapability");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, CAPABILITY_VERSION_PROPERTY, capabilityVersion, "addSoftwareCapability");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, PATCH_LEVEL_PROPERTY, patchLevel, "addSoftwareCapability");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, SOURCE_PROPERTY, source, "addSoftwareCapability");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addSoftwareCapability");
        properties = this.archiveHelper.addPropertyMapToInstance(this.archiveRootName, properties, extendedProperties, "addSoftwareCapability");
        EntityDetail assetEntity = this.archiveHelper.getEntityDetail(assetTypeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(assetEntity);
        return assetEntity.getGUID();
    }

    public void addConnectionForAsset(String assetGUID, String assetSummary, String connectionGUID) {
        String methodName = "addConnectionForAsset";
        EntityDetail assetEntity = this.archiveBuilder.getEntity(assetGUID);
        EntityDetail connectionEntity = this.archiveBuilder.getEntity(connectionGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(connectionEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(assetEntity);
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, ASSET_SUMMARY_PROPERTY, assetSummary, "addConnectionForAsset");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(CONNECTION_TO_ASSET_TYPE_NAME, this.idToGUIDMap.getGUID(assetGUID + "_to_" + connectionGUID + "_asset_connection_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addDataContentForDataSet(String dataContentGUID, String dataSetGUID) {
        EntityDetail dataContentEntity = this.archiveBuilder.getEntity(dataContentGUID);
        EntityDetail dataSetEntity = this.archiveBuilder.getEntity(dataSetGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(dataContentEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(dataSetEntity);
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(DATA_CONTENT_FOR_DATA_SET_TYPE_NAME, this.idToGUIDMap.getGUID(dataContentGUID + "_to_" + dataSetGUID + "_data_content_for_data_set_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public String addTopLevelSchemaType(String assetGUID, String typeName, String qualifiedName, String displayName, String description, Map<String, String> additionalProperties) {
        String methodName = "addTopLevelSchemaType";
        String schemaTypeTypeName = SCHEMA_TYPE_TYPE_NAME;
        if (typeName != null) {
            schemaTypeTypeName = typeName;
        }
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addTopLevelSchemaType");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addTopLevelSchemaType");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addTopLevelSchemaType");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addTopLevelSchemaType");
        EntityDetail schemaTypeEntity = this.archiveHelper.getEntityDetail(schemaTypeTypeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(schemaTypeEntity);
        if (assetGUID != null) {
            EntityDetail assetEntity = this.archiveBuilder.getEntity(assetGUID);
            EntityProxy end1 = this.archiveHelper.getEntityProxy(assetEntity);
            EntityProxy end2 = this.archiveHelper.getEntityProxy(schemaTypeEntity);
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(ASSET_SCHEMA_TYPE_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName + "_asset_schema_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        }
        return schemaTypeEntity.getGUID();
    }

    public String addAPIOperation(String apiSchemaTypeGUID, String qualifiedName, String displayName, String description, String path, String command, Map<String, String> additionalProperties) {
        String methodName = "addAPIOperation";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addAPIOperation");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addAPIOperation");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addAPIOperation");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, PATH_TYPE_PROPERTY, path, "addAPIOperation");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, COMMAND_TYPE_PROPERTY, command, "addAPIOperation");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addAPIOperation");
        EntityDetail schemaTypeEntity = this.archiveHelper.getEntityDetail(API_OPERATION_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(schemaTypeEntity);
        if (apiSchemaTypeGUID != null) {
            EntityDetail parentEntity = this.archiveBuilder.getEntity(apiSchemaTypeGUID);
            EntityProxy end1 = this.archiveHelper.getEntityProxy(parentEntity);
            EntityProxy end2 = this.archiveHelper.getEntityProxy(schemaTypeEntity);
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(API_OPERATIONS_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName + "_parent_api_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        }
        return schemaTypeEntity.getGUID();
    }

    public String addAPIParameterList(String apiOperationGUID, String relationshipTypeName, String qualifiedName, String displayName, String description, boolean required, Map<String, String> additionalProperties) {
        String methodName = "addAPIParameterList";
        String typeName = API_REQUEST_TYPE_NAME;
        if (relationshipTypeName != null) {
            typeName = relationshipTypeName;
        }
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addAPIParameterList");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addAPIParameterList");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addAPIParameterList");
        properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, properties, REQUIRED_PROPERTY, required, "addAPIParameterList");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addAPIParameterList");
        EntityDetail parameterListEntity = this.archiveHelper.getEntityDetail(API_PARAMETER_LIST_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(parameterListEntity);
        if (apiOperationGUID != null) {
            EntityDetail operationEntity = this.archiveBuilder.getEntity(apiOperationGUID);
            EntityProxy end1 = this.archiveHelper.getEntityProxy(operationEntity);
            EntityProxy end2 = this.archiveHelper.getEntityProxy(parameterListEntity);
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(typeName, this.idToGUIDMap.getGUID(qualifiedName + "_api_parameter_to_operation_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        }
        return parameterListEntity.getGUID();
    }

    public void addSchemaTypeOption(String schemaTypeChoiceGUID, String schemaTypeOptionGUID) {
        EntityDetail schemaTypeChoiceEntity = this.archiveBuilder.getEntity(schemaTypeChoiceGUID);
        EntityDetail schemaTypeOptionEntity = this.archiveBuilder.getEntity(schemaTypeOptionGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(schemaTypeChoiceEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(schemaTypeOptionEntity);
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(SCHEMA_TYPE_OPTION_TYPE_NAME, this.idToGUIDMap.getGUID(schemaTypeChoiceGUID + "_to_" + schemaTypeOptionGUID + "_schema_type_option_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addAttributeForSchemaType(String schemaTypeGUID, String schemaAttributeGUID) {
        EntityDetail schemaTypeChoiceEntity = this.archiveBuilder.getEntity(schemaTypeGUID);
        EntityDetail schemaTypeOptionEntity = this.archiveBuilder.getEntity(schemaAttributeGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(schemaTypeChoiceEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(schemaTypeOptionEntity);
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(ATTRIBUTE_FOR_SCHEMA_TYPE_NAME, this.idToGUIDMap.getGUID(schemaTypeGUID + "_to_" + schemaAttributeGUID + "_attribute_for_schema_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addNestedSchemaAttribute(String parentSchemaAttributeGUID, String childSchemaAttributeGUID) {
        EntityDetail parentSchemaAttributeEntity = this.archiveBuilder.getEntity(parentSchemaAttributeGUID);
        EntityDetail childSchemaAttributeEntity = this.archiveBuilder.getEntity(childSchemaAttributeGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(parentSchemaAttributeEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(childSchemaAttributeEntity);
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(NESTED_SCHEMA_ATTRIBUTE_TYPE_NAME, this.idToGUIDMap.getGUID(parentSchemaAttributeGUID + "_to_" + childSchemaAttributeGUID + "_nested_schema_attribute_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public String addSchemaAttribute(String typeName, String schemaTypeName, String qualifiedName, String displayName, String description, String dataType, int length, int position, Map<String, String> additionalProperties) {
        String methodName = "addSchemaAttribute";
        String schemaAttributeTypeName = SCHEMA_ATTRIBUTE_TYPE_NAME;
        if (typeName != null) {
            schemaAttributeTypeName = typeName;
        }
        String schemaTypeTypeName = PRIMITIVE_SCHEMA_TYPE_TYPE_NAME;
        if (schemaTypeName != null) {
            schemaTypeTypeName = schemaTypeName;
        }
        InstanceProperties entityProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addSchemaAttribute");
        entityProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, entityProperties, DISPLAY_NAME_PROPERTY, displayName, "addSchemaAttribute");
        entityProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, entityProperties, DESCRIPTION_PROPERTY, description, "addSchemaAttribute");
        entityProperties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, entityProperties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addSchemaAttribute");
        InstanceProperties classificationProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, SCHEMA_TYPE_NAME_PROPERTY, schemaTypeTypeName, "addSchemaAttribute");
        classificationProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, classificationProperties, DATA_TYPE_PROPERTY, dataType, "addSchemaAttribute");
        classificationProperties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, classificationProperties, LENGTH_PROPERTY, length, "addSchemaAttribute");
        Classification classification = this.archiveHelper.getClassification(TYPE_EMBEDDED_ATTRIBUTE_TYPE_NAME, classificationProperties, InstanceStatus.ACTIVE);
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        classifications.add(classification);
        EntityDetail schemaAttributeEntity = this.archiveHelper.getEntityDetail(schemaAttributeTypeName, this.idToGUIDMap.getGUID(qualifiedName), entityProperties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(schemaAttributeEntity);
        return schemaAttributeEntity.getGUID();
    }

    public String addConnection(String qualifiedName, String displayName, String description, String userId, String clearPassword, String encryptedPassword, Map<String, String> securedProperties, Map<String, Object> configurationProperties, Map<String, String> additionalProperties, String connectorTypeGUID, String endpointGUID) {
        EntityProxy end2;
        EntityProxy end1;
        String methodName = "addConnection";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addConnection");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addConnection");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addConnection");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, USER_ID_PROPERTY, userId, "addConnection");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, CLEAR_PASSWORD_PROPERTY, clearPassword, "addConnection");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, ENCRYPTED_PASSWORD_PROPERTY, encryptedPassword, "addConnection");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, SECURED_PROPERTIES_PROPERTY, securedProperties, "addConnection");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addConnection");
        properties = this.archiveHelper.addMapPropertyToInstance(this.archiveRootName, properties, CONFIGURATION_PROPERTIES_PROPERTY, configurationProperties, "addConnection");
        EntityDetail connectionEntity = this.archiveHelper.getEntityDetail(CONNECTION_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(connectionEntity);
        if (connectorTypeGUID != null) {
            EntityDetail connectorTypeEntity = this.archiveBuilder.getEntity(connectorTypeGUID);
            end1 = this.archiveHelper.getEntityProxy(connectionEntity);
            end2 = this.archiveHelper.getEntityProxy(connectorTypeEntity);
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(CONNECTION_CONNECTOR_TYPE_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName + "_connectorType_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        }
        if (endpointGUID != null) {
            EntityDetail endpointEntity = this.archiveBuilder.getEntity(endpointGUID);
            end1 = this.archiveHelper.getEntityProxy(endpointEntity);
            end2 = this.archiveHelper.getEntityProxy(connectionEntity);
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(CONNECTION_ENDPOINT_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName + "_endpoint_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        }
        return connectionEntity.getGUID();
    }

    public String addConnectorType(String connectorCategoryGUID, String connectorTypeGUID, String qualifiedName, String displayName, String description, String supportedAssetTypeName, String expectedDataFormat, String connectorProviderClassName, String connectorFrameworkName, String connectorInterfaceLanguage, List<String> connectorInterfaces, String targetTechnologySource, String targetTechnologyName, List<String> targetTechnologyInterfaces, List<String> targetTechnologyVersions, List<String> recognizedSecuredProperties, List<String> recognizedConfigurationProperties, List<String> recognizedAdditionalProperties, Map<String, String> additionalProperties) {
        this.idToGUIDMap.setGUID(qualifiedName, connectorTypeGUID);
        try {
            return this.addConnectorType(connectorCategoryGUID, qualifiedName, displayName, description, supportedAssetTypeName, expectedDataFormat, connectorProviderClassName, connectorFrameworkName, connectorInterfaceLanguage, connectorInterfaces, targetTechnologySource, targetTechnologyName, targetTechnologyInterfaces, targetTechnologyVersions, recognizedSecuredProperties, recognizedConfigurationProperties, recognizedAdditionalProperties, additionalProperties);
        }
        catch (Exception alreadyDefined) {
            return connectorTypeGUID;
        }
    }

    protected String addConnectorType(String connectorCategoryGUID, String qualifiedName, String displayName, String description, String supportedAssetTypeName, String expectedDataFormat, String connectorProviderClassName, String connectorFrameworkName, String connectorInterfaceLanguage, List<String> connectorInterfaces, String targetTechnologySource, String targetTechnologyName, List<String> targetTechnologyInterfaces, List<String> targetTechnologyVersions, List<String> recognizedSecuredProperties, List<String> recognizedConfigurationProperties, List<String> recognizedAdditionalProperties, Map<String, String> additionalProperties) {
        String methodName = "addConnectorType";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addConnectorType");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addConnectorType");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addConnectorType");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, SUPPORTED_ASSET_TYPE_PROPERTY, supportedAssetTypeName, "addConnectorType");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, EXPECTED_DATA_FORMAT_PROPERTY, expectedDataFormat, "addConnectorType");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, CONNECTOR_PROVIDER_PROPERTY, connectorProviderClassName, "addConnectorType");
        properties = connectorFrameworkName != null ? this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, CONNECTOR_FRAMEWORK_PROPERTY, connectorFrameworkName, "addConnectorType") : this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, CONNECTOR_FRAMEWORK_PROPERTY, CONNECTOR_FRAMEWORK_DEFAULT, "addConnectorType");
        properties = connectorInterfaceLanguage != null ? this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, CONNECTOR_INTERFACE_LANGUAGE_PROPERTY, connectorInterfaceLanguage, "addConnectorType") : this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, CONNECTOR_INTERFACE_LANGUAGE_PROPERTY, CONNECTOR_INTERFACE_LANGUAGE_DEFAULT, "addConnectorType");
        properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, properties, CONNECTOR_INTERFACES_PROPERTY, connectorInterfaces, "addConnectorType");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, TARGET_TECHNOLOGY_SOURCE_PROPERTY, targetTechnologySource, "addConnectorType");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, TARGET_TECHNOLOGY_NAME_PROPERTY, targetTechnologyName, "addConnectorType");
        properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, properties, TARGET_TECHNOLOGY_INTERFACES_PROPERTY, targetTechnologyInterfaces, "addConnectorType");
        properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, properties, TARGET_TECHNOLOGY_VERSIONS_PROPERTY, targetTechnologyVersions, "addConnectorType");
        properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, properties, RECOGNIZED_SECURED_PROPERTIES_PROPERTY, recognizedSecuredProperties, "addConnectorType");
        properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, properties, RECOGNIZED_ADDITIONAL_PROPERTIES_PROPERTY, recognizedAdditionalProperties, "addConnectorType");
        properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, properties, RECOGNIZED_CONFIGURATION_PROPERTIES_PROPERTY, recognizedConfigurationProperties, "addConnectorType");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addConnectorType");
        EntityDetail connectorTypeEntity = this.archiveHelper.getEntityDetail(CONNECTOR_TYPE_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(connectorTypeEntity);
        if (connectorCategoryGUID != null) {
            EntityDetail connectorCategoryEntity = this.archiveBuilder.getEntity(connectorCategoryGUID);
            EntityProxy end1 = this.archiveHelper.getEntityProxy(connectorCategoryEntity);
            EntityProxy end2 = this.archiveHelper.getEntityProxy(connectorTypeEntity);
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(CONNECTOR_IMPL_CHOICE_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName + "_connector_category_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        }
        return connectorTypeEntity.getGUID();
    }

    public String addConnectorCategory(String connectorTypeDirectoryGUID, String qualifiedName, String displayName, String description, String targetTechnologySource, String targetTechnologyName, Map<String, Boolean> recognizedSecuredProperties, Map<String, Boolean> recognizedConfigurationProperties, Map<String, Boolean> recognizedAdditionalProperties, Map<String, String> additionalProperties) {
        String methodName = "addConnectorCategory";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addConnectorCategory");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addConnectorCategory");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addConnectorCategory");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, TARGET_TECHNOLOGY_SOURCE_PROPERTY, targetTechnologySource, "addConnectorCategory");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, TARGET_TECHNOLOGY_NAME_PROPERTY, targetTechnologyName, "addConnectorCategory");
        properties = this.archiveHelper.addBooleanMapPropertyToInstance(this.archiveRootName, properties, RECOGNIZED_SECURED_PROPERTIES_PROPERTY, recognizedSecuredProperties, "addConnectorCategory");
        properties = this.archiveHelper.addBooleanMapPropertyToInstance(this.archiveRootName, properties, RECOGNIZED_ADDITIONAL_PROPERTIES_PROPERTY, recognizedAdditionalProperties, "addConnectorCategory");
        properties = this.archiveHelper.addBooleanMapPropertyToInstance(this.archiveRootName, properties, RECOGNIZED_CONFIGURATION_PROPERTIES_PROPERTY, recognizedConfigurationProperties, "addConnectorCategory");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addConnectorCategory");
        EntityDetail connectorCategoryEntity = this.archiveHelper.getEntityDetail(CONNECTOR_CATEGORY_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(connectorCategoryEntity);
        if (connectorTypeDirectoryGUID != null) {
            EntityDetail connectorTypeDirectoryEntity = this.archiveBuilder.getEntity(connectorTypeDirectoryGUID);
            EntityProxy end1 = this.archiveHelper.getEntityProxy(connectorTypeDirectoryEntity);
            EntityProxy end2 = this.archiveHelper.getEntityProxy(connectorCategoryEntity);
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(COLLECTION_MEMBER_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName + "_connector_type_directory_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        }
        return connectorCategoryEntity.getGUID();
    }

    public String addConnectorTypeDirectory(String qualifiedName, String displayName, String description, Map<String, String> additionalProperties) {
        String methodName = "addConnectorTypeDirectory";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addConnectorTypeDirectory");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addConnectorTypeDirectory");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addConnectorTypeDirectory");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addConnectorTypeDirectory");
        Classification classification = this.archiveHelper.getClassification(CONNECTOR_TYPE_DIRECTORY_TYPE_NAME, null, InstanceStatus.ACTIVE);
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        classifications.add(classification);
        EntityDetail connectorTypeDirectoryEntity = this.archiveHelper.getEntityDetail(COLLECTION_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(connectorTypeDirectoryEntity);
        return connectorTypeDirectoryEntity.getGUID();
    }

    public String addEndpoint(String qualifiedName, String displayName, String description, String networkAddress, String protocol, Map<String, String> additionalProperties) {
        String methodName = "addEndpoint";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addEndpoint");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addEndpoint");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addEndpoint");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, NETWORK_ADDRESS_PROPERTY, networkAddress, "addEndpoint");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, PROTOCOL_PROPERTY, protocol, "addEndpoint");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addEndpoint");
        EntityDetail endpointEntity = this.archiveHelper.getEntityDetail(ENDPOINT_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(endpointEntity);
        return endpointEntity.getGUID();
    }

    public String addGlossary(String qualifiedName, String displayName, String description, String language, String usage, String externalLink, String scope) {
        String methodName = "addGlossary";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addGlossary");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addGlossary");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addGlossary");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, LANGUAGE_PROPERTY, language, "addGlossary");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, USAGE_PROPERTY, usage, "addGlossary");
        ArrayList<Classification> classifications = null;
        if (scope != null) {
            Classification canonicalVocabClassification = this.archiveHelper.getClassification(CANONICAL_VOCABULARY_TYPE_NAME, this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, SCOPE_PROPERTY, scope, "addGlossary"), InstanceStatus.ACTIVE);
            classifications = new ArrayList<Classification>();
            classifications.add(canonicalVocabClassification);
        }
        EntityDetail glossaryEntity = this.archiveHelper.getEntityDetail(GLOSSARY_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(glossaryEntity);
        if (externalLink != null) {
            String externalLinkQualifiedName = qualifiedName + "_external_link";
            properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, externalLinkQualifiedName, "addGlossary");
            properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, URL_PROPERTY, externalLink, "addGlossary");
            properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, ORGANIZATION_PROPERTY, this.originatorName, "addGlossary");
            properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, REFERENCE_VERSION_PROPERTY, this.versionName, "addGlossary");
            EntityDetail externalLinkEntity = this.archiveHelper.getEntityDetail(EXTERNAL_GLOSSARY_LINK_TYPE_NAME, this.idToGUIDMap.getGUID(externalLinkQualifiedName), properties, InstanceStatus.ACTIVE, classifications);
            this.archiveBuilder.addEntity(externalLinkEntity);
            EntityProxy end1 = this.archiveHelper.getEntityProxy(glossaryEntity);
            EntityProxy end2 = this.archiveHelper.getEntityProxy(externalLinkEntity);
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(EXTERNALLY_SOURCED_GLOSSARY_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(qualifiedName + "_link_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        }
        return glossaryEntity.getGUID();
    }

    public String addCategory(String glossaryGUID, String qualifiedName, String displayName, String description, String subjectArea) {
        String methodName = "addCategory";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addCategory");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addCategory");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addCategory");
        ArrayList<Classification> classifications = null;
        if (subjectArea != null) {
            Classification subjectAreaClassification = this.archiveHelper.getClassification(SUBJECT_AREA_CLASSIFICATION_NAME, this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, NAME_PROPERTY, subjectArea, "addCategory"), InstanceStatus.ACTIVE);
            classifications = new ArrayList<Classification>();
            classifications.add(subjectAreaClassification);
        }
        EntityDetail categoryEntity = this.archiveHelper.getEntityDetail(GLOSSARY_CATEGORY_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(categoryEntity);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(glossaryGUID));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(categoryEntity);
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(CATEGORY_ANCHOR_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName + "_anchor_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        return categoryEntity.getGUID();
    }

    public String addTerm(String glossaryGUID, List<String> categoryGUIDs, String qualifiedName, String displayName, String description) {
        return this.addTerm(glossaryGUID, categoryGUIDs, false, qualifiedName, displayName, description, null, false, false, false, null, null);
    }

    public String addTerm(String glossaryGUID, List<String> categoryIds, String qualifiedName, String displayName, String description, String examples, boolean isSpineObject, boolean isSpineAttribute, boolean categoriesAsNames) {
        return this.addTerm(glossaryGUID, categoryIds, categoriesAsNames, qualifiedName, displayName, description, examples, isSpineObject, isSpineAttribute, false, null, null);
    }

    public String addTerm(String glossaryGUID, List<String> categoryIds, boolean categoriesAsNames, String qualifiedName, String displayName, String description, String examples, boolean isSpineObject, boolean isSpineAttribute, boolean isContext, String contextDescription, String contextScope) {
        Classification subjectAreaClassification;
        String methodName = "addTerm";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addTerm");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addTerm");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addTerm");
        if (examples != null) {
            properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, EXAMPLES_PROPERTY, examples, "addTerm");
        }
        ArrayList<Classification> classifications = null;
        if (isSpineObject) {
            subjectAreaClassification = this.archiveHelper.getClassification(SPINE_OBJECT_NAME, null, InstanceStatus.ACTIVE);
            classifications = new ArrayList<Classification>();
            classifications.add(subjectAreaClassification);
        }
        if (isSpineAttribute) {
            subjectAreaClassification = this.archiveHelper.getClassification(SPINE_ATTRIBUTE_NAME, null, InstanceStatus.ACTIVE);
            if (classifications == null) {
                classifications = new ArrayList();
            }
            classifications.add(subjectAreaClassification);
        }
        if (isContext) {
            InstanceProperties classificationProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, DESCRIPTION_PROPERTY, contextDescription, "addTerm");
            classificationProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, classificationProperties, SCOPE_PROPERTY, contextScope, "addTerm");
            Classification subjectAreaClassification2 = this.archiveHelper.getClassification(CONTEXT_DEFINITION_CLASSIFICATION_NAME, classificationProperties, InstanceStatus.ACTIVE);
            if (classifications == null) {
                classifications = new ArrayList();
            }
            classifications.add(subjectAreaClassification2);
        }
        EntityDetail termEntity = this.archiveHelper.getEntityDetail(GLOSSARY_TERM_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(termEntity);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(glossaryGUID));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(termEntity);
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship("TermAnchor", this.idToGUIDMap.getGUID(qualifiedName + "_anchor_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        if (categoryIds != null) {
            InstanceProperties categorizationProperties = this.archiveHelper.addEnumPropertyToInstance(this.archiveRootName, null, STATUS_PROPERTY, this.activeStatus.getOrdinal(), this.activeStatus.getValue(), this.activeStatus.getDescription(), "addTerm");
            for (String categoryId : categoryIds) {
                if (categoryId == null) continue;
                String categoryGUID = categoryId;
                if (categoriesAsNames) {
                    categoryGUID = this.idToGUIDMap.getGUID(categoryId);
                }
                end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(categoryGUID));
                this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(TERM_CATEGORIZATION_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName + "_category_" + categoryId + "_term_categorization_relationship"), categorizationProperties, InstanceStatus.ACTIVE, end1, end2));
            }
        }
        return termEntity.getGUID();
    }

    public void addCategoryToCategory(String parentCategoryGUID, String childCategoryGUID) {
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(parentCategoryGUID));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(childCategoryGUID));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(CATEGORY_HIERARCHY_LINK_TYPE_NAME, this.idToGUIDMap.getGUID(parentCategoryGUID + "_to_" + childCategoryGUID + "_category_hierarchy_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addTermToContext(String categoryGUID, String termGUID, int status, String description) {
        String methodName = "addTermToContext";
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(categoryGUID));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(termGUID));
        EnumElementDef termStatus = this.archiveHelper.getEnumElement(TERM_RELATIONSHIP_STATUS_ENUM_NAME, status);
        InstanceProperties properties = this.archiveHelper.addEnumPropertyToInstance(this.archiveRootName, null, STATUS_PROPERTY, termStatus.getOrdinal(), termStatus.getValue(), termStatus.getDescription(), "addTermToContext");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addTermToContext");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(USED_IN_CONTEXT_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(categoryGUID + "_to_" + termGUID + "_used_in_context_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addTermToCategory(String categoryGUID, String termGUID, int status, String description) {
        String methodName = "addTermToCategory";
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(categoryGUID));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(termGUID));
        EnumElementDef termStatus = this.archiveHelper.getEnumElement(TERM_RELATIONSHIP_STATUS_ENUM_NAME, status);
        InstanceProperties properties = this.archiveHelper.addEnumPropertyToInstance(this.archiveRootName, null, STATUS_PROPERTY, termStatus.getOrdinal(), termStatus.getValue(), termStatus.getDescription(), "addTermToCategory");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addTermToCategory");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(TERM_CATEGORIZATION_TYPE_NAME, this.idToGUIDMap.getGUID(categoryGUID + "_to_" + termGUID + "_term_categorization_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addLibraryCategoryReference(String categoryGUID, String externalGlossaryLinkGUID, String identifier, String description, String steward, Date lastVerified) {
        String methodName = "addLibraryCategoryReference";
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(categoryGUID));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(externalGlossaryLinkGUID));
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, IDENTIFIER_PROPERTY, identifier, "addLibraryCategoryReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addLibraryCategoryReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, STEWARD_PROPERTY, steward, "addLibraryCategoryReference");
        properties = this.archiveHelper.addDatePropertyToInstance(this.archiveRootName, properties, LAST_VERIFIED_PROPERTY, lastVerified, "addLibraryCategoryReference");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(LIBRARY_CATEGORY_REFERENCE_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(categoryGUID + "_to_" + externalGlossaryLinkGUID + "_library_category_reference_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addLibraryTermReference(String termGUID, String externalGlossaryLinkGUID, String identifier, String description, String steward, Date lastVerified) {
        String methodName = "addLibraryTermReference";
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(termGUID));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(externalGlossaryLinkGUID));
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, IDENTIFIER_PROPERTY, identifier, "addLibraryTermReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addLibraryTermReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, STEWARD_PROPERTY, steward, "addLibraryTermReference");
        properties = this.archiveHelper.addDatePropertyToInstance(this.archiveRootName, properties, LAST_VERIFIED_PROPERTY, lastVerified, "addLibraryTermReference");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(LIBRARY_TERM_REFERENCE_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(termGUID + "_to_" + externalGlossaryLinkGUID + "_library_term_reference_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addMoreInformationLink(String describedElementId, String describerElementId) {
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(describedElementId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(describerElementId));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(MORE_INFORMATION_TYPE_NAME, this.idToGUIDMap.getGUID(describedElementId + "_to_" + describerElementId + "_more_information_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public void linkTermToReferenceable(String termId, String referenceableId) {
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(referenceableId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(termId));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship("TermAnchor", this.idToGUIDMap.getGUID(referenceableId + "_to_" + termId + "_semantic_assignment_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addIsATypeOfRelationship(String specialTermQName, String generalizedTermQName) {
        String specializedTermId = this.idToGUIDMap.getGUID(specialTermQName);
        String generalizedTermId = this.idToGUIDMap.getGUID(generalizedTermQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(specializedTermId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(generalizedTermId));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(IS_A_TYPE_OF_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(specializedTermId + "_to_" + generalizedTermId + "_isatypeof_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addHasARelationship(String conceptQName, String propertyQName) {
        String conceptId = this.idToGUIDMap.getGUID(conceptQName);
        String propertyId = this.idToGUIDMap.getGUID(propertyQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(propertyId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(conceptId));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(HAS_A_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(conceptId + "_to_" + propertyId + "_hasa_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addRelatedTermRelationship(String conceptQName, String propertyQName) {
        String conceptId = this.idToGUIDMap.getGUID(conceptQName);
        String propertyId = this.idToGUIDMap.getGUID(propertyQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(conceptId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(propertyId));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(RELATED_TERM_RELATIONSHIP_NAME, this.idToGUIDMap.getGUID(conceptId + "_to_" + propertyId + "_related_term_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }
}

