/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.connectors.ConnectorProviderBase;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.OpenMetadataArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.samples.archiveutilities.SimpleCatalogArchiveHelper;

public class GovernanceArchiveHelper
extends SimpleCatalogArchiveHelper {
    private static final String GOVERNANCE_ENGINE_TYPE_NAME = "GovernanceEngine";
    private static final String GOVERNANCE_SERVICE_TYPE_NAME = "GovernanceService";
    private static final String GOVERNANCE_ACTION_PROCESS_TYPE_NAME = "GovernanceActionProcess";
    private static final String GOVERNANCE_ACTION_TYPE_TYPE_NAME = "GovernanceActionType";
    private static final String SUPPORTED_GOVERNANCE_SERVICE_TYPE_NAME = "SupportedGovernanceService";
    private static final String GOVERNANCE_ACTION_TYPE_EXECUTOR_TYPE_NAME = "GovernanceActionTypeExecutor";
    private static final String NEXT_GOVERNANCE_ACTION_TYPE_TYPE_NAME = "NextGovernanceActionType";
    private static final String GOVERNANCE_ACTION_FLOW_TYPE_NAME = "GovernanceActionFlow";
    private static final String REQUEST_TYPE_PROPERTY = "requestType";
    private static final String REQUEST_PARAMETERS_PROPERTY = "parameters";
    private static final String GUARD_PROPERTY = "guard";
    private static final String PRODUCED_GUARDS_PROPERTY = "producedGuards";
    private static final String MANDATORY_GUARD_PROPERTY = "mandatoryGuard";
    private static final String IGNORE_MULTIPLE_TRIGGERS_PROPERTY = "ignoreMultipleTriggers";

    public GovernanceArchiveHelper(OpenMetadataArchiveBuilder archiveBuilder, String archiveGUID, String archiveRootName, String originatorName, Date creationDate, long versionNumber, String versionName) {
        super(archiveBuilder, archiveGUID, archiveRootName, archiveRootName, originatorName, creationDate, versionNumber, versionName);
    }

    public GovernanceArchiveHelper(OpenMetadataArchiveBuilder archiveBuilder, String archiveGUID, String archiveName, String archiveRootName, String originatorName, Date creationDate, long versionNumber, String versionName) {
        super(archiveBuilder, archiveGUID, archiveName, archiveRootName, originatorName, creationDate, versionNumber, versionName);
    }

    public GovernanceArchiveHelper(OpenMetadataArchiveBuilder archiveBuilder, String archiveGUID, String archiveRootName, String originatorName, Date creationDate, long versionNumber, String versionName, String guidMapFileName) {
        super(archiveBuilder, archiveGUID, archiveRootName, originatorName, creationDate, versionNumber, versionName, guidMapFileName);
    }

    public String addGovernanceService(String typeName, String connectorProviderName, Map<String, Object> configurationProperties, String qualifiedName, String displayName, String description, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) {
        String serviceTypeName = GOVERNANCE_SERVICE_TYPE_NAME;
        if (typeName != null) {
            serviceTypeName = typeName;
        }
        try {
            Class<?> connectorProviderClass = Class.forName(connectorProviderName);
            Object potentialConnectorProvider = connectorProviderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            ConnectorProviderBase serviceProvider = (ConnectorProviderBase)potentialConnectorProvider;
            ConnectorType connectorType = serviceProvider.getConnectorType();
            String connectorTypeGUID = super.addConnectorType(null, connectorType.getGUID(), connectorType.getQualifiedName(), connectorType.getDisplayName(), connectorType.getDescription(), connectorType.getSupportedAssetTypeName(), connectorType.getExpectedDataFormat(), connectorType.getConnectorProviderClassName(), connectorType.getConnectorFrameworkName(), connectorType.getConnectorInterfaceLanguage(), connectorType.getConnectorInterfaces(), connectorType.getTargetTechnologySource(), connectorType.getTargetTechnologyName(), connectorType.getTargetTechnologyInterfaces(), connectorType.getTargetTechnologyVersions(), connectorType.getRecognizedSecuredProperties(), connectorType.getRecognizedConfigurationProperties(), connectorType.getRecognizedAdditionalProperties(), connectorType.getAdditionalProperties());
            String connectionGUID = super.addConnection(qualifiedName + "_implementation", displayName + " Governance Service Provider Implementation", "Connection for governance service: " + qualifiedName, null, null, null, null, configurationProperties, null, connectorTypeGUID, null);
            String serviceGUID = super.addAsset(serviceTypeName, qualifiedName, displayName, description, additionalProperties, extendedProperties);
            if (serviceGUID != null && connectionGUID != null) {
                super.addConnectionForAsset(serviceGUID, null, connectionGUID);
            }
            return serviceGUID;
        }
        catch (Exception error) {
            System.out.println("Invalid connector type " + connectorProviderName + " for governance service.  Exception " + error.getClass().getName() + " with message " + error.getMessage());
            return null;
        }
    }

    public String addGovernanceEngine(String typeName, String qualifiedName, String displayName, String description, String capabilityType, String capabilityVersion, String patchLevel, String source, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) {
        String engineTypeName = GOVERNANCE_ENGINE_TYPE_NAME;
        if (typeName != null) {
            engineTypeName = typeName;
        }
        return super.addSoftwareCapability(engineTypeName, qualifiedName, displayName, description, capabilityType, capabilityVersion, patchLevel, source, additionalProperties, extendedProperties);
    }

    public void addSupportedGovernanceService(String engineGUID, String requestType, Map<String, String> requestParameters, String serviceGUID) {
        String methodName = "addSupportedGovernanceService";
        EntityDetail engineEntity = this.archiveBuilder.getEntity(engineGUID);
        EntityDetail serviceEntity = this.archiveBuilder.getEntity(serviceGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(engineEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(serviceEntity);
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, REQUEST_TYPE_PROPERTY, requestType, "addSupportedGovernanceService");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, REQUEST_PARAMETERS_PROPERTY, requestParameters, "addSupportedGovernanceService");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(SUPPORTED_GOVERNANCE_SERVICE_TYPE_NAME, this.idToGUIDMap.getGUID(engineGUID + "_to_" + serviceGUID + "_supported_governance_service_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public String addGovernanceActionProcess(String typeName, String qualifiedName, String displayName, String description, String formula, int domainIdentifier, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, List<Classification> classifications) {
        Map<String, Object> processExtendedProperties;
        String processTypeName = GOVERNANCE_ACTION_PROCESS_TYPE_NAME;
        if (typeName != null) {
            processTypeName = typeName;
        }
        if ((processExtendedProperties = extendedProperties) == null) {
            processExtendedProperties = new HashMap<String, Object>();
            processExtendedProperties.put("domainIdentifier", domainIdentifier);
        }
        return super.addProcess(processTypeName, qualifiedName, displayName, description, formula, additionalProperties, extendedProperties, classifications);
    }

    public String addGovernanceActionType(String typeName, String qualifiedName, String displayName, String description, int domainIdentifier, List<String> producedGuards, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, List<Classification> classifications) {
        String methodName = "addGovernanceActionType";
        String actionTypeName = GOVERNANCE_ACTION_TYPE_TYPE_NAME;
        if (typeName != null) {
            actionTypeName = typeName;
        }
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, "qualifiedName", qualifiedName, "addGovernanceActionType");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "displayName", displayName, "addGovernanceActionType");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "description", description, "addGovernanceActionType");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, "domainIdentifier", domainIdentifier, "addGovernanceActionType");
        properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, properties, PRODUCED_GUARDS_PROPERTY, producedGuards, "addGovernanceActionType");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, "additionalProperties", additionalProperties, "addGovernanceActionType");
        properties = this.archiveHelper.addPropertyMapToInstance(this.archiveRootName, properties, extendedProperties, "addGovernanceActionType");
        EntityDetail assetEntity = this.archiveHelper.getEntityDetail(actionTypeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(assetEntity);
        return assetEntity.getGUID();
    }

    public void addGovernanceActionFlow(String governanceActionProcessGUID, String guard, String governanceActionTypeGUID) {
        String methodName = "addGovernanceActionFlow";
        EntityDetail processEntity = this.archiveBuilder.getEntity(governanceActionProcessGUID);
        EntityDetail actionTypeEntity = this.archiveBuilder.getEntity(governanceActionTypeGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(processEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(actionTypeEntity);
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, GUARD_PROPERTY, guard, "addGovernanceActionFlow");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(GOVERNANCE_ACTION_FLOW_TYPE_NAME, this.idToGUIDMap.getGUID(governanceActionProcessGUID + "_to_" + governanceActionTypeGUID + "_governance_action_flow_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addNextGovernanceActionType(String governanceActionTypeGUID, String guard, boolean mandatoryGuard, boolean ignoreMultipleTriggers, String nextGovernanceActionTypeGUID) {
        String methodName = "addNextGovernanceActionType";
        EntityDetail actionTypeEntity = this.archiveBuilder.getEntity(governanceActionTypeGUID);
        EntityDetail nextActionTypeEntity = this.archiveBuilder.getEntity(nextGovernanceActionTypeGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(actionTypeEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(nextActionTypeEntity);
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, GUARD_PROPERTY, guard, "addNextGovernanceActionType");
        properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, properties, MANDATORY_GUARD_PROPERTY, mandatoryGuard, "addNextGovernanceActionType");
        properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, properties, IGNORE_MULTIPLE_TRIGGERS_PROPERTY, ignoreMultipleTriggers, "addNextGovernanceActionType");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(NEXT_GOVERNANCE_ACTION_TYPE_TYPE_NAME, this.idToGUIDMap.getGUID(governanceActionTypeGUID + "_to_" + nextGovernanceActionTypeGUID + "_next_governance_action_type_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addGovernanceActionTypeExecutor(String governanceActionTypeGUID, String requestType, Map<String, String> requestParameters, String governanceEngineGUID) {
        String methodName = "addGovernanceActionTypeExecutor";
        EntityDetail actionTypeEntity = this.archiveBuilder.getEntity(governanceActionTypeGUID);
        EntityDetail engineEntity = this.archiveBuilder.getEntity(governanceEngineGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(actionTypeEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(engineEntity);
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, REQUEST_TYPE_PROPERTY, requestType, "addGovernanceActionTypeExecutor");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, REQUEST_PARAMETERS_PROPERTY, requestParameters, "addGovernanceActionTypeExecutor");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(GOVERNANCE_ACTION_TYPE_EXECUTOR_TYPE_NAME, this.idToGUIDMap.getGUID(governanceActionTypeGUID + "_to_" + governanceEngineGUID + "_governance_action_executor_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }
}

