/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.connectors.ConnectorProvider;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.frameworks.integration.connectors.IntegrationConnectorProvider;
import org.odpi.openmetadata.frameworks.integration.controls.CatalogTargetType;
import org.odpi.openmetadata.frameworks.openmetadata.enums.BusinessCapabilityType;
import org.odpi.openmetadata.frameworks.openmetadata.enums.CommunityMembershipType;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ConceptModelDecoration;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ContactMethodType;
import org.odpi.openmetadata.frameworks.openmetadata.enums.GlossaryTermRelationshipStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.MediaType;
import org.odpi.openmetadata.frameworks.openmetadata.enums.MediaUsage;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OperationalStatus;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationType;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.ResourceUse;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveGUIDMap;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.OpenMetadataArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumElementDef;

public class SimpleCatalogArchiveHelper {
    protected static final String guidMapFileNamePostFix = "GUIDMap.json";
    protected OpenMetadataArchiveBuilder archiveBuilder;
    protected OMRSArchiveHelper archiveHelper;
    protected OMRSArchiveGUIDMap idToGUIDMap;
    protected String archiveRootName;
    protected String originatorName;
    protected String versionName;

    public SimpleCatalogArchiveHelper(OpenMetadataArchiveBuilder archiveBuilder, String archiveGUID, String archiveName, String archiveRootName, String originatorName, Date creationDate, long versionNumber, String versionName) {
        this(archiveBuilder, archiveGUID, archiveName, originatorName, creationDate, versionNumber, versionName, archiveRootName + guidMapFileNamePostFix);
    }

    public SimpleCatalogArchiveHelper(OpenMetadataArchiveBuilder archiveBuilder, String archiveGUID, String archiveName, String archiveRootName, String originatorName, Date creationDate, long versionNumber, String versionName, InstanceProvenanceType instanceProvenanceType, String license) {
        this(archiveBuilder, archiveGUID, archiveName, originatorName, creationDate, versionNumber, versionName, instanceProvenanceType, license, archiveRootName + guidMapFileNamePostFix);
    }

    public SimpleCatalogArchiveHelper(OpenMetadataArchiveBuilder archiveBuilder, String archiveGUID, String archiveName, String originatorName, Date creationDate, long versionNumber, String versionName, String guidMapFileName) {
        this(archiveBuilder, archiveGUID, archiveName, originatorName, creationDate, versionNumber, versionName, InstanceProvenanceType.CONTENT_PACK, null, guidMapFileName);
    }

    public SimpleCatalogArchiveHelper(OpenMetadataArchiveBuilder archiveBuilder, String archiveGUID, String archiveName, String originatorName, Date creationDate, long versionNumber, String versionName, InstanceProvenanceType instanceProvenanceType, String license, String guidMapFileName) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, archiveName, originatorName, creationDate, versionNumber, versionName, instanceProvenanceType, license);
        this.idToGUIDMap = new OMRSArchiveGUIDMap(guidMapFileName);
        this.archiveRootName = archiveName;
        this.originatorName = originatorName;
        this.versionName = versionName;
    }

    public String getGUID(String qualifiedName) {
        return this.idToGUIDMap.getGUID(qualifiedName);
    }

    public void setGUID(String qualifiedName, String guid) {
        this.idToGUIDMap.setGUID(qualifiedName, guid);
    }

    public String queryGUID(String qualifiedName) {
        return this.idToGUIDMap.queryGUID(qualifiedName);
    }

    public void saveGUIDs() {
        System.out.println("GUIDs map size: " + this.idToGUIDMap.getSize());
        this.idToGUIDMap.saveGUIDs();
    }

    public void saveUsedGUIDs() {
        System.out.println("Used GUIDs map size: " + this.idToGUIDMap.getUsedSize());
        this.idToGUIDMap.saveUsedGUIDs();
    }

    public String addExternalReference(String typeName, String anchorGUID, String anchorTypeName, String anchorDomainName, String qualifiedName, String displayName, String referenceTitle, String referenceAbstract, String description, List<String> authors, int numberOfPages, String pageRange, String authorOrganization, String publicationSeries, String publicationSeriesVolume, String edition, String versionNumber, String referenceURL, String publisher, Date firstPublicationDate, Date publicationDate, String publicationCity, String publicationYear, List<String> publicationNumbers, String license, String copyright, String attribution, List<String> searchKeywords, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) {
        String methodName = "addExternalReference";
        String elementTypeName = OpenMetadataType.EXTERNAL_REFERENCE.typeName;
        if (typeName != null) {
            elementTypeName = typeName;
        }
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DISPLAY_NAME.name, displayName, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.REFERENCE_TITLE.name, referenceTitle, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.REFERENCE_ABSTRACT.name, referenceAbstract, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addExternalReference");
        properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.AUTHORS.name, authors, "addExternalReference");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.NUMBER_OF_PAGES.name, numberOfPages, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.PAGE_RANGE.name, pageRange, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ORGANIZATION.name, authorOrganization, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.REFERENCE_VERSION.name, versionNumber, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.PUBLICATION_SERIES.name, publicationSeries, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.PUBLICATION_SERIES_VOLUME.name, publicationSeriesVolume, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.EDITION.name, edition, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.URL.name, referenceURL, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.PUBLISHER.name, publisher, "addExternalReference");
        properties = this.archiveHelper.addDatePropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.FIRST_PUB_DATE.name, firstPublicationDate, "addExternalReference");
        properties = this.archiveHelper.addDatePropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.PUBLICATION_DATE.name, publicationDate, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.PUBLICATION_CITY.name, publicationCity, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.PUBLICATION_YEAR.name, publicationYear, "addExternalReference");
        properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.PUBLICATION_NUMBERS.name, publicationNumbers, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.LICENSE.name, license, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.COPYRIGHT.name, copyright, "addExternalReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ATTRIBUTION.name, attribution, "addExternalReference");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, "addExternalReference");
        properties = this.archiveHelper.addPropertyMapToInstance(this.archiveRootName, properties, extendedProperties, "addExternalReference");
        ArrayList<Classification> classifications = null;
        if (anchorGUID != null) {
            classifications = new ArrayList<Classification>();
            classifications.add(this.getAnchorClassification(anchorGUID, anchorTypeName, anchorDomainName, "addExternalReference"));
        }
        EntityDetail externalReferenceEntity = this.archiveHelper.getEntityDetail(elementTypeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(externalReferenceEntity);
        if (searchKeywords != null) {
            for (String keyword : searchKeywords) {
                if (keyword == null) continue;
                String keywordGUID = this.idToGUIDMap.queryGUID(OpenMetadataType.SEARCH_KEYWORD.typeName + ":" + keyword);
                EntityDetail keywordEntity = null;
                InstanceProperties keywordProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.KEYWORD.name, keyword, "addExternalReference");
                if (keywordGUID != null) {
                    keywordEntity = this.archiveBuilder.queryEntity(keywordGUID);
                }
                if (keywordEntity == null) {
                    keywordEntity = this.archiveHelper.getEntityDetail(OpenMetadataType.SEARCH_KEYWORD.typeName, this.idToGUIDMap.getGUID(OpenMetadataType.SEARCH_KEYWORD.typeName + ":" + keyword), keywordProperties, InstanceStatus.ACTIVE, null);
                    this.archiveBuilder.addEntity(keywordEntity);
                }
                if (keywordEntity == null) continue;
                EntityProxy end1 = this.archiveHelper.getEntityProxy(externalReferenceEntity);
                EntityProxy end2 = this.archiveHelper.getEntityProxy(keywordEntity);
                this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.SEARCH_KEYWORD_LINK_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(externalReferenceEntity.getGUID() + "_to_" + keywordEntity.getGUID() + "_search_keyword_link_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
            }
        }
        return externalReferenceEntity.getGUID();
    }

    public void addExternalReferenceLink(String referenceableGUID, String externalReferenceGUID, String referenceId, String description, String pages) {
        String methodName = "addExternalReferenceLink";
        EntityDetail referenceableEntity = this.archiveBuilder.getEntity(referenceableGUID);
        EntityDetail externalReferenceEntity = this.archiveBuilder.getEntity(externalReferenceGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(referenceableEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(externalReferenceEntity);
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.REFERENCE_ID.name, referenceId, "addExternalReferenceLink");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addExternalReferenceLink");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.PAGES.name, pages, "addExternalReferenceLink");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.EXTERNAL_REFERENCE_LINK_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(referenceableGUID + "_to_" + externalReferenceGUID + "_external_reference_link_relationship" + referenceId), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public String addMediaReference(String typeName, String qualifiedName, String displayName, String description, List<String> authors, String authorOrganization, String versionNumber, String referenceURL, String license, String copyright, String attribution, int mediaType, String mediaTypeOtherId, int defaultMediaUsage, String defaultMediaUsageOtherId, List<String> searchKeywords, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) {
        String methodName = "addMediaReference";
        String elementTypeName = OpenMetadataType.RELATED_MEDIA.typeName;
        if (typeName != null) {
            elementTypeName = typeName;
        }
        EnumElementDef typeEnumElement = this.archiveHelper.getEnumElement(MediaType.getOpenTypeName(), mediaType);
        EnumElementDef usageEnumElement = this.archiveHelper.getEnumElement(MediaUsage.getOpenTypeName(), defaultMediaUsage);
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, "addMediaReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DISPLAY_NAME.name, displayName, "addMediaReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addMediaReference");
        properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.AUTHORS.name, authors, "addMediaReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ORGANIZATION.name, authorOrganization, "addMediaReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.REFERENCE_VERSION.name, versionNumber, "addMediaReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.URL.name, referenceURL, "addMediaReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.LICENSE.name, license, "addMediaReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.COPYRIGHT.name, copyright, "addMediaReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ATTRIBUTION.name, attribution, "addMediaReference");
        properties = this.archiveHelper.addEnumPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.MEDIA_TYPE.name, MediaType.getOpenTypeGUID(), MediaType.getOpenTypeName(), typeEnumElement.getOrdinal(), typeEnumElement.getValue(), typeEnumElement.getDescription(), "addMediaReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.MEDIA_TYPE_OTHER_ID.name, mediaTypeOtherId, "addMediaReference");
        properties = this.archiveHelper.addEnumPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DEFAULT_MEDIA_USAGE.name, MediaUsage.getOpenTypeGUID(), MediaUsage.getOpenTypeName(), usageEnumElement.getOrdinal(), usageEnumElement.getValue(), usageEnumElement.getDescription(), "addMediaReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DEFAULT_MEDIA_USAGE_OTHER_ID.name, defaultMediaUsageOtherId, "addMediaReference");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, "addMediaReference");
        properties = this.archiveHelper.addPropertyMapToInstance(this.archiveRootName, properties, extendedProperties, "addMediaReference");
        EntityDetail mediaReferenceEntity = this.archiveHelper.getEntityDetail(elementTypeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(mediaReferenceEntity);
        if (searchKeywords != null) {
            for (String keyword : searchKeywords) {
                if (keyword == null) continue;
                String keywordGUID = this.idToGUIDMap.queryGUID(OpenMetadataType.SEARCH_KEYWORD.typeName + ":" + keyword);
                EntityDetail keywordEntity = null;
                InstanceProperties keywordProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.KEYWORD.name, keyword, "addMediaReference");
                if (keywordGUID != null) {
                    keywordEntity = this.archiveBuilder.queryEntity(keywordGUID);
                }
                if (keywordEntity == null) {
                    keywordEntity = this.archiveHelper.getEntityDetail(OpenMetadataType.SEARCH_KEYWORD.typeName, this.idToGUIDMap.getGUID(OpenMetadataType.SEARCH_KEYWORD.typeName + ":" + keyword), keywordProperties, InstanceStatus.ACTIVE, null);
                    this.archiveBuilder.addEntity(keywordEntity);
                }
                if (keywordEntity == null) continue;
                EntityProxy end1 = this.archiveHelper.getEntityProxy(mediaReferenceEntity);
                EntityProxy end2 = this.archiveHelper.getEntityProxy(keywordEntity);
                this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.SEARCH_KEYWORD_LINK_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(mediaReferenceEntity.getGUID() + "_to_" + keywordEntity.getGUID() + "_search_keyword_link_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
            }
        }
        return mediaReferenceEntity.getGUID();
    }

    public void addMediaReferenceLink(String referenceableGUID, String mediaReferenceGUID, String mediaId, String description, int mediaUsage, String mediaUsageOtherId) {
        String methodName = "addMediaReferenceLink";
        EnumElementDef enumElement = this.archiveHelper.getEnumElement(MediaUsage.getOpenTypeName(), mediaUsage);
        EntityDetail referenceableEntity = this.archiveBuilder.getEntity(referenceableGUID);
        EntityDetail externalReferenceEntity = this.archiveBuilder.getEntity(mediaReferenceGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(referenceableEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(externalReferenceEntity);
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.MEDIA_ID.name, mediaId, "addMediaReferenceLink");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addMediaReferenceLink");
        properties = this.archiveHelper.addEnumPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.MEDIA_USAGE.name, MediaUsage.getOpenTypeGUID(), MediaUsage.getOpenTypeName(), enumElement.getOrdinal(), enumElement.getValue(), enumElement.getDescription(), "addMediaReferenceLink");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.MEDIA_USAGE_OTHER_ID.name, mediaUsageOtherId, "addMediaReferenceLink");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.MEDIA_REFERENCE_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(referenceableGUID + "_to_" + mediaReferenceGUID + "_media_reference_relationship" + mediaId), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addDeployedOnRelationship(String deployedElementQName, String deployedOnQName, Date deploymentTime, String deployerTypeName, String deployerPropertyName, String deployer, int deploymentStatus) {
        String methodName = "addDeployedOnRelationship";
        String deployedElementId = this.idToGUIDMap.getGUID(deployedElementQName);
        String deployedOnId = this.idToGUIDMap.getGUID(deployedOnQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(deployedElementId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(deployedOnId));
        EnumElementDef statusEnumElement = this.archiveHelper.getEnumElement(OperationalStatus.getOpenTypeName(), deploymentStatus);
        InstanceProperties properties = this.archiveHelper.addDatePropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.DEPLOYMENT_TIME.name, deploymentTime, "addDeployedOnRelationship");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DEPLOYER_TYPE_NAME.name, deployerTypeName, "addDeployedOnRelationship");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DEPLOYER_PROPERTY_NAME.name, deployerPropertyName, "addDeployedOnRelationship");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DEPLOYER.name, deployer, "addDeployedOnRelationship");
        properties = this.archiveHelper.addEnumPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.OPERATIONAL_STATUS.name, OperationalStatus.getOpenTypeGUID(), OperationalStatus.getOpenTypeName(), statusEnumElement.getOrdinal(), statusEnumElement.getValue(), statusEnumElement.getDescription(), "addDeployedOnRelationship");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.DEPLOYED_ON.typeName, this.idToGUIDMap.getGUID(deployedElementId + "_to_" + deployedOnId + "_deployed_on_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addResourceListRelationship(String parentQName, String resourceQName, String resourceUse, String resourceUseDescription) {
        this.addResourceListRelationshipByGUID(this.idToGUIDMap.getGUID(parentQName), this.idToGUIDMap.getGUID(resourceQName), resourceUse, resourceUseDescription);
    }

    public void addResourceListRelationshipByGUID(String parentGUID, String resourceGUID, String resourceUse, String resourceUseDescription) {
        String methodName = "addResourceListRelationshipByGUID";
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(parentGUID));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(resourceGUID));
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.RESOURCE_USE.name, resourceUse, "addResourceListRelationshipByGUID");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.RESOURCE_USE_DESCRIPTION.name, resourceUseDescription, "addResourceListRelationshipByGUID");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.RESOURCE_LIST_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(parentGUID + "_to_" + resourceGUID + "_resource_list_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addResourceListRelationshipByGUID(String parentGUID, String resourceGUID, String resourceUse, String resourceUseDescription, Map<String, String> resourceUseProperties, boolean watchResource) {
        String methodName = "addResourceListRelationshipByGUID";
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(parentGUID));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(resourceGUID));
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.RESOURCE_USE.name, resourceUse, "addResourceListRelationshipByGUID");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.RESOURCE_USE_DESCRIPTION.name, resourceUseDescription, "addResourceListRelationshipByGUID");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.RESOURCE_USE_PROPERTIES.name, resourceUseProperties, "addResourceListRelationshipByGUID");
        properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.WATCH_RESOURCE.name, watchResource, "addResourceListRelationshipByGUID");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.RESOURCE_LIST_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(parentGUID + "_to_" + resourceGUID + "_resource_list_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addResourceListRelationship(String referenceableQName, String resourceQName, String resourceUse, String resourceUseDescription, Map<String, String> resourceUseProperties, boolean watchResource) {
        String methodName = "addResourceListRelationship";
        String guid1 = this.idToGUIDMap.getGUID(referenceableQName);
        String guid2 = this.idToGUIDMap.getGUID(resourceQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid1));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid2));
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.RESOURCE_USE.name, resourceUse, "addResourceListRelationship");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.RESOURCE_USE_DESCRIPTION.name, resourceUseDescription, "addResourceListRelationship");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.RESOURCE_USE_PROPERTIES.name, resourceUseProperties, "addResourceListRelationship");
        properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.WATCH_RESOURCE.name, watchResource, "addResourceListRelationship");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.RESOURCE_LIST_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(guid1 + "_to_" + guid2 + "_resource_list_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public String addLocation(String qualifiedName, String identifier, String displayName, String description, Map<String, String> additionalProperties) {
        String methodName = "addLocation";
        return this.addClassifiedLocation(qualifiedName, identifier, displayName, description, additionalProperties, null, null, "addLocation");
    }

    public String addFixedLocation(String qualifiedName, String identifier, String displayName, String description, String coordinates, String mapProjection, String postalAddress, String timeZone, Map<String, String> additionalProperties) {
        String methodName = "addFixedLocation";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.COORDINATES.name, coordinates, "addFixedLocation");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.MAP_PROJECTION.name, mapProjection, "addFixedLocation");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.POSTAL_ADDRESS.name, postalAddress, "addFixedLocation");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.TIME_ZONE.name, timeZone, "addFixedLocation");
        return this.addClassifiedLocation(qualifiedName, identifier, displayName, description, additionalProperties, OpenMetadataType.FIXED_LOCATION_CLASSIFICATION.typeName, properties, "addFixedLocation");
    }

    public String addSecureLocation(String qualifiedName, String identifier, String displayName, String description, String level, String securityDescription, Map<String, String> additionalProperties) {
        String methodName = "addSecureLocation";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.LEVEL.name, level, "addSecureLocation");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, securityDescription, "addSecureLocation");
        return this.addClassifiedLocation(qualifiedName, identifier, displayName, description, additionalProperties, OpenMetadataType.SECURE_LOCATION_CLASSIFICATION.typeName, properties, "addSecureLocation");
    }

    public String addCyberLocation(String qualifiedName, String identifier, String displayName, String description, String networkAddress, Map<String, String> additionalProperties) {
        String methodName = "addCyberLocation";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.NETWORK_ADDRESS.name, networkAddress, "addCyberLocation");
        return this.addClassifiedLocation(qualifiedName, identifier, displayName, description, additionalProperties, OpenMetadataType.CYBER_LOCATION_CLASSIFICATION.typeName, properties, "addCyberLocation");
    }

    private String addClassifiedLocation(String qualifiedName, String identifier, String displayName, String description, Map<String, String> additionalProperties, String classificationName, InstanceProperties classificationProperties, String methodName) {
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, methodName);
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.IDENTIFIER.name, identifier, methodName);
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DISPLAY_NAME.name, displayName, methodName);
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, methodName);
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, methodName);
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        Classification classification = this.archiveHelper.getClassification(classificationName, classificationProperties, InstanceStatus.ACTIVE);
        classifications.add(classification);
        EntityDetail location = this.archiveHelper.getEntityDetail(OpenMetadataType.LOCATION.typeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(location);
        return location.getGUID();
    }

    public void addMobileAssetClassification(String assetGUID) {
        EntityDetail assetEntity = this.archiveBuilder.getEntity(assetGUID);
        EntityProxy entityProxy = this.archiveHelper.getEntityProxy(assetEntity);
        Classification classification = this.archiveHelper.getClassification(OpenMetadataType.MOBILE_ASSET_CLASSIFICATION.typeName, null, InstanceStatus.ACTIVE);
        this.archiveBuilder.addClassification(this.archiveHelper.getClassificationEntityExtension(entityProxy, classification));
    }

    public void addLocationHierarchy(String broaderLocationGUID, String nestedLocationGUID) {
        EntityDetail entity1 = this.archiveBuilder.getEntity(broaderLocationGUID);
        EntityDetail entity2 = this.archiveBuilder.getEntity(nestedLocationGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(entity1);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(entity2);
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.NESTED_LOCATION_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(broaderLocationGUID + "_to_" + nestedLocationGUID + "_nested_location_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addPeerLocations(String location1GUID, String location2GUID) {
        EntityDetail referenceableEntity = this.archiveBuilder.getEntity(location1GUID);
        EntityDetail externalReferenceEntity = this.archiveBuilder.getEntity(location2GUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(referenceableEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(externalReferenceEntity);
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.ADJACENT_LOCATION_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(location1GUID + "_to_" + location2GUID + "_adjacent_location_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addAssetLocationRelationship(String locationQName, String assetQName) {
        String validValueId = this.idToGUIDMap.getGUID(locationQName);
        String assetId = this.idToGUIDMap.getGUID(assetQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(validValueId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(assetId));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.ASSET_LOCATION_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(validValueId + "_to_" + assetId + "_asset_location_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public String addUserIdentity(String qualifiedName, String userId, String distinguishedName, Map<String, String> additionalProperties) {
        String methodName = "addUserIdentity";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, "addUserIdentity");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.USER_ID.name, userId, "addUserIdentity");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DISTINGUISHED_NAME.name, distinguishedName, "addUserIdentity");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, "addUserIdentity");
        EntityDetail userIdentity = this.archiveHelper.getEntityDetail(OpenMetadataType.USER_IDENTITY.typeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(userIdentity);
        return userIdentity.getGUID();
    }

    public void addProfileLocationRelationship(String profileQName, String locationQName, String associationType) {
        String methodName = "addProfileLocationRelationship";
        String entity1GUID = this.idToGUIDMap.getGUID(locationQName);
        String entity2GUID = this.idToGUIDMap.getGUID(profileQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(entity1GUID));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(entity2GUID));
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.ASSOCIATION_TYPE.name, associationType, "addProfileLocationRelationship");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.PROFILE_LOCATION_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(entity1GUID + "_to_" + entity2GUID + "_profile_location_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addProfileIdentity(String profileGUID, String userIdentityGUID, String roleTypeName, String roleGUID, String description) {
        String methodName = "addProfileIdentity";
        EntityDetail profileEntity = this.archiveBuilder.getEntity(profileGUID);
        EntityDetail userIdentityEntity = this.archiveBuilder.getEntity(userIdentityGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(profileEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(userIdentityEntity);
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.ROLE_TYPE_NAME.name, roleTypeName, "addProfileIdentity");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ROLE_GUID.name, roleGUID, "addProfileIdentity");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addProfileIdentity");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.PROFILE_IDENTITY_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(profileGUID + "_to_" + userIdentityGUID + "_profile_identity_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addContactDetails(String profileGUID, String profileTypeName, String name, String contactType, int contactMethodType, String contactMethodService, String contactMethodValue) {
        String methodName = "addContactDetails";
        EntityDetail profileEntity = this.archiveBuilder.getEntity(profileGUID);
        EnumElementDef enumElement = this.archiveHelper.getEnumElement(ContactMethodType.getOpenTypeName(), contactMethodType);
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.NAME.name, name, "addContactDetails");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.CONTACT_TYPE.name, contactType, "addContactDetails");
        properties = this.archiveHelper.addEnumPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.CONTACT_METHOD_TYPE.name, ContactMethodType.getOpenTypeGUID(), ContactMethodType.getOpenTypeName(), enumElement.getOrdinal(), enumElement.getValue(), enumElement.getDescription(), "addContactDetails");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.CONTACT_METHOD_SERVICE.name, contactMethodService, "addContactDetails");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.CONTACT_METHOD_VALUE.name, contactMethodValue, "addContactDetails");
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        classifications.add(this.getAnchorClassification(profileGUID, profileTypeName, OpenMetadataType.ACTOR.typeName, "addContactDetails"));
        EntityDetail contactDetails = this.archiveHelper.getEntityDetail(OpenMetadataType.CONTACT_DETAILS.typeName, this.idToGUIDMap.getGUID(contactMethodValue), properties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(contactDetails);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(profileEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(contactDetails);
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.CONTACT_THROUGH_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(profileGUID + "_to_" + contactDetails.getGUID() + "_contact_through_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public String addPersonRole(String suppliedTypeName, String qualifiedName, String identifier, String name, String description, String scope, boolean setHeadCount, int headCount, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) {
        String methodName = "addPersonRole";
        String typeName = suppliedTypeName;
        if (typeName == null) {
            typeName = OpenMetadataType.PERSON_ROLE.typeName;
        }
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, "addPersonRole");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.IDENTIFIER.name, identifier, "addPersonRole");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.NAME.name, name, "addPersonRole");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addPersonRole");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.SCOPE.name, scope, "addPersonRole");
        if (setHeadCount) {
            properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.HEAD_COUNT.name, headCount, "addPersonRole");
        }
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, "addPersonRole");
        properties = this.archiveHelper.addPropertyMapToInstance(this.archiveRootName, properties, extendedProperties, "addPersonRole");
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        classifications.add(this.getAnchorClassification(null, typeName, OpenMetadataType.ACTOR.typeName, "addPersonRole"));
        EntityDetail role = this.archiveHelper.getEntityDetail(typeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(role);
        return role.getGUID();
    }

    public String addGovernanceRole(String suppliedTypeName, String qualifiedName, int domainIdentifier, String identifier, String name, String description, String scope, boolean setHeadCount, int headCount, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) {
        String methodName = "addPersonRole";
        String typeName = suppliedTypeName;
        if (typeName == null) {
            typeName = OpenMetadataType.PERSON_ROLE.typeName;
        }
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, "addPersonRole");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.IDENTIFIER.name, identifier, "addPersonRole");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, "domainIdentifier", domainIdentifier, "addPersonRole");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.NAME.name, name, "addPersonRole");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addPersonRole");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.SCOPE.name, scope, "addPersonRole");
        if (setHeadCount) {
            properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.HEAD_COUNT.name, headCount, "addPersonRole");
        }
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, "addPersonRole");
        properties = this.archiveHelper.addPropertyMapToInstance(this.archiveRootName, properties, extendedProperties, "addPersonRole");
        EntityDetail role = this.archiveHelper.getEntityDetail(typeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(role);
        return role.getGUID();
    }

    public void addPersonRoleAppointmentRelationship(String personQName, String personRoleQName, boolean isPublic) {
        String methodName = "addPersonRoleAppointmentRelationship";
        String guid1 = this.idToGUIDMap.getGUID(personQName);
        String guid2 = this.idToGUIDMap.getGUID(personRoleQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid1));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid2));
        InstanceProperties properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.IS_PUBLIC.name, isPublic, "addPersonRoleAppointmentRelationship");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.PERSON_ROLE_APPOINTMENT_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(guid1 + "_to_" + guid2 + "_person_role_appointment_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addPeerRelationship(String person1QName, String person2QName) {
        String guid1 = this.idToGUIDMap.getGUID(person1QName);
        String guid2 = this.idToGUIDMap.getGUID(person2QName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid1));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid2));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.PEER_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(guid1 + "_to_" + guid2 + "_peer_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public String addPerson(String qualifiedName, String name, String pronouns, String description, String initials, String title, String givenNames, String surname, String fullName, String jobTitle, String employeeNumber, String employeeType, String preferredLanguage, boolean isPublic, Map<String, String> additionalProperties) {
        String methodName = "addPerson";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, "addPerson");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.NAME.name, name, "addPerson");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.PRONOUNS.name, pronouns, "addPerson");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addPerson");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.COURTESY_TITLE.name, title, "addPerson");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.INITIALS.name, initials, "addPerson");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.GIVEN_NAMES.name, givenNames, "addPerson");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.SURNAME.name, surname, "addPerson");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.FULL_NAME.name, fullName, "addPerson");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.JOB_TITLE.name, jobTitle, "addPerson");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.EMPLOYEE_NUMBER.name, employeeNumber, "addPerson");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.EMPLOYEE_TYPE.name, employeeType, "addPerson");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.PREFERRED_LANGUAGE.name, preferredLanguage, "addPerson");
        properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.IS_PUBLIC.name, isPublic, "addPerson");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, "addPerson");
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        classifications.add(this.getAnchorClassification(null, OpenMetadataType.PERSON.typeName, OpenMetadataType.ACTOR.typeName, "addPerson"));
        EntityDetail person = this.archiveHelper.getEntityDetail(OpenMetadataType.PERSON.typeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(person);
        return person.getGUID();
    }

    public String addTeam(String suppliedTypeName, String qualifiedName, String name, String description, String teamType, String identifier, Map<String, String> additionalProperties) {
        String methodName = "addTeam";
        String typeName = suppliedTypeName;
        if (typeName == null) {
            typeName = OpenMetadataType.TEAM.typeName;
        }
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, "addTeam");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.NAME.name, name, "addTeam");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addTeam");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.TEAM_TYPE.name, teamType, "addTeam");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.IDENTIFIER.name, identifier, "addTeam");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, "addTeam");
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        classifications.add(this.getAnchorClassification(null, typeName, OpenMetadataType.ACTOR.typeName, "addTeam"));
        EntityDetail profile = this.archiveHelper.getEntityDetail(typeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(profile);
        return profile.getGUID();
    }

    public void addTeamLeadershipRelationship(String personRoleQName, String teamQName, String position) {
        String methodName = "addTeamLeadershipRelationship";
        String guid1 = this.idToGUIDMap.getGUID(personRoleQName);
        String guid2 = this.idToGUIDMap.getGUID(teamQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid1));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid2));
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.ROLE_POSITION.name, position, "addTeamLeadershipRelationship");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.TEAM_LEADERSHIP_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(guid1 + "_to_" + guid2 + "_team_leadership_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addTeamMembershipRelationship(String personRoleQName, String teamQName, String position) {
        String methodName = "addTeamMembershipRelationship";
        String guid1 = this.idToGUIDMap.getGUID(personRoleQName);
        String guid2 = this.idToGUIDMap.getGUID(teamQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid1));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid2));
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.ROLE_POSITION.name, position, "addTeamMembershipRelationship");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.TEAM_MEMBERSHIP_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(guid1 + "_to_" + guid2 + "_team_membership_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addTeamStructureRelationship(String superTeamQName, String subTeamQName, boolean delegationEscalationAuthority) {
        String methodName = "addTeamStructureRelationship";
        String guid1 = this.idToGUIDMap.getGUID(superTeamQName);
        String guid2 = this.idToGUIDMap.getGUID(subTeamQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid1));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid2));
        InstanceProperties properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.DELEGATION_ESCALATION.name, delegationEscalationAuthority, "addTeamStructureRelationship");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.TEAM_STRUCTURE_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(guid1 + "_to_" + guid2 + "_team_structure_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public String addITProfile(String infrastructureGUID, String userId, String qualifiedName, String name, String description, Map<String, String> additionalProperties) {
        EntityProxy end2;
        EntityProxy end1;
        String methodName = "addITProfile";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, "addITProfile");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.NAME.name, name, "addITProfile");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addITProfile");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, "addITProfile");
        EntityDetail profile = this.archiveHelper.getEntityDetail(OpenMetadataType.IT_PROFILE.typeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(profile);
        if (infrastructureGUID != null) {
            EntityDetail itEntity = this.archiveBuilder.getEntity(infrastructureGUID);
            end1 = this.archiveHelper.getEntityProxy(itEntity);
            end2 = this.archiveHelper.getEntityProxy(profile);
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.IT_INFRASTRUCTURE_PROFILE_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(infrastructureGUID + "_to_" + profile.getGUID() + "_it_infrastructure_profile_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        }
        if (userId != null) {
            properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName + ":UserIdentity", "addITProfile");
            properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.USER_ID.name, userId, "addITProfile");
            EntityDetail userIdentity = this.archiveHelper.getEntityDetail(OpenMetadataType.USER_IDENTITY.typeName, this.idToGUIDMap.getGUID(qualifiedName + ":UserIdentity"), properties, InstanceStatus.ACTIVE, null);
            this.archiveBuilder.addEntity(userIdentity);
            end1 = this.archiveHelper.getEntityProxy(profile);
            end2 = this.archiveHelper.getEntityProxy(userIdentity);
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.PROFILE_IDENTITY_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(profile.getGUID() + "_to_" + userIdentity.getGUID() + "_profile_identity_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        }
        return profile.getGUID();
    }

    public void addAssignmentScopeRelationship(String actorQName, String scopeQName, String assignmentType, String description) {
        String methodName = "addAssignmentScopeRelationship";
        String guid1 = this.idToGUIDMap.getGUID(actorQName);
        String guid2 = this.idToGUIDMap.getGUID(scopeQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid1));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid2));
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.ASSIGNMENT_TYPE.name, assignmentType, "addAssignmentScopeRelationship");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addAssignmentScopeRelationship");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.ASSIGNMENT_SCOPE_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(guid1 + "_to_" + guid2 + "_assignment_scope_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public String addProject(String suppliedTypeName, String qualifiedName, String identifier, String name, String description, Date startDate, Date plannedEndDate, String projectPhase, String projectHealth, String projectStatus, boolean setCampaignClassification, boolean setTaskClassification, String projectTypeClassification, List<Classification> otherClassifications, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) {
        Classification classification;
        String methodName = "addProject";
        String typeName = suppliedTypeName;
        if (typeName == null) {
            typeName = OpenMetadataType.PROJECT.typeName;
        }
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, "addProject");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.IDENTIFIER.name, identifier, "addProject");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.NAME.name, name, "addProject");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addProject");
        properties = this.archiveHelper.addDatePropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.START_DATE.name, startDate, "addProject");
        properties = this.archiveHelper.addDatePropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.PLANNED_END_DATE.name, plannedEndDate, "addProject");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.PROJECT_PHASE.name, projectPhase, "addProject");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.PROJECT_HEALTH.name, projectHealth, "addProject");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.PROJECT_STATUS.name, projectStatus, "addProject");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, "addProject");
        properties = this.archiveHelper.addPropertyMapToInstance(this.archiveRootName, properties, extendedProperties, "addProject");
        List<Classification> classifications = otherClassifications != null ? otherClassifications : new ArrayList<Classification>();
        if (setCampaignClassification) {
            classification = this.archiveHelper.getClassification(OpenMetadataType.CAMPAIGN_CLASSIFICATION.typeName, null, InstanceStatus.ACTIVE);
            classifications.add(classification);
        }
        if (setTaskClassification) {
            classification = this.archiveHelper.getClassification(OpenMetadataType.TASK_CLASSIFICATION.typeName, null, InstanceStatus.ACTIVE);
            classifications.add(classification);
        }
        if (projectTypeClassification != null) {
            classification = this.archiveHelper.getClassification(projectTypeClassification, null, InstanceStatus.ACTIVE);
            classifications.add(classification);
        }
        if (classifications.isEmpty()) {
            classifications = null;
        }
        EntityDetail project = this.archiveHelper.getEntityDetail(typeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(project);
        return project.getGUID();
    }

    public void addProjectHierarchyRelationship(String projectQName, String subprojectQName) {
        String guid1 = this.idToGUIDMap.getGUID(projectQName);
        String guid2 = this.idToGUIDMap.getGUID(subprojectQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid1));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid2));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.PROJECT_HIERARCHY_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(guid1 + "_to_" + guid2 + "_project_hierarchy_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addStakeHolderRelationship(String referenceableQName, String actorQName) {
        String guid1 = this.idToGUIDMap.getGUID(referenceableQName);
        String guid2 = this.idToGUIDMap.getGUID(actorQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid1));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid2));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.STAKEHOLDER_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(guid1 + "_to_" + guid2 + "_stakeholder_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addProjectDependencyRelationship(String projectQName, String dependsOnProjectQName, String dependencySummary) {
        String methodName = "addProjectDependencyRelationship";
        String guid1 = this.idToGUIDMap.getGUID(projectQName);
        String guid2 = this.idToGUIDMap.getGUID(dependsOnProjectQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid1));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid2));
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.DEPENDENCY_SUMMARY.name, dependencySummary, "addProjectDependencyRelationship");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.PROJECT_DEPENDENCY_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(guid1 + "_to_" + guid2 + "_project_dependency_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addProjectTeamRelationship(String personQName, String personRoleQName, String teamRole) {
        String methodName = "addProjectTeamRelationship";
        String guid1 = this.idToGUIDMap.getGUID(personQName);
        String guid2 = this.idToGUIDMap.getGUID(personRoleQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid1));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid2));
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.TEAM_ROLE.name, teamRole, "addProjectTeamRelationship");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.PROJECT_TEAM_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(guid1 + "_to_" + guid2 + "_project_team_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addProjectManagementRelationship(String projectQName, String projectManagerRoleQName) {
        String guid1 = this.idToGUIDMap.getGUID(projectQName);
        String guid2 = this.idToGUIDMap.getGUID(projectManagerRoleQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid1));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid2));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.PROJECT_MANAGEMENT_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(guid1 + "_to_" + guid2 + "_project_management_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public String addCommunity(String suppliedTypeName, String qualifiedName, String name, String description, String mission, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) {
        String methodName = "addCommunity";
        String typeName = suppliedTypeName;
        if (typeName == null) {
            typeName = OpenMetadataType.COMMUNITY.typeName;
        }
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, "addCommunity");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.NAME.name, name, "addCommunity");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addCommunity");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.MISSION.name, mission, "addCommunity");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, "addCommunity");
        properties = this.archiveHelper.addPropertyMapToInstance(this.archiveRootName, properties, extendedProperties, "addCommunity");
        EntityDetail project = this.archiveHelper.getEntityDetail(typeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(project);
        return project.getGUID();
    }

    public void addCommunityMembershipRelationship(String communityQName, String membershipRoleQName, int membershipType) {
        String methodName = "addCommunityMembershipRelationship";
        EnumElementDef enumElement = this.archiveHelper.getEnumElement(CommunityMembershipType.getOpenTypeName(), membershipType);
        String guid1 = this.idToGUIDMap.getGUID(communityQName);
        String guid2 = this.idToGUIDMap.getGUID(membershipRoleQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid1));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid2));
        InstanceProperties properties = this.archiveHelper.addEnumPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.MEMBERSHIP_TYPE.name, CommunityMembershipType.getOpenTypeGUID(), CommunityMembershipType.getOpenTypeName(), enumElement.getOrdinal(), enumElement.getValue(), enumElement.getDescription(), "addCommunityMembershipRelationship");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.COMMUNITY_MEMBERSHIP_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(guid1 + "_to_" + guid2 + "_community_membership_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public String addCollection(String suppliedTypeName, String anchorGUID, String anchorTypeName, String anchorDomainName, String classificationName, String qualifiedName, String displayName, String description, String collectionType, Map<String, String> additionalProperties, List<Classification> otherClassifications, Map<String, Object> extendedProperties) {
        String methodName = "addCollection";
        String typeName = OpenMetadataType.COLLECTION.typeName;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        List<Classification> classifications = otherClassifications;
        if (classificationName != null) {
            if (classifications == null) {
                classifications = new ArrayList<Classification>();
            }
            Classification classification = this.archiveHelper.getClassification(classificationName, null, InstanceStatus.ACTIVE);
            classifications.add(classification);
        }
        if (anchorTypeName != null) {
            classifications.add(this.getAnchorClassification(anchorGUID, anchorTypeName, anchorDomainName, "addCollection"));
        }
        if (classifications.isEmpty()) {
            classifications = null;
        }
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, "addCollection");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.NAME.name, displayName, "addCollection");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addCollection");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.COLLECTION_TYPE.name, collectionType, "addCollection");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, "addCollection");
        properties = this.archiveHelper.addPropertyMapToInstance(this.archiveRootName, properties, extendedProperties, "addCollection");
        EntityDetail newEntity = this.archiveHelper.getEntityDetail(typeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(newEntity);
        return newEntity.getGUID();
    }

    public void addMemberToCollection(String collectionGUID, String memberGUID, String membershipRationale) {
        String methodName = "addMemberToCollection";
        EntityDetail entity1 = this.archiveBuilder.getEntity(collectionGUID);
        EntityDetail entity2 = this.archiveBuilder.getEntity(memberGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(entity1);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(entity2);
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.MEMBERSHIP_RATIONALE.name, membershipRationale, "addMemberToCollection");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.COLLECTION_MEMBERSHIP_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(collectionGUID + "_to_" + memberGUID + "_collection_membership_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public String addGovernanceDomainDescription(String governanceDomainSetGUID, String qualifiedName, int domainIdentifier, String displayName, String description, Map<String, String> additionalProperties) {
        String methodName = "addGovernanceDomainDescription";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, "addGovernanceDomainDescription");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, "domainIdentifier", domainIdentifier, "addGovernanceDomainDescription");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DISPLAY_NAME.name, displayName, "addGovernanceDomainDescription");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addGovernanceDomainDescription");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, "addGovernanceDomainDescription");
        EntityDetail newEntity = this.archiveHelper.getEntityDetail("GovernanceDomainDescription", this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(newEntity);
        if (governanceDomainSetGUID != null) {
            this.addMemberToCollection(governanceDomainSetGUID, newEntity.getGUID(), null);
        }
        return newEntity.getGUID();
    }

    public String addGovernanceDefinition(String suppliedTypeName, String qualifiedName, String title, String summary, String description, String scope, int domainIdentifier, String priority, List<String> implications, List<String> outcomes, List<String> results, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) {
        String methodName = "addGovernanceDefinition";
        String typeName = "GovernanceDefinition";
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, "addGovernanceDefinition");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.TITLE.name, title, "addGovernanceDefinition");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.SUMMARY.name, summary, "addGovernanceDefinition");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addGovernanceDefinition");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.SCOPE.name, scope, "addGovernanceDefinition");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.PRIORITY.name, priority, "addGovernanceDefinition");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, "domainIdentifier", domainIdentifier, "addGovernanceDefinition");
        properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, properties, "implications", implications, "addGovernanceDefinition");
        properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, properties, "outcomes", outcomes, "addGovernanceDefinition");
        properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, properties, "results", results, "addGovernanceDefinition");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, "addGovernanceDefinition");
        properties = this.archiveHelper.addPropertyMapToInstance(this.archiveRootName, properties, extendedProperties, "addGovernanceDefinition");
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        classifications.add(this.getAnchorClassification(null, typeName, "GovernanceDefinition", "addGovernanceDefinition"));
        EntityDetail newEntity = this.archiveHelper.getEntityDetail(typeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(newEntity);
        return newEntity.getGUID();
    }

    public void addGovernanceDefinitionScopeRelationship(String referenceableQName, String governanceDefinitionQName) {
        String guid1 = this.idToGUIDMap.getGUID(referenceableQName);
        String guid2 = this.idToGUIDMap.getGUID(governanceDefinitionQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid1));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid2));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship("GovernanceDefinitionScope", this.idToGUIDMap.getGUID(guid1 + "_to_" + guid2 + "_governance_definition_scope_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addGovernedByRelationship(String referenceableQName, String governanceDefinitionQName) {
        String guid1 = this.idToGUIDMap.getGUID(referenceableQName);
        String guid2 = this.idToGUIDMap.getGUID(governanceDefinitionQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid1));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid2));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship("GovernedBy", this.idToGUIDMap.getGUID(guid1 + "_to_" + guid2 + "_governed_by_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addGovernanceDefinitionPeerRelationship(String relationshipTypeName, String governanceDefinition1QName, String governanceDefinition2QName, String description) {
        String methodName = "addGovernanceDefinitionPeerRelationship";
        String guid1 = this.idToGUIDMap.getGUID(governanceDefinition1QName);
        String guid2 = this.idToGUIDMap.getGUID(governanceDefinition2QName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid1));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid2));
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.DESCRIPTION.name, description, "addGovernanceDefinitionPeerRelationship");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(relationshipTypeName, this.idToGUIDMap.getGUID(guid1 + "_to_" + guid2 + "_governance_definition_" + relationshipTypeName + "_peer_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addGovernanceDefinitionDelegationRelationship(String relationshipTypeName, String governanceDefinition1QName, String governanceDefinition2QName, String rationale) {
        String methodName = "addGovernanceDefinitionDelegationRelationship";
        String guid1 = this.idToGUIDMap.getGUID(governanceDefinition1QName);
        String guid2 = this.idToGUIDMap.getGUID(governanceDefinition2QName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid1));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(guid2));
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, "rationale", rationale, "addGovernanceDefinitionDelegationRelationship");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(relationshipTypeName, this.idToGUIDMap.getGUID(guid1 + "_to_" + guid2 + "_governance_definition_" + relationshipTypeName + "_delegation_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public String addGovernanceZone(String qualifiedName, String zoneName, String displayName, String description, String criteria, String scope, int domainIdentifier, Map<String, String> additionalProperties) {
        String methodName = "addGovernanceZone";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, "addGovernanceZone");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "zoneName", zoneName, "addGovernanceZone");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DISPLAY_NAME.name, displayName, "addGovernanceZone");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addGovernanceZone");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "scope", scope, "addGovernanceZone");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "criteria", criteria, "addGovernanceZone");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, "domainIdentifier", domainIdentifier, "addGovernanceZone");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, "addGovernanceZone");
        EntityDetail newEntity = this.archiveHelper.getEntityDetail("GovernanceZone", this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(newEntity);
        return newEntity.getGUID();
    }

    public void addZoneHierarchy(String broaderGovernanceZoneGUID, String nestedGovernanceZoneGUID) {
        EntityDetail entity1 = this.archiveBuilder.getEntity(broaderGovernanceZoneGUID);
        EntityDetail entity2 = this.archiveBuilder.getEntity(nestedGovernanceZoneGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(entity1);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(entity2);
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship("ZoneHierarchy", this.idToGUIDMap.getGUID(broaderGovernanceZoneGUID + "_to_" + nestedGovernanceZoneGUID + "_zone_hierarchy_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public Classification getAssetZoneMembershipClassification(List<String> zones) {
        String methodName = "getAssetZoneMembershipClassification";
        return this.archiveHelper.getClassification("AssetZoneMembership", this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.ZONE_MEMBERSHIP.name, zones, "getAssetZoneMembershipClassification"), InstanceStatus.ACTIVE);
    }

    public void addAssetZoneMembershipClassification(String assetGUID, List<String> zones) {
        EntityDetail assetEntity = this.archiveBuilder.getEntity(assetGUID);
        EntityProxy entityProxy = this.archiveHelper.getEntityProxy(assetEntity);
        Classification classification = this.getAssetZoneMembershipClassification(zones);
        this.archiveBuilder.addClassification(this.archiveHelper.getClassificationEntityExtension(entityProxy, classification));
    }

    public Classification getAssetOriginClassification(String organization, String organizationPropertyName, String businessCapability, String businessCapabilityPropertyName, Map<String, String> otherOriginValues) {
        String methodName = "getAssetOriginClassification";
        InstanceProperties classificationProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, "organization", organization, "getAssetOriginClassification");
        classificationProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, classificationProperties, "organizationPropertyName", organizationPropertyName, "getAssetOriginClassification");
        classificationProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, classificationProperties, "businessCapability", businessCapability, "getAssetOriginClassification");
        classificationProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, classificationProperties, "businessCapabilityPropertyName", businessCapabilityPropertyName, "getAssetOriginClassification");
        classificationProperties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, classificationProperties, "otherOriginValues", otherOriginValues, "getAssetOriginClassification");
        return this.archiveHelper.getClassification("AssetOrigin", classificationProperties, InstanceStatus.ACTIVE);
    }

    public Classification getConfidentialityClassification(int statusIdentifier, int confidence, String steward, String stewardTypeName, String stewardPropertyName, String source, String notes, int levelIdentifier) {
        String methodName = "getConfidentialityClassification";
        InstanceProperties classificationProperties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.STATUS_IDENTIFIER.name, statusIdentifier, "getConfidentialityClassification");
        classificationProperties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, classificationProperties, OpenMetadataProperty.CONFIDENCE.name, confidence, "getConfidentialityClassification");
        classificationProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, classificationProperties, OpenMetadataProperty.STEWARD.name, steward, "getConfidentialityClassification");
        classificationProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, classificationProperties, OpenMetadataProperty.STEWARD_TYPE_NAME.name, stewardTypeName, "getConfidentialityClassification");
        classificationProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, classificationProperties, OpenMetadataProperty.STEWARD_PROPERTY_NAME.name, stewardPropertyName, "getConfidentialityClassification");
        classificationProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, classificationProperties, OpenMetadataProperty.SOURCE.name, source, "getConfidentialityClassification");
        classificationProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, classificationProperties, OpenMetadataProperty.NOTES.name, notes, "getConfidentialityClassification");
        classificationProperties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, classificationProperties, OpenMetadataProperty.CONFIDENTIALITY_LEVEL_IDENTIFIER.name, levelIdentifier, "getConfidentialityClassification");
        return this.archiveHelper.getClassification(OpenMetadataType.CONFIDENTIALITY_CLASSIFICATION.typeName, classificationProperties, InstanceStatus.ACTIVE);
    }

    public String addSubjectAreaDefinition(String qualifiedName, String subjectAreaName, String displayName, String description, String scope, String usage, int domainIdentifier, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) {
        String methodName = "addSubjectAreaDefinition";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, "addSubjectAreaDefinition");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "subjectAreaName", subjectAreaName, "addSubjectAreaDefinition");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DISPLAY_NAME.name, displayName, "addSubjectAreaDefinition");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addSubjectAreaDefinition");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "scope", scope, "addSubjectAreaDefinition");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.USAGE.name, usage, "addSubjectAreaDefinition");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, "domainIdentifier", domainIdentifier, "addSubjectAreaDefinition");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, "addSubjectAreaDefinition");
        properties = this.archiveHelper.addPropertyMapToInstance(this.archiveRootName, properties, extendedProperties, "addSubjectAreaDefinition");
        EntityDetail newEntity = this.archiveHelper.getEntityDetail("SubjectAreaDefinition", this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(newEntity);
        return newEntity.getGUID();
    }

    public void addSubjectAreaHierarchy(String broaderSubjectAreaGUID, String nestedSubjectAreaGUID) {
        EntityDetail referenceableEntity = this.archiveBuilder.getEntity(broaderSubjectAreaGUID);
        EntityDetail externalReferenceEntity = this.archiveBuilder.getEntity(nestedSubjectAreaGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(referenceableEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(externalReferenceEntity);
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship("SubjectAreaHierarchy", this.idToGUIDMap.getGUID(broaderSubjectAreaGUID + "_to_" + nestedSubjectAreaGUID + "_subject_area_hierarchy_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addSubjectAreaClassification(String referenceableGUID, String subjectAreaQualifiedName) {
        String methodName = "addSubjectAreaClassification";
        EntityDetail referenceableEntity = this.archiveBuilder.getEntity(referenceableGUID);
        EntityProxy referenceableEntityProxy = this.archiveHelper.getEntityProxy(referenceableEntity);
        Classification subjectAreaClassification = this.archiveHelper.getClassification("SubjectArea", this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.NAME.name, subjectAreaQualifiedName, "addSubjectAreaClassification"), InstanceStatus.ACTIVE);
        this.archiveBuilder.addClassification(this.archiveHelper.getClassificationEntityExtension(referenceableEntityProxy, subjectAreaClassification));
    }

    public String addBusinessArea(String qualifiedName, String identifier, String displayName, String description, Map<String, String> additionalProperties) {
        String methodName = "addBusinessArea";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, "addBusinessArea");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.IDENTIFIER.name, identifier, "addBusinessArea");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DISPLAY_NAME.name, displayName, "addBusinessArea");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addBusinessArea");
        properties = this.archiveHelper.addEnumPropertyToInstance(this.archiveRootName, properties, "businessCapabilityType", BusinessCapabilityType.getOpenTypeGUID(), BusinessCapabilityType.getOpenTypeName(), BusinessCapabilityType.BUSINESS_AREA.getOrdinal(), BusinessCapabilityType.BUSINESS_AREA.getName(), BusinessCapabilityType.BUSINESS_AREA.getDescription(), "addBusinessArea");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, "addBusinessArea");
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        classifications.add(this.getAnchorClassification(null, "BusinessCapability", "BusinessCapability", "addBusinessArea"));
        EntityDetail newEntity = this.archiveHelper.getEntityDetail("BusinessCapability", this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(newEntity);
        return newEntity.getGUID();
    }

    public void addOrganizationalCapabilityRelationship(String businessCapabilityQName, String teamQName, String scope) {
        String methodName = "addOrganizationalCapabilityRelationship";
        String end1GUID = this.idToGUIDMap.getGUID(businessCapabilityQName);
        String end2GUID = this.idToGUIDMap.getGUID(teamQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(end1GUID));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(end2GUID));
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, "scope", scope, "addOrganizationalCapabilityRelationship");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship("OrganizationalCapability", this.idToGUIDMap.getGUID(end1GUID + "_to_" + end2GUID + "_organizational_capability_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public String addDesignModel(String typeName, String classificationName, String qualifiedName, String displayName, String technicalName, String description, String versionNumber, String author, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) {
        String methodName = "addDesignModel";
        String elementTypeName = "DesignModel";
        if (typeName != null) {
            elementTypeName = typeName;
        }
        ArrayList<Classification> entityClassifications = new ArrayList<Classification>();
        entityClassifications.add(this.getAnchorClassification(null, elementTypeName, "DesignModel", "addDesignModel"));
        if (classificationName != null) {
            Classification classification = this.archiveHelper.getClassification(classificationName, null, InstanceStatus.ACTIVE);
            entityClassifications.add(classification);
        }
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, "addDesignModel");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.NAME.name, displayName, "addDesignModel");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "technicalName", technicalName, "addDesignModel");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addDesignModel");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "versionNumber", versionNumber, "addDesignModel");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "author", author, "addDesignModel");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, "addDesignModel");
        properties = this.archiveHelper.addPropertyMapToInstance(this.archiveRootName, properties, extendedProperties, "addDesignModel");
        EntityDetail newEntity = this.archiveHelper.getEntityDetail(elementTypeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, entityClassifications);
        this.archiveBuilder.addEntity(newEntity);
        return newEntity.getGUID();
    }

    public String addDesignModelElement(String designModelGUID, String designModelTypeName, String typeName, String qualifiedName, String displayName, String technicalName, String description, String versionNumber, String author, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, List<Classification> classifications) {
        String methodName = "addDesignModelElement";
        String elementTypeName = "DesignModelElement";
        if (typeName != null) {
            elementTypeName = typeName;
        }
        List<Classification> entityClassifications = classifications;
        if (designModelGUID != null) {
            if (entityClassifications == null) {
                entityClassifications = new ArrayList<Classification>();
            }
            entityClassifications.add(this.getAnchorClassification(designModelGUID, designModelTypeName, "DesignModelElement", "addDesignModelElement"));
        }
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, "addDesignModelElement");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DISPLAY_NAME.name, displayName, "addDesignModelElement");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "technicalName", technicalName, "addDesignModelElement");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addDesignModelElement");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "versionNumber", versionNumber, "addDesignModelElement");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "author", author, "addDesignModelElement");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, "addDesignModelElement");
        properties = this.archiveHelper.addPropertyMapToInstance(this.archiveRootName, properties, extendedProperties, "addDesignModelElement");
        EntityDetail newEntity = this.archiveHelper.getEntityDetail(elementTypeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, entityClassifications);
        this.archiveBuilder.addEntity(newEntity);
        if (designModelGUID != null) {
            EntityDetail designModelEntity = this.archiveBuilder.getEntity(designModelGUID);
            EntityDetail designModelElementEntity = this.archiveBuilder.getEntity(newEntity.getGUID());
            EntityProxy end1 = this.archiveHelper.getEntityProxy(designModelEntity);
            EntityProxy end2 = this.archiveHelper.getEntityProxy(designModelElementEntity);
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship("DesignModelGroupMembership", this.idToGUIDMap.getGUID(designModelGUID + "_to_" + newEntity.getGUID() + "_design_model_group_membership_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        }
        return newEntity.getGUID();
    }

    public void addDesignModelGroupMembership(String groupGUID, String memberGUID) {
        EntityDetail designModelGroupEntity = this.archiveBuilder.getEntity(groupGUID);
        EntityDetail designModelElementEntity = this.archiveBuilder.getEntity(memberGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(designModelGroupEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(designModelElementEntity);
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship("DesignModelGroupMembership", this.idToGUIDMap.getGUID(groupGUID + "_to_" + memberGUID + "_design_model_group_membership_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addConceptBeadRelationshipEnd(String conceptBeadLinkGUID, String conceptBeadGUID, String attributeName, int conceptModelDecoration, int position, int minCardinality, int maxCardinality, boolean uniqueValues, boolean orderedValues, boolean navigable) {
        String methodName = "addConceptBeadRelationshipEnd";
        EntityDetail entityOne = this.archiveBuilder.getEntity(conceptBeadLinkGUID);
        EntityDetail entityTwo = this.archiveBuilder.getEntity(conceptBeadGUID);
        EnumElementDef conceptModelDecorationEnum = this.archiveHelper.getEnumElement(ConceptModelDecoration.getOpenTypeName(), conceptModelDecoration);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(entityOne);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(entityTwo);
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, "attributeName", attributeName, "addConceptBeadRelationshipEnd");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.POSITION.name, position, "addConceptBeadRelationshipEnd");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, "minCardinality", minCardinality, "addConceptBeadRelationshipEnd");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, "maxCardinality", maxCardinality, "addConceptBeadRelationshipEnd");
        properties = this.archiveHelper.addEnumPropertyToInstance(this.archiveRootName, properties, "decoration", ConceptModelDecoration.getOpenTypeGUID(), ConceptModelDecoration.getOpenTypeName(), conceptModelDecorationEnum.getOrdinal(), conceptModelDecorationEnum.getValue(), conceptModelDecorationEnum.getDescription(), "addConceptBeadRelationshipEnd");
        properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, properties, "uniqueValues", uniqueValues, "addConceptBeadRelationshipEnd");
        properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, properties, "orderedValues", orderedValues, "addConceptBeadRelationshipEnd");
        properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, properties, "navigable", navigable, "addConceptBeadRelationshipEnd");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship("DesignModelGroupMembership", this.idToGUIDMap.getGUID(conceptBeadLinkGUID + "_to_" + conceptBeadGUID + "_concept_bead_relationship_end_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addConceptBeadAttributeLink(String conceptBeadGUID, String conceptBeadAttributeGUID, int position, int minCardinality, int maxCardinality, boolean uniqueValues, boolean orderedValues) {
        String methodName = "addConceptBeadAttributeLink";
        EntityDetail entityOne = this.archiveBuilder.getEntity(conceptBeadGUID);
        EntityDetail entityTwo = this.archiveBuilder.getEntity(conceptBeadAttributeGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(entityOne);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(entityTwo);
        InstanceProperties properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.POSITION.name, position, "addConceptBeadAttributeLink");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, "minCardinality", minCardinality, "addConceptBeadAttributeLink");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, "maxCardinality", maxCardinality, "addConceptBeadAttributeLink");
        properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, properties, "uniqueValues", uniqueValues, "addConceptBeadAttributeLink");
        properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, properties, "orderedValues", orderedValues, "addConceptBeadAttributeLink");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship("DesignModelGroupMembership", this.idToGUIDMap.getGUID(conceptBeadGUID + "_to_" + conceptBeadAttributeGUID + "_concept_bead_attribute_link_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addPropertyFacet(String referenceableGUID, String referenceableTypeName, String referenceableDomainName, String referenceableQualifiedName, String source, String schemaVersion, String description, Map<String, String> facetProperties) {
        String methodName = "addPropertyFacet";
        String qualifiedName = referenceableQualifiedName + "_propertyFacetFrom_" + source + "@" + schemaVersion;
        ArrayList<Classification> entityClassifications = new ArrayList<Classification>();
        String facetGUID = this.idToGUIDMap.getGUID(qualifiedName);
        entityClassifications.add(this.getAnchorClassification(referenceableGUID, referenceableTypeName, referenceableDomainName, "addPropertyFacet"));
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, "addPropertyFacet");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.SCHEMA_VERSION.name, schemaVersion, "addPropertyFacet");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addPropertyFacet");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.PROPERTIES.name, facetProperties, "addPropertyFacet");
        EntityDetail facetEntity = this.archiveHelper.getEntityDetail(OpenMetadataType.PROPERTY_FACET.typeName, facetGUID, properties, InstanceStatus.ACTIVE, entityClassifications);
        this.archiveBuilder.addEntity(facetEntity);
        EntityDetail referenceableEntity = this.archiveBuilder.getEntity(referenceableGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(referenceableEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(facetEntity);
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.SOURCE.name, source, "addPropertyFacet");
        Relationship relationship = this.archiveHelper.getRelationship(OpenMetadataType.REFERENCEABLE_FACET.typeName, this.idToGUIDMap.getGUID(referenceableGUID + "_to_" + facetGUID + "_referenceable_facet_relationship"), properties, InstanceStatus.ACTIVE, end1, end2);
        this.archiveBuilder.addRelationship(relationship);
    }

    public String addAsset(String typeName, String qualifiedName, String name, String description, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, List<Classification> classifications) {
        return this.addAsset(typeName, qualifiedName, name, null, description, additionalProperties, extendedProperties, classifications);
    }

    public String addAnchoredAsset(String typeName, String anchorGUID, String anchorTypeName, String anchorDomainName, String qualifiedName, String name, String versionIdentifier, String description, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, List<Classification> classifications) {
        List<Classification> entityClassifications;
        String methodName = "addAsset";
        String assetTypeName = OpenMetadataType.ASSET.typeName;
        if (typeName != null) {
            assetTypeName = typeName;
        }
        if ((entityClassifications = classifications) == null) {
            entityClassifications = new ArrayList<Classification>();
        }
        String guid = this.idToGUIDMap.getGUID(qualifiedName);
        entityClassifications.add(this.getAnchorClassification(anchorGUID, anchorTypeName, anchorDomainName, "addAsset"));
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, "addAsset");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.NAME.name, name, "addAsset");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.VERSION_IDENTIFIER.name, versionIdentifier, "addAsset");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addAsset");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, "addAsset");
        properties = this.archiveHelper.addPropertyMapToInstance(this.archiveRootName, properties, extendedProperties, "addAsset");
        EntityDetail assetEntity = this.archiveHelper.getEntityDetail(assetTypeName, guid, properties, InstanceStatus.ACTIVE, entityClassifications);
        this.archiveBuilder.addEntity(assetEntity);
        return assetEntity.getGUID();
    }

    public String addAsset(String typeName, String qualifiedName, String name, String versionIdentifier, String description, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, List<Classification> classifications) {
        List<Classification> entityClassifications;
        String methodName = "addAsset";
        String assetTypeName = OpenMetadataType.ASSET.typeName;
        if (typeName != null) {
            assetTypeName = typeName;
        }
        if ((entityClassifications = classifications) == null) {
            entityClassifications = new ArrayList<Classification>();
        }
        String guid = this.idToGUIDMap.getGUID(qualifiedName);
        entityClassifications.add(this.getAnchorClassification(guid, assetTypeName, OpenMetadataType.ASSET.typeName, "addAsset"));
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, "addAsset");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.NAME.name, name, "addAsset");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.VERSION_IDENTIFIER.name, versionIdentifier, "addAsset");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addAsset");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, "addAsset");
        properties = this.archiveHelper.addPropertyMapToInstance(this.archiveRootName, properties, extendedProperties, "addAsset");
        EntityDetail assetEntity = this.archiveHelper.getEntityDetail(assetTypeName, guid, properties, InstanceStatus.ACTIVE, entityClassifications);
        this.archiveBuilder.addEntity(assetEntity);
        return assetEntity.getGUID();
    }

    public String addAsset(String typeName, String qualifiedName, String name, String description, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) {
        return this.addAsset(typeName, qualifiedName, name, description, additionalProperties, extendedProperties, null);
    }

    public String addAsset(String typeName, String qualifiedName, String name, String description, List<String> governanceZones, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) {
        return this.addAsset(typeName, qualifiedName, name, null, description, governanceZones, additionalProperties, extendedProperties);
    }

    public String addAsset(String typeName, String qualifiedName, String name, String versionIdentifier, String description, List<String> governanceZones, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) {
        String methodName = "addAsset (with governance zones)";
        if (governanceZones == null) {
            return this.addAsset(typeName, qualifiedName, name, versionIdentifier, description, additionalProperties, extendedProperties, null);
        }
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        InstanceProperties properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.ZONE_MEMBERSHIP.name, governanceZones, "addAsset (with governance zones)");
        Classification classification = this.archiveHelper.getClassification("AssetZoneMembership", properties, InstanceStatus.ACTIVE);
        classifications.add(classification);
        return this.addAsset(typeName, qualifiedName, name, description, additionalProperties, extendedProperties, classifications);
    }

    public String addProcess(String typeName, String qualifiedName, String name, String description, String formula, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, List<Classification> classifications) {
        return this.addProcess(typeName, qualifiedName, name, null, description, formula, additionalProperties, extendedProperties, classifications);
    }

    public String addProcess(String typeName, String qualifiedName, String name, String versionIdentifier, String description, String formula, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, List<Classification> classifications) {
        List<Classification> entityClassifications;
        String methodName = "addProcess";
        String processTypeName = OpenMetadataType.PROCESS.typeName;
        if (typeName != null) {
            processTypeName = typeName;
        }
        if ((entityClassifications = classifications) == null) {
            entityClassifications = new ArrayList<Classification>();
        }
        String guid = this.idToGUIDMap.getGUID(qualifiedName);
        entityClassifications.add(this.getAnchorClassification(guid, processTypeName, OpenMetadataType.ASSET.typeName, "addProcess"));
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, "addProcess");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.NAME.name, name, "addProcess");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.VERSION_IDENTIFIER.name, versionIdentifier, "addProcess");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addProcess");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.FORMULA.name, formula, "addProcess");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, "addProcess");
        properties = this.archiveHelper.addPropertyMapToInstance(this.archiveRootName, properties, extendedProperties, "addProcess");
        EntityDetail assetEntity = this.archiveHelper.getEntityDetail(processTypeName, guid, properties, InstanceStatus.ACTIVE, entityClassifications);
        this.archiveBuilder.addEntity(assetEntity);
        return assetEntity.getGUID();
    }

    public String addSoftwareCapability(String typeName, String qualifiedName, String name, String description, String deployedImplementationType, String capabilityVersion, String patchLevel, String source, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, Classification classification, String anchorGUID, String anchorTypeName, String anchorDomainName) {
        ArrayList<Classification> classifications = null;
        if (classification != null) {
            classifications = new ArrayList<Classification>();
            classifications.add(classification);
        }
        return this.addSoftwareCapability(typeName, qualifiedName, name, description, deployedImplementationType, capabilityVersion, patchLevel, source, additionalProperties, extendedProperties, classifications, anchorGUID, anchorTypeName, anchorDomainName);
    }

    public String addSoftwareCapability(String typeName, String qualifiedName, String name, String description, String deployedImplementationType, String capabilityVersion, String patchLevel, String source, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, List<Classification> suppliedClassifications, String anchorGUID, String anchorTypeName, String anchorDomainName) {
        String methodName = "addSoftwareCapability";
        String entityTypeName = OpenMetadataType.SOFTWARE_CAPABILITY.typeName;
        if (typeName != null) {
            entityTypeName = typeName;
        }
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, "addSoftwareCapability");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.NAME.name, name, "addSoftwareCapability");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addSoftwareCapability");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, deployedImplementationType, "addSoftwareCapability");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.CAPABILITY_VERSION.name, capabilityVersion, "addSoftwareCapability");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.PATCH_LEVEL.name, patchLevel, "addSoftwareCapability");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.SOURCE.name, source, "addSoftwareCapability");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, "addSoftwareCapability");
        properties = this.archiveHelper.addPropertyMapToInstance(this.archiveRootName, properties, extendedProperties, "addSoftwareCapability");
        String guid = this.idToGUIDMap.getGUID(qualifiedName);
        List<Classification> classifications = suppliedClassifications;
        if (classifications == null) {
            classifications = new ArrayList<Classification>();
        }
        if (anchorGUID == null) {
            classifications.add(this.getAnchorClassification(guid, entityTypeName, OpenMetadataType.SOFTWARE_CAPABILITY.typeName, "addSoftwareCapability"));
        } else {
            classifications.add(this.getAnchorClassification(anchorGUID, anchorTypeName, anchorDomainName, "addSoftwareCapability"));
        }
        EntityDetail entity = this.archiveHelper.getEntityDetail(entityTypeName, guid, properties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(entity);
        return entity.getGUID();
    }

    public void addConnectionForAsset(String assetGUID, String assetSummary, String connectionGUID) {
        String methodName = "addConnectionForAsset";
        EntityDetail assetEntity = this.archiveBuilder.getEntity(assetGUID);
        EntityDetail connectionEntity = this.archiveBuilder.getEntity(connectionGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(connectionEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(assetEntity);
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.ASSET_SUMMARY.name, assetSummary, "addConnectionForAsset");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.CONNECTION_TO_ASSET_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(assetGUID + "_to_" + connectionGUID + "_asset_connection_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addDataContentForDataSet(String dataContentGUID, String dataSetGUID) {
        this.addDataContentForDataSet(dataContentGUID, dataSetGUID, null, null);
    }

    public void addDataContentForDataSet(String dataContentGUID, String dataSetGUID, String queryId, String query) {
        String methodName = "addDataContentForDataSet";
        EntityDetail dataContentEntity = this.archiveBuilder.getEntity(dataContentGUID);
        EntityDetail dataSetEntity = this.archiveBuilder.getEntity(dataSetGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(dataContentEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(dataSetEntity);
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, "queryId", queryId, "addDataContentForDataSet");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "query", query, "addDataContentForDataSet");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.DATA_CONTENT_FOR_DATA_SET_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(dataContentGUID + "_to_" + dataSetGUID + "_data_content_for_data_set_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addLineageRelationship(String sourceGUID, String destinationGUID, String relationshipType, String label) {
        String methodName = "addLineageRelationship";
        EntityDetail end1Entity = this.archiveBuilder.getEntity(sourceGUID);
        EntityDetail end2Entity = this.archiveBuilder.getEntity(destinationGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(end1Entity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(end2Entity);
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.LABEL.name, label, "addLineageRelationship");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(relationshipType, this.idToGUIDMap.getGUID(sourceGUID + "_to_" + destinationGUID + "_" + relationshipType + "_" + label + "_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public Classification getDataAssetEncodingClassification(String encoding, String language, String description, Map<String, String> properties) {
        String methodName = "getDataAssetEncodingClassification";
        InstanceProperties instanceProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.ENCODING.name, encoding, "getDataAssetEncodingClassification");
        instanceProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, instanceProperties, OpenMetadataProperty.ENCODING_LANGUAGE.name, language, "getDataAssetEncodingClassification");
        instanceProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, instanceProperties, OpenMetadataProperty.ENCODING_DESCRIPTION.name, description, "getDataAssetEncodingClassification");
        instanceProperties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, instanceProperties, OpenMetadataProperty.ENCODING_PROPERTIES.name, properties, "getDataAssetEncodingClassification");
        return this.archiveHelper.getClassification(OpenMetadataType.DATA_ASSET_ENCODING_CLASSIFICATION.typeName, instanceProperties, InstanceStatus.ACTIVE);
    }

    public String addTopLevelSchemaType(String assetGUID, String assetTypeName, String typeName, String qualifiedName, String displayName, String description, Map<String, String> additionalProperties) {
        String methodName = "addTopLevelSchemaType";
        String schemaTypeTypeName = "SchemaType";
        if (typeName != null) {
            schemaTypeTypeName = typeName;
        }
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, "addTopLevelSchemaType");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DISPLAY_NAME.name, displayName, "addTopLevelSchemaType");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addTopLevelSchemaType");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, "addTopLevelSchemaType");
        ArrayList<Classification> classifications = null;
        if (assetGUID != null) {
            classifications = new ArrayList<Classification>();
            classifications.add(this.getAnchorClassification(assetGUID, assetTypeName, OpenMetadataType.ASSET.typeName, "addTopLevelSchemaType"));
        }
        EntityDetail schemaTypeEntity = this.archiveHelper.getEntityDetail(schemaTypeTypeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(schemaTypeEntity);
        if (assetGUID != null) {
            EntityDetail assetEntity = this.archiveBuilder.getEntity(assetGUID);
            EntityProxy end1 = this.archiveHelper.getEntityProxy(assetEntity);
            EntityProxy end2 = this.archiveHelper.getEntityProxy(schemaTypeEntity);
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship("AssetSchemaType", this.idToGUIDMap.getGUID(qualifiedName + "_asset_schema_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        }
        return schemaTypeEntity.getGUID();
    }

    public String addSchemaType(String assetGUID, String assetTypeName, String typeName, String qualifiedName, String displayName, String description, Map<String, String> additionalProperties) {
        String methodName = "addSchemaType";
        String schemaTypeTypeName = "SchemaType";
        if (typeName != null) {
            schemaTypeTypeName = typeName;
        }
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, "addSchemaType");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DISPLAY_NAME.name, displayName, "addSchemaType");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addSchemaType");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, "addSchemaType");
        ArrayList<Classification> classifications = null;
        if (assetGUID != null) {
            classifications = new ArrayList<Classification>();
            classifications.add(this.getAnchorClassification(assetGUID, assetTypeName, OpenMetadataType.ASSET.typeName, "addSchemaType"));
        }
        EntityDetail schemaTypeEntity = this.archiveHelper.getEntityDetail(schemaTypeTypeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(schemaTypeEntity);
        return schemaTypeEntity.getGUID();
    }

    public String addAPIOperation(String apiSchemaTypeGUID, String qualifiedName, String displayName, String description, String path, String command, Map<String, String> additionalProperties) {
        String methodName = "addAPIOperation";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, "addAPIOperation");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DISPLAY_NAME.name, displayName, "addAPIOperation");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addAPIOperation");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "path", path, "addAPIOperation");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "command", command, "addAPIOperation");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, "addAPIOperation");
        EntityDetail schemaTypeEntity = this.archiveHelper.getEntityDetail("APIOperation", this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(schemaTypeEntity);
        if (apiSchemaTypeGUID != null) {
            EntityDetail parentEntity = this.archiveBuilder.getEntity(apiSchemaTypeGUID);
            EntityProxy end1 = this.archiveHelper.getEntityProxy(parentEntity);
            EntityProxy end2 = this.archiveHelper.getEntityProxy(schemaTypeEntity);
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship("APIOperations", this.idToGUIDMap.getGUID(qualifiedName + "_parent_api_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        }
        return schemaTypeEntity.getGUID();
    }

    public String addAPIParameterList(String apiOperationGUID, String relationshipTypeName, String qualifiedName, String displayName, String description, boolean required, Map<String, String> additionalProperties) {
        String methodName = "addAPIParameterList";
        String typeName = "APIRequest";
        if (relationshipTypeName != null) {
            typeName = relationshipTypeName;
        }
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, "addAPIParameterList");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DISPLAY_NAME.name, displayName, "addAPIParameterList");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addAPIParameterList");
        properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, properties, "required", required, "addAPIParameterList");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, "addAPIParameterList");
        EntityDetail parameterListEntity = this.archiveHelper.getEntityDetail("APIParameterList", this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(parameterListEntity);
        if (apiOperationGUID != null) {
            EntityDetail operationEntity = this.archiveBuilder.getEntity(apiOperationGUID);
            EntityProxy end1 = this.archiveHelper.getEntityProxy(operationEntity);
            EntityProxy end2 = this.archiveHelper.getEntityProxy(parameterListEntity);
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(typeName, this.idToGUIDMap.getGUID(qualifiedName + "_api_parameter_to_operation_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        }
        return parameterListEntity.getGUID();
    }

    public String addAPIParameter(String typeName, String schemaTypeName, String qualifiedName, String displayName, String description, String dataType, int length, int position, String parameterType, Map<String, String> additionalProperties) {
        String methodName = "addAPIParameter";
        String schemaAttributeTypeName = "APIParameter";
        if (typeName != null) {
            schemaAttributeTypeName = typeName;
        }
        String schemaTypeTypeName = "PrimitiveSchemaType";
        if (schemaTypeName != null) {
            schemaTypeTypeName = schemaTypeName;
        }
        InstanceProperties entityProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, "addAPIParameter");
        entityProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, entityProperties, OpenMetadataProperty.DISPLAY_NAME.name, displayName, "addAPIParameter");
        entityProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, entityProperties, OpenMetadataProperty.DESCRIPTION.name, description, "addAPIParameter");
        entityProperties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, entityProperties, OpenMetadataProperty.POSITION.name, position, "addAPIParameter");
        entityProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, entityProperties, "parameterType", parameterType, "addAPIParameter");
        entityProperties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, entityProperties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, "addAPIParameter");
        InstanceProperties classificationProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, "schemaTypeName", schemaTypeTypeName, "addAPIParameter");
        classificationProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, classificationProperties, "dataType", dataType, "addAPIParameter");
        classificationProperties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, classificationProperties, "length", length, "addAPIParameter");
        Classification classification = this.archiveHelper.getClassification("TypeEmbeddedAttribute", classificationProperties, InstanceStatus.ACTIVE);
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        classifications.add(classification);
        EntityDetail schemaAttributeEntity = this.archiveHelper.getEntityDetail(schemaAttributeTypeName, this.idToGUIDMap.getGUID(qualifiedName), entityProperties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(schemaAttributeEntity);
        return schemaAttributeEntity.getGUID();
    }

    public void addSchemaTypeOption(String schemaTypeChoiceGUID, String schemaTypeOptionGUID) {
        EntityDetail schemaTypeChoiceEntity = this.archiveBuilder.getEntity(schemaTypeChoiceGUID);
        EntityDetail schemaTypeOptionEntity = this.archiveBuilder.getEntity(schemaTypeOptionGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(schemaTypeChoiceEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(schemaTypeOptionEntity);
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship("SchemaTypeOption", this.idToGUIDMap.getGUID(schemaTypeChoiceGUID + "_to_" + schemaTypeOptionGUID + "_schema_type_option_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addAttributeForSchemaType(String schemaTypeGUID, String schemaAttributeGUID) {
        EntityDetail schemaTypeChoiceEntity = this.archiveBuilder.getEntity(schemaTypeGUID);
        EntityDetail schemaTypeOptionEntity = this.archiveBuilder.getEntity(schemaAttributeGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(schemaTypeChoiceEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(schemaTypeOptionEntity);
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship("AttributeForSchema", this.idToGUIDMap.getGUID(schemaTypeGUID + "_to_" + schemaAttributeGUID + "_attribute_for_schema_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addNestedSchemaAttribute(String parentSchemaAttributeGUID, String childSchemaAttributeGUID) {
        EntityDetail parentSchemaAttributeEntity = this.archiveBuilder.getEntity(parentSchemaAttributeGUID);
        EntityDetail childSchemaAttributeEntity = this.archiveBuilder.getEntity(childSchemaAttributeGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(parentSchemaAttributeEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(childSchemaAttributeEntity);
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship("NestedSchemaAttribute", this.idToGUIDMap.getGUID(parentSchemaAttributeGUID + "_to_" + childSchemaAttributeGUID + "_nested_schema_attribute_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public String addSchemaAttribute(String assetGUID, String assetTypeName, String typeName, String schemaTypeName, String qualifiedName, String displayName, String description, String dataType, int length, int position, String encodingStandard, Map<String, String> additionalProperties) {
        String methodName = "addSchemaAttribute";
        String schemaAttributeTypeName = OpenMetadataType.SCHEMA_ATTRIBUTE.typeName;
        if (typeName != null) {
            schemaAttributeTypeName = typeName;
        }
        String schemaTypeTypeName = "PrimitiveSchemaType";
        if (schemaTypeName != null) {
            schemaTypeTypeName = schemaTypeName;
        }
        InstanceProperties entityProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, "addSchemaAttribute");
        entityProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, entityProperties, OpenMetadataProperty.DISPLAY_NAME.name, displayName, "addSchemaAttribute");
        entityProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, entityProperties, OpenMetadataProperty.DESCRIPTION.name, description, "addSchemaAttribute");
        entityProperties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, entityProperties, "length", length, "addSchemaAttribute");
        entityProperties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, entityProperties, OpenMetadataProperty.POSITION.name, position, "addSchemaAttribute");
        entityProperties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, entityProperties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, "addSchemaAttribute");
        InstanceProperties classificationProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, "schemaTypeName", schemaTypeTypeName, "addSchemaAttribute");
        classificationProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, classificationProperties, "dataType", dataType, "addSchemaAttribute");
        classificationProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, classificationProperties, "encodingStandard", encodingStandard, "addSchemaAttribute");
        Classification classification = this.archiveHelper.getClassification("TypeEmbeddedAttribute", classificationProperties, InstanceStatus.ACTIVE);
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        classifications.add(classification);
        if (assetGUID != null) {
            classifications.add(this.getAnchorClassification(assetGUID, assetTypeName, OpenMetadataType.ASSET.typeName, "addSchemaAttribute"));
        }
        EntityDetail schemaAttributeEntity = this.archiveHelper.getEntityDetail(schemaAttributeTypeName, this.idToGUIDMap.getGUID(qualifiedName), entityProperties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(schemaAttributeEntity);
        return schemaAttributeEntity.getGUID();
    }

    public String addConnection(String qualifiedName, String displayName, String description, String userId, String clearPassword, String encryptedPassword, Map<String, String> securedProperties, Map<String, Object> configurationProperties, Map<String, String> additionalProperties, String connectorTypeGUID, String endpointGUID, String anchorGUID, String anchorTypeName, String anchorDomainName) {
        return this.addConnection(OpenMetadataType.CONNECTION.typeName, qualifiedName, displayName, description, userId, clearPassword, encryptedPassword, securedProperties, configurationProperties, additionalProperties, connectorTypeGUID, endpointGUID, anchorGUID, anchorTypeName, anchorDomainName);
    }

    public String addConnection(String typeName, String qualifiedName, String displayName, String description, String userId, String clearPassword, String encryptedPassword, Map<String, String> securedProperties, Map<String, Object> configurationProperties, Map<String, String> additionalProperties, String connectorTypeGUID, String endpointGUID, String anchorGUID, String anchorTypeName, String anchorDomainName) {
        EntityProxy end2;
        EntityProxy end1;
        String methodName = "addConnection";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, "addConnection");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DISPLAY_NAME.name, displayName, "addConnection");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addConnection");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.USER_ID.name, userId, "addConnection");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.CLEAR_PASSWORD.name, clearPassword, "addConnection");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ENCRYPTED_PASSWORD.name, encryptedPassword, "addConnection");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.SECURED_PROPERTIES.name, securedProperties, "addConnection");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, "addConnection");
        properties = this.archiveHelper.addMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.CONFIGURATION_PROPERTIES.name, configurationProperties, "addConnection");
        ArrayList<Classification> entityClassifications = null;
        if (anchorGUID != null) {
            entityClassifications = new ArrayList<Classification>();
            entityClassifications.add(this.getAnchorClassification(anchorGUID, anchorTypeName, anchorDomainName, "addConnection"));
        }
        EntityDetail connectionEntity = this.archiveHelper.getEntityDetail(typeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, entityClassifications);
        this.archiveBuilder.addEntity(connectionEntity);
        if (connectorTypeGUID != null) {
            EntityDetail connectorTypeEntity = this.archiveBuilder.getEntity(connectorTypeGUID);
            end1 = this.archiveHelper.getEntityProxy(connectionEntity);
            end2 = this.archiveHelper.getEntityProxy(connectorTypeEntity);
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.CONNECTION_CONNECTOR_TYPE_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(qualifiedName + "_connectorType_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        }
        if (endpointGUID != null) {
            EntityDetail endpointEntity = this.archiveBuilder.getEntity(endpointGUID);
            end1 = this.archiveHelper.getEntityProxy(endpointEntity);
            end2 = this.archiveHelper.getEntityProxy(connectionEntity);
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.CONNECTION_ENDPOINT_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(qualifiedName + "_endpoint_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        }
        return connectionEntity.getGUID();
    }

    public void addEmbeddedConnection(String parentConnectionGUID, int position, String displayName, Map<String, String> arguments, String childConnectionGUID) {
        String methodName = "addEmbeddedConnection";
        InstanceProperties properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.POSITION.name, position, "addEmbeddedConnection");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DISPLAY_NAME.name, displayName, "addEmbeddedConnection");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ARGUMENTS.name, arguments, "addEmbeddedConnection");
        EntityDetail parentEntity = this.archiveBuilder.getEntity(parentConnectionGUID);
        EntityDetail childEntity = this.archiveBuilder.getEntity(childConnectionGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(parentEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(childEntity);
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.EMBEDDED_CONNECTION_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(parentConnectionGUID + "_to_" + childConnectionGUID + "_embedded_connection_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public String addConnectorType(String connectorCategoryGUID, ConnectorProvider connectorProvider) {
        return this.addConnectorType(connectorCategoryGUID, connectorProvider.getConnectorType());
    }

    public String addConnectorType(String connectorCategoryGUID, IntegrationConnectorProvider connectorProvider) {
        String connectorTypeGUID = this.addConnectorType(connectorCategoryGUID, connectorProvider.getConnectorType());
        if (connectorProvider.getCatalogTargets() != null) {
            for (CatalogTargetType catalogTarget : connectorProvider.getCatalogTargets()) {
                if (catalogTarget == null) continue;
                DeployedImplementationType deployedImplementationType = DeployedImplementationType.getDefinitionFromDeployedImplementationType((String)catalogTarget.getDeployedImplementationType());
                ConnectorType connectorType = connectorProvider.getConnectorType();
                if (deployedImplementationType == null || connectorType == null) continue;
                this.addResourceListRelationship(deployedImplementationType.getQualifiedName(), connectorType.getQualifiedName(), ResourceUse.CONFIGURE_CONNECTOR.getResourceUse(), ResourceUse.CONFIGURE_CONNECTOR.getDescription());
            }
        }
        return connectorTypeGUID;
    }

    public String addConnectorType(String connectorCategoryGUID, ConnectorType connectorType) {
        this.idToGUIDMap.setGUID(connectorType.getQualifiedName(), connectorType.getGUID());
        try {
            return this.addConnectorType(connectorCategoryGUID, connectorType.getGUID(), connectorType.getQualifiedName(), connectorType.getDisplayName(), connectorType.getDescription(), connectorType.getSupportedDeployedImplementationType(), connectorType.getSupportedAssetTypeName(), connectorType.getExpectedDataFormat(), connectorType.getConnectorProviderClassName(), connectorType.getConnectorFrameworkName(), connectorType.getConnectorInterfaceLanguage(), connectorType.getConnectorInterfaces(), connectorType.getTargetTechnologySource(), connectorType.getTargetTechnologyName(), connectorType.getTargetTechnologyInterfaces(), connectorType.getTargetTechnologyVersions(), connectorType.getRecognizedSecuredProperties(), connectorType.getRecognizedConfigurationProperties(), connectorType.getRecognizedAdditionalProperties(), connectorType.getAdditionalProperties());
        }
        catch (Exception alreadyDefined) {
            return connectorType.getGUID();
        }
    }

    public String addConnectorType(String connectorCategoryGUID, String connectorTypeGUID, String qualifiedName, String displayName, String description, String deployedImplementationType, String supportedAssetTypeName, String expectedDataFormat, String connectorProviderClassName, String connectorFrameworkName, String connectorInterfaceLanguage, List<String> connectorInterfaces, String targetTechnologySource, String targetTechnologyName, List<String> targetTechnologyInterfaces, List<String> targetTechnologyVersions, List<String> recognizedSecuredProperties, List<String> recognizedConfigurationProperties, List<String> recognizedAdditionalProperties, Map<String, String> additionalProperties) {
        this.idToGUIDMap.setGUID(qualifiedName, connectorTypeGUID);
        try {
            return this.addConnectorType(connectorCategoryGUID, qualifiedName, displayName, description, deployedImplementationType, supportedAssetTypeName, expectedDataFormat, connectorProviderClassName, connectorFrameworkName, connectorInterfaceLanguage, connectorInterfaces, targetTechnologySource, targetTechnologyName, targetTechnologyInterfaces, targetTechnologyVersions, recognizedSecuredProperties, recognizedConfigurationProperties, recognizedAdditionalProperties, additionalProperties);
        }
        catch (Exception alreadyDefined) {
            return connectorTypeGUID;
        }
    }

    protected String addConnectorType(String connectorCategoryGUID, String qualifiedName, String displayName, String description, String deployedImplementationType, String supportedAssetTypeName, String expectedDataFormat, String connectorProviderClassName, String connectorFrameworkName, String connectorInterfaceLanguage, List<String> connectorInterfaces, String targetTechnologySource, String targetTechnologyName, List<String> targetTechnologyInterfaces, List<String> targetTechnologyVersions, List<String> recognizedSecuredProperties, List<String> recognizedConfigurationProperties, List<String> recognizedAdditionalProperties, Map<String, String> additionalProperties) {
        String methodName = "addConnectorType";
        EntityDetail connectorTypeEntity = this.archiveBuilder.queryEntity(this.getGUID(qualifiedName));
        if (connectorTypeEntity == null) {
            DeployedImplementationType definition;
            InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, "addConnectorType");
            properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DISPLAY_NAME.name, displayName, "addConnectorType");
            properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addConnectorType");
            properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.SUPPORTED_DEPLOYED_IMPLEMENTATION_TYPE.name, deployedImplementationType, "addConnectorType");
            properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.SUPPORTED_ASSET_TYPE_NAME.name, supportedAssetTypeName, "addConnectorType");
            properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.EXPECTED_DATA_FORMAT.name, expectedDataFormat, "addConnectorType");
            properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.CONNECTOR_PROVIDER_CLASS_NAME.name, connectorProviderClassName, "addConnectorType");
            properties = connectorFrameworkName != null ? this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.CONNECTOR_FRAMEWORK_NAME.name, connectorFrameworkName, "addConnectorType") : this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.CONNECTOR_FRAMEWORK_NAME.name, "Open Connector Framework (OCF)", "addConnectorType");
            properties = connectorInterfaceLanguage != null ? this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.CONNECTOR_INTERFACE_LANGUAGE.name, connectorInterfaceLanguage, "addConnectorType") : this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.CONNECTOR_INTERFACE_LANGUAGE.name, "Java", "addConnectorType");
            properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.CONNECTOR_INTERFACES.name, connectorInterfaces, "addConnectorType");
            properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.TARGET_TECHNOLOGY_SOURCE.name, targetTechnologySource, "addConnectorType");
            properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.TARGET_TECHNOLOGY_NAME.name, targetTechnologyName, "addConnectorType");
            properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.TARGET_TECHNOLOGY_INTERFACES.name, targetTechnologyInterfaces, "addConnectorType");
            properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.TARGET_TECHNOLOGY_VERSIONS.name, targetTechnologyVersions, "addConnectorType");
            properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.RECOGNIZED_SECURED_PROPERTIES.name, recognizedSecuredProperties, "addConnectorType");
            properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.RECOGNIZED_ADDITIONAL_PROPERTIES.name, recognizedAdditionalProperties, "addConnectorType");
            properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.RECOGNIZED_CONFIGURATION_PROPERTIES.name, recognizedConfigurationProperties, "addConnectorType");
            properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, "addConnectorType");
            String guid = this.idToGUIDMap.getGUID(qualifiedName);
            ArrayList<Classification> classifications = new ArrayList<Classification>();
            classifications.add(this.getAnchorClassification(guid, OpenMetadataType.CONNECTOR_TYPE.typeName, OpenMetadataType.CONNECTOR_TYPE.typeName, "addConnectorType"));
            connectorTypeEntity = this.archiveHelper.getEntityDetail(OpenMetadataType.CONNECTOR_TYPE.typeName, guid, properties, InstanceStatus.ACTIVE, classifications);
            this.archiveBuilder.addEntity(connectorTypeEntity);
            if (connectorCategoryGUID != null) {
                EntityDetail connectorCategoryEntity = this.archiveBuilder.getEntity(connectorCategoryGUID);
                EntityProxy end1 = this.archiveHelper.getEntityProxy(connectorCategoryEntity);
                EntityProxy end2 = this.archiveHelper.getEntityProxy(connectorTypeEntity);
                this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.CONNECTOR_IMPLEMENTATION_CHOICE_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(qualifiedName + "_connector_implementation_choice_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
            }
            if ((definition = DeployedImplementationType.getDefinitionFromDeployedImplementationType((String)deployedImplementationType)) != null && this.archiveBuilder.queryEntity(this.idToGUIDMap.getGUID(definition.getQualifiedName())) != null) {
                this.addResourceListRelationship(definition.getQualifiedName(), qualifiedName, ResourceUse.CONFIGURE_CONNECTOR.getResourceUse(), ResourceUse.CONFIGURE_CONNECTOR.getDescription());
            }
        }
        return connectorTypeEntity.getGUID();
    }

    public String addConnectorCategory(String connectorTypeDirectoryGUID, String qualifiedName, String displayName, String description, String targetTechnologySource, String targetTechnologyName, Map<String, Boolean> recognizedSecuredProperties, Map<String, Boolean> recognizedConfigurationProperties, Map<String, Boolean> recognizedAdditionalProperties, Map<String, String> additionalProperties) {
        String methodName = "addConnectorCategory";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, "addConnectorCategory");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DISPLAY_NAME.name, displayName, "addConnectorCategory");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addConnectorCategory");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.TARGET_TECHNOLOGY_SOURCE.name, targetTechnologySource, "addConnectorCategory");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.TARGET_TECHNOLOGY_NAME.name, targetTechnologyName, "addConnectorCategory");
        properties = this.archiveHelper.addBooleanMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.RECOGNIZED_SECURED_PROPERTIES.name, recognizedSecuredProperties, "addConnectorCategory");
        properties = this.archiveHelper.addBooleanMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.RECOGNIZED_ADDITIONAL_PROPERTIES.name, recognizedAdditionalProperties, "addConnectorCategory");
        properties = this.archiveHelper.addBooleanMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.RECOGNIZED_CONFIGURATION_PROPERTIES.name, recognizedConfigurationProperties, "addConnectorCategory");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, "addConnectorCategory");
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        classifications.add(this.getAnchorClassification(connectorTypeDirectoryGUID, OpenMetadataType.COLLECTION.typeName, OpenMetadataType.COLLECTION.typeName, "addConnectorCategory"));
        EntityDetail connectorCategoryEntity = this.archiveHelper.getEntityDetail(OpenMetadataType.CONNECTOR_CATEGORY.typeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(connectorCategoryEntity);
        if (connectorTypeDirectoryGUID != null) {
            EntityDetail connectorTypeDirectoryEntity = this.archiveBuilder.getEntity(connectorTypeDirectoryGUID);
            EntityProxy end1 = this.archiveHelper.getEntityProxy(connectorTypeDirectoryEntity);
            EntityProxy end2 = this.archiveHelper.getEntityProxy(connectorCategoryEntity);
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.COLLECTION_MEMBERSHIP_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(qualifiedName + "_collection_membership_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        }
        return connectorCategoryEntity.getGUID();
    }

    public String addConnectorTypeDirectory(String qualifiedName, String displayName, String description, Map<String, String> additionalProperties) {
        String methodName = "addConnectorTypeDirectory";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, "addConnectorTypeDirectory");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.NAME.name, displayName, "addConnectorTypeDirectory");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addConnectorTypeDirectory");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, "addConnectorTypeDirectory");
        String guid = this.idToGUIDMap.getGUID(qualifiedName);
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        Classification classification = this.archiveHelper.getClassification(OpenMetadataType.CONNECTOR_TYPE_DIRECTORY_CLASSIFICATION.typeName, null, InstanceStatus.ACTIVE);
        classifications.add(classification);
        classifications.add(this.getAnchorClassification(guid, OpenMetadataType.COLLECTION.typeName, OpenMetadataType.COLLECTION.typeName, "addConnectorTypeDirectory"));
        EntityDetail connectorTypeDirectoryEntity = this.archiveHelper.getEntityDetail(OpenMetadataType.COLLECTION.typeName, guid, properties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(connectorTypeDirectoryEntity);
        return connectorTypeDirectoryEntity.getGUID();
    }

    public Classification getFileSystemClassification(String format, String encryption, String methodName) {
        InstanceProperties classificationProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.FORMAT.name, format, methodName);
        classificationProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, classificationProperties, OpenMetadataProperty.ENCRYPTION.name, encryption, methodName);
        return this.archiveHelper.getClassification(OpenMetadataType.FILE_SYSTEM_CLASSIFICATION.typeName, classificationProperties, InstanceStatus.ACTIVE);
    }

    public Classification getTemplateClassification(String templateName, String templateDescription, String versionIdentifier, Map<String, String> additionalProperties, String methodName) {
        InstanceProperties classificationProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.NAME.name, templateName, methodName);
        classificationProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, classificationProperties, OpenMetadataProperty.DESCRIPTION.name, templateDescription, methodName);
        classificationProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, classificationProperties, OpenMetadataProperty.VERSION_IDENTIFIER.name, versionIdentifier, methodName);
        classificationProperties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, classificationProperties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, methodName);
        return this.archiveHelper.getClassification(OpenMetadataType.TEMPLATE_CLASSIFICATION.typeName, classificationProperties, InstanceStatus.ACTIVE);
    }

    public Classification getTemplateSubstituteClassification() {
        return this.archiveHelper.getClassification(OpenMetadataType.TEMPLATE_SUBSTITUTE_CLASSIFICATION.typeName, null, InstanceStatus.ACTIVE);
    }

    public void addSourcedFromRelationship(String resultingElementGUID, long sourceVersionNumber, String templateElementGUID, String methodName) {
        InstanceProperties relationshipProperties = this.archiveHelper.addLongPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.SOURCE_VERSION_NUMBER.name, sourceVersionNumber, methodName);
        EntityDetail end1Entity = this.archiveBuilder.getEntity(resultingElementGUID);
        EntityDetail end2Entity = this.archiveBuilder.getEntity(templateElementGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(end1Entity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(end2Entity);
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.SOURCED_FROM_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(resultingElementGUID + "_to_" + templateElementGUID + "_sourced_from_relationship"), relationshipProperties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addCatalogTemplateRelationship(String owningElementGUID, String templateElementGUID) {
        EntityDetail end1Entity = this.archiveBuilder.getEntity(owningElementGUID);
        EntityDetail end2Entity = this.archiveBuilder.getEntity(templateElementGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(end1Entity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(end2Entity);
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.CATALOG_TEMPLATE_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(owningElementGUID + "_to_" + templateElementGUID + "_catalog_template_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public String addEndpoint(String anchorGUID, String anchorTypeName, String anchorDomainName, String qualifiedName, String displayName, String description, String networkAddress, String protocol, Map<String, String> additionalProperties) {
        return this.addEndpoint(anchorGUID, anchorTypeName, anchorDomainName, qualifiedName, displayName, description, networkAddress, protocol, additionalProperties, null);
    }

    public String addEndpoint(String anchorGUID, String anchorTypeName, String anchorDomainName, String qualifiedName, String displayName, String description, String networkAddress, String protocol, Map<String, String> additionalProperties, Classification additionalClassification) {
        String methodName = "addEndpoint";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, "addEndpoint");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.NAME.name, displayName, "addEndpoint");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addEndpoint");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.NETWORK_ADDRESS.name, networkAddress, "addEndpoint");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.PROTOCOL.name, protocol, "addEndpoint");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, "addEndpoint");
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        if (additionalClassification != null) {
            classifications.add(additionalClassification);
        }
        if (anchorGUID != null || anchorTypeName != null) {
            classifications.add(this.getAnchorClassification(anchorGUID, anchorTypeName, anchorDomainName, "addEndpoint"));
        }
        if (classifications.isEmpty()) {
            classifications = null;
        }
        EntityDetail endpointEntity = this.archiveHelper.getEntityDetail(OpenMetadataType.ENDPOINT.typeName, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(endpointEntity);
        return endpointEntity.getGUID();
    }

    public void addServerEndpointRelationship(String itInfrastructureGUID, String endpointGUID) {
        EntityDetail end1Entity = this.archiveBuilder.getEntity(itInfrastructureGUID);
        EntityDetail end2Entity = this.archiveBuilder.getEntity(endpointGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(end1Entity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(end2Entity);
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.SERVER_ENDPOINT_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(itInfrastructureGUID + "_to_" + endpointGUID + "_server_endpoint_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public String addGlossary(String qualifiedName, String displayName, String description, String language, String usage, String externalLink, String scope) {
        return this.addGlossary(qualifiedName, displayName, description, language, usage, externalLink, scope, null);
    }

    public String addGlossary(String qualifiedName, String displayName, String description, String language, String usage, String externalLink, String scope, Map<String, String> additionalProperties) {
        String methodName = "addGlossary";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, "addGlossary");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DISPLAY_NAME.name, displayName, "addGlossary");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addGlossary");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "language", language, "addGlossary");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.USAGE.name, usage, "addGlossary");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, "addGlossary");
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        if (scope != null) {
            Classification canonicalVocabClassification = this.archiveHelper.getClassification("CanonicalVocabulary", this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, "scope", scope, "addGlossary"), InstanceStatus.ACTIVE);
            classifications.add(canonicalVocabClassification);
        }
        String guid = this.idToGUIDMap.getGUID(qualifiedName);
        Classification anchorClassification = this.getAnchorClassification(guid, "Glossary", "Glossary", "addGlossary");
        classifications.add(anchorClassification);
        EntityDetail glossaryEntity = this.archiveHelper.getEntityDetail("Glossary", guid, properties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(glossaryEntity);
        if (externalLink != null) {
            String externalLinkQualifiedName = qualifiedName + "_external_link";
            properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.QUALIFIED_NAME.name, externalLinkQualifiedName, "addGlossary");
            properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.URL.name, externalLink, "addGlossary");
            properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ORGANIZATION.name, this.originatorName, "addGlossary");
            properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.REFERENCE_VERSION.name, this.versionName, "addGlossary");
            classifications = new ArrayList();
            classifications.add(anchorClassification);
            EntityDetail externalLinkEntity = this.archiveHelper.getEntityDetail("ExternalGlossaryLink", this.idToGUIDMap.getGUID(externalLinkQualifiedName), properties, InstanceStatus.ACTIVE, classifications);
            this.archiveBuilder.addEntity(externalLinkEntity);
            EntityProxy end1 = this.archiveHelper.getEntityProxy(glossaryEntity);
            EntityProxy end2 = this.archiveHelper.getEntityProxy(externalLinkEntity);
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship("ExternallySourcedGlossary", this.idToGUIDMap.getGUID(qualifiedName + "_externally_sourced_link_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        }
        return glossaryEntity.getGUID();
    }

    public String addGlossaryCategory(String glossaryGUID, String qualifiedName, String displayName, String description, String subjectArea) {
        return this.addGlossaryCategory(glossaryGUID, false, qualifiedName, displayName, description, subjectArea, null);
    }

    public String addGlossaryCategory(String glossaryGUID, String qualifiedName, String displayName, String description, String subjectArea, Map<String, String> additionalProperties) {
        return this.addGlossaryCategory(glossaryGUID, false, qualifiedName, displayName, description, subjectArea, additionalProperties);
    }

    public String addGlossaryCategory(String glossaryGUID, boolean isRootCategory, String qualifiedName, String displayName, String description, String subjectArea, Map<String, String> additionalProperties) {
        String methodName = "addCategory";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, "addCategory");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DISPLAY_NAME.name, displayName, "addCategory");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addCategory");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, "addCategory");
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        if (subjectArea != null) {
            Classification subjectAreaClassification = this.archiveHelper.getClassification("SubjectArea", this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.NAME.name, subjectArea, "addCategory"), InstanceStatus.ACTIVE);
            classifications.add(subjectAreaClassification);
        }
        if (isRootCategory) {
            Classification rootCategoryClassification = this.archiveHelper.getClassification("RootCategory", null, InstanceStatus.ACTIVE);
            classifications.add(rootCategoryClassification);
        }
        classifications.add(this.getAnchorClassification(glossaryGUID, "Glossary", "Glossary", "addCategory"));
        EntityDetail categoryEntity = this.archiveHelper.getEntityDetail("GlossaryCategory", this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(categoryEntity);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(glossaryGUID));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(categoryEntity);
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship("CategoryAnchor", this.idToGUIDMap.getGUID(qualifiedName + "_category_anchor_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        return categoryEntity.getGUID();
    }

    public String addTerm(String glossaryGUID, List<String> categoryGUIDs, String qualifiedName, String displayName, String description) {
        return this.addTerm(glossaryGUID, categoryGUIDs, false, qualifiedName, displayName, null, description, null, null, null, false, false, false, null, null, null, null);
    }

    public String addTerm(String glossaryGUID, List<String> categoryIds, boolean categoriesAsNames, String qualifiedName, String displayName, String summary, String description, String examples, String abbreviation, String usage, boolean isSpineObject, boolean isSpineAttribute, boolean isContext, String contextDescription, String contextScope, Map<String, String> additionalProperties, List<Classification> additionalClassifications) {
        Classification newClassification;
        String methodName = "addTerm";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, "addTerm");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DISPLAY_NAME.name, displayName, "addTerm");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.SUMMARY.name, summary, "addTerm");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addTerm");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.EXAMPLES.name, examples, "addTerm");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ABBREVIATION.name, abbreviation, "addTerm");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.USAGE.name, usage, "addTerm");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, "addTerm");
        List<Classification> classifications = additionalClassifications;
        if (classifications == null) {
            classifications = new ArrayList<Classification>();
        }
        if (isSpineObject) {
            newClassification = this.archiveHelper.getClassification("SpineObject", null, InstanceStatus.ACTIVE);
            classifications.add(newClassification);
        }
        if (isSpineAttribute) {
            newClassification = this.archiveHelper.getClassification("SpineAttribute", null, InstanceStatus.ACTIVE);
            classifications.add(newClassification);
        }
        if (isContext) {
            InstanceProperties classificationProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.DESCRIPTION.name, contextDescription, "addTerm");
            classificationProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, classificationProperties, "scope", contextScope, "addTerm");
            Classification newClassification2 = this.archiveHelper.getClassification("ContextDefinition", classificationProperties, InstanceStatus.ACTIVE);
            classifications.add(newClassification2);
        }
        classifications.add(this.getAnchorClassification(glossaryGUID, "Glossary", "Glossary", "addTerm"));
        EntityDetail termEntity = this.archiveHelper.getEntityDetail("GlossaryTerm", this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, classifications);
        this.archiveBuilder.addEntity(termEntity);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(glossaryGUID));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(termEntity);
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship("TermAnchor", this.idToGUIDMap.getGUID(qualifiedName + "_term_anchor_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        if (categoryIds != null) {
            InstanceProperties categorizationProperties = this.archiveHelper.addEnumPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.TERM_RELATIONSHIP_STATUS.name, GlossaryTermRelationshipStatus.getOpenTypeGUID(), GlossaryTermRelationshipStatus.getOpenTypeName(), GlossaryTermRelationshipStatus.ACTIVE.getOrdinal(), GlossaryTermRelationshipStatus.ACTIVE.getName(), GlossaryTermRelationshipStatus.ACTIVE.getDescription(), "addTerm");
            for (String categoryId : categoryIds) {
                if (categoryId == null) continue;
                String categoryGUID = categoryId;
                if (categoriesAsNames) {
                    categoryGUID = this.idToGUIDMap.getGUID(categoryId);
                }
                end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(categoryGUID));
                this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship("TermCategorization", this.idToGUIDMap.getGUID(qualifiedName + "_category_" + categoryId + "_term_categorization_relationship"), categorizationProperties, InstanceStatus.ACTIVE, end1, end2));
            }
        }
        return termEntity.getGUID();
    }

    public void addCategoryToCategory(String parentCategoryGUID, String childCategoryGUID) {
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(parentCategoryGUID));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(childCategoryGUID));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship("CategoryHierarchyLink", this.idToGUIDMap.getGUID(parentCategoryGUID + "_to_" + childCategoryGUID + "_category_hierarchy_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addSemanticAssignment(String dataGUID, String glossaryTermGUID) {
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(dataGUID));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(glossaryTermGUID));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.SEMANTIC_ASSIGNMENT.typeName, this.idToGUIDMap.getGUID(dataGUID + "_to_" + glossaryTermGUID + "_semantic_assignment_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addTermToContext(String contextGUID, String termGUID, int status, String description) {
        String methodName = "addTermToContext";
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(termGUID));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(contextGUID));
        EnumElementDef termStatus = this.archiveHelper.getEnumElement(GlossaryTermRelationshipStatus.getOpenTypeName(), status);
        InstanceProperties properties = this.archiveHelper.addEnumPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.TERM_RELATIONSHIP_STATUS.name, GlossaryTermRelationshipStatus.getOpenTypeGUID(), GlossaryTermRelationshipStatus.getOpenTypeName(), termStatus.getOrdinal(), termStatus.getValue(), termStatus.getDescription(), "addTermToContext");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addTermToContext");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship("UsedInContext", this.idToGUIDMap.getGUID(contextGUID + "_to_" + termGUID + "_used_in_context_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addTermToSynonym(String synonymGUID, String termGUID, int status, String description, String expression, String steward, String source) {
        String methodName = "addTermToSynonym";
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(synonymGUID));
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(termGUID));
        EnumElementDef termStatus = this.archiveHelper.getEnumElement(GlossaryTermRelationshipStatus.getOpenTypeName(), status);
        InstanceProperties properties = this.archiveHelper.addEnumPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.TERM_RELATIONSHIP_STATUS.name, GlossaryTermRelationshipStatus.getOpenTypeGUID(), GlossaryTermRelationshipStatus.getOpenTypeName(), termStatus.getOrdinal(), termStatus.getValue(), termStatus.getDescription(), "addTermToSynonym");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addTermToSynonym");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.EXPRESSION.name, expression, "addTermToSynonym");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.STEWARD.name, steward, "addTermToSynonym");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.SOURCE.name, source, "addTermToSynonym");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship("Synonym", this.idToGUIDMap.getGUID(synonymGUID + "_to_" + termGUID + "_synonym_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addTermToCategory(String categoryGUID, String termGUID) {
        this.addTermToCategory(categoryGUID, termGUID, 1, null);
    }

    public void addTermToCategory(String categoryGUID, String termGUID, int status, String description) {
        String methodName = "addTermToCategory";
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(categoryGUID));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(termGUID));
        EnumElementDef termStatus = this.archiveHelper.getEnumElement(GlossaryTermRelationshipStatus.getOpenTypeName(), status);
        InstanceProperties properties = this.archiveHelper.addEnumPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.TERM_RELATIONSHIP_STATUS.name, GlossaryTermRelationshipStatus.getOpenTypeGUID(), GlossaryTermRelationshipStatus.getOpenTypeName(), termStatus.getOrdinal(), termStatus.getValue(), termStatus.getDescription(), "addTermToCategory");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addTermToCategory");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship("TermCategorization", this.idToGUIDMap.getGUID(categoryGUID + "_to_" + termGUID + "_term_categorization_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addLibraryCategoryReference(String categoryGUID, String externalGlossaryLinkGUID, String identifier, String description, String steward, Date lastVerified) {
        String methodName = "addLibraryCategoryReference";
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(categoryGUID));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(externalGlossaryLinkGUID));
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.IDENTIFIER.name, identifier, "addLibraryCategoryReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addLibraryCategoryReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.STEWARD.name, steward, "addLibraryCategoryReference");
        properties = this.archiveHelper.addDatePropertyToInstance(this.archiveRootName, properties, "lastVerified", lastVerified, "addLibraryCategoryReference");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship("LibraryCategoryReference", this.idToGUIDMap.getGUID(categoryGUID + "_to_" + externalGlossaryLinkGUID + "_library_category_reference_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addLibraryTermReference(String termGUID, String externalGlossaryLinkGUID, String identifier, String description, String steward, Date lastVerified) {
        String methodName = "addLibraryTermReference";
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(termGUID));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(externalGlossaryLinkGUID));
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.IDENTIFIER.name, identifier, "addLibraryTermReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addLibraryTermReference");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.STEWARD.name, steward, "addLibraryTermReference");
        properties = this.archiveHelper.addDatePropertyToInstance(this.archiveRootName, properties, "lastVerified", lastVerified, "addLibraryTermReference");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.LIBRARY_TERM_REFERENCE.typeName, this.idToGUIDMap.getGUID(termGUID + "_to_" + externalGlossaryLinkGUID + "_library_term_reference_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addMoreInformationLink(String describedElementId, String describerElementId) {
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(describedElementId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(describerElementId));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.MORE_INFORMATION_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(describedElementId + "_to_" + describerElementId + "_more_information_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addLicense(String licensedElementGUID, String licenseGUID, Date startDate, Date endDate, String conditions, String licensedBy, String licensedByTypeName, String licensedByPropertyName, String custodian, String custodianTypeName, String custodianPropertyName, String licensee, String licenseeTypeName, String licenseePropertyName, Map<String, String> entitlements, Map<String, String> restrictions, Map<String, String> obligations, String notes, String licenseTypeGUID) {
        String methodName = "addLicense";
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(licensedElementGUID));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(licenseTypeGUID));
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, "licenseGUID", licenseGUID, "addLicense");
        properties = this.archiveHelper.addDatePropertyToInstance(this.archiveRootName, properties, "start", startDate, "addLicense");
        properties = this.archiveHelper.addDatePropertyToInstance(this.archiveRootName, properties, "end", endDate, "addLicense");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "conditions", conditions, "addLicense");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "licensedBy", licensedBy, "addLicense");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "licensedByTypeName", licensedByTypeName, "addLicense");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "licensedByPropertyName", licensedByPropertyName, "addLicense");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "custodian", custodian, "addLicense");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "custodianTypeName", custodianTypeName, "addLicense");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "custodianPropertyName", custodianPropertyName, "addLicense");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "licensee", licensee, "addLicense");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "licenseeTypeName", licenseeTypeName, "addLicense");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "licenseePropertyName", licenseePropertyName, "addLicense");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, "entitlements", entitlements, "addLicense");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, "restrictions", restrictions, "addLicense");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, "obligations", obligations, "addLicense");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "notes", notes, "addLicense");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship("License", this.idToGUIDMap.getGUID(licensedElementGUID + "_to_" + licenseTypeGUID + "_license_relationship_" + licenseGUID), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addCertification(String certifiedElementGUID, String certificationGUID, Date startDate, Date endDate, String conditions, String certifiedBy, String certifiedByTypeName, String certifiedByPropertyName, String custodian, String custodianTypeName, String custodianPropertyName, String recipient, String recipientTypeName, String recipientPropertyName, String notes, String certificationTypeGUID) {
        String methodName = "addCertification";
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(certifiedElementGUID));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(certificationTypeGUID));
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, "certificateGUID", certificationGUID, "addCertification");
        properties = this.archiveHelper.addDatePropertyToInstance(this.archiveRootName, properties, "start", startDate, "addCertification");
        properties = this.archiveHelper.addDatePropertyToInstance(this.archiveRootName, properties, "end", endDate, "addCertification");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "conditions", conditions, "addCertification");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "certifiedBy", certifiedBy, "addCertification");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "certifiedByTypeName", certifiedByTypeName, "addCertification");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "certifiedByPropertyName", certifiedByPropertyName, "addCertification");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "custodian", custodian, "addCertification");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "custodianTypeName", custodianTypeName, "addCertification");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "custodianPropertyName", custodianPropertyName, "addCertification");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "recipient", recipient, "addCertification");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "recipientTypeName", recipientTypeName, "addCertification");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "recipientPropertyName", recipientPropertyName, "addCertification");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "notes", notes, "addCertification");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship("Certification", this.idToGUIDMap.getGUID(certifiedElementGUID + "_to_" + certificationTypeGUID + "_certification_relationship_" + certificationGUID), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void linkApprovedPurpose(String referenceableGUID, String dataProcessingPurposeGUID) {
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(referenceableGUID));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(dataProcessingPurposeGUID));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.APPROVED_PURPOSE_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(dataProcessingPurposeGUID + "_to_" + referenceableGUID + "_approved_purpose_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public void linkTermToReferenceable(String termId, String referenceableId) {
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(referenceableId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(termId));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.SEMANTIC_ASSIGNMENT.typeName, this.idToGUIDMap.getGUID(referenceableId + "_to_" + termId + "_semantic_assignment_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addIsATypeOfRelationship(String specialTermQName, String generalizedTermQName) {
        String specializedTermId = this.idToGUIDMap.getGUID(specialTermQName);
        String generalizedTermId = this.idToGUIDMap.getGUID(generalizedTermQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(specializedTermId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(generalizedTermId));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship("TermISATYPEOFRelationship", this.idToGUIDMap.getGUID(specializedTermId + "_to_" + generalizedTermId + "_isatypeof_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addHasARelationship(String conceptQName, String propertyQName) {
        String conceptId = this.idToGUIDMap.getGUID(conceptQName);
        String propertyId = this.idToGUIDMap.getGUID(propertyQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(propertyId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(conceptId));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship("TermHASARelationship", this.idToGUIDMap.getGUID(conceptId + "_to_" + propertyId + "_hasa_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addRelatedTermRelationship(String conceptQName, String propertyQName) {
        String conceptId = this.idToGUIDMap.getGUID(conceptQName);
        String propertyId = this.idToGUIDMap.getGUID(propertyQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(conceptId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(propertyId));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship("RelatedTerm", this.idToGUIDMap.getGUID(conceptId + "_to_" + propertyId + "_related_term_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public String addValidValue(String typeName, String qualifiedName, String name, String description, String usage, String scope, String preferredValue, boolean isDeprecated, Map<String, String> additionalProperties) {
        return this.addValidValue(null, null, null, null, null, typeName, qualifiedName, name, description, null, usage, null, scope, preferredValue, isDeprecated, false, additionalProperties);
    }

    public String addValidValue(String suppliedValidValueGUID, String setGUID, String anchorGUID, String anchorTypeName, String anchorDomainName, String typeName, String qualifiedName, String name, String description, String category, String usage, String dataType, String scope, String preferredValue, boolean isDeprecated, boolean isCaseSensitive, Map<String, String> additionalProperties) {
        String methodName = "addValidValue";
        String validValueGUID = suppliedValidValueGUID;
        if (validValueGUID == null) {
            validValueGUID = this.idToGUIDMap.getGUID(qualifiedName);
        } else {
            this.idToGUIDMap.setGUID(qualifiedName, validValueGUID);
        }
        if (this.archiveBuilder.queryEntity(validValueGUID) == null) {
            InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, "addValidValue");
            properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.NAME.name, name, "addValidValue");
            properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DESCRIPTION.name, description, "addValidValue");
            properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.CATEGORY.name, category, "addValidValue");
            properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.USAGE.name, usage, "addValidValue");
            properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DATA_TYPE.name, dataType, "addValidValue");
            properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.SCOPE.name, scope, "addValidValue");
            properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.PREFERRED_VALUE.name, preferredValue, "addValidValue");
            properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.IS_DEPRECATED.name, isDeprecated, "addValidValue");
            properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.IS_CASE_SENSITIVE.name, isCaseSensitive, "addValidValue");
            properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, "addValidValue");
            ArrayList<Classification> entityClassifications = new ArrayList<Classification>();
            if (anchorGUID != null) {
                entityClassifications.add(this.getAnchorClassification(anchorGUID, anchorTypeName, anchorDomainName, "addValidValue"));
            } else {
                entityClassifications.add(this.getAnchorClassification(validValueGUID, typeName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, "addValidValue"));
            }
            EntityDetail validValueEntity = this.archiveHelper.getEntityDetail(typeName, validValueGUID, properties, InstanceStatus.ACTIVE, entityClassifications);
            this.archiveBuilder.addEntity(validValueEntity);
            if (setGUID != null) {
                this.addValidValueMembershipRelationshipByGUID(setGUID, validValueEntity.getGUID(), false);
            }
            return validValueEntity.getGUID();
        }
        return validValueGUID;
    }

    Classification getAnchorClassification(String anchorGUID, String anchorTypeName, String anchorDomainName, String methodName) {
        InstanceProperties classificationProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.ANCHOR_GUID.name, anchorGUID, methodName);
        classificationProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, classificationProperties, OpenMetadataProperty.ANCHOR_TYPE_NAME.name, anchorTypeName, methodName);
        classificationProperties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, classificationProperties, OpenMetadataProperty.ANCHOR_DOMAIN_NAME.name, anchorDomainName, methodName);
        return this.archiveHelper.getClassification(OpenMetadataType.ANCHORS_CLASSIFICATION.typeName, classificationProperties, InstanceStatus.ACTIVE);
    }

    public void addValidValueMembershipRelationship(String setQName, String memberQName, boolean isDefaultValue) {
        String setId = this.idToGUIDMap.getGUID(setQName);
        String memberId = this.idToGUIDMap.getGUID(memberQName);
        this.addValidValueMembershipRelationshipByGUID(setId, memberId, isDefaultValue);
    }

    public void addValidValueMembershipRelationshipByGUID(String setId, String memberId, boolean isDefaultValue) {
        String methodName = "addValidValuesAssignmentRelationship";
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(setId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(memberId));
        InstanceProperties properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, null, "isDefaultValue", isDefaultValue, "addValidValuesAssignmentRelationship");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.VALID_VALUE_MEMBER_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(setId + "_to_" + memberId + "_valid_value_member_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addConsistentValidValueRelationship(String validValue1QName, String validValue2QName) {
        String methodName = "addConsistentValidValueRelationship";
        String setId = this.idToGUIDMap.getGUID(validValue1QName);
        String memberId = this.idToGUIDMap.getGUID(validValue2QName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(setId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(memberId));
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.CONSISTENT_VALID_VALUES_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(setId + "_to_" + memberId + "_consistent_valid_value_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addValidValuesAssignmentRelationship(String dataFieldQName, String validValueQName, boolean strictRequirement) {
        String methodName = "addValidValuesAssignmentRelationship";
        String dataFieldId = this.idToGUIDMap.getGUID(dataFieldQName);
        String validValueId = this.idToGUIDMap.getGUID(validValueQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(dataFieldId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(validValueId));
        InstanceProperties properties = this.archiveHelper.addBooleanPropertyToInstance(this.archiveRootName, null, "strictRequirement", strictRequirement, "addValidValuesAssignmentRelationship");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.VALID_VALUES_ASSIGNMENT_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(dataFieldId + "_to_" + validValueId + "_valid_values_assignment_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addValidValuesMappingRelationship(String matchingValue1QName, String matchingValue2QName, String associationDescription, int confidence, String steward, String stewardTypeName, String stewardPropertyName, String notes) {
        String methodName = "addValidValuesMappingRelationship";
        String matchingValue1Id = this.idToGUIDMap.getGUID(matchingValue1QName);
        String matchingValueId = this.idToGUIDMap.getGUID(matchingValue2QName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(matchingValue1Id));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(matchingValueId));
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, "associationDescription", associationDescription, "addValidValuesMappingRelationship");
        properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.CONFIDENCE.name, confidence, "addValidValuesMappingRelationship");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.STEWARD.name, steward, "addValidValuesMappingRelationship");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.STEWARD_TYPE_NAME.name, stewardTypeName, "addValidValuesMappingRelationship");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.STEWARD_PROPERTY_NAME.name, stewardPropertyName, "addValidValuesMappingRelationship");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.NOTES.name, notes, "addValidValuesMappingRelationship");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.VALID_VALUES_MAPPING_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(matchingValue1Id + "_to_" + matchingValueId + "_valid_values_mapping_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addValidValueAssociationRelationship(String end1QName, String end2QName, String associationName, String associationType, Map<String, String> additionalProperties) {
        String methodName = "addValidValueAssociationRelationship";
        String end1GUID = this.idToGUIDMap.getGUID(end1QName);
        String end2GUID = this.idToGUIDMap.getGUID(end2QName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(end1GUID));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(end2GUID));
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.ASSOCIATION_NAME.name, associationName, "addValidValueAssociationRelationship");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ASSOCIATION_TYPE.name, associationType, "addValidValueAssociationRelationship");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, "addValidValueAssociationRelationship");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.VALID_VALUE_ASSOCIATION_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(end1GUID + "_to_" + end2GUID + "_valid_value_association_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addReferenceValueAssignmentRelationship(String referenceableQName, String validValueQName, int confidence, String steward, String stewardTypeName, String stewardPropertyName, String notes) {
        String referenceableId = this.idToGUIDMap.getGUID(referenceableQName);
        String validValueId = this.idToGUIDMap.getGUID(validValueQName);
        this.addReferenceValueAssignmentRelationship(referenceableId, validValueId, null, confidence, steward, stewardTypeName, stewardPropertyName, notes);
    }

    public void addReferenceValueAssignmentRelationship(String referenceableGUID, String validValueGUID, String attributeName, int confidence, String steward, String stewardTypeName, String stewardPropertyName, String notes) {
        String methodName = "addReferenceValueAssignmentRelationship";
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(referenceableGUID));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(validValueGUID));
        InstanceProperties properties = this.archiveHelper.addIntPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.CONFIDENCE.name, confidence, "addReferenceValueAssignmentRelationship");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "attributeName", attributeName, "addReferenceValueAssignmentRelationship");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.STEWARD.name, steward, "addReferenceValueAssignmentRelationship");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.STEWARD_TYPE_NAME.name, stewardTypeName, "addReferenceValueAssignmentRelationship");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.STEWARD_PROPERTY_NAME.name, stewardPropertyName, "addReferenceValueAssignmentRelationship");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.NOTES.name, notes, "addReferenceValueAssignmentRelationship");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.REFERENCE_VALUE_ASSIGNMENT_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(referenceableGUID + "_to_" + validValueGUID + "_reference_value_assignment_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addSpecificationPropertyAssignmentRelationship(String referenceableGUID, String validValueGUID, String propertyType) {
        String methodName = "addSpecificationPropertyAssignmentRelationship";
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(referenceableGUID));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(validValueGUID));
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.PROPERTY_TYPE.name, propertyType, "addSpecificationPropertyAssignmentRelationship");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.SPECIFICATION_PROPERTY_ASSIGNMENT_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(referenceableGUID + "_to_" + validValueGUID + "_specification_property_type_relationship_for_" + propertyType), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addValidValuesImplementationRelationship(String validValueQName, String assetQName, String symbolicName, String implementationValue, Map<String, String> additionalValues) {
        String methodName = "addValidValuesImplementationRelationship";
        String validValueId = this.idToGUIDMap.getGUID(validValueQName);
        String assetId = this.idToGUIDMap.getGUID(assetQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(validValueId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(assetId));
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, "symbolicName", symbolicName, "addValidValuesImplementationRelationship");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, "implementationValue", implementationValue, "addValidValuesImplementationRelationship");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, "additionalValues", additionalValues, "addValidValuesImplementationRelationship");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.VALID_VALUES_IMPL_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(validValueId + "_to_" + assetId + "_valid_values_implementation_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public void addReferenceDataClassification(String assetGUID) {
        EntityDetail assetEntity = this.archiveBuilder.getEntity(assetGUID);
        EntityProxy referenceableEntityProxy = this.archiveHelper.getEntityProxy(assetEntity);
        Classification classification = this.archiveHelper.getClassification(OpenMetadataType.REFERENCE_DATA_CLASSIFICATION.typeName, null, InstanceStatus.ACTIVE);
        this.archiveBuilder.addClassification(this.archiveHelper.getClassificationEntityExtension(referenceableEntityProxy, classification));
    }

    public void addSecurityTagsClassification(String assetGUID, List<String> securityLabels, Map<String, Object> securityProperties, Map<String, List<String>> accessGroups) {
        String methodName = "addSecurityTagsClassification";
        EntityDetail assetEntity = this.archiveBuilder.getEntity(assetGUID);
        EntityProxy entityProxy = this.archiveHelper.getEntityProxy(assetEntity);
        InstanceProperties properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, null, "securityLabels", securityLabels, "addSecurityTagsClassification");
        properties = this.archiveHelper.addMapPropertyToInstance(this.archiveRootName, properties, "securityProperties", securityProperties, "addSecurityTagsClassification");
        properties = this.archiveHelper.addStringArrayStringMapPropertyToInstance(this.archiveRootName, properties, "accessGroups", accessGroups, "addSecurityTagsClassification");
        Classification classification = this.archiveHelper.getClassification("SecurityTags", properties, InstanceStatus.ACTIVE);
        this.archiveBuilder.addClassification(this.archiveHelper.getClassificationEntityExtension(entityProxy, classification));
    }

    public void addSupportedSoftwareCapabilityRelationship(String deployedElementQName, String deployedOnQName, Date deploymentTime, String deployerTypeName, String deployerPropertyName, String deployer, int serverCapabilityStatus) {
        String methodName = "addSupportedSoftwareCapabilityRelationship";
        String deployedElementId = this.idToGUIDMap.getGUID(deployedElementQName);
        String deployedOnId = this.idToGUIDMap.getGUID(deployedOnQName);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(deployedOnId));
        EntityProxy end2 = this.archiveHelper.getEntityProxy(this.archiveBuilder.getEntity(deployedElementId));
        EnumElementDef statusEnumElement = this.archiveHelper.getEnumElement(OperationalStatus.getOpenTypeName(), serverCapabilityStatus);
        InstanceProperties properties = this.archiveHelper.addDatePropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.DEPLOYMENT_TIME.name, deploymentTime, "addSupportedSoftwareCapabilityRelationship");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DEPLOYER_TYPE_NAME.name, deployerTypeName, "addSupportedSoftwareCapabilityRelationship");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DEPLOYER_PROPERTY_NAME.name, deployerPropertyName, "addSupportedSoftwareCapabilityRelationship");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.DEPLOYER.name, deployer, "addSupportedSoftwareCapabilityRelationship");
        properties = this.archiveHelper.addEnumPropertyToInstance(this.archiveRootName, properties, OpenMetadataProperty.OPERATIONAL_STATUS.name, OperationalStatus.getOpenTypeGUID(), OperationalStatus.getOpenTypeName(), statusEnumElement.getOrdinal(), statusEnumElement.getValue(), statusEnumElement.getDescription(), "addSupportedSoftwareCapabilityRelationship");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(OpenMetadataType.SUPPORTED_CAPABILITY_RELATIONSHIP.typeName, this.idToGUIDMap.getGUID(deployedOnId + "_to_" + deployedElementId + "_supported_software_capability_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }

    public Classification getServerPurposeClassification(String classificationName, String deployedImplementationType) {
        String methodName = "getServerPurposeClassification";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, deployedImplementationType, "getServerPurposeClassification");
        return this.archiveHelper.getClassification(classificationName, properties, InstanceStatus.ACTIVE);
    }

    public Classification getEngineClassification(String classificationName) {
        return this.archiveHelper.getClassification(classificationName, null, InstanceStatus.ACTIVE);
    }

    public void addServerPurposeClassification(String elementGUID, String classificationName, String deployedImplementationType) {
        String methodName = "addServerPurposeClassification";
        EntityDetail assetEntity = this.archiveBuilder.getEntity(elementGUID);
        EntityProxy entityProxy = this.archiveHelper.getEntityProxy(assetEntity);
        Classification classification = this.getServerPurposeClassification(classificationName, deployedImplementationType);
        this.archiveBuilder.addClassification(this.archiveHelper.getClassificationEntityExtension(entityProxy, classification));
    }
}

