/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.archiveutilities.openconnectors;

import org.odpi.openmetadata.adapters.connectors.apacheatlas.survey.SurveyApacheAtlasProvider;
import org.odpi.openmetadata.adapters.connectors.apachekafka.survey.SurveyApacheKafkaServerProvider;
import org.odpi.openmetadata.adapters.connectors.governanceactions.provisioning.MoveCopyFileGovernanceActionProvider;
import org.odpi.openmetadata.adapters.connectors.governanceactions.remediation.OriginSeekerGovernanceActionProvider;
import org.odpi.openmetadata.adapters.connectors.governanceactions.remediation.QualifiedNamePeerDuplicateGovernanceActionProvider;
import org.odpi.openmetadata.adapters.connectors.governanceactions.remediation.RetentionClassifierGovernanceActionProvider;
import org.odpi.openmetadata.adapters.connectors.governanceactions.remediation.ZonePublisherGovernanceActionProvider;
import org.odpi.openmetadata.adapters.connectors.governanceactions.stewardship.CatalogServerGovernanceActionProvider;
import org.odpi.openmetadata.adapters.connectors.governanceactions.stewardship.CreateServerGovernanceActionProvider;
import org.odpi.openmetadata.adapters.connectors.governanceactions.stewardship.DaysOfWeekGovernanceActionProvider;
import org.odpi.openmetadata.adapters.connectors.governanceactions.stewardship.EvaluateAnnotationsGovernanceActionProvider;
import org.odpi.openmetadata.adapters.connectors.governanceactions.stewardship.WriteAuditLogMessageGovernanceActionProvider;
import org.odpi.openmetadata.adapters.connectors.governanceactions.verification.VerifyAssetGovernanceActionProvider;
import org.odpi.openmetadata.adapters.connectors.governanceactions.watchdog.GenericFolderWatchdogGovernanceActionProvider;
import org.odpi.openmetadata.adapters.connectors.postgres.survey.PostgresDatabaseSurveyActionProvider;
import org.odpi.openmetadata.adapters.connectors.postgres.survey.PostgresServerSurveyActionProvider;
import org.odpi.openmetadata.adapters.connectors.reports.surveyreport.SurveyReportProvider;
import org.odpi.openmetadata.adapters.connectors.surveyaction.surveycsv.CSVSurveyServiceProvider;
import org.odpi.openmetadata.adapters.connectors.surveyaction.surveyfile.FileSurveyServiceProvider;
import org.odpi.openmetadata.adapters.connectors.surveyaction.surveyfolder.FolderSurveyServiceProvider;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.survey.OSSUnityCatalogInsideCatalogSurveyProvider;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.survey.OSSUnityCatalogInsideSchemaSurveyProvider;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.survey.OSSUnityCatalogInsideVolumeSurveyProvider;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.survey.OSSUnityCatalogServerSurveyProvider;
import org.odpi.openmetadata.archiveutilities.openconnectors.ContentPackDefinition;
import org.odpi.openmetadata.frameworks.governanceaction.GovernanceServiceProviderBase;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationType;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationTypeDefinition;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.ResourceUse;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyActionServiceProvider;
import org.odpi.openmetadata.samples.archiveutilities.GovernanceActionDescription;

public enum GovernanceServiceDefinition {
    FILE_PROVISIONER("bc302284-d423-47fa-86f3-0c6fd9892535", "file-provisioning-governance-action-service", "File {move, copy, delete} Governance Action Service", (GovernanceServiceProviderBase)new MoveCopyFileGovernanceActionProvider(), ResourceUse.PROVISION_RESOURCE, (DeployedImplementationTypeDefinition)DeployedImplementationType.GOVERNANCE_ACTION_SERVICE_CONNECTOR, ContentPackDefinition.CORE_CONTENT_PACK),
    NEW_FILES_WATCHDOG("16ba9235-ae9f-4754-8430-5ffbce7da6a0", "new-files-watchdog-governance-action-service", "New Files Watchdog Governance Action Service", (GovernanceServiceProviderBase)new GenericFolderWatchdogGovernanceActionProvider(), ResourceUse.WATCH_DOG, (DeployedImplementationTypeDefinition)DeployedImplementationType.GOVERNANCE_ACTION_SERVICE_CONNECTOR, ContentPackDefinition.CORE_CONTENT_PACK),
    ORIGIN_SEEKER("e1044fa8-18c7-44bf-ac19-65945f3d2333", "origin-seeker-governance-action-service", "Locate and Set Origin Governance Action Service", (GovernanceServiceProviderBase)new OriginSeekerGovernanceActionProvider(), ResourceUse.IMPROVE_METADATA, (DeployedImplementationTypeDefinition)DeployedImplementationType.GOVERNANCE_ACTION_SERVICE_CONNECTOR, ContentPackDefinition.CORE_CONTENT_PACK),
    RETENTION_CLASSIFIER("613dd0b5-5ced-4ad1-9269-51f5138aaf7c", "retention-classifier-governance-action-service", "Add a Retention classification to an Asset Governance Action Service", (GovernanceServiceProviderBase)new RetentionClassifierGovernanceActionProvider(), ResourceUse.IMPROVE_METADATA, (DeployedImplementationTypeDefinition)DeployedImplementationType.GOVERNANCE_ACTION_SERVICE_CONNECTOR, ContentPackDefinition.CORE_CONTENT_PACK),
    ZONE_PUBLISHER("4718325b-ae49-4378-97d7-8b283309c3ce", "zone-publisher-governance-action-service", "Update Asset's Zone Membership Governance Action Service", (GovernanceServiceProviderBase)new ZonePublisherGovernanceActionProvider(), ResourceUse.IMPROVE_METADATA, (DeployedImplementationTypeDefinition)DeployedImplementationType.GOVERNANCE_ACTION_SERVICE_CONNECTOR, ContentPackDefinition.CORE_CONTENT_PACK),
    QUALIFIED_NAME_DEDUP("3023fa37-89eb-42d2-a637-d600b408dcf3", "qualified-name-deduplication-governance-action-service", "Qualified Name De-duplicator Governance Action Service", (GovernanceServiceProviderBase)new QualifiedNamePeerDuplicateGovernanceActionProvider(), ResourceUse.IMPROVE_METADATA, (DeployedImplementationTypeDefinition)DeployedImplementationType.GOVERNANCE_ACTION_SERVICE_CONNECTOR, ContentPackDefinition.CORE_CONTENT_PACK),
    EVALUATE_ANNOTATIONS("16026ffb-2147-42c5-9dbd-362ff7aa58af", "evaluate-annotations-governance-action-service", "Verify annotations in a Survey Report", (GovernanceServiceProviderBase)new EvaluateAnnotationsGovernanceActionProvider(), ResourceUse.IMPROVE_METADATA, (DeployedImplementationTypeDefinition)DeployedImplementationType.GOVERNANCE_ACTION_SERVICE_CONNECTOR, ContentPackDefinition.CORE_CONTENT_PACK),
    PRINT_SURVEY_REPORT("fac65c1a-ef30-4995-b962-28fc070f40f8", "print-survey-report-governance-action-service", "Print a Survey Report as a markdown document", (GovernanceServiceProviderBase)new SurveyReportProvider(), ResourceUse.INFORM_STEWARD, (DeployedImplementationTypeDefinition)DeployedImplementationType.GOVERNANCE_ACTION_SERVICE_CONNECTOR, ContentPackDefinition.CORE_CONTENT_PACK),
    WRITE_AUDIT_LOG("6898b138-9ab0-4465-9ee8-ed9607dcc4f8", "write-audit-log-governance-action-service", "Write an Audit Log Message", (GovernanceServiceProviderBase)new WriteAuditLogMessageGovernanceActionProvider(), ResourceUse.INFORM_STEWARD, (DeployedImplementationTypeDefinition)DeployedImplementationType.GOVERNANCE_ACTION_SERVICE_CONNECTOR, ContentPackDefinition.CORE_CONTENT_PACK),
    DAY_OF_WEEK("a4837c75-aa3f-49c6-a903-ef0da0017546", "get-day-of-week-governance-action-service", "Detect the day of the week", (GovernanceServiceProviderBase)new DaysOfWeekGovernanceActionProvider(), ResourceUse.CHOOSE_PATH, (DeployedImplementationTypeDefinition)DeployedImplementationType.GOVERNANCE_ACTION_SERVICE_CONNECTOR, ContentPackDefinition.CORE_CONTENT_PACK),
    VERIFY_ASSET("9c5b74a0-148b-4623-9c50-8a2f6072bb0a", "verify-asset-governance-action-service", "Verify an Asset Governance Action Service", (GovernanceServiceProviderBase)new VerifyAssetGovernanceActionProvider(), ResourceUse.IMPROVE_METADATA, (DeployedImplementationTypeDefinition)DeployedImplementationType.GOVERNANCE_ACTION_SERVICE_CONNECTOR, ContentPackDefinition.CORE_CONTENT_PACK),
    CSV_FILE_SURVEY("e8edf32a-ec39-437a-8deb-1e32355fea38", "csv-file-survey-service", "CSV File Survey Service", (GovernanceServiceProviderBase)new CSVSurveyServiceProvider(), ResourceUse.SURVEY_RESOURCE, (DeployedImplementationTypeDefinition)DeployedImplementationType.SURVEY_ACTION_SERVICE_CONNECTOR, ContentPackDefinition.CORE_CONTENT_PACK),
    DATA_FILE_SURVEY("8e27e53b-a827-487e-b444-719545c93be5", "data-file-survey-service", "Data File Survey Service", (GovernanceServiceProviderBase)new FileSurveyServiceProvider(), ResourceUse.SURVEY_RESOURCE, (DeployedImplementationTypeDefinition)DeployedImplementationType.SURVEY_ACTION_SERVICE_CONNECTOR, ContentPackDefinition.CORE_CONTENT_PACK),
    FOLDER_SURVEY("0f89211c-15bf-4c69-9d29-0dac3be1fa8b", "folder-survey-service", "Folder (directory) Survey Service", (GovernanceServiceProviderBase)new FolderSurveyServiceProvider(), ResourceUse.SURVEY_RESOURCE, (DeployedImplementationTypeDefinition)DeployedImplementationType.SURVEY_ACTION_SERVICE_CONNECTOR, ContentPackDefinition.CORE_CONTENT_PACK),
    APACHE_ATLAS_SURVEY("ff973b80-d7aa-4c07-a318-be848d4d0b91", "apache-atlas-survey-service", "Apache Atlas Survey Service", (GovernanceServiceProviderBase)new SurveyApacheAtlasProvider(), ResourceUse.SURVEY_RESOURCE, (DeployedImplementationTypeDefinition)DeployedImplementationType.SURVEY_ACTION_SERVICE_CONNECTOR, ContentPackDefinition.APACHE_ATLAS_CONTENT_PACK),
    UC_SERVER_SURVEY("8285b149-5419-4cee-94d2-12eae983c605", "oss-unity-catalog-server-survey-service", "OSS Unity Catalog Server Survey Service", (GovernanceServiceProviderBase)new OSSUnityCatalogServerSurveyProvider(), ResourceUse.SURVEY_RESOURCE, (DeployedImplementationTypeDefinition)DeployedImplementationType.SURVEY_ACTION_SERVICE_CONNECTOR, ContentPackDefinition.UNITY_CATALOG_CONTENT_PACK),
    UC_CATALOG_SURVEY("6f15ffd6-1cbb-4764-a868-7186a92f4b3e", "oss-unity-catalog-inside-catalog-survey-service", "OSS Unity Catalog Inside Catalog Survey Service", (GovernanceServiceProviderBase)new OSSUnityCatalogInsideCatalogSurveyProvider(), ResourceUse.SURVEY_RESOURCE, (DeployedImplementationTypeDefinition)DeployedImplementationType.SURVEY_ACTION_SERVICE_CONNECTOR, ContentPackDefinition.UNITY_CATALOG_CONTENT_PACK),
    UC_SCHEMA_SURVEY("4227dd15-272e-4be9-8918-33df80d5c271", "oss-unity-catalog-inside-schema-survey-service", "OSS Unity Catalog Inside Schema Survey Service", (GovernanceServiceProviderBase)new OSSUnityCatalogInsideSchemaSurveyProvider(), ResourceUse.SURVEY_RESOURCE, (DeployedImplementationTypeDefinition)DeployedImplementationType.SURVEY_ACTION_SERVICE_CONNECTOR, ContentPackDefinition.UNITY_CATALOG_CONTENT_PACK),
    UC_VOLUME_SURVEY("a73554b3-c661-4065-a15e-a31f54d0f1a9", "oss-unity-catalog-volume-survey-service", "Unity Catalog Volume Folder (directory) Survey Service", (GovernanceServiceProviderBase)new OSSUnityCatalogInsideVolumeSurveyProvider(), ResourceUse.SURVEY_RESOURCE, (DeployedImplementationTypeDefinition)DeployedImplementationType.SURVEY_ACTION_SERVICE_CONNECTOR, ContentPackDefinition.UNITY_CATALOG_CONTENT_PACK),
    POSTGRES_SERVER_SURVEY("7ca400d7-ff64-42b0-981e-2a5422818cfc", "postgres-server-survey-service", "PostgreSQL Server Survey Service", (GovernanceServiceProviderBase)new PostgresServerSurveyActionProvider(), ResourceUse.SURVEY_RESOURCE, (DeployedImplementationTypeDefinition)DeployedImplementationType.SURVEY_ACTION_SERVICE_CONNECTOR, ContentPackDefinition.POSTGRES_CONTENT_PACK),
    POSTGRES_DATABASE_SURVEY("08542267-97ec-4bdb-a15a-f5045af758e0", "postgres-database-survey-service", "PostgreSQL Database Survey Service", (GovernanceServiceProviderBase)new PostgresDatabaseSurveyActionProvider(), ResourceUse.SURVEY_RESOURCE, (DeployedImplementationTypeDefinition)DeployedImplementationType.SURVEY_ACTION_SERVICE_CONNECTOR, ContentPackDefinition.POSTGRES_CONTENT_PACK),
    KAFKA_SERVER_SURVEY("540c7db1-20ce-4c4c-a98c-de3e41390c1e", "kafka-server-survey-service", "Apache Kafka Server Survey Service", (GovernanceServiceProviderBase)new SurveyApacheKafkaServerProvider(), ResourceUse.SURVEY_RESOURCE, (DeployedImplementationTypeDefinition)DeployedImplementationType.SURVEY_ACTION_SERVICE_CONNECTOR, ContentPackDefinition.APACHE_KAFKA_CONTENT_PACK),
    CREATE_SERVER("e971749f-4b0e-4c46-b4dd-ca0cf8df3900", "create-server-governance-service", "Create Server Governance Service", (GovernanceServiceProviderBase)new CreateServerGovernanceActionProvider(), ResourceUse.CATALOG_RESOURCE, (DeployedImplementationTypeDefinition)DeployedImplementationType.GOVERNANCE_ACTION_SERVICE_CONNECTOR, ContentPackDefinition.CORE_CONTENT_PACK),
    CATALOG_SERVER("96a01919-a361-404d-bcb7-3855fbbc8cd5", "catalog-server-governance-service", "Catalog Server Governance Service", (GovernanceServiceProviderBase)new CatalogServerGovernanceActionProvider(), ResourceUse.CATALOG_RESOURCE, (DeployedImplementationTypeDefinition)DeployedImplementationType.GOVERNANCE_ACTION_SERVICE_CONNECTOR, ContentPackDefinition.CORE_CONTENT_PACK);

    private final String guid;
    private final String name;
    private final String displayName;
    private final GovernanceServiceProviderBase connectorProvider;
    private final ResourceUse resourceUse;
    private final DeployedImplementationTypeDefinition deployedImplementationType;
    private final ContentPackDefinition contentPackDefinition;

    private GovernanceServiceDefinition(String guid, String name, String displayName, GovernanceServiceProviderBase connectorProvider, ResourceUse resourceUse, DeployedImplementationTypeDefinition deployedImplementationType, ContentPackDefinition contentPackDefinition) {
        this.guid = guid;
        this.name = name;
        this.displayName = displayName;
        this.connectorProvider = connectorProvider;
        this.resourceUse = resourceUse;
        this.deployedImplementationType = deployedImplementationType;
        this.contentPackDefinition = contentPackDefinition;
    }

    public String getGUID() {
        return this.guid;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.connectorProvider.getConnectorType().getDescription();
    }

    public String getConnectorProviderClassName() {
        return this.connectorProvider.getClass().getName();
    }

    public String getDeployedImplementationType() {
        return this.deployedImplementationType.getDeployedImplementationType();
    }

    public String getOpenMetadataTypeName() {
        return this.deployedImplementationType.getAssociatedTypeName();
    }

    public GovernanceActionDescription getGovernanceActionDescription() {
        GovernanceActionDescription governanceActionDescription = new GovernanceActionDescription();
        governanceActionDescription.governanceServiceGUID = this.guid;
        governanceActionDescription.resourceUse = this.resourceUse;
        governanceActionDescription.supportedTechnologies = this.connectorProvider.getSupportedTechnologyTypes();
        governanceActionDescription.supportedRequestTypes = this.connectorProvider.getSupportedRequestTypes();
        governanceActionDescription.supportedRequestParameters = this.connectorProvider.getSupportedRequestParameters();
        governanceActionDescription.supportedActionTargets = this.connectorProvider.getSupportedActionTargetTypes();
        governanceActionDescription.producedRequestParameters = this.connectorProvider.getProducedRequestParameters();
        governanceActionDescription.producedActionTargets = this.connectorProvider.getProducedActionTargetTypes();
        governanceActionDescription.producedGuards = this.connectorProvider.getProducedGuards();
        GovernanceServiceProviderBase governanceServiceProviderBase = this.connectorProvider;
        if (governanceServiceProviderBase instanceof SurveyActionServiceProvider) {
            SurveyActionServiceProvider surveyActionServiceProvider = (SurveyActionServiceProvider)governanceServiceProviderBase;
            governanceActionDescription.supportedAnalysisSteps = surveyActionServiceProvider.getSupportedAnalysisSteps();
            governanceActionDescription.supportedAnnotationTypes = surveyActionServiceProvider.getProducedAnnotationTypes();
        }
        governanceActionDescription.governanceServiceDescription = this.getDescription();
        return governanceActionDescription;
    }

    public ContentPackDefinition getContentPackDefinition() {
        return this.contentPackDefinition;
    }

    public String toString() {
        return "GovernanceServiceDefinition{name='" + this.name + "'}";
    }
}

