/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.archiveutilities.openconnectors.core;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.apachekafka.control.KafkaPlaceholderProperty;
import org.odpi.openmetadata.adapters.connectors.datastore.basicfile.BasicFileStoreProvider;
import org.odpi.openmetadata.adapters.connectors.datastore.basicfile.BasicFolderProvider;
import org.odpi.openmetadata.adapters.connectors.datastore.csvfile.CSVFileStoreProvider;
import org.odpi.openmetadata.adapters.connectors.datastore.datafolder.DataFolderProvider;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.control.EgeriaDeployedImplementationType;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.control.EgeriaSoftwareServerTemplateDefinition;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.platform.OMAGServerPlatformProvider;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.platform.catalog.OMAGServerPlatformCatalogProvider;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.servers.EngineHostProvider;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.servers.IntegrationDaemonProvider;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.servers.MetadataAccessServerProvider;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.servers.OMAGServerProvider;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.servers.ViewServerProvider;
import org.odpi.openmetadata.adapters.connectors.governanceactions.stewardship.DaysOfWeekGuard;
import org.odpi.openmetadata.adapters.connectors.governanceactions.stewardship.WriteAuditLogRequestParameter;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.DataFilesMonitorIntegrationProvider;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.DataFolderMonitorIntegrationProvider;
import org.odpi.openmetadata.adapters.connectors.integration.csvlineageimporter.CSVLineageImporterProvider;
import org.odpi.openmetadata.adapters.connectors.integration.jdbc.JDBCIntegrationConnectorProvider;
import org.odpi.openmetadata.adapters.connectors.integration.kafkaaudit.DistributeAuditEventsFromKafkaProvider;
import org.odpi.openmetadata.adapters.connectors.integration.openlineage.APIBasedOpenLineageLogStoreProvider;
import org.odpi.openmetadata.adapters.connectors.integration.openlineage.FileBasedOpenLineageLogStoreProvider;
import org.odpi.openmetadata.adapters.connectors.integration.openlineage.GovernanceActionOpenLineageIntegrationProvider;
import org.odpi.openmetadata.adapters.connectors.integration.openlineage.OpenLineageCataloguerIntegrationProvider;
import org.odpi.openmetadata.adapters.connectors.integration.openlineage.OpenLineageEventReceiverIntegrationProvider;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.JDBCResourceConnectorProvider;
import org.odpi.openmetadata.adapters.connectors.secretsstore.envar.EnvVarSecretsStoreProvider;
import org.odpi.openmetadata.adapters.connectors.secretsstore.yaml.YAMLSecretsStoreProvider;
import org.odpi.openmetadata.adapters.eventbus.topic.kafka.KafkaOpenMetadataTopicProvider;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.CommonServicesDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.EngineServiceDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.GovernanceServicesDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.IntegrationServiceDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.ViewServiceDescription;
import org.odpi.openmetadata.archiveutilities.openconnectors.ContentPackDefinition;
import org.odpi.openmetadata.archiveutilities.openconnectors.EndpointTemplateDefinition;
import org.odpi.openmetadata.archiveutilities.openconnectors.GovernanceEngineDefinition;
import org.odpi.openmetadata.archiveutilities.openconnectors.IntegrationGroupDefinition;
import org.odpi.openmetadata.archiveutilities.openconnectors.RequestTypeDefinition;
import org.odpi.openmetadata.archiveutilities.openconnectors.base.ContentPackBaseArchiveWriter;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDevelopmentStatus;
import org.odpi.openmetadata.frameworks.connectors.ConnectorProvider;
import org.odpi.openmetadata.frameworks.connectors.controls.SecretsStoreConfigurationProperty;
import org.odpi.openmetadata.frameworks.integration.connectors.IntegrationConnectorProvider;
import org.odpi.openmetadata.frameworks.openmetadata.controls.PlaceholderProperty;
import org.odpi.openmetadata.frameworks.openmetadata.controls.PlaceholderPropertyType;
import org.odpi.openmetadata.frameworks.openmetadata.controls.ReplacementAttributeType;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ByteOrdering;
import org.odpi.openmetadata.frameworks.openmetadata.enums.CollectionMemberStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.CommentType;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ConfidenceLevel;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ConfidentialityLevel;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ContactMethodType;
import org.odpi.openmetadata.frameworks.openmetadata.enums.CriticalityLevel;
import org.odpi.openmetadata.frameworks.openmetadata.enums.DataClassAssignmentStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.DataItemSortOrder;
import org.odpi.openmetadata.frameworks.openmetadata.enums.DeleteMethod;
import org.odpi.openmetadata.frameworks.openmetadata.enums.EngineActionStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.GlossaryTermActivityType;
import org.odpi.openmetadata.frameworks.openmetadata.enums.GlossaryTermAssignmentStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.GlossaryTermRelationshipStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.GovernanceClassificationStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ImpactSeverity;
import org.odpi.openmetadata.frameworks.openmetadata.enums.IncidentReportStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.KeyPattern;
import org.odpi.openmetadata.frameworks.openmetadata.enums.MediaType;
import org.odpi.openmetadata.frameworks.openmetadata.enums.MediaUsage;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OpenMetadataEnum;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OperationalStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ProcessContainmentType;
import org.odpi.openmetadata.frameworks.openmetadata.enums.RetentionBasis;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ServerAssetUseType;
import org.odpi.openmetadata.frameworks.openmetadata.enums.StarRating;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ToDoStatus;
import org.odpi.openmetadata.frameworks.openmetadata.mapper.OpenMetadataValidValues;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.CollectionType;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationType;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationTypeDefinition;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.FileExtension;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.FileName;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.FileType;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.ProjectHealth;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.ProjectPhase;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.ProjectStatus;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.ResourceUse;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.ResourceUseProperties;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.SpecificationPropertyType;
import org.odpi.openmetadata.frameworks.openmetadata.types.DataType;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;

public class CorePackArchiveWriter
extends ContentPackBaseArchiveWriter {
    private static final String connectorTypeDirectoryQualifiedName = "OpenMetadataConnectorTypeDirectory_09450b83-20ff-4a8b-a8fb-f9b527bbcba6";
    private static final String connectorTypeDirectoryDisplayName = "Open Metadata Connector Type Directory";
    private static final String connectorTypeDirectoryDescription = "Open Metadata standard connector categories and connector types.";
    private static final String fileConnectorCategoryQualifiedName = "OpenMetadataFileConnectorCategory_09450b83-20ff-4a8b-a8fb-f9b527bbcba6";
    private static final String fileConnectorCategoryDisplayName = "Open Metadata File Connector Category";
    private static final String fileConnectorCategoryDescription = "Open Metadata connector category for connectors that work with files.";
    private static final String kafkaConnectorCategoryQualifiedName = "OpenMetadataKafkaConnectorCategory_09450b83-20ff-4a8b-a8fb-f9b527bbcba6";
    private static final String kafkaConnectorCategoryDisplayName = "Open Metadata Apache Kafka Connector Category";
    private static final String kafkaConnectorCategoryDescription = "Open Metadata connector category for connectors to Apache Kafka.";
    private static final String kafkaConnectorCategoryTargetSource = "Apache Software Foundation (ASF)";
    private static final String kafkaConnectorCategoryTargetName = "Apache Kafka";
    private static final String relationalConnectorCategoryQualifiedName = "OpenMetadataJDBCConnectorCategory_09450b83-20ff-4a8b-a8fb-f9b527bbcba6";
    private static final String relationalConnectorCategoryDisplayName = "Open Metadata JDBC Connector Category";
    private static final String relationalConnectorCategoryDescription = "Open Metadata connector category for connectors to relational databases.";
    private static final String relationalConnectorCategoryTargetSource = "Java Database Connector (JDBC)";
    private static final String relationalConnectorCategoryTargetName = "Relational Database";

    public CorePackArchiveWriter() {
        super(ContentPackDefinition.CORE_CONTENT_PACK.getArchiveGUID(), ContentPackDefinition.CORE_CONTENT_PACK.getArchiveName(), ContentPackDefinition.CORE_CONTENT_PACK.getArchiveDescription(), new Date(), ContentPackDefinition.CORE_CONTENT_PACK.getArchiveFileName(), null);
    }

    /*
     * WARNING - void declaration
     */
    public void getArchiveContent() {
        void var14_68;
        void var14_66;
        void var14_64;
        void var14_62;
        void var14_60;
        void var14_58;
        void var14_56;
        void var14_54;
        String guid;
        void var14_52;
        void var13_38;
        void var13_36;
        void var9_15;
        String connectorDirectoryTypeGUID = this.archiveHelper.addConnectorTypeDirectory(connectorTypeDirectoryQualifiedName, connectorTypeDirectoryDisplayName, connectorTypeDirectoryDescription, null);
        String fileConnectorCategoryGUID = this.archiveHelper.addConnectorCategory(connectorDirectoryTypeGUID, fileConnectorCategoryQualifiedName, fileConnectorCategoryDisplayName, fileConnectorCategoryDescription, null, null, null, null, null, null);
        String kafkaConnectorCategoryGUID = this.archiveHelper.addConnectorCategory(connectorDirectoryTypeGUID, kafkaConnectorCategoryQualifiedName, kafkaConnectorCategoryDisplayName, kafkaConnectorCategoryDescription, kafkaConnectorCategoryTargetSource, kafkaConnectorCategoryTargetName, null, null, null, null);
        String relationalConnectorCategoryGUID = this.archiveHelper.addConnectorCategory(connectorDirectoryTypeGUID, relationalConnectorCategoryQualifiedName, relationalConnectorCategoryDisplayName, relationalConnectorCategoryDescription, relationalConnectorCategoryTargetSource, relationalConnectorCategoryTargetName, null, null, null, null);
        String resourceUseParentSetGUID = this.getParentSet(null, OpenMetadataType.RESOURCE_LIST_RELATIONSHIP.typeName, OpenMetadataProperty.RESOURCE_USE.name, null);
        for (ResourceUse resourceUse : ResourceUse.values()) {
            HashMap<String, String> additionalProperties = null;
            if (resourceUse.getResourceUseProperties() != null) {
                additionalProperties = new HashMap<String, String>();
                for (ResourceUseProperties resourceUseProperties : resourceUse.getResourceUseProperties()) {
                    additionalProperties.put(resourceUseProperties.getName(), resourceUseProperties.getDescription());
                }
            }
            this.archiveHelper.addValidValue(null, resourceUseParentSetGUID, resourceUseParentSetGUID, OpenMetadataType.VALID_VALUE_SET.typeName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, OpenMetadataType.VALID_VALUE_SET.typeName, resourceUse.getQualifiedName(), resourceUse.getResourceUse(), resourceUse.getDescription(), resourceUse.getCategory(), "Used to control valid values in open metadata.", "string", "Open Metadata Ecosystem", resourceUse.getResourceUse(), false, false, additionalProperties);
        }
        for (ResourceUse resourceUse : ResourceUseProperties.values()) {
            this.getParentSet(null, OpenMetadataType.RESOURCE_LIST_RELATIONSHIP.typeName, OpenMetadataProperty.RESOURCE_USE_PROPERTIES.name, resourceUse.getName());
        }
        String projectPhaseParentSetGUID = this.getParentSet(null, OpenMetadataType.PROJECT.typeName, OpenMetadataProperty.PROJECT_PHASE.name, null);
        ProjectPhase[] projectPhaseArray = ProjectPhase.values();
        int n = projectPhaseArray.length;
        boolean bl = false;
        while (var9_15 < n) {
            ProjectPhase projectStatus = projectPhaseArray[var9_15];
            this.archiveHelper.addValidValue(null, projectPhaseParentSetGUID, projectPhaseParentSetGUID, OpenMetadataType.VALID_VALUE_SET.typeName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, OpenMetadataType.VALID_VALUE_SET.typeName, projectStatus.getQualifiedName(), projectStatus.getName(), projectStatus.getDescription(), projectStatus.getCategory(), "Used to control valid values in open metadata.", "string", "Open Metadata Ecosystem", projectStatus.getName(), false, false, null);
            ++var9_15;
        }
        String projectHealthParentSetGUID = this.getParentSet(null, OpenMetadataType.PROJECT.typeName, OpenMetadataProperty.PROJECT_HEALTH.name, null);
        for (ProjectHealth projectHealth : ProjectHealth.values()) {
            HashMap<String, String> additionalProperties = new HashMap<String, String>();
            additionalProperties.put("colour", projectHealth.getColour());
            this.archiveHelper.addValidValue(null, projectHealthParentSetGUID, projectHealthParentSetGUID, OpenMetadataType.VALID_VALUE_SET.typeName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, OpenMetadataType.VALID_VALUE_SET.typeName, projectHealth.getQualifiedName(), projectHealth.getName(), projectHealth.getDescription(), projectHealth.getCategory(), "Used to control valid values in open metadata.", "string", "Open Metadata Ecosystem", projectHealth.getName(), false, false, additionalProperties);
        }
        String projectStatusParentSetGUID = this.getParentSet(null, OpenMetadataType.PROJECT.typeName, OpenMetadataProperty.PROJECT_STATUS.name, null);
        for (ProjectStatus projectStatus : ProjectStatus.values()) {
            this.archiveHelper.addValidValue(null, projectStatusParentSetGUID, projectStatusParentSetGUID, OpenMetadataType.VALID_VALUE_SET.typeName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, OpenMetadataType.VALID_VALUE_SET.typeName, projectStatus.getQualifiedName(), projectStatus.getName(), projectStatus.getDescription(), projectStatus.getCategory(), "Used to control valid values in open metadata.", "string", "Open Metadata Ecosystem", projectStatus.getName(), false, false, null);
        }
        String string = this.getParentSet(null, OpenMetadataType.COLLECTION.typeName, OpenMetadataProperty.COLLECTION_TYPE.name, null);
        for (CollectionType collectionType : CollectionType.values()) {
            this.archiveHelper.addValidValue(null, string, string, OpenMetadataType.VALID_VALUE_SET.typeName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, OpenMetadataType.VALID_VALUE_SET.typeName, collectionType.getQualifiedName(), collectionType.getName(), collectionType.getDescription(), collectionType.getCategory(), "Used to control valid values in open metadata.", "string", "Open Metadata Ecosystem", collectionType.getName(), false, false, null);
        }
        for (CollectionType collectionType : OpenMetadataType.values()) {
            this.addOpenMetadataType((OpenMetadataType)collectionType);
        }
        this.addOpenMetadataEnumValidNames(OpenMetadataType.OPERATING_PLATFORM.typeName, OpenMetadataProperty.BYTE_ORDERING.name, ByteOrdering.getOpenTypeName(), new ArrayList<ByteOrdering>(Arrays.asList(ByteOrdering.values())));
        this.addOpenMetadataEnumValidNames(null, OpenMetadataProperty.OPERATIONAL_STATUS.name, OperationalStatus.getOpenTypeName(), new ArrayList<OperationalStatus>(Arrays.asList(OperationalStatus.values())));
        this.addOpenMetadataEnumValidNames("CatalogTarget", OpenMetadataProperty.DELETE_METHOD.name, DeleteMethod.getOpenTypeName(), new ArrayList<DeleteMethod>(Arrays.asList(DeleteMethod.values())));
        this.addOpenMetadataEnumValidNames(OpenMetadataType.EXTERNAL_ID.typeName, OpenMetadataProperty.KEY_PATTERN.name, KeyPattern.getOpenTypeName(), new ArrayList<KeyPattern>(Arrays.asList(KeyPattern.values())));
        this.addOpenMetadataEnumValidNames("PrimaryKey", OpenMetadataProperty.KEY_PATTERN.name, KeyPattern.getOpenTypeName(), new ArrayList<KeyPattern>(Arrays.asList(KeyPattern.values())));
        this.addOpenMetadataEnumValidNames(OpenMetadataType.COLLECTION_MEMBERSHIP_RELATIONSHIP.typeName, OpenMetadataProperty.MEMBERSHIP_STATUS.name, CollectionMemberStatus.getOpenTypeName(), new ArrayList<CollectionMemberStatus>(Arrays.asList(CollectionMemberStatus.values())));
        this.addOpenMetadataEnumValidNames(OpenMetadataType.COMMENT.typeName, OpenMetadataProperty.COMMENT_TYPE.name, CommentType.getOpenTypeName(), new ArrayList<CommentType>(Arrays.asList(CommentType.values())));
        this.addOpenMetadataEnumValidIdentifiers(OpenMetadataType.CONFIDENCE_CLASSIFICATION.typeName, OpenMetadataProperty.CONFIDENCE_LEVEL_IDENTIFIER.name, new ArrayList<ConfidenceLevel>(Arrays.asList(ConfidenceLevel.values())));
        this.addOpenMetadataEnumValidIdentifiers(OpenMetadataType.CONFIDENTIALITY_CLASSIFICATION.typeName, OpenMetadataProperty.CONFIDENTIALITY_LEVEL_IDENTIFIER.name, new ArrayList<ConfidentialityLevel>(Arrays.asList(ConfidentialityLevel.values())));
        this.addOpenMetadataEnumValidNames(OpenMetadataType.CONTACT_DETAILS.typeName, OpenMetadataProperty.CONTACT_METHOD_TYPE.name, ContactMethodType.getOpenTypeName(), new ArrayList<ContactMethodType>(Arrays.asList(ContactMethodType.values())));
        this.addOpenMetadataEnumValidIdentifiers(OpenMetadataType.CRITICALITY_CLASSIFICATION.typeName, OpenMetadataProperty.CRITICALITY_LEVEL_IDENTIFIER.name, new ArrayList<CriticalityLevel>(Arrays.asList(CriticalityLevel.values())));
        this.addOpenMetadataEnumValidNames(OpenMetadataType.DATA_CLASS_ASSIGNMENT.typeName, OpenMetadataProperty.DATA_CLASS_ASSIGNMENT_STATUS.name, DataClassAssignmentStatus.getOpenTypeName(), new ArrayList<DataClassAssignmentStatus>(Arrays.asList(DataClassAssignmentStatus.values())));
        this.addOpenMetadataEnumValidNames(OpenMetadataType.SCHEMA_ATTRIBUTE.typeName, OpenMetadataProperty.SORT_ORDER.name, DataItemSortOrder.getOpenTypeName(), new ArrayList<DataItemSortOrder>(Arrays.asList(DataItemSortOrder.values())));
        this.addOpenMetadataEnumValidNames(OpenMetadataType.DATA_FIELD.typeName, OpenMetadataProperty.DATA_FIELD_SORT_ORDER.name, DataItemSortOrder.getOpenTypeName(), new ArrayList<DataItemSortOrder>(Arrays.asList(DataItemSortOrder.values())));
        this.addOpenMetadataEnumValidNames(OpenMetadataType.ENGINE_ACTION.typeName, OpenMetadataProperty.ACTION_STATUS.name, EngineActionStatus.getOpenTypeName(), new ArrayList<EngineActionStatus>(Arrays.asList(EngineActionStatus.values())));
        this.addOpenMetadataEnumValidNames(OpenMetadataType.TARGET_FOR_ACTION.typeName, OpenMetadataProperty.ACTION_STATUS.name, EngineActionStatus.getOpenTypeName(), new ArrayList<EngineActionStatus>(Arrays.asList(EngineActionStatus.values())));
        this.addOpenMetadataEnumValidNames(OpenMetadataType.ACTIVITY_DESCRIPTION_CLASSIFICATION.typeName, OpenMetadataProperty.ACTIVITY_TYPE.name, GlossaryTermActivityType.getOpenTypeName(), new ArrayList<GlossaryTermActivityType>(Arrays.asList(GlossaryTermActivityType.values())));
        this.addOpenMetadataEnumValidNames(OpenMetadataType.SEMANTIC_ASSIGNMENT.typeName, OpenMetadataProperty.TERM_ASSIGNMENT_STATUS.name, GlossaryTermAssignmentStatus.getOpenTypeName(), new ArrayList<GlossaryTermAssignmentStatus>(Arrays.asList(GlossaryTermAssignmentStatus.values())));
        this.addOpenMetadataEnumValidNames(OpenMetadataType.TERM_CATEGORIZATION.typeName, OpenMetadataProperty.TERM_RELATIONSHIP_STATUS.name, GlossaryTermRelationshipStatus.getOpenTypeName(), new ArrayList<GlossaryTermRelationshipStatus>(Arrays.asList(GlossaryTermRelationshipStatus.values())));
        this.addOpenMetadataEnumValidNames("RelatedTerm", OpenMetadataProperty.TERM_RELATIONSHIP_STATUS.name, GlossaryTermRelationshipStatus.getOpenTypeName(), new ArrayList<GlossaryTermRelationshipStatus>(Arrays.asList(GlossaryTermRelationshipStatus.values())));
        this.addOpenMetadataEnumValidNames(OpenMetadataType.USED_IN_CONTEXT.typeName, OpenMetadataProperty.TERM_RELATIONSHIP_STATUS.name, GlossaryTermRelationshipStatus.getOpenTypeName(), new ArrayList<GlossaryTermRelationshipStatus>(Arrays.asList(GlossaryTermRelationshipStatus.values())));
        this.addOpenMetadataEnumValidIdentifiers(null, OpenMetadataProperty.STATUS_IDENTIFIER.name, new ArrayList<GovernanceClassificationStatus>(Arrays.asList(GovernanceClassificationStatus.values())));
        this.addOpenMetadataEnumValidIdentifiers(OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeName, OpenMetadataProperty.USE_TYPE.name, new ArrayList<ServerAssetUseType>(Arrays.asList(ServerAssetUseType.values())));
        this.addOpenMetadataEnumValidIdentifiers(null, OpenMetadataProperty.SEVERITY_IDENTIFIER.name, new ArrayList<ImpactSeverity>(Arrays.asList(ImpactSeverity.values())));
        this.addOpenMetadataEnumValidNames(OpenMetadataType.INCIDENT_REPORT.typeName, OpenMetadataProperty.INCIDENT_STATUS.name, IncidentReportStatus.getOpenTypeName(), new ArrayList<IncidentReportStatus>(Arrays.asList(IncidentReportStatus.values())));
        this.addOpenMetadataEnumValidIdentifiers(OpenMetadataType.RETENTION_CLASSIFICATION.typeName, OpenMetadataProperty.RETENTION_BASIS_IDENTIFIER.name, new ArrayList<RetentionBasis>(Arrays.asList(RetentionBasis.values())));
        this.addOpenMetadataEnumValidNames(OpenMetadataType.RATING.typeName, OpenMetadataProperty.STARS.name, StarRating.getOpenTypeName(), new ArrayList<StarRating>(Arrays.asList(StarRating.values())));
        this.addOpenMetadataEnumValidNames(OpenMetadataType.EXTERNAL_ID_SCOPE_RELATIONSHIP.typeName, OpenMetadataProperty.PERMITTED_SYNCHRONIZATION.name, PermittedSynchronization.getOpenTypeName(), new ArrayList<PermittedSynchronization>(Arrays.asList(PermittedSynchronization.values())));
        this.addOpenMetadataEnumValidNames("RegisteredIntegrationConnector", OpenMetadataProperty.PERMITTED_SYNCHRONIZATION.name, PermittedSynchronization.getOpenTypeName(), new ArrayList<PermittedSynchronization>(Arrays.asList(PermittedSynchronization.values())));
        this.addOpenMetadataEnumValidNames("CatalogTarget", OpenMetadataProperty.PERMITTED_SYNCHRONIZATION.name, PermittedSynchronization.getOpenTypeName(), new ArrayList<PermittedSynchronization>(Arrays.asList(PermittedSynchronization.values())));
        this.addOpenMetadataEnumValidNames(OpenMetadataType.TO_DO.typeName, OpenMetadataProperty.TO_DO_STATUS.name, ToDoStatus.getOpenTypeName(), new ArrayList<ToDoStatus>(Arrays.asList(ToDoStatus.values())));
        this.addOpenMetadataEnumValidNames("ProcessHierarchy", "containmentType", ProcessContainmentType.getOpenTypeName(), new ArrayList<ProcessContainmentType>(Arrays.asList(ProcessContainmentType.values())));
        this.addOpenMetadataEnumValidNames(OpenMetadataType.RELATED_MEDIA.typeName, OpenMetadataProperty.MEDIA_TYPE.name, MediaType.getOpenTypeName(), new ArrayList<MediaType>(Arrays.asList(MediaType.values())));
        this.addOpenMetadataEnumValidNames(OpenMetadataType.RELATED_MEDIA.typeName, OpenMetadataProperty.DEFAULT_MEDIA_USAGE.name, MediaUsage.getOpenTypeName(), new ArrayList<MediaUsage>(Arrays.asList(MediaUsage.values())));
        this.addOpenMetadataEnumValidNames(OpenMetadataType.MEDIA_REFERENCE_RELATIONSHIP.typeName, OpenMetadataProperty.MEDIA_USAGE.name, MediaUsage.getOpenTypeName(), new ArrayList<MediaUsage>(Arrays.asList(MediaUsage.values())));
        for (CollectionType collectionType : DeployedImplementationType.values()) {
            this.addDeployedImplementationType(collectionType.getDeployedImplementationType(), collectionType.getAssociatedTypeName(), collectionType.getQualifiedName(), collectionType.getCategory(), collectionType.getDescription(), collectionType.getWikiLink());
        }
        for (CollectionType collectionType : EgeriaDeployedImplementationType.values()) {
            this.addDeployedImplementationType(collectionType.getDeployedImplementationType(), collectionType.getAssociatedTypeName(), collectionType.getQualifiedName(), collectionType.getCategory(), collectionType.getDescription(), collectionType.getWikiLink());
        }
        HashMap<String, String> serviceGUIDs = new HashMap<String, String>();
        CommonServicesDescription[] projectHealth = CommonServicesDescription.values();
        int n2 = projectHealth.length;
        boolean bl2 = false;
        while (var13_36 < n2) {
            CommonServicesDescription commonServicesDescription = projectHealth[var13_36];
            if (commonServicesDescription.getServiceDevelopmentStatus() != ComponentDevelopmentStatus.DEPRECATED) {
                String string2 = this.addDeployedImplementationType(commonServicesDescription.getServiceName(), OpenMetadataType.SOFTWARE_SERVICE.typeName, commonServicesDescription.getServiceDescription(), commonServicesDescription.getServiceWiki());
                serviceGUIDs.put(commonServicesDescription.getServiceName(), string2);
            }
            ++var13_36;
        }
        projectHealth = GovernanceServicesDescription.values();
        n2 = projectHealth.length;
        boolean bl3 = false;
        while (var13_38 < n2) {
            CommonServicesDescription commonServicesDescription = projectHealth[var13_38];
            if (commonServicesDescription.getServiceDevelopmentStatus() != ComponentDevelopmentStatus.DEPRECATED) {
                String string3 = this.addDeployedImplementationType(commonServicesDescription.getServiceName(), OpenMetadataType.SOFTWARE_SERVICE.typeName, commonServicesDescription.getServiceDescription(), commonServicesDescription.getServiceWiki());
                serviceGUIDs.put(commonServicesDescription.getServiceName(), string3);
            }
            ++var13_38;
        }
        String serverTypeGUID = this.archiveHelper.queryGUID((String)this.deployedImplementationTypeQNAMEs.get(EgeriaDeployedImplementationType.METADATA_ACCESS_SERVER.getDeployedImplementationType()));
        AccessServiceDescription[] accessServiceDescriptionArray = AccessServiceDescription.values();
        int n3 = accessServiceDescriptionArray.length;
        boolean bl4 = false;
        while (var14_52 < n3) {
            AccessServiceDescription accessServiceDescription = accessServiceDescriptionArray[var14_52];
            if (accessServiceDescription.getAccessServiceDevelopmentStatus() != ComponentDevelopmentStatus.DEPRECATED) {
                guid = this.addDeployedImplementationType(accessServiceDescription.getAccessServiceFullName(), OpenMetadataType.SOFTWARE_SERVICE.typeName, accessServiceDescription.getAccessServiceDescription(), accessServiceDescription.getAccessServiceWiki());
                serviceGUIDs.put(accessServiceDescription.getAccessServiceFullName(), guid);
                this.archiveHelper.addResourceListRelationshipByGUID(serverTypeGUID, guid, ResourceUse.HOSTED_SERVICE.getResourceUse(), ResourceUse.HOSTED_SERVICE.getDescription());
            }
            ++var14_52;
        }
        serverTypeGUID = this.archiveHelper.queryGUID((String)this.deployedImplementationTypeQNAMEs.get(EgeriaDeployedImplementationType.VIEW_SERVER.getDeployedImplementationType()));
        accessServiceDescriptionArray = ViewServiceDescription.values();
        int n4 = accessServiceDescriptionArray.length;
        boolean bl5 = false;
        while (var14_54 < n4) {
            AccessServiceDescription accessServiceDescription = accessServiceDescriptionArray[var14_54];
            if (accessServiceDescription.getViewServiceDevelopmentStatus() != ComponentDevelopmentStatus.DEPRECATED) {
                guid = this.addDeployedImplementationType(accessServiceDescription.getViewServiceFullName(), OpenMetadataType.SOFTWARE_SERVICE.typeName, accessServiceDescription.getViewServiceDescription(), accessServiceDescription.getViewServiceWiki());
                this.archiveHelper.addResourceListRelationshipByGUID(serverTypeGUID, guid, ResourceUse.HOSTED_SERVICE.getResourceUse(), ResourceUse.HOSTED_SERVICE.getDescription());
                this.archiveHelper.addResourceListRelationshipByGUID(guid, (String)serviceGUIDs.get(accessServiceDescription.getViewServicePartnerService()), ResourceUse.CALLED_SERVICE.getResourceUse(), ResourceUse.CALLED_SERVICE.getDescription());
            }
            ++var14_54;
        }
        serverTypeGUID = this.archiveHelper.queryGUID((String)this.deployedImplementationTypeQNAMEs.get(EgeriaDeployedImplementationType.ENGINE_HOST.getDeployedImplementationType()));
        accessServiceDescriptionArray = EngineServiceDescription.values();
        int n5 = accessServiceDescriptionArray.length;
        boolean bl6 = false;
        while (var14_56 < n5) {
            AccessServiceDescription accessServiceDescription = accessServiceDescriptionArray[var14_56];
            if (accessServiceDescription.getEngineServiceDevelopmentStatus() != ComponentDevelopmentStatus.DEPRECATED) {
                guid = this.addDeployedImplementationType(accessServiceDescription.getEngineServiceFullName(), OpenMetadataType.SOFTWARE_SERVICE.typeName, accessServiceDescription.getEngineServiceDescription(), accessServiceDescription.getEngineServiceWiki());
                this.archiveHelper.addResourceListRelationshipByGUID(serverTypeGUID, guid, ResourceUse.HOSTED_SERVICE.getResourceUse(), ResourceUse.HOSTED_SERVICE.getDescription());
                this.archiveHelper.addResourceListRelationshipByGUID(guid, (String)serviceGUIDs.get(accessServiceDescription.getEngineServicePartnerService()), ResourceUse.CALLED_SERVICE.getResourceUse(), ResourceUse.CALLED_SERVICE.getDescription());
                String governanceEngineGUID = this.archiveHelper.queryGUID((String)this.deployedImplementationTypeQNAMEs.get(accessServiceDescription.getHostedGovernanceEngineDeployedImplementationType()));
                String governanceServiceGUID = this.archiveHelper.queryGUID((String)this.deployedImplementationTypeQNAMEs.get(accessServiceDescription.getHostedGovernanceServiceDeployedImplementationType()));
                if (governanceEngineGUID != null) {
                    this.archiveHelper.addResourceListRelationshipByGUID(guid, governanceEngineGUID, ResourceUse.HOSTED_GOVERNANCE_ENGINE.getResourceUse(), ResourceUse.HOSTED_GOVERNANCE_ENGINE.getDescription());
                    if (governanceServiceGUID != null) {
                        this.archiveHelper.addResourceListRelationshipByGUID(governanceEngineGUID, governanceServiceGUID, ResourceUse.HOSTED_CONNECTOR.getResourceUse(), ResourceUse.HOSTED_CONNECTOR.getDescription());
                    }
                }
            }
            ++var14_56;
        }
        serverTypeGUID = this.archiveHelper.queryGUID((String)this.deployedImplementationTypeQNAMEs.get(EgeriaDeployedImplementationType.INTEGRATION_DAEMON.getDeployedImplementationType()));
        accessServiceDescriptionArray = IntegrationServiceDescription.values();
        int n6 = accessServiceDescriptionArray.length;
        boolean bl7 = false;
        while (var14_58 < n6) {
            AccessServiceDescription accessServiceDescription = accessServiceDescriptionArray[var14_58];
            if (accessServiceDescription.getIntegrationServiceDevelopmentStatus() != ComponentDevelopmentStatus.DEPRECATED) {
                guid = this.addDeployedImplementationType(accessServiceDescription.getIntegrationServiceFullName(), OpenMetadataType.SOFTWARE_SERVICE.typeName, accessServiceDescription.getIntegrationServiceDescription(), accessServiceDescription.getIntegrationServiceWiki());
                this.archiveHelper.addResourceListRelationshipByGUID(serverTypeGUID, guid, ResourceUse.HOSTED_SERVICE.getResourceUse(), ResourceUse.HOSTED_SERVICE.getDescription());
                this.archiveHelper.addResourceListRelationshipByGUID(guid, (String)serviceGUIDs.get(accessServiceDescription.getIntegrationServicePartnerOMAS().getAccessServiceFullName()), ResourceUse.CALLED_SERVICE.getResourceUse(), ResourceUse.CALLED_SERVICE.getDescription());
                String connectorTypeGUID = this.archiveHelper.queryGUID((String)this.deployedImplementationTypeQNAMEs.get(accessServiceDescription.getConnectorDeployedImplementationType()));
                if (connectorTypeGUID != null) {
                    this.archiveHelper.addResourceListRelationshipByGUID(guid, connectorTypeGUID, ResourceUse.HOSTED_CONNECTOR.getResourceUse(), ResourceUse.HOSTED_CONNECTOR.getDescription());
                }
            }
            ++var14_58;
        }
        accessServiceDescriptionArray = FileType.values();
        int n7 = accessServiceDescriptionArray.length;
        boolean bl8 = false;
        while (var14_60 < n7) {
            AccessServiceDescription accessServiceDescription = accessServiceDescriptionArray[var14_60];
            this.addFileType(accessServiceDescription.getFileTypeName(), accessServiceDescription.getEncoding(), accessServiceDescription.getAssetSubTypeName(), accessServiceDescription.getDeployedImplementationType(), accessServiceDescription.getDescription());
            ++var14_60;
        }
        accessServiceDescriptionArray = FileName.values();
        int n8 = accessServiceDescriptionArray.length;
        boolean bl9 = false;
        while (var14_62 < n8) {
            AccessServiceDescription accessServiceDescription = accessServiceDescriptionArray[var14_62];
            this.addFileName(accessServiceDescription.getFileName(), accessServiceDescription.getFileType(), accessServiceDescription.getFileType().getDeployedImplementationType());
            ++var14_62;
        }
        accessServiceDescriptionArray = FileExtension.values();
        int n9 = accessServiceDescriptionArray.length;
        boolean bl10 = false;
        while (var14_64 < n9) {
            AccessServiceDescription accessServiceDescription = accessServiceDescriptionArray[var14_64];
            this.addFileExtension(accessServiceDescription.getFileExtension(), accessServiceDescription.getFileTypes());
            ++var14_64;
        }
        accessServiceDescriptionArray = SpecificationPropertyType.values();
        int n10 = accessServiceDescriptionArray.length;
        boolean bl11 = false;
        while (var14_66 < n10) {
            AccessServiceDescription accessServiceDescription = accessServiceDescriptionArray[var14_66];
            this.addAttributeName(accessServiceDescription.getPropertyType(), accessServiceDescription.getDescription());
            ++var14_66;
        }
        this.archiveHelper.addConnectorType(fileConnectorCategoryGUID, (ConnectorProvider)new CSVFileStoreProvider());
        this.archiveHelper.addConnectorType(fileConnectorCategoryGUID, (ConnectorProvider)new DataFolderProvider());
        this.archiveHelper.addConnectorType(fileConnectorCategoryGUID, (ConnectorProvider)new BasicFileStoreProvider());
        this.archiveHelper.addConnectorType(fileConnectorCategoryGUID, (ConnectorProvider)new BasicFolderProvider());
        this.archiveHelper.addConnectorType(relationalConnectorCategoryGUID, (ConnectorProvider)new JDBCResourceConnectorProvider());
        this.archiveHelper.addConnectorType(kafkaConnectorCategoryGUID, (ConnectorProvider)new KafkaOpenMetadataTopicProvider());
        this.archiveHelper.addConnectorType(null, (ConnectorProvider)new EnvVarSecretsStoreProvider());
        this.archiveHelper.addConnectorType(null, (ConnectorProvider)new YAMLSecretsStoreProvider());
        this.archiveHelper.addConnectorType(null, (IntegrationConnectorProvider)new CSVLineageImporterProvider());
        this.archiveHelper.addConnectorType(null, (IntegrationConnectorProvider)new DataFilesMonitorIntegrationProvider());
        this.archiveHelper.addConnectorType(null, (IntegrationConnectorProvider)new DataFolderMonitorIntegrationProvider());
        this.archiveHelper.addConnectorType(null, (IntegrationConnectorProvider)new JDBCIntegrationConnectorProvider());
        this.archiveHelper.addConnectorType(null, (IntegrationConnectorProvider)new DistributeAuditEventsFromKafkaProvider());
        this.archiveHelper.addConnectorType(null, (IntegrationConnectorProvider)new APIBasedOpenLineageLogStoreProvider());
        this.archiveHelper.addConnectorType(null, (IntegrationConnectorProvider)new FileBasedOpenLineageLogStoreProvider());
        this.archiveHelper.addConnectorType(null, (IntegrationConnectorProvider)new GovernanceActionOpenLineageIntegrationProvider());
        this.archiveHelper.addConnectorType(null, (IntegrationConnectorProvider)new OpenLineageCataloguerIntegrationProvider());
        this.archiveHelper.addConnectorType(null, (IntegrationConnectorProvider)new OpenLineageEventReceiverIntegrationProvider());
        this.archiveHelper.addConnectorType(null, (IntegrationConnectorProvider)new OMAGServerPlatformCatalogProvider());
        this.archiveHelper.addConnectorType(null, (ConnectorProvider)new OMAGServerPlatformProvider());
        this.archiveHelper.addConnectorType(null, (ConnectorProvider)new OMAGServerProvider());
        this.archiveHelper.addConnectorType(null, (ConnectorProvider)new EngineHostProvider());
        this.archiveHelper.addConnectorType(null, (ConnectorProvider)new IntegrationDaemonProvider());
        this.archiveHelper.addConnectorType(null, (ConnectorProvider)new MetadataAccessServerProvider());
        this.archiveHelper.addConnectorType(null, (ConnectorProvider)new ViewServerProvider());
        this.addFileTemplates();
        this.addEndpointCatalogTemplates();
        this.addSoftwareServerCatalogTemplates(ContentPackDefinition.CORE_CONTENT_PACK);
        accessServiceDescriptionArray = EgeriaSoftwareServerTemplateDefinition.values();
        int n11 = accessServiceDescriptionArray.length;
        boolean bl12 = false;
        while (var14_68 < n11) {
            AccessServiceDescription accessServiceDescription = accessServiceDescriptionArray[var14_68];
            this.createSoftwareServerCatalogTemplate(accessServiceDescription.getTemplateGUID(), accessServiceDescription.getQualifiedName(), accessServiceDescription.getTemplateName(), accessServiceDescription.getTemplateDescription(), accessServiceDescription.getTemplateVersionIdentifier(), accessServiceDescription.getDeployedImplementationType(), accessServiceDescription.getSoftwareCapabilityType(), accessServiceDescription.getSoftwareCapabilityName(), accessServiceDescription.getServerName(), accessServiceDescription.getServerDescription(), accessServiceDescription.getUserId(), accessServiceDescription.getConnectorTypeGUID(), accessServiceDescription.getNetworkAddress(), accessServiceDescription.getConfigurationProperties(), accessServiceDescription.getSecretsStorePurpose(), accessServiceDescription.getSecretsStoreConnectorTypeGUID(), accessServiceDescription.getSecretsStoreFileName(), accessServiceDescription.getReplacementAttributes(), accessServiceDescription.getPlaceholders());
            ++var14_68;
        }
        this.addMacBookProCatalogTemplate();
        this.addFileSystemTemplate();
        this.addUNIXFileSystemTemplate();
        this.addKafkaTopicCatalogTemplate();
        this.addDefaultOMAGServerPlatform();
        super.addIntegrationGroups(ContentPackDefinition.CORE_CONTENT_PACK);
        super.addIntegrationConnectors(ContentPackDefinition.CORE_CONTENT_PACK, IntegrationGroupDefinition.DEFAULT);
        super.createGovernanceEngines(ContentPackDefinition.CORE_CONTENT_PACK);
        super.createGovernanceServices(ContentPackDefinition.CORE_CONTENT_PACK);
        super.createRequestTypes(ContentPackDefinition.CORE_CONTENT_PACK);
        this.createDailyGovernanceActionProcess();
        this.archiveHelper.saveGUIDs();
        this.archiveHelper.saveUsedGUIDs();
    }

    protected void createEgeriaSoftwareServerCatalogTemplate(String guid, String templateName, String templateDescription, String templateVersion, DeployedImplementationTypeDefinition deployedImplementationType, DeployedImplementationTypeDefinition softwareCapabilityType, String softwareCapabilityName, String serverName, String serverId, String description, String userId, String connectorTypeGUID, String networkAddress, Map<String, Object> configurationProperties, String secretsStorePurpose, String secretsStoreConnectorTypeGUID, String secretsStoreFileName, List<ReplacementAttributeType> replacementAttributeTypes, List<PlaceholderPropertyType> placeholderPropertyTypes) {
        String connectionGUID;
        String methodName = "createEgeriaSoftwareServerCatalogTemplate";
        String qualifiedName = deployedImplementationType.getDeployedImplementationType() + ":" + serverName + "[" + serverId + "]";
        HashMap<String, String> extendedProperties = new HashMap<String, String>();
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        extendedProperties.put(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, deployedImplementationType.getDeployedImplementationType());
        extendedProperties.put(OpenMetadataProperty.RESOURCE_NAME.name, serverName);
        if (deployedImplementationType.getAssociatedClassification() != null) {
            classifications.add(this.archiveHelper.getServerPurposeClassification(deployedImplementationType.getAssociatedClassification(), null));
        }
        classifications.add(this.archiveHelper.getTemplateClassification(templateName, templateDescription, templateVersion, null, "createEgeriaSoftwareServerCatalogTemplate"));
        this.archiveHelper.setGUID(qualifiedName, guid);
        String assetGUID = this.archiveHelper.addAsset(deployedImplementationType.getAssociatedTypeName(), qualifiedName, serverName, PlaceholderProperty.VERSION_IDENTIFIER.getPlaceholder(), description, null, extendedProperties, classifications);
        assert (guid.equals(assetGUID));
        if (softwareCapabilityType != null) {
            this.archiveHelper.addSoftwareCapability(softwareCapabilityType.getAssociatedTypeName(), qualifiedName + ":" + softwareCapabilityName, softwareCapabilityName, null, softwareCapabilityType.getDeployedImplementationType(), null, null, null, null, null, (Classification)null, assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName);
            this.archiveHelper.addSupportedSoftwareCapabilityRelationship(qualifiedName + ":" + softwareCapabilityName, qualifiedName, null, null, null, null, 1);
        }
        String endpointGUID = this.archiveHelper.addEndpoint(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, qualifiedName + ":Endpoint", serverName + " endpoint", null, networkAddress, null, null);
        this.archiveHelper.addServerEndpointRelationship(assetGUID, endpointGUID);
        if (secretsStoreConnectorTypeGUID == null) {
            connectionGUID = this.archiveHelper.addConnection(qualifiedName + ":Connection", serverName + " connection", null, userId, null, null, null, configurationProperties, null, connectorTypeGUID, endpointGUID, assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName);
        } else {
            connectionGUID = this.archiveHelper.addConnection(OpenMetadataType.VIRTUAL_CONNECTION.typeName, qualifiedName + ":Connection", serverName + " connection", null, userId, null, null, null, configurationProperties, null, connectorTypeGUID, endpointGUID, assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName);
            HashMap<String, CallSite> secretsStoreConfigurationProperties = new HashMap<String, CallSite>();
            secretsStoreConfigurationProperties.put(SecretsStoreConfigurationProperty.SECRETS_COLLECTION_NAME.getName(), (CallSite)((Object)qualifiedName));
            String secretStoreEndpointGUID = this.archiveHelper.addEndpoint(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, qualifiedName + ":SecretStoreEndpoint", serverName + " secret store endpoint", null, secretsStoreFileName, null, null);
            String secretsStoreConnectionGUID = this.archiveHelper.addConnection(OpenMetadataType.CONNECTION.typeName, qualifiedName + ":SecretsStoreConnection", serverName + " secrets store connection", null, null, null, null, null, secretsStoreConfigurationProperties, null, secretsStoreConnectorTypeGUID, secretStoreEndpointGUID, assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName);
            this.archiveHelper.addEmbeddedConnection(connectionGUID, 0, secretsStorePurpose, null, secretsStoreConnectionGUID);
        }
        this.archiveHelper.addConnectionForAsset(assetGUID, null, connectionGUID);
        String deployedImplementationTypeGUID = this.archiveHelper.getGUID(deployedImplementationType.getQualifiedName());
        this.archiveHelper.addCatalogTemplateRelationship(deployedImplementationTypeGUID, assetGUID);
        this.archiveHelper.addReplacementAttributes(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, replacementAttributeTypes);
        this.archiveHelper.addPlaceholderProperties(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, placeholderPropertyTypes);
    }

    protected void addOpenMetadataEnumValidNames(String enumConsumingTypeName, String enumConsumingProperty, String enumTypeName, List<OpenMetadataEnum> openMetadataEnums) {
        String parentSetGUID = this.getParentSet(null, enumConsumingTypeName, enumConsumingProperty, null);
        for (OpenMetadataEnum enumValue : openMetadataEnums) {
            String enumPreferredValue = enumValue.getName().toUpperCase();
            this.archiveHelper.addValidValue(enumValue.getDescriptionGUID(), parentSetGUID, parentSetGUID, OpenMetadataType.VALID_VALUE_SET.typeName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, OpenMetadataType.VALID_VALUE_SET.typeName, OpenMetadataValidValues.constructValidValueQualifiedName((String)enumConsumingTypeName, (String)enumConsumingProperty, null, (String)enumPreferredValue), enumValue.getName(), enumValue.getDescription(), OpenMetadataValidValues.constructValidValueCategory((String)enumConsumingTypeName, (String)enumConsumingProperty, null), "Used to control valid values in open metadata.", enumTypeName, "Open Metadata Ecosystem", enumPreferredValue, false, false, null);
        }
    }

    protected void addOpenMetadataEnumValidIdentifiers(String enumConsumingTypeName, String enumConsumingProperty, List<OpenMetadataEnum> openMetadataEnums) {
        String parentSetGUID = this.getParentSet(null, enumConsumingTypeName, enumConsumingProperty, null);
        for (OpenMetadataEnum enumValue : openMetadataEnums) {
            String enumPreferredValue = Integer.toString(enumValue.getOrdinal());
            this.archiveHelper.addValidValue(enumValue.getDescriptionGUID(), parentSetGUID, parentSetGUID, OpenMetadataType.VALID_VALUE_SET.typeName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, OpenMetadataType.VALID_VALUE_SET.typeName, OpenMetadataValidValues.constructValidValueQualifiedName((String)enumConsumingTypeName, (String)enumConsumingProperty, null, (String)enumPreferredValue), enumValue.getName(), enumValue.getDescription(), OpenMetadataValidValues.constructValidValueCategory((String)enumConsumingTypeName, (String)enumConsumingProperty, null), "Used to control valid values in open metadata.", DataType.INT.getName(), "Open Metadata Ecosystem", enumPreferredValue, false, false, null);
        }
    }

    private void addFileTemplates() {
        String basicFileConnectorTypeGUID = new BasicFileStoreProvider().getConnectorType().getGUID();
        this.createFolderCatalogTemplate(DeployedImplementationType.FILE_FOLDER, new BasicFolderProvider().getConnectorType().getGUID());
        this.createFolderCatalogTemplate(DeployedImplementationType.DATA_FOLDER, new DataFolderProvider().getConnectorType().getGUID());
        this.createDataFileCatalogTemplate(DeployedImplementationType.FILE, basicFileConnectorTypeGUID, null);
        this.createDataFileCatalogTemplate(DeployedImplementationType.DATA_FILE, basicFileConnectorTypeGUID, null);
        this.createDataFileCatalogTemplate(DeployedImplementationType.CSV_FILE, new CSVFileStoreProvider().getConnectorType().getGUID(), null);
        this.createDataFileCatalogTemplate(DeployedImplementationType.AVRO_FILE, basicFileConnectorTypeGUID, null);
        this.createDataFileCatalogTemplate(DeployedImplementationType.JSON_FILE, basicFileConnectorTypeGUID, null);
        this.createDataFileCatalogTemplate(DeployedImplementationType.PARQUET_FILE, basicFileConnectorTypeGUID, null);
        this.createDataFileCatalogTemplate(DeployedImplementationType.SPREADSHEET_FILE, basicFileConnectorTypeGUID, null);
        this.createDataFileCatalogTemplate(DeployedImplementationType.XML_FILE, basicFileConnectorTypeGUID, null);
        this.createDataFileCatalogTemplate(DeployedImplementationType.DOCUMENT, basicFileConnectorTypeGUID, null);
        this.createDataFileCatalogTemplate(DeployedImplementationType.AUDIO_DATA_FILE, basicFileConnectorTypeGUID, null);
        this.createDataFileCatalogTemplate(DeployedImplementationType.VIDEO_DATA_FILE, basicFileConnectorTypeGUID, null);
        this.createDataFileCatalogTemplate(DeployedImplementationType.THREE_D_IMAGE_DATA_FILE, basicFileConnectorTypeGUID, null);
        this.createDataFileCatalogTemplate(DeployedImplementationType.RASTER_DATA_FILE, basicFileConnectorTypeGUID, null);
        this.createDataFileCatalogTemplate(DeployedImplementationType.VECTOR_DATA_FILE, basicFileConnectorTypeGUID, null);
        this.createDataFileCatalogTemplate(DeployedImplementationType.ARCHIVE_FILE, basicFileConnectorTypeGUID, null);
        this.createDataFileCatalogTemplate(DeployedImplementationType.KEYSTORE_FILE, basicFileConnectorTypeGUID, null);
        this.createSoftwareFileCatalogTemplate(DeployedImplementationType.PROGRAM_FILE, basicFileConnectorTypeGUID);
        this.createSoftwareFileCatalogTemplate(DeployedImplementationType.SOURCE_CODE_FILE, basicFileConnectorTypeGUID);
        this.createSoftwareFileCatalogTemplate(DeployedImplementationType.BUILD_FILE, basicFileConnectorTypeGUID);
        this.createSoftwareFileCatalogTemplate(DeployedImplementationType.EXECUTABLE_FILE, basicFileConnectorTypeGUID);
        this.createSoftwareFileCatalogTemplate(DeployedImplementationType.SCRIPT_FILE, basicFileConnectorTypeGUID);
        this.createSoftwareFileCatalogTemplate(DeployedImplementationType.PROPERTIES_FILE, basicFileConnectorTypeGUID);
        this.createSoftwareFileCatalogTemplate(DeployedImplementationType.YAML_FILE, basicFileConnectorTypeGUID);
    }

    private void addEndpointCatalogTemplates() {
        for (EndpointTemplateDefinition templateDefinition : EndpointTemplateDefinition.values()) {
            this.createEndpointCatalogTemplate(templateDefinition.getTemplateGUID(), templateDefinition.getTemplateName(), templateDefinition.getTemplateDescription(), templateDefinition.getTemplateVersionIdentifier(), templateDefinition.getDeployedImplementationType(), templateDefinition.getServerName(), templateDefinition.getEndpointDescription(), templateDefinition.getNetworkAddress(), templateDefinition.getProtocol(), templateDefinition.getPlaceholders());
        }
    }

    private void addDefaultOMAGServerPlatform() {
        String guid = "44bf319f-1e41-4da1-b771-2753b92b631a";
        OMAGServerPlatformProvider provider = new OMAGServerPlatformProvider();
        EgeriaDeployedImplementationType deployedImplementationType = EgeriaDeployedImplementationType.OMAG_SERVER_PLATFORM;
        DeployedImplementationType softwareCapabilityType = DeployedImplementationType.USER_AUTHENTICATION_MANAGER;
        String softwareCapabilityName = "User Token Manager";
        String serverName = "Default Local OMAG Server Platform";
        String userId = "garygeeke";
        String connectorTypeGUID = provider.getConnectorType().getGUID();
        String networkAddress = "https://localhost:9443";
        String qualifiedName = deployedImplementationType.getDeployedImplementationType() + ":" + serverName;
        String versionIdentifier = "V1.0";
        String description = "Default OMAG Server Platform running on local host and port 9443.";
        HashMap<String, String> extendedProperties = new HashMap<String, String>();
        ArrayList<Classification> classifications = null;
        extendedProperties.put(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, deployedImplementationType.getDeployedImplementationType());
        if (deployedImplementationType.getAssociatedClassification() != null) {
            classifications = new ArrayList<Classification>();
            classifications.add(this.archiveHelper.getServerPurposeClassification(deployedImplementationType.getAssociatedClassification(), null));
        }
        this.archiveHelper.setGUID(qualifiedName, "44bf319f-1e41-4da1-b771-2753b92b631a");
        String assetGUID = this.archiveHelper.addAsset(deployedImplementationType.getAssociatedTypeName(), qualifiedName, serverName, versionIdentifier, description, null, extendedProperties, classifications);
        assert ("44bf319f-1e41-4da1-b771-2753b92b631a".equals(assetGUID));
        this.archiveHelper.addSoftwareCapability(softwareCapabilityType.getAssociatedTypeName(), qualifiedName + ":" + softwareCapabilityName, softwareCapabilityName, null, softwareCapabilityType.getDeployedImplementationType(), null, null, null, null, null, (Classification)null, assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName);
        this.archiveHelper.addSupportedSoftwareCapabilityRelationship(qualifiedName + ":" + softwareCapabilityName, qualifiedName, null, null, null, null, 1);
        String endpointGUID = this.archiveHelper.addEndpoint(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, qualifiedName + ":Endpoint", serverName + " endpoint", null, networkAddress, null, null);
        this.archiveHelper.addServerEndpointRelationship(assetGUID, endpointGUID);
        String connectionGUID = this.archiveHelper.addConnection(qualifiedName + ":Connection", serverName + " connection", null, userId, null, null, null, null, null, connectorTypeGUID, endpointGUID, assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName);
        this.archiveHelper.addConnectionForAsset(assetGUID, null, connectionGUID);
    }

    private void addMacBookProCatalogTemplate() {
        String methodName = "addMacBookProCatalogTemplate";
        String guid = "32a9fd56-85c9-47fe-a211-9da3871bf4da";
        Classification classification = this.archiveHelper.getFileSystemClassification("APFS", "Enabled", "addMacBookProCatalogTemplate");
        this.createHostCatalogTemplate("32a9fd56-85c9-47fe-a211-9da3871bf4da", DeployedImplementationType.MACBOOK_PRO, DeployedImplementationType.UNIX_FILE_SYSTEM, "Local File System", classification);
    }

    private void addFileSystemTemplate() {
        String methodName = "addFileSystemTemplate";
        String guid = "522f228c-097c-4f90-9efc-26c1f2696f87";
        Classification fileSystemClassification = this.archiveHelper.getFileSystemClassification(PlaceholderProperty.FORMAT.getPlaceholder(), PlaceholderProperty.ENCRYPTION.getPlaceholder(), "addFileSystemTemplate");
        this.createSoftwareCapabilityCatalogTemplate("522f228c-097c-4f90-9efc-26c1f2696f87", DeployedImplementationType.FILE_SYSTEM, null, PlaceholderProperty.FILE_SYSTEM_NAME.getPlaceholder(), PlaceholderProperty.DESCRIPTION.getPlaceholder(), fileSystemClassification, null, PlaceholderProperty.getFileSystemPlaceholderPropertyTypes());
    }

    private void addUNIXFileSystemTemplate() {
        String methodName = "addUNIXFileSystemTemplate";
        String guid = "27117270-8667-41d0-a99a-9118f9b60199";
        Classification fileSystemClassification = this.archiveHelper.getFileSystemClassification(PlaceholderProperty.FORMAT.getPlaceholder(), PlaceholderProperty.ENCRYPTION.getPlaceholder(), "addUNIXFileSystemTemplate");
        this.createSoftwareCapabilityCatalogTemplate("27117270-8667-41d0-a99a-9118f9b60199", DeployedImplementationType.UNIX_FILE_SYSTEM, null, PlaceholderProperty.FILE_SYSTEM_NAME.getPlaceholder(), PlaceholderProperty.DESCRIPTION.getPlaceholder(), fileSystemClassification, null, PlaceholderProperty.getFileSystemPlaceholderPropertyTypes());
    }

    private void addKafkaTopicCatalogTemplate() {
        String guid = "ea8f81c9-c59c-47de-9525-7cc59d1251e5";
        KafkaOpenMetadataTopicProvider provider = new KafkaOpenMetadataTopicProvider();
        List placeholderPropertyTypes = KafkaPlaceholderProperty.getKafkaTopicPlaceholderPropertyTypes();
        HashMap<String, Object> configurationProperties = new HashMap<String, Object>();
        HashMap<String, CallSite> bootstrapServersProperties = new HashMap<String, CallSite>();
        bootstrapServersProperties.put("bootstrap.servers", (CallSite)((Object)(PlaceholderProperty.HOST_IDENTIFIER.getPlaceholder() + ":" + PlaceholderProperty.PORT_NUMBER.getPlaceholder())));
        configurationProperties.put(KafkaPlaceholderProperty.EVENT_DIRECTION.getName(), "inOut");
        configurationProperties.put("producer", bootstrapServersProperties);
        configurationProperties.put("consumer", bootstrapServersProperties);
        this.createDataAssetCatalogTemplate("ea8f81c9-c59c-47de-9525-7cc59d1251e5", (DeployedImplementationTypeDefinition)DeployedImplementationType.APACHE_KAFKA_TOPIC, KafkaPlaceholderProperty.SHORT_TOPIC_NAME.getPlaceholder(), PlaceholderProperty.DESCRIPTION.getPlaceholder(), PlaceholderProperty.SERVER_NAME.getPlaceholder() + "." + KafkaPlaceholderProperty.FULL_TOPIC_NAME.getPlaceholder() + ":inOut", null, null, provider.getConnectorType().getGUID(), KafkaPlaceholderProperty.FULL_TOPIC_NAME.getPlaceholder(), configurationProperties, null, placeholderPropertyTypes);
    }

    private String addDeployedImplementationType(String deployedImplementationType, String associatedTypeName, String description, String wikiLink) {
        String qualifiedName = OpenMetadataValidValues.constructValidValueQualifiedName((String)associatedTypeName, (String)OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, null, (String)deployedImplementationType);
        String category = OpenMetadataValidValues.constructValidValueCategory((String)associatedTypeName, (String)OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, null);
        return super.addDeployedImplementationType(deployedImplementationType, associatedTypeName, qualifiedName, category, description, wikiLink);
    }

    private void addOpenMetadataType(OpenMetadataType openMetadataType) {
        String parentSetGUID = this.getParentSet(null, null, OpenMetadataProperty.TYPE_NAME.name, null);
        String qualifiedName = OpenMetadataValidValues.constructValidValueQualifiedName(null, (String)OpenMetadataProperty.TYPE_NAME.name, null, (String)openMetadataType.typeName);
        String category = OpenMetadataValidValues.constructValidValueCategory(null, (String)OpenMetadataProperty.TYPE_NAME.name, null);
        String validValueGUID = this.archiveHelper.addValidValue(openMetadataType.descriptionGUID, parentSetGUID, parentSetGUID, OpenMetadataType.VALID_VALUE_SET.typeName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, OpenMetadataType.VALID_VALUE_SET.typeName, qualifiedName, openMetadataType.typeName, openMetadataType.description, category, "Used to control valid values in open metadata.", "string", "Open Metadata Ecosystem", openMetadataType.typeName, false, false, null);
        assert (openMetadataType.descriptionGUID.equals(validValueGUID));
        if (openMetadataType.wikiURL != null) {
            String externalReferenceGUID = this.archiveHelper.addExternalReference(null, validValueGUID, OpenMetadataType.VALID_VALUE_SET.typeName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, qualifiedName + "_wikiLink", "More information about open metadata type: " + openMetadataType.typeName, null, null, null, null, 0, null, null, null, null, null, null, openMetadataType.wikiURL, null, null, null, null, null, null, null, null, null, null, null, null);
            this.archiveHelper.addExternalReferenceLink(validValueGUID, externalReferenceGUID, null, null, null);
        }
    }

    private void addFileType(String fileTypeName, String encoding, String assetSubTypeName, DeployedImplementationType deployedImplementationType, String description) {
        String qualifiedName = OpenMetadataValidValues.constructValidValueQualifiedName((String)OpenMetadataType.DATA_FILE.typeName, (String)OpenMetadataProperty.FILE_TYPE.name, null, (String)fileTypeName);
        String category = OpenMetadataValidValues.constructValidValueCategory((String)OpenMetadataType.DATA_FILE.typeName, (String)OpenMetadataProperty.FILE_TYPE.name, null);
        HashMap<String, String> additionalProperties = new HashMap<String, String>();
        if (encoding != null) {
            additionalProperties.put(OpenMetadataProperty.ENCODING.name, encoding);
        }
        if (assetSubTypeName != null) {
            additionalProperties.put("assetSubTypeName", assetSubTypeName);
        }
        if (additionalProperties.isEmpty()) {
            additionalProperties = null;
        }
        String parentSetGUID = this.getParentSet(null, OpenMetadataType.DATA_FILE.typeName, OpenMetadataProperty.FILE_TYPE.name, null);
        this.archiveHelper.addValidValue(null, parentSetGUID, parentSetGUID, OpenMetadataType.VALID_VALUE_SET.typeName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, OpenMetadataType.VALID_VALUE_SET.typeName, qualifiedName, fileTypeName, description, category, "Used to control valid values in open metadata.", "string", "Open Metadata Ecosystem", fileTypeName, false, false, additionalProperties);
        if (deployedImplementationType != null) {
            String deployedImplementationTypeQName = deployedImplementationType.getQualifiedName();
            this.archiveHelper.addConsistentValidValueRelationship(qualifiedName, deployedImplementationTypeQName);
        }
    }

    private void addFileName(String fileName, FileType fileType, DeployedImplementationType deployedImplementationType) {
        String qualifiedName = OpenMetadataValidValues.constructValidValueQualifiedName((String)OpenMetadataType.DATA_FILE.typeName, (String)OpenMetadataProperty.FILE_NAME.name, null, (String)fileName);
        String category = OpenMetadataValidValues.constructValidValueCategory((String)OpenMetadataType.DATA_FILE.typeName, (String)OpenMetadataProperty.FILE_NAME.name, null);
        String parentSetGUID = this.getParentSet(null, OpenMetadataType.DATA_FILE.typeName, OpenMetadataProperty.FILE_NAME.name, null);
        this.archiveHelper.addValidValue(null, parentSetGUID, parentSetGUID, OpenMetadataType.VALID_VALUE_SET.typeName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, OpenMetadataType.VALID_VALUE_SET.typeName, qualifiedName, fileName, null, category, "Used to control valid values in open metadata.", "string", "Open Metadata Ecosystem", fileName, false, false, null);
        if (deployedImplementationType != null) {
            String deployedImplementationTypeQName = OpenMetadataValidValues.constructValidValueQualifiedName((String)deployedImplementationType.getAssociatedTypeName(), (String)OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, null, (String)deployedImplementationType.getDeployedImplementationType());
            this.archiveHelper.addConsistentValidValueRelationship(qualifiedName, deployedImplementationTypeQName);
        }
        if (fileType != null) {
            String fileTypeQName = OpenMetadataValidValues.constructValidValueQualifiedName((String)OpenMetadataType.DATA_FILE.typeName, (String)OpenMetadataProperty.FILE_TYPE.name, null, (String)fileType.getFileTypeName());
            this.archiveHelper.addConsistentValidValueRelationship(qualifiedName, fileTypeQName);
        }
    }

    private void addFileExtension(String fileExtension, List<FileType> fileTypes) {
        String qualifiedName = OpenMetadataValidValues.constructValidValueQualifiedName((String)OpenMetadataType.DATA_FILE.typeName, (String)OpenMetadataProperty.FILE_EXTENSION.name, null, (String)fileExtension);
        String category = OpenMetadataValidValues.constructValidValueCategory((String)OpenMetadataType.DATA_FILE.typeName, (String)OpenMetadataProperty.FILE_EXTENSION.name, null);
        String parentSetGUID = this.getParentSet(null, OpenMetadataType.DATA_FILE.typeName, OpenMetadataProperty.FILE_EXTENSION.name, null);
        this.archiveHelper.addValidValue(null, parentSetGUID, parentSetGUID, OpenMetadataType.VALID_VALUE_SET.typeName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, OpenMetadataType.VALID_VALUE_SET.typeName, qualifiedName, fileExtension, null, category, "Used to control valid values in open metadata.", "string", "Open Metadata Ecosystem", fileExtension, false, false, null);
        if (fileTypes != null) {
            for (FileType fileType : fileTypes) {
                String fileTypeQName = OpenMetadataValidValues.constructValidValueQualifiedName((String)OpenMetadataType.DATA_FILE.typeName, (String)OpenMetadataProperty.FILE_TYPE.name, null, (String)fileType.getFileTypeName());
                this.archiveHelper.addConsistentValidValueRelationship(qualifiedName, fileTypeQName);
            }
        }
    }

    private void addAttributeName(String attributeName, String attributeDescription) {
        String qualifiedName = OpenMetadataValidValues.constructValidValueQualifiedName((String)OpenMetadataType.SPECIFICATION_PROPERTY_ASSIGNMENT_RELATIONSHIP.typeName, (String)OpenMetadataProperty.PROPERTY_TYPE.name, null, (String)attributeName);
        String category = OpenMetadataValidValues.constructValidValueCategory((String)OpenMetadataType.SPECIFICATION_PROPERTY_ASSIGNMENT_RELATIONSHIP.typeName, (String)OpenMetadataProperty.PROPERTY_TYPE.name, null);
        String parentSetGUID = this.getParentSet(null, OpenMetadataType.SPECIFICATION_PROPERTY_ASSIGNMENT_RELATIONSHIP.typeName, OpenMetadataProperty.PROPERTY_TYPE.name, null);
        this.archiveHelper.addValidValue(null, parentSetGUID, parentSetGUID, OpenMetadataType.VALID_VALUE_SET.typeGUID, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, OpenMetadataType.VALID_VALUE_SET.typeName, qualifiedName, attributeName, attributeDescription, category, "Used to control valid values in open metadata.", "string", "Open Metadata Ecosystem", attributeName, false, false, null);
    }

    private void createDailyGovernanceActionProcess() {
        String step8GUID;
        String step7GUID;
        String step6GUID;
        String step5GUID;
        String step4GUID;
        String step3GUID;
        String step2GUID;
        String processGUID = this.archiveHelper.addGovernanceActionProcess("GovernanceActionProcess", "Egeria:DailyGovernanceActionProcess", "DailyGovernanceActionProcess", null, null, null, 0, null, null, null);
        String step1GUID = this.archiveHelper.addGovernanceActionProcessStep("GovernanceActionProcessStep", processGUID, "GovernanceActionProcess", OpenMetadataType.ASSET.typeName, "Egeria:DailyGovernanceActionProcess:GetDayOfWeek", "Get the day of the Week", null, 0, null, null, null, null, null, null, null, 0, true, null, null, null);
        if (step1GUID != null) {
            this.archiveHelper.addGovernanceActionExecutor(step1GUID, RequestTypeDefinition.GET_DAY_OF_WEEK.getGovernanceRequestType(), null, null, null, null, null, GovernanceEngineDefinition.STEWARDSHIP_ENGINE.getGUID());
            this.archiveHelper.addGovernanceActionProcessFlow(processGUID, null, null, step1GUID);
        }
        if ((step2GUID = this.archiveHelper.addGovernanceActionProcessStep("GovernanceActionProcessStep", processGUID, "GovernanceActionProcess", OpenMetadataType.ASSET.typeName, "Egeria:DailyGovernanceActionProcess:MondayTask", "Output Monday's task", null, 0, null, null, null, null, null, null, null, 0, true, null, null, null)) != null) {
            HashMap<String, String> requestParameters = new HashMap<String, String>();
            requestParameters.put(WriteAuditLogRequestParameter.MESSAGE_TEXT.getName(), "Action For Monday is: Wash");
            this.archiveHelper.addGovernanceActionExecutor(step2GUID, RequestTypeDefinition.WRITE_AUDIT_LOG.getGovernanceRequestType(), requestParameters, null, null, null, null, GovernanceEngineDefinition.STEWARDSHIP_ENGINE.getGUID());
            this.archiveHelper.addNextGovernanceActionProcessStep(step1GUID, DaysOfWeekGuard.MONDAY.getName(), false, step2GUID);
        }
        if ((step3GUID = this.archiveHelper.addGovernanceActionProcessStep("GovernanceActionProcessStep", processGUID, "GovernanceActionProcess", OpenMetadataType.ASSET.typeName, "Egeria:DailyGovernanceActionProcess:TuesdayTask", "Output Tuesday's task", null, 0, null, null, null, null, null, null, null, 0, true, null, null, null)) != null) {
            HashMap<String, String> requestParameters = new HashMap<String, String>();
            requestParameters.put(WriteAuditLogRequestParameter.MESSAGE_TEXT.getName(), "Action For Tuesday is: Iron");
            this.archiveHelper.addGovernanceActionExecutor(step3GUID, RequestTypeDefinition.WRITE_AUDIT_LOG.getGovernanceRequestType(), requestParameters, null, null, null, null, GovernanceEngineDefinition.STEWARDSHIP_ENGINE.getGUID());
            this.archiveHelper.addNextGovernanceActionProcessStep(step1GUID, DaysOfWeekGuard.TUESDAY.getName(), false, step3GUID);
        }
        if ((step4GUID = this.archiveHelper.addGovernanceActionProcessStep("GovernanceActionProcessStep", processGUID, "GovernanceActionProcess", OpenMetadataType.ASSET.typeName, "Egeria:DailyGovernanceActionProcess:WednesdayTask", "Output Wednesday's task", null, 0, null, null, null, null, null, null, null, 0, true, null, null, null)) != null) {
            HashMap<String, String> requestParameters = new HashMap<String, String>();
            requestParameters.put(WriteAuditLogRequestParameter.MESSAGE_TEXT.getName(), "Action For Wednesday is: Mend");
            this.archiveHelper.addGovernanceActionExecutor(step4GUID, RequestTypeDefinition.WRITE_AUDIT_LOG.getGovernanceRequestType(), requestParameters, null, null, null, null, GovernanceEngineDefinition.STEWARDSHIP_ENGINE.getGUID());
            this.archiveHelper.addNextGovernanceActionProcessStep(step1GUID, DaysOfWeekGuard.WEDNESDAY.getName(), false, step4GUID);
        }
        if ((step5GUID = this.archiveHelper.addGovernanceActionProcessStep("GovernanceActionProcessStep", processGUID, "GovernanceActionProcess", OpenMetadataType.ASSET.typeName, "Egeria:DailyGovernanceActionProcess:ThursdayTask", "Output Thursday's task", null, 0, null, null, null, null, null, null, null, 0, true, null, null, null)) != null) {
            HashMap<String, String> requestParameters = new HashMap<String, String>();
            requestParameters.put(WriteAuditLogRequestParameter.MESSAGE_TEXT.getName(), "Action For Thursday is: Market");
            this.archiveHelper.addGovernanceActionExecutor(step5GUID, RequestTypeDefinition.WRITE_AUDIT_LOG.getGovernanceRequestType(), requestParameters, null, null, null, null, GovernanceEngineDefinition.STEWARDSHIP_ENGINE.getGUID());
            this.archiveHelper.addNextGovernanceActionProcessStep(step1GUID, DaysOfWeekGuard.THURSDAY.getName(), false, step5GUID);
        }
        if ((step6GUID = this.archiveHelper.addGovernanceActionProcessStep("GovernanceActionProcessStep", processGUID, "GovernanceActionProcess", OpenMetadataType.ASSET.typeName, "Egeria:DailyGovernanceActionProcess:FridayTask", "Output Friday's task", null, 0, null, null, null, null, null, null, null, 0, true, null, null, null)) != null) {
            HashMap<String, String> requestParameters = new HashMap<String, String>();
            requestParameters.put(WriteAuditLogRequestParameter.MESSAGE_TEXT.getName(), "Action For Friday is: Clean");
            this.archiveHelper.addGovernanceActionExecutor(step6GUID, RequestTypeDefinition.WRITE_AUDIT_LOG.getGovernanceRequestType(), requestParameters, null, null, null, null, GovernanceEngineDefinition.STEWARDSHIP_ENGINE.getGUID());
            this.archiveHelper.addNextGovernanceActionProcessStep(step1GUID, DaysOfWeekGuard.FRIDAY.getName(), false, step6GUID);
        }
        if ((step7GUID = this.archiveHelper.addGovernanceActionProcessStep("GovernanceActionProcessStep", processGUID, "GovernanceActionProcess", OpenMetadataType.ASSET.typeName, "Egeria:DailyGovernanceActionProcess:SaturdayTask", "Output Saturday's task", null, 0, null, null, null, null, null, null, null, 0, true, null, null, null)) != null) {
            HashMap<String, String> requestParameters = new HashMap<String, String>();
            requestParameters.put(WriteAuditLogRequestParameter.MESSAGE_TEXT.getName(), "Action For Saturday is: Bake");
            this.archiveHelper.addGovernanceActionExecutor(step7GUID, RequestTypeDefinition.WRITE_AUDIT_LOG.getGovernanceRequestType(), requestParameters, null, null, null, null, GovernanceEngineDefinition.STEWARDSHIP_ENGINE.getGUID());
            this.archiveHelper.addNextGovernanceActionProcessStep(step1GUID, DaysOfWeekGuard.SATURDAY.getName(), false, step7GUID);
        }
        if ((step8GUID = this.archiveHelper.addGovernanceActionProcessStep("GovernanceActionProcessStep", processGUID, "GovernanceActionProcess", OpenMetadataType.ASSET.typeName, "Egeria:DailyGovernanceActionProcess:SundayTask", "Output Sunday's task", null, 0, null, null, null, null, null, null, null, 0, true, null, null, null)) != null) {
            HashMap<String, String> requestParameters = new HashMap<String, String>();
            requestParameters.put(WriteAuditLogRequestParameter.MESSAGE_TEXT.getName(), "Action For Sunday is: Rest");
            this.archiveHelper.addGovernanceActionExecutor(step8GUID, RequestTypeDefinition.WRITE_AUDIT_LOG.getGovernanceRequestType(), requestParameters, null, null, null, null, GovernanceEngineDefinition.STEWARDSHIP_ENGINE.getGUID());
            this.archiveHelper.addNextGovernanceActionProcessStep(step1GUID, DaysOfWeekGuard.SUNDAY.getName(), false, step8GUID);
        }
    }

    public static void main(String[] args) {
        try {
            CorePackArchiveWriter archiveWriter = new CorePackArchiveWriter();
            archiveWriter.writeOpenMetadataArchive();
        }
        catch (Exception error) {
            System.err.println("Exception: " + error);
            System.exit(-1);
        }
    }
}

