/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.archiveutilities.openconnectors.postgres;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.adapters.connectors.postgres.catalog.PostgresServerIntegrationProvider;
import org.odpi.openmetadata.adapters.connectors.postgres.controls.PostgresDeployedImplementationType;
import org.odpi.openmetadata.adapters.connectors.postgres.controls.PostgresPlaceholderProperty;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.JDBCResourceConnectorProvider;
import org.odpi.openmetadata.archiveutilities.openconnectors.ContentPackDefinition;
import org.odpi.openmetadata.archiveutilities.openconnectors.GovernanceEngineDefinition;
import org.odpi.openmetadata.archiveutilities.openconnectors.IntegrationGroupDefinition;
import org.odpi.openmetadata.archiveutilities.openconnectors.RequestTypeDefinition;
import org.odpi.openmetadata.archiveutilities.openconnectors.base.ContentPackBaseArchiveWriter;
import org.odpi.openmetadata.archiveutilities.openconnectors.core.CorePackArchiveWriter;
import org.odpi.openmetadata.frameworks.integration.connectors.IntegrationConnectorProvider;
import org.odpi.openmetadata.frameworks.openmetadata.controls.PlaceholderProperty;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationTypeDefinition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;

public class PostgresPackArchiveWriter
extends ContentPackBaseArchiveWriter {
    public PostgresPackArchiveWriter() {
        super(ContentPackDefinition.POSTGRES_CONTENT_PACK.getArchiveGUID(), ContentPackDefinition.POSTGRES_CONTENT_PACK.getArchiveName(), ContentPackDefinition.POSTGRES_CONTENT_PACK.getArchiveDescription(), new Date(), ContentPackDefinition.POSTGRES_CONTENT_PACK.getArchiveFileName(), new OpenMetadataArchive[]{new CorePackArchiveWriter().getOpenMetadataArchive()});
    }

    public void getArchiveContent() {
        for (PostgresDeployedImplementationType deployedImplementationType : PostgresDeployedImplementationType.values()) {
            this.addDeployedImplementationType(deployedImplementationType.getDeployedImplementationType(), deployedImplementationType.getAssociatedTypeName(), deployedImplementationType.getQualifiedName(), deployedImplementationType.getCategory(), deployedImplementationType.getDescription(), deployedImplementationType.getWikiLink());
        }
        this.archiveHelper.addConnectorType(null, (IntegrationConnectorProvider)new PostgresServerIntegrationProvider());
        this.addSoftwareServerCatalogTemplates(ContentPackDefinition.POSTGRES_CONTENT_PACK);
        this.addPostgresDatabaseCatalogTemplate();
        this.addPostgresDatabaseSchemaCatalogTemplate();
        super.addIntegrationGroups(ContentPackDefinition.POSTGRES_CONTENT_PACK);
        super.addIntegrationConnectors(ContentPackDefinition.POSTGRES_CONTENT_PACK, IntegrationGroupDefinition.DEFAULT);
        super.createGovernanceEngines(ContentPackDefinition.POSTGRES_CONTENT_PACK);
        super.createGovernanceServices(ContentPackDefinition.POSTGRES_CONTENT_PACK);
        super.createRequestTypes(ContentPackDefinition.POSTGRES_CONTENT_PACK);
        this.createAndSurveyServerGovernanceActionProcess("PostgreSQLServer", PostgresDeployedImplementationType.POSTGRESQL_SERVER.getDeployedImplementationType(), RequestTypeDefinition.CREATE_POSTGRES_SERVER, GovernanceEngineDefinition.POSTGRES_GOVERNANCE_ENGINE, RequestTypeDefinition.SURVEY_POSTGRES_SERVER, GovernanceEngineDefinition.POSTGRES_SURVEY_ENGINE);
        this.createAndCatalogServerGovernanceActionProcess("PostgreSQLServer", PostgresDeployedImplementationType.POSTGRESQL_SERVER.getDeployedImplementationType(), RequestTypeDefinition.CREATE_POSTGRES_SERVER, GovernanceEngineDefinition.POSTGRES_GOVERNANCE_ENGINE, RequestTypeDefinition.CATALOG_POSTGRES_SERVER, GovernanceEngineDefinition.POSTGRES_GOVERNANCE_ENGINE);
        this.archiveHelper.saveGUIDs();
        this.archiveHelper.saveUsedGUIDs();
    }

    private void addPostgresDatabaseCatalogTemplate() {
        String guid = "3d398b3f-7ae6-4713-952a-409f3dea8520";
        JDBCResourceConnectorProvider provider = new JDBCResourceConnectorProvider();
        List placeholderPropertyTypes = PostgresPlaceholderProperty.getPostgresDatabasePlaceholderPropertyTypes();
        this.createDataAssetCatalogTemplate("3d398b3f-7ae6-4713-952a-409f3dea8520", (DeployedImplementationTypeDefinition)PostgresDeployedImplementationType.POSTGRESQL_DATABASE, PostgresPlaceholderProperty.DATABASE_NAME.getPlaceholder(), PostgresPlaceholderProperty.DATABASE_DESCRIPTION.getPlaceholder(), PlaceholderProperty.SERVER_NAME.getPlaceholder(), PostgresPlaceholderProperty.DATABASE_USER_ID.getPlaceholder(), PostgresPlaceholderProperty.DATABASE_PASSWORD.getPlaceholder(), provider.getConnectorType().getGUID(), "jdbc:postgresql://" + PlaceholderProperty.HOST_IDENTIFIER.getPlaceholder() + ":" + PlaceholderProperty.PORT_NUMBER.getPlaceholder() + "/" + PostgresPlaceholderProperty.DATABASE_NAME.getPlaceholder(), null, null, placeholderPropertyTypes);
    }

    private void addPostgresDatabaseSchemaCatalogTemplate() {
        String guid = "82a5417c-d882-4271-8444-4c6a996a8bfc";
        JDBCResourceConnectorProvider provider = new JDBCResourceConnectorProvider();
        List placeholderPropertyTypes = PostgresPlaceholderProperty.getPostgresSchemaPlaceholderPropertyTypes();
        this.createDataAssetCatalogTemplate("82a5417c-d882-4271-8444-4c6a996a8bfc", (DeployedImplementationTypeDefinition)PostgresDeployedImplementationType.POSTGRESQL_DATABASE_SCHEMA, PostgresPlaceholderProperty.SCHEMA_NAME.getPlaceholder(), PostgresPlaceholderProperty.SCHEMA_DESCRIPTION.getPlaceholder(), PlaceholderProperty.SERVER_NAME.getPlaceholder() + "." + PostgresPlaceholderProperty.DATABASE_NAME.getPlaceholder(), PostgresPlaceholderProperty.DATABASE_USER_ID.getPlaceholder(), PostgresPlaceholderProperty.DATABASE_PASSWORD.getPlaceholder(), provider.getConnectorType().getGUID(), "jdbc:postgresql://" + PlaceholderProperty.HOST_IDENTIFIER.getPlaceholder() + ":" + PlaceholderProperty.PORT_NUMBER.getPlaceholder() + "/" + PostgresPlaceholderProperty.DATABASE_NAME.getPlaceholder() + "?currentSchema=" + PostgresPlaceholderProperty.SCHEMA_NAME.getPlaceholder(), null, null, placeholderPropertyTypes);
    }

    public static void main(String[] args) {
        try {
            PostgresPackArchiveWriter archiveWriter = new PostgresPackArchiveWriter();
            archiveWriter.writeOpenMetadataArchive();
        }
        catch (Exception error) {
            System.err.println("Exception: " + error);
            System.exit(-1);
        }
    }
}

