/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.archiveutilities.openconnectors;

import java.util.List;
import org.odpi.openmetadata.adapters.connectors.postgres.controls.PostgresPlaceholderProperty;
import org.odpi.openmetadata.frameworks.openmetadata.controls.PlaceholderProperty;
import org.odpi.openmetadata.frameworks.openmetadata.controls.PlaceholderPropertyType;
import org.odpi.openmetadata.frameworks.openmetadata.controls.ReplacementAttributeType;
import org.odpi.openmetadata.frameworks.openmetadata.controls.TemplateDefinition;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationType;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationTypeDefinition;

public enum EndpointTemplateDefinition implements TemplateDefinition
{
    JDBC_ENDPOINT_TEMPLATE("3d79ce50-1887-4627-ad71-ba4649aba2bc", DeployedImplementationType.JDBC_ENDPOINT, "REST", "jdbc:postgresql://" + PlaceholderProperty.HOST_IDENTIFIER.getPlaceholder() + ":" + PlaceholderProperty.PORT_NUMBER.getPlaceholder() + "/postgres", PostgresPlaceholderProperty.getJDBCEndpointPlaceholderPropertyTypes()),
    REST_ENDPOINT_TEMPLATE("9ea4bff4-d193-492f-bcad-6e68c07c6f9e", DeployedImplementationType.REST_API_ENDPOINT, "JDBC", PlaceholderProperty.HOST_URL.getPlaceholder() + ":" + PlaceholderProperty.PORT_NUMBER.getPlaceholder() + PlaceholderProperty.API_OPERATION.getPlaceholder(), PlaceholderProperty.getHTTPEndpointPlaceholderPropertyTypes());

    private final String guid;
    private final DeployedImplementationType deployedImplementationType;
    private final String protocol;
    private final String networkAddress;
    private final List<PlaceholderPropertyType> placeholderPropertyTypes;

    private EndpointTemplateDefinition(String guid, DeployedImplementationType deployedImplementationType, String protocol, String networkAddress, List<PlaceholderPropertyType> placeholderPropertyTypes) {
        this.guid = guid;
        this.deployedImplementationType = deployedImplementationType;
        this.protocol = protocol;
        this.networkAddress = networkAddress;
        this.placeholderPropertyTypes = placeholderPropertyTypes;
    }

    public String getTemplateGUID() {
        return this.guid;
    }

    public String getTemplateName() {
        return this.deployedImplementationType.getDeployedImplementationType() + " template";
    }

    public String getTemplateDescription() {
        return "Create a " + this.deployedImplementationType.getDeployedImplementationType() + ".";
    }

    public String getTemplateVersionIdentifier() {
        return "V1.0";
    }

    public DeployedImplementationTypeDefinition getDeployedImplementationType() {
        return this.deployedImplementationType;
    }

    public String getServerName() {
        return PlaceholderProperty.SERVER_NAME.getPlaceholder();
    }

    public String getEndpointDescription() {
        return PlaceholderProperty.DESCRIPTION.getPlaceholder();
    }

    public String getNetworkAddress() {
        return this.networkAddress;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public List<PlaceholderPropertyType> getPlaceholders() {
        return this.placeholderPropertyTypes;
    }

    public List<ReplacementAttributeType> getReplacementAttributes() {
        return null;
    }

    public String toString() {
        return "TemplateDefinition{templateName='" + this.getTemplateName() + "'}";
    }
}

