/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.archiveutilities.openconnectors;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.controls.AtlasDeployedImplementationType;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.ApacheAtlasRESTProvider;
import org.odpi.openmetadata.adapters.connectors.apachekafka.control.KafkaDeployedImplementationType;
import org.odpi.openmetadata.adapters.connectors.apachekafka.control.KafkaPlaceholderProperty;
import org.odpi.openmetadata.adapters.connectors.apachekafka.resource.ApacheKafkaAdminProvider;
import org.odpi.openmetadata.adapters.connectors.postgres.controls.PostgreSQLTemplateType;
import org.odpi.openmetadata.adapters.connectors.postgres.controls.PostgresDeployedImplementationType;
import org.odpi.openmetadata.adapters.connectors.postgres.controls.PostgresPlaceholderProperty;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.JDBCResourceConnectorProvider;
import org.odpi.openmetadata.adapters.connectors.secretsstore.yaml.YAMLSecretsStoreProvider;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogDeployedImplementationType;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogPlaceholderProperty;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogTemplateType;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.resource.OSSUnityCatalogResourceProvider;
import org.odpi.openmetadata.archiveutilities.openconnectors.ContentPackDefinition;
import org.odpi.openmetadata.frameworks.connectors.controls.SecretsStorePurpose;
import org.odpi.openmetadata.frameworks.openmetadata.controls.PlaceholderProperty;
import org.odpi.openmetadata.frameworks.openmetadata.controls.PlaceholderPropertyType;
import org.odpi.openmetadata.frameworks.openmetadata.controls.ReplacementAttributeType;
import org.odpi.openmetadata.frameworks.openmetadata.controls.TemplateDefinition;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationType;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationTypeDefinition;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public enum SoftwareServerTemplateDefinition implements TemplateDefinition
{
    POSTGRES_SERVER_TEMPLATE(PostgreSQLTemplateType.POSTGRES_SERVER_TEMPLATE.getDefaultTemplateGUID(), (DeployedImplementationTypeDefinition)PostgresDeployedImplementationType.POSTGRESQL_SERVER, (DeployedImplementationTypeDefinition)PostgresDeployedImplementationType.POSTGRESQL_DATABASE_MANAGER, "Database Management System (DBMS)", PlaceholderProperty.SERVER_NAME.getPlaceholder(), PlaceholderProperty.DESCRIPTION.getPlaceholder(), null, new JDBCResourceConnectorProvider().getConnectorType().getGUID(), "jdbc:postgresql://" + PlaceholderProperty.HOST_IDENTIFIER.getPlaceholder() + ":" + PlaceholderProperty.PORT_NUMBER.getPlaceholder() + "/postgres", null, SecretsStorePurpose.REST_BASIC_AUTHENTICATION.getName(), new YAMLSecretsStoreProvider().getConnectorType().getGUID(), PlaceholderProperty.SECRETS_STORE.getPlaceholder(), null, PostgresPlaceholderProperty.getPostgresServerPlaceholderPropertyTypes(), ContentPackDefinition.POSTGRES_CONTENT_PACK),
    APACHE_ATLAS_TEMPLATE("fe6dce45-a978-4417-ab55-17f05b8bcea7", (DeployedImplementationTypeDefinition)AtlasDeployedImplementationType.APACHE_ATLAS_SERVER, (DeployedImplementationTypeDefinition)DeployedImplementationType.ASSET_CATALOG, "Metadata Catalog", PlaceholderProperty.SERVER_NAME.getPlaceholder(), PlaceholderProperty.DESCRIPTION.getPlaceholder(), null, new ApacheAtlasRESTProvider().getConnectorType().getGUID(), PlaceholderProperty.HOST_URL.getPlaceholder() + ":" + PlaceholderProperty.PORT_NUMBER.getPlaceholder(), null, SecretsStorePurpose.REST_BASIC_AUTHENTICATION.getName(), new YAMLSecretsStoreProvider().getConnectorType().getGUID(), PlaceholderProperty.SECRETS_STORE.getPlaceholder(), null, PlaceholderProperty.getSecretServerPlaceholderPropertyTypes(), ContentPackDefinition.APACHE_ATLAS_CONTENT_PACK),
    UNITY_CATALOG_SERVER_TEMPLATE(UnityCatalogTemplateType.OSS_UC_SERVER_TEMPLATE.getDefaultTemplateGUID(), (DeployedImplementationTypeDefinition)UnityCatalogDeployedImplementationType.OSS_UNITY_CATALOG_SERVER, (DeployedImplementationTypeDefinition)DeployedImplementationType.REST_API_MANAGER, "Unity Catalog REST API", PlaceholderProperty.SERVER_NAME.getPlaceholder(), PlaceholderProperty.DESCRIPTION.getPlaceholder(), null, new OSSUnityCatalogResourceProvider().getConnectorType().getGUID(), PlaceholderProperty.HOST_URL.getPlaceholder() + ":" + PlaceholderProperty.PORT_NUMBER.getPlaceholder(), null, null, null, null, null, UnityCatalogPlaceholderProperty.getServerPlaceholderPropertyTypes(), ContentPackDefinition.UNITY_CATALOG_CONTENT_PACK),
    DATABRICKS_UC_SERVER_TEMPLATE(UnityCatalogTemplateType.DB_UC_SERVER_TEMPLATE.getDefaultTemplateGUID(), (DeployedImplementationTypeDefinition)UnityCatalogDeployedImplementationType.DB_UNITY_CATALOG_SERVER, (DeployedImplementationTypeDefinition)DeployedImplementationType.REST_API_MANAGER, "Databricks Unity Catalog REST API", PlaceholderProperty.SERVER_NAME.getPlaceholder(), PlaceholderProperty.DESCRIPTION.getPlaceholder(), null, new OSSUnityCatalogResourceProvider().getConnectorType().getGUID(), PlaceholderProperty.HOST_URL.getPlaceholder() + ":" + PlaceholderProperty.PORT_NUMBER.getPlaceholder(), null, SecretsStorePurpose.REST_BEARER_TOKEN.getName(), new YAMLSecretsStoreProvider().getConnectorType().getGUID(), PlaceholderProperty.SECRETS_STORE.getPlaceholder(), null, UnityCatalogPlaceholderProperty.getSecureServerPlaceholderPropertyTypes(), ContentPackDefinition.UNITY_CATALOG_CONTENT_PACK),
    KAFKA_SERVER_TEMPLATE("5e1ff810-5418-43f7-b7c4-e6e062f9aff7", (DeployedImplementationTypeDefinition)KafkaDeployedImplementationType.APACHE_KAFKA_SERVER, (DeployedImplementationTypeDefinition)KafkaDeployedImplementationType.APACHE_KAFKA_EVENT_BROKER, OpenMetadataType.EVENT_BROKER.typeName, PlaceholderProperty.SERVER_NAME.getPlaceholder(), PlaceholderProperty.DESCRIPTION.getPlaceholder(), null, new ApacheKafkaAdminProvider().getConnectorType().getGUID(), PlaceholderProperty.HOST_IDENTIFIER.getPlaceholder() + ":" + PlaceholderProperty.PORT_NUMBER.getPlaceholder(), null, null, null, null, null, KafkaPlaceholderProperty.getKafkaServerPlaceholderPropertyTypes(), ContentPackDefinition.APACHE_KAFKA_CONTENT_PACK);

    private final String guid;
    private final DeployedImplementationTypeDefinition deployedImplementationType;
    private final DeployedImplementationTypeDefinition softwareCapabilityType;
    private final String softwareCapabilityName;
    private final String serverName;
    private final String description;
    private final String userId;
    private final String connectorTypeGUID;
    private final String networkAddress;
    private final Map<String, Object> configurationProperties;
    private final String secretsStorePurpose;
    private final String secretsStoreConnectorTypeGUID;
    private final String secretsStoreFileName;
    private final List<ReplacementAttributeType> replacementAttributeTypes;
    private final List<PlaceholderPropertyType> placeholderPropertyTypes;
    private final ContentPackDefinition contentPackDefinition;

    private SoftwareServerTemplateDefinition(String guid, DeployedImplementationTypeDefinition deployedImplementationType, DeployedImplementationTypeDefinition softwareCapabilityType, String softwareCapabilityName, String serverName, String description, String userId, String connectorTypeGUID, String networkAddress, Map<String, Object> configurationProperties, String secretsStorePurpose, String secretsStoreConnectorTypeGUID, String secretsStoreFileName, List<ReplacementAttributeType> replacementAttributeTypes, List<PlaceholderPropertyType> placeholderPropertyTypes, ContentPackDefinition contentPackDefinition) {
        this.guid = guid;
        this.deployedImplementationType = deployedImplementationType;
        this.softwareCapabilityType = softwareCapabilityType;
        this.softwareCapabilityName = softwareCapabilityName;
        this.serverName = serverName;
        this.description = description;
        this.userId = userId;
        this.connectorTypeGUID = connectorTypeGUID;
        this.networkAddress = networkAddress;
        this.configurationProperties = configurationProperties;
        this.secretsStorePurpose = secretsStorePurpose;
        this.secretsStoreConnectorTypeGUID = secretsStoreConnectorTypeGUID;
        this.secretsStoreFileName = secretsStoreFileName;
        this.replacementAttributeTypes = replacementAttributeTypes;
        this.placeholderPropertyTypes = placeholderPropertyTypes;
        this.contentPackDefinition = contentPackDefinition;
    }

    public String getTemplateGUID() {
        return this.guid;
    }

    public String getQualifiedName() {
        return this.deployedImplementationType.getDeployedImplementationType() + ":" + this.serverName;
    }

    public String getTemplateName() {
        return this.deployedImplementationType.getDeployedImplementationType() + " template";
    }

    public String getTemplateDescription() {
        return "Create a " + this.deployedImplementationType.getDeployedImplementationType() + " SoftwareServer with an associated SoftwareCapability and Connection.";
    }

    public String getTemplateVersionIdentifier() {
        return "V1.0";
    }

    public DeployedImplementationTypeDefinition getDeployedImplementationType() {
        return this.deployedImplementationType;
    }

    public DeployedImplementationTypeDefinition getSoftwareCapabilityType() {
        return this.softwareCapabilityType;
    }

    public String getSoftwareCapabilityName() {
        return this.softwareCapabilityName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerDescription() {
        return this.description;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getConnectorTypeGUID() {
        return this.connectorTypeGUID;
    }

    public String getNetworkAddress() {
        return this.networkAddress;
    }

    public Map<String, Object> getConfigurationProperties() {
        return this.configurationProperties;
    }

    public String getSecretsStorePurpose() {
        return this.secretsStorePurpose;
    }

    public String getSecretsStoreConnectorTypeGUID() {
        return this.secretsStoreConnectorTypeGUID;
    }

    public String getSecretsStoreFileName() {
        return this.secretsStoreFileName;
    }

    public List<PlaceholderPropertyType> getPlaceholders() {
        return this.placeholderPropertyTypes;
    }

    public List<ReplacementAttributeType> getReplacementAttributes() {
        return this.replacementAttributeTypes;
    }

    public ContentPackDefinition getContentPackDefinition() {
        return this.contentPackDefinition;
    }

    public String toString() {
        return "TemplateDefinition{templateName='" + this.getTemplateName() + "'}";
    }
}

