/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.archiveutilities.openconnectors.postgres;

import org.odpi.openmetadata.adapters.connectors.postgres.catalog.PostgresServerIntegrationProvider;
import org.odpi.openmetadata.adapters.connectors.postgres.controls.PostgresDeployedImplementationType;
import org.odpi.openmetadata.archiveutilities.openconnectors.ContentPackDefinition;
import org.odpi.openmetadata.archiveutilities.openconnectors.GovernanceEngineDefinition;
import org.odpi.openmetadata.archiveutilities.openconnectors.IntegrationGroupDefinition;
import org.odpi.openmetadata.archiveutilities.openconnectors.RequestTypeDefinition;
import org.odpi.openmetadata.archiveutilities.openconnectors.base.ContentPackBaseArchiveWriter;
import org.odpi.openmetadata.archiveutilities.openconnectors.core.CorePackArchiveWriter;
import org.odpi.openmetadata.frameworks.integration.connectors.IntegrationConnectorProvider;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;

public class PostgresPackArchiveWriter
extends ContentPackBaseArchiveWriter {
    public PostgresPackArchiveWriter() {
        super(ContentPackDefinition.POSTGRES_CONTENT_PACK.getArchiveGUID(), ContentPackDefinition.POSTGRES_CONTENT_PACK.getArchiveName(), ContentPackDefinition.POSTGRES_CONTENT_PACK.getArchiveDescription(), ContentPackDefinition.POSTGRES_CONTENT_PACK.getArchiveFileName(), new OpenMetadataArchive[]{new CorePackArchiveWriter().getOpenMetadataArchive()});
    }

    public void getArchiveContent() {
        for (PostgresDeployedImplementationType deployedImplementationType : PostgresDeployedImplementationType.values()) {
            this.addDeployedImplementationType(deployedImplementationType.getDeployedImplementationType(), deployedImplementationType.getAssociatedTypeName(), deployedImplementationType.getQualifiedName(), deployedImplementationType.getCategory(), deployedImplementationType.getDescription(), deployedImplementationType.getWikiLink(), deployedImplementationType.getIsATypeOf());
        }
        this.archiveHelper.addConnectorType(null, (IntegrationConnectorProvider)new PostgresServerIntegrationProvider());
        this.addSoftwareServerCatalogTemplates(ContentPackDefinition.POSTGRES_CONTENT_PACK);
        this.addDataAssetCatalogTemplates(ContentPackDefinition.POSTGRES_CONTENT_PACK);
        super.addIntegrationGroups(ContentPackDefinition.POSTGRES_CONTENT_PACK);
        super.addIntegrationConnectors(ContentPackDefinition.POSTGRES_CONTENT_PACK, IntegrationGroupDefinition.POSTGRES);
        super.createGovernanceEngines(ContentPackDefinition.POSTGRES_CONTENT_PACK);
        super.createGovernanceServices(ContentPackDefinition.POSTGRES_CONTENT_PACK);
        super.createRequestTypes(ContentPackDefinition.POSTGRES_CONTENT_PACK);
        this.createAndSurveyServerGovernanceActionProcess("PostgreSQLServer", PostgresDeployedImplementationType.POSTGRESQL_SERVER.getDeployedImplementationType(), RequestTypeDefinition.CREATE_POSTGRES_SERVER, GovernanceEngineDefinition.POSTGRES_GOVERNANCE_ENGINE, RequestTypeDefinition.SURVEY_POSTGRES_SERVER, GovernanceEngineDefinition.POSTGRES_SURVEY_ENGINE, PostgresDeployedImplementationType.POSTGRESQL_SERVER.getQualifiedName());
        this.createAndCatalogServerGovernanceActionProcess("PostgreSQLServer", PostgresDeployedImplementationType.POSTGRESQL_SERVER.getDeployedImplementationType(), RequestTypeDefinition.CREATE_POSTGRES_SERVER, GovernanceEngineDefinition.POSTGRES_GOVERNANCE_ENGINE, RequestTypeDefinition.CATALOG_POSTGRES_SERVER, GovernanceEngineDefinition.POSTGRES_GOVERNANCE_ENGINE, PostgresDeployedImplementationType.POSTGRESQL_SERVER.getQualifiedName());
        this.deleteAsCatalogTargetGovernanceActionProcess("PostgreSQLServer", PostgresDeployedImplementationType.POSTGRESQL_SERVER.getAssociatedTypeName(), PostgresDeployedImplementationType.POSTGRESQL_SERVER.getDeployedImplementationType(), RequestTypeDefinition.DELETE_POSTGRES_SERVER, GovernanceEngineDefinition.POSTGRES_GOVERNANCE_ENGINE, PostgresDeployedImplementationType.POSTGRESQL_SERVER.getQualifiedName());
        this.createAndSurveyServerGovernanceActionProcess("PostgreSQLDatabase", PostgresDeployedImplementationType.POSTGRESQL_DATABASE.getDeployedImplementationType(), RequestTypeDefinition.CREATE_POSTGRES_DB, GovernanceEngineDefinition.POSTGRES_GOVERNANCE_ENGINE, RequestTypeDefinition.SURVEY_POSTGRES_DATABASE, GovernanceEngineDefinition.POSTGRES_SURVEY_ENGINE, PostgresDeployedImplementationType.POSTGRESQL_DATABASE.getQualifiedName());
        this.createAndCatalogAssetGovernanceActionProcess("PostgreSQLDatabase", PostgresDeployedImplementationType.POSTGRESQL_DATABASE.getAssociatedTypeName(), PostgresDeployedImplementationType.POSTGRESQL_DATABASE.getDeployedImplementationType(), RequestTypeDefinition.CREATE_POSTGRES_DB, GovernanceEngineDefinition.POSTGRES_GOVERNANCE_ENGINE, RequestTypeDefinition.CATALOG_POSTGRES_DATABASE, GovernanceEngineDefinition.POSTGRES_GOVERNANCE_ENGINE, PostgresDeployedImplementationType.POSTGRESQL_DATABASE.getQualifiedName());
        this.deleteAsCatalogTargetGovernanceActionProcess("PostgreSQLDatabase", PostgresDeployedImplementationType.POSTGRESQL_DATABASE.getAssociatedTypeName(), PostgresDeployedImplementationType.POSTGRESQL_DATABASE.getDeployedImplementationType(), RequestTypeDefinition.DELETE_POSTGRES_DB, GovernanceEngineDefinition.POSTGRES_GOVERNANCE_ENGINE, PostgresDeployedImplementationType.POSTGRESQL_DATABASE.getQualifiedName());
        this.createAndCatalogAssetGovernanceActionProcess("PostgreSQLDatabaseSchema", PostgresDeployedImplementationType.POSTGRESQL_DATABASE_SCHEMA.getAssociatedTypeName(), PostgresDeployedImplementationType.POSTGRESQL_DATABASE_SCHEMA.getDeployedImplementationType(), RequestTypeDefinition.CREATE_POSTGRES_SCHEMA, GovernanceEngineDefinition.POSTGRES_GOVERNANCE_ENGINE, RequestTypeDefinition.CATALOG_POSTGRES_SCHEMA, GovernanceEngineDefinition.POSTGRES_GOVERNANCE_ENGINE, PostgresDeployedImplementationType.POSTGRESQL_DATABASE_SCHEMA.getQualifiedName());
        this.deleteAsCatalogTargetGovernanceActionProcess("PostgreSQLDatabaseSchema", PostgresDeployedImplementationType.POSTGRESQL_DATABASE_SCHEMA.getAssociatedTypeName(), PostgresDeployedImplementationType.POSTGRESQL_DATABASE_SCHEMA.getDeployedImplementationType(), RequestTypeDefinition.DELETE_POSTGRES_SCHEMA, GovernanceEngineDefinition.POSTGRES_GOVERNANCE_ENGINE, PostgresDeployedImplementationType.POSTGRESQL_DATABASE_SCHEMA.getQualifiedName());
        this.archiveHelper.saveGUIDs();
        this.archiveHelper.saveUsedGUIDs();
    }

    public static void main(String[] args) {
        try {
            PostgresPackArchiveWriter archiveWriter = new PostgresPackArchiveWriter();
            archiveWriter.writeOpenMetadataArchive();
        }
        catch (Exception error) {
            System.err.println("Exception: " + error);
            System.exit(-1);
        }
    }
}

