/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.archiveutilities.openconnectors.unitycatalog;

import java.util.ArrayList;
import java.util.HashMap;
import org.odpi.openmetadata.adapters.connectors.datastore.datafolder.DataFolderProvider;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogDeployedImplementationType;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogPlaceholderProperty;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogTemplateType;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.provision.ProvisionUnityCatalogRequestParameter;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.resource.OSSUnityCatalogResourceProvider;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.sync.OSSUnityCatalogInsideCatalogSyncProvider;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.sync.OSSUnityCatalogServerSyncProvider;
import org.odpi.openmetadata.archiveutilities.openconnectors.ContentPackDefinition;
import org.odpi.openmetadata.archiveutilities.openconnectors.GovernanceEngineDefinition;
import org.odpi.openmetadata.archiveutilities.openconnectors.IntegrationGroupDefinition;
import org.odpi.openmetadata.archiveutilities.openconnectors.RequestTypeDefinition;
import org.odpi.openmetadata.archiveutilities.openconnectors.base.ContentPackBaseArchiveWriter;
import org.odpi.openmetadata.archiveutilities.openconnectors.core.CorePackArchiveWriter;
import org.odpi.openmetadata.frameworks.connectors.ConnectorProvider;
import org.odpi.openmetadata.frameworks.integration.connectors.IntegrationConnectorProvider;
import org.odpi.openmetadata.frameworks.openmetadata.controls.PlaceholderProperty;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.ResourceUse;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;

public class UnityCatalogPackArchiveWriter
extends ContentPackBaseArchiveWriter {
    public UnityCatalogPackArchiveWriter() {
        super(ContentPackDefinition.UNITY_CATALOG_CONTENT_PACK.getArchiveGUID(), ContentPackDefinition.UNITY_CATALOG_CONTENT_PACK.getArchiveName(), ContentPackDefinition.UNITY_CATALOG_CONTENT_PACK.getArchiveDescription(), ContentPackDefinition.UNITY_CATALOG_CONTENT_PACK.getArchiveFileName(), new OpenMetadataArchive[]{new CorePackArchiveWriter().getOpenMetadataArchive()});
    }

    public void getArchiveContent() {
        for (UnityCatalogDeployedImplementationType deployedImplementationType : UnityCatalogDeployedImplementationType.values()) {
            this.addDeployedImplementationType(deployedImplementationType.getDeployedImplementationType(), deployedImplementationType.getAssociatedTypeName(), deployedImplementationType.getQualifiedName(), deployedImplementationType.getCategory(), deployedImplementationType.getDescription(), deployedImplementationType.getWikiLink(), deployedImplementationType.getIsATypeOf());
        }
        this.archiveHelper.addConnectorType(null, (ConnectorProvider)new OSSUnityCatalogResourceProvider());
        this.archiveHelper.addConnectorType(null, (IntegrationConnectorProvider)new OSSUnityCatalogServerSyncProvider());
        this.archiveHelper.addConnectorType(null, (IntegrationConnectorProvider)new OSSUnityCatalogInsideCatalogSyncProvider());
        this.addSoftwareServerCatalogTemplates(ContentPackDefinition.UNITY_CATALOG_CONTENT_PACK);
        this.addOSSUCCatalogCatalogTemplate();
        this.addUCSchemaCatalogTemplate();
        this.addUCVolumeCatalogTemplate();
        this.addUCTableCatalogTemplate();
        this.addUCFunctionCatalogTemplate();
        this.addUCRegisteredModelCatalogTemplate();
        this.addUCModelVersionCatalogTemplate();
        super.addIntegrationGroups(ContentPackDefinition.UNITY_CATALOG_CONTENT_PACK);
        super.addIntegrationConnectors(ContentPackDefinition.UNITY_CATALOG_CONTENT_PACK, IntegrationGroupDefinition.UNITY_CATALOG);
        super.createGovernanceEngines(ContentPackDefinition.UNITY_CATALOG_CONTENT_PACK);
        super.createGovernanceServices(ContentPackDefinition.UNITY_CATALOG_CONTENT_PACK);
        super.createRequestTypes(ContentPackDefinition.UNITY_CATALOG_CONTENT_PACK);
        this.createAndSurveyServerGovernanceActionProcess("UnityCatalogServer", UnityCatalogDeployedImplementationType.OSS_UNITY_CATALOG_SERVER.getDeployedImplementationType(), RequestTypeDefinition.CREATE_UC_SERVER, GovernanceEngineDefinition.UNITY_CATALOG_GOVERNANCE_ENGINE, RequestTypeDefinition.SURVEY_UC_SERVER, GovernanceEngineDefinition.UNITY_CATALOG_SURVEY_ENGINE, UnityCatalogDeployedImplementationType.OSS_UNITY_CATALOG_SERVER.getQualifiedName());
        this.createAndCatalogServerGovernanceActionProcess("UnityCatalogServer", UnityCatalogDeployedImplementationType.OSS_UNITY_CATALOG_SERVER.getDeployedImplementationType(), RequestTypeDefinition.CREATE_UC_SERVER, GovernanceEngineDefinition.UNITY_CATALOG_GOVERNANCE_ENGINE, RequestTypeDefinition.CATALOG_UC_SERVER, GovernanceEngineDefinition.UNITY_CATALOG_GOVERNANCE_ENGINE, UnityCatalogDeployedImplementationType.OSS_UNITY_CATALOG_SERVER.getQualifiedName());
        this.deleteAsCatalogTargetGovernanceActionProcess("UnityCatalogServer", UnityCatalogDeployedImplementationType.OSS_UNITY_CATALOG_SERVER.getAssociatedTypeName(), UnityCatalogDeployedImplementationType.OSS_UNITY_CATALOG_SERVER.getDeployedImplementationType(), RequestTypeDefinition.DELETE_UC_SERVER, GovernanceEngineDefinition.UNITY_CATALOG_GOVERNANCE_ENGINE, UnityCatalogDeployedImplementationType.OSS_UNITY_CATALOG_SERVER.getQualifiedName());
        this.createAndSurveyServerGovernanceActionProcess("DatabricksUnityCatalogServer", UnityCatalogDeployedImplementationType.DB_UNITY_CATALOG_SERVER.getDeployedImplementationType(), RequestTypeDefinition.CREATE_DB_UC_SERVER, GovernanceEngineDefinition.UNITY_CATALOG_GOVERNANCE_ENGINE, RequestTypeDefinition.SURVEY_UC_SERVER, GovernanceEngineDefinition.UNITY_CATALOG_SURVEY_ENGINE, UnityCatalogDeployedImplementationType.DB_UNITY_CATALOG_SERVER.getQualifiedName());
        this.createAndCatalogServerGovernanceActionProcess("DatabricksUnityCatalogServer", UnityCatalogDeployedImplementationType.DB_UNITY_CATALOG_SERVER.getDeployedImplementationType(), RequestTypeDefinition.CREATE_DB_UC_SERVER, GovernanceEngineDefinition.UNITY_CATALOG_GOVERNANCE_ENGINE, RequestTypeDefinition.CATALOG_UC_SERVER, GovernanceEngineDefinition.UNITY_CATALOG_GOVERNANCE_ENGINE, UnityCatalogDeployedImplementationType.DB_UNITY_CATALOG_SERVER.getQualifiedName());
        this.deleteAsCatalogTargetGovernanceActionProcess("DatabricksUnityCatalogServer", UnityCatalogDeployedImplementationType.DB_UNITY_CATALOG_SERVER.getAssociatedTypeName(), UnityCatalogDeployedImplementationType.DB_UNITY_CATALOG_SERVER.getDeployedImplementationType(), RequestTypeDefinition.DELETE_UC_SERVER, GovernanceEngineDefinition.UNITY_CATALOG_GOVERNANCE_ENGINE, UnityCatalogDeployedImplementationType.DB_UNITY_CATALOG_SERVER.getQualifiedName());
        this.createProvisionUnityCatalogGovernanceActionProcess("UnityCatalogCatalog", UnityCatalogDeployedImplementationType.OSS_UC_CATALOG.getDeployedImplementationType(), RequestTypeDefinition.PROVISION_UC, GovernanceEngineDefinition.UNITY_CATALOG_GOVERNANCE_ENGINE, UnityCatalogDeployedImplementationType.OSS_UC_CATALOG.getQualifiedName());
        this.createProvisionUnityCatalogGovernanceActionProcess("UnityCatalogSchema", UnityCatalogDeployedImplementationType.OSS_UC_SCHEMA.getDeployedImplementationType(), RequestTypeDefinition.PROVISION_UC, GovernanceEngineDefinition.UNITY_CATALOG_GOVERNANCE_ENGINE, UnityCatalogDeployedImplementationType.OSS_UC_SCHEMA.getQualifiedName());
        this.createProvisionUnityCatalogGovernanceActionProcess("UnityCatalogVolume", UnityCatalogDeployedImplementationType.OSS_UC_VOLUME.getDeployedImplementationType(), RequestTypeDefinition.PROVISION_UC, GovernanceEngineDefinition.UNITY_CATALOG_GOVERNANCE_ENGINE, UnityCatalogDeployedImplementationType.OSS_UC_VOLUME.getQualifiedName());
        this.createProvisionUnityCatalogGovernanceActionProcess("UnityCatalogTable", UnityCatalogDeployedImplementationType.OSS_UC_TABLE.getDeployedImplementationType(), RequestTypeDefinition.PROVISION_UC, GovernanceEngineDefinition.UNITY_CATALOG_GOVERNANCE_ENGINE, UnityCatalogDeployedImplementationType.OSS_UC_TABLE.getQualifiedName());
        this.createProvisionUnityCatalogGovernanceActionProcess("UnityCatalogFunction", UnityCatalogDeployedImplementationType.OSS_UC_FUNCTION.getDeployedImplementationType(), RequestTypeDefinition.PROVISION_UC, GovernanceEngineDefinition.UNITY_CATALOG_GOVERNANCE_ENGINE, UnityCatalogDeployedImplementationType.OSS_UC_FUNCTION.getQualifiedName());
        this.archiveHelper.saveGUIDs();
        this.archiveHelper.saveUsedGUIDs();
    }

    protected void createProvisionUnityCatalogGovernanceActionProcess(String technologyName, String technologyType, RequestTypeDefinition provisionRequestType, GovernanceEngineDefinition provisionEngineDefinition, String supportedElementQualifiedName) {
        String description = "Create a " + technologyType + " element in the correct metadata collection so that it is provisioned into unity catalog.";
        String processGUID = this.archiveHelper.addGovernanceActionProcess("GovernanceActionProcess", "Provision:" + technologyName + ":GovernanceActionProcess", "Provision " + technologyType, null, description, null, 0, null, null, null);
        String step1GUID = this.archiveHelper.addGovernanceActionProcessStep("GovernanceActionProcessStep", processGUID, "GovernanceActionProcess", OpenMetadataType.ASSET.typeName, "Provision:" + technologyName + ":Step1", "Create the new element", "Create a " + technologyType + " element in the correct metadata collection so that it is provisioned into unity catalog.", 0, null, null, null, null, null, null, null, 0, true, null, null, null);
        if (step1GUID != null) {
            super.addStepExecutor(step1GUID, provisionRequestType, provisionEngineDefinition);
            HashMap<String, String> requestParameters = new HashMap<String, String>();
            requestParameters.put(ProvisionUnityCatalogRequestParameter.TECHNOLOGY_TYPE.getName(), technologyType);
            this.archiveHelper.addGovernanceActionProcessFlow(processGUID, null, requestParameters, step1GUID);
        }
        if (supportedElementQualifiedName != null) {
            String supportedElementGUID = this.archiveHelper.queryGUID(supportedElementQualifiedName);
            this.archiveHelper.addResourceListRelationshipByGUID(supportedElementGUID, processGUID, ResourceUse.SURVEY_RESOURCE.getResourceUse(), description, provisionRequestType.getRequestParameters(), false);
        }
    }

    private void addOSSUCCatalogCatalogTemplate() {
        String methodName = "addOSSUCCatalogCatalogTemplate";
        String guid = UnityCatalogTemplateType.OSS_UC_CATALOG_TEMPLATE.getDefaultTemplateGUID();
        UnityCatalogDeployedImplementationType deployedImplementationType = UnityCatalogDeployedImplementationType.OSS_UC_CATALOG;
        String qualifiedName = deployedImplementationType.getDeployedImplementationType() + ":" + PlaceholderProperty.SERVER_NETWORK_ADDRESS.getPlaceholder() + ":" + UnityCatalogPlaceholderProperty.CATALOG_NAME.getPlaceholder();
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        classifications.add(this.archiveHelper.getTemplateClassification(deployedImplementationType.getDeployedImplementationType() + " template", UnityCatalogTemplateType.OSS_UC_CATALOG_TEMPLATE.getTemplateDescription(), "V1.0", null, "addOSSUCCatalogCatalogTemplate"));
        this.archiveHelper.setGUID(qualifiedName, guid);
        String capabilityGUID = this.archiveHelper.addSoftwareCapability(deployedImplementationType.getAssociatedTypeName(), qualifiedName, UnityCatalogPlaceholderProperty.CATALOG_NAME.getPlaceholder(), PlaceholderProperty.DESCRIPTION.getPlaceholder(), deployedImplementationType.getDeployedImplementationType(), PlaceholderProperty.VERSION_IDENTIFIER.getPlaceholder(), null, null, null, null, classifications, null, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.SOFTWARE_CAPABILITY.typeName);
        assert (guid.equals(capabilityGUID));
        String deployedImplementationTypeGUID = this.archiveHelper.getGUID(deployedImplementationType.getQualifiedName());
        this.archiveHelper.addCatalogTemplateRelationship(deployedImplementationTypeGUID, capabilityGUID);
        this.archiveHelper.addPlaceholderProperties(capabilityGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.SOFTWARE_CAPABILITY.typeName, UnityCatalogPlaceholderProperty.getCatalogPlaceholderPropertyTypes());
    }

    private void addUCSchemaCatalogTemplate() {
        String methodName = "addOSSUCSchemaCatalogTemplate";
        String guid = UnityCatalogTemplateType.OSS_UC_SCHEMA_TEMPLATE.getDefaultTemplateGUID();
        UnityCatalogDeployedImplementationType deployedImplementationType = UnityCatalogDeployedImplementationType.OSS_UC_SCHEMA;
        String fullName = UnityCatalogPlaceholderProperty.CATALOG_NAME.getPlaceholder() + "." + UnityCatalogPlaceholderProperty.SCHEMA_NAME.getPlaceholder();
        String qualifiedName = deployedImplementationType.getDeployedImplementationType() + ":" + PlaceholderProperty.SERVER_NETWORK_ADDRESS.getPlaceholder() + ":" + fullName;
        HashMap<String, Object> extendedProperties = new HashMap<String, Object>();
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        extendedProperties.put(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, deployedImplementationType.getDeployedImplementationType());
        extendedProperties.put(OpenMetadataProperty.RESOURCE_NAME.name, fullName);
        classifications.add(this.archiveHelper.getTemplateClassification(deployedImplementationType.getDeployedImplementationType() + " template", UnityCatalogTemplateType.OSS_UC_SCHEMA_TEMPLATE.getTemplateDescription(), "V1.0", null, "addOSSUCSchemaCatalogTemplate"));
        this.archiveHelper.setGUID(qualifiedName, guid);
        String assetGUID = this.archiveHelper.addAsset(deployedImplementationType.getAssociatedTypeName(), qualifiedName, UnityCatalogPlaceholderProperty.SCHEMA_NAME.getPlaceholder(), PlaceholderProperty.VERSION_IDENTIFIER.getPlaceholder(), PlaceholderProperty.DESCRIPTION.getPlaceholder(), null, extendedProperties, classifications);
        assert (guid.equals(assetGUID));
        String deployedImplementationTypeGUID = this.archiveHelper.getGUID(deployedImplementationType.getQualifiedName());
        this.archiveHelper.addCatalogTemplateRelationship(deployedImplementationTypeGUID, assetGUID);
        this.archiveHelper.addPlaceholderProperties(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, UnityCatalogPlaceholderProperty.getSchemaPlaceholderPropertyTypes());
    }

    private void addUCVolumeCatalogTemplate() {
        String methodName = "addUCVolumeCatalogTemplate";
        String guid = UnityCatalogTemplateType.OSS_UC_VOLUME_TEMPLATE.getDefaultTemplateGUID();
        UnityCatalogDeployedImplementationType deployedImplementationType = UnityCatalogDeployedImplementationType.OSS_UC_VOLUME;
        String fullName = UnityCatalogPlaceholderProperty.CATALOG_NAME.getPlaceholder() + "." + UnityCatalogPlaceholderProperty.SCHEMA_NAME.getPlaceholder() + "." + UnityCatalogPlaceholderProperty.VOLUME_NAME.getPlaceholder();
        String qualifiedName = deployedImplementationType.getDeployedImplementationType() + ":" + PlaceholderProperty.SERVER_NETWORK_ADDRESS.getPlaceholder() + ":" + fullName;
        String connectorTypeGUID = new DataFolderProvider().getConnectorType().getGUID();
        HashMap<String, Object> extendedProperties = new HashMap<String, Object>();
        HashMap<String, String> facetProperties = new HashMap<String, String>();
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        extendedProperties.put(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, deployedImplementationType.getDeployedImplementationType());
        extendedProperties.put(OpenMetadataProperty.PATH_NAME.name, UnityCatalogPlaceholderProperty.STORAGE_LOCATION.getPlaceholder());
        extendedProperties.put(OpenMetadataProperty.RESOURCE_NAME.name, fullName);
        facetProperties.put(UnityCatalogPlaceholderProperty.VOLUME_TYPE.getName(), UnityCatalogPlaceholderProperty.VOLUME_TYPE.getPlaceholder());
        facetProperties.put(UnityCatalogPlaceholderProperty.STORAGE_LOCATION.getName(), UnityCatalogPlaceholderProperty.STORAGE_LOCATION.getPlaceholder());
        classifications.add(this.archiveHelper.getTemplateClassification(deployedImplementationType.getDeployedImplementationType() + " template", UnityCatalogTemplateType.OSS_UC_VOLUME_TEMPLATE.getTemplateDescription(), "V1.0", null, "addUCVolumeCatalogTemplate"));
        this.archiveHelper.setGUID(qualifiedName, guid);
        String assetGUID = this.archiveHelper.addAsset(deployedImplementationType.getAssociatedTypeName(), qualifiedName, UnityCatalogPlaceholderProperty.VOLUME_NAME.getPlaceholder(), PlaceholderProperty.VERSION_IDENTIFIER.getPlaceholder(), PlaceholderProperty.DESCRIPTION.getPlaceholder(), null, extendedProperties, classifications);
        assert (guid.equals(assetGUID));
        this.archiveHelper.addPropertyFacet(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, qualifiedName, "Unity Catalog (UC)", "1.0", "vendorProperties", facetProperties);
        String endpointGUID = this.archiveHelper.addEndpoint(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, qualifiedName + ":Endpoint", fullName + " endpoint", null, UnityCatalogPlaceholderProperty.STORAGE_LOCATION.getPlaceholder(), null, null);
        String connectionGUID = this.archiveHelper.addConnection(qualifiedName + ":Connection", fullName + " connection", null, null, null, null, null, null, null, connectorTypeGUID, endpointGUID, assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName);
        this.archiveHelper.addConnectionForAsset(assetGUID, null, connectionGUID);
        String deployedImplementationTypeGUID = this.archiveHelper.getGUID(deployedImplementationType.getQualifiedName());
        this.archiveHelper.addCatalogTemplateRelationship(deployedImplementationTypeGUID, assetGUID);
        this.archiveHelper.addPlaceholderProperties(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, UnityCatalogPlaceholderProperty.getVolumePlaceholderPropertyTypes());
    }

    private void addUCTableCatalogTemplate() {
        String methodName = "addUCTableCatalogTemplate";
        String guid = UnityCatalogTemplateType.OSS_UC_TABLE_TEMPLATE.getDefaultTemplateGUID();
        UnityCatalogDeployedImplementationType deployedImplementationType = UnityCatalogDeployedImplementationType.OSS_UC_TABLE;
        String fullName = UnityCatalogPlaceholderProperty.CATALOG_NAME.getPlaceholder() + "." + UnityCatalogPlaceholderProperty.SCHEMA_NAME.getPlaceholder() + "." + UnityCatalogPlaceholderProperty.TABLE_NAME.getPlaceholder();
        String qualifiedName = deployedImplementationType.getDeployedImplementationType() + ":" + PlaceholderProperty.SERVER_NETWORK_ADDRESS.getPlaceholder() + ":" + fullName;
        HashMap<Object, Object> extendedProperties = new HashMap<Object, Object>();
        HashMap<String, String> folderProperties = new HashMap<String, String>();
        HashMap<String, String> facetProperties = new HashMap<String, String>();
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        extendedProperties.put(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, deployedImplementationType.getDeployedImplementationType());
        extendedProperties.put(OpenMetadataProperty.RESOURCE_NAME.name, fullName);
        folderProperties.put(OpenMetadataProperty.PATH_NAME.name, UnityCatalogPlaceholderProperty.STORAGE_LOCATION.getPlaceholder());
        facetProperties.put(UnityCatalogPlaceholderProperty.STORAGE_LOCATION.getName(), UnityCatalogPlaceholderProperty.STORAGE_LOCATION.getPlaceholder());
        facetProperties.put(UnityCatalogPlaceholderProperty.TABLE_TYPE.getName(), UnityCatalogPlaceholderProperty.TABLE_TYPE.getPlaceholder());
        classifications.add(this.archiveHelper.getTemplateClassification(deployedImplementationType.getDeployedImplementationType() + " template", UnityCatalogTemplateType.OSS_UC_TABLE_TEMPLATE.getTemplateDescription(), "V1.0", null, "addUCTableCatalogTemplate"));
        classifications.add(this.archiveHelper.getDataAssetEncodingClassification(UnityCatalogPlaceholderProperty.DATA_SOURCE_FORMAT.getPlaceholder(), null, null, null));
        this.archiveHelper.setGUID(qualifiedName, guid);
        String assetGUID = this.archiveHelper.addAsset(deployedImplementationType.getAssociatedTypeName(), qualifiedName, UnityCatalogPlaceholderProperty.TABLE_NAME.getPlaceholder(), PlaceholderProperty.VERSION_IDENTIFIER.getPlaceholder(), PlaceholderProperty.DESCRIPTION.getPlaceholder(), null, extendedProperties, classifications);
        assert (guid.equals(assetGUID));
        extendedProperties = new HashMap();
        extendedProperties.put("file:///" + OpenMetadataProperty.RESOURCE_NAME.name, UnityCatalogPlaceholderProperty.STORAGE_LOCATION.getPlaceholder());
        String folderGUID = this.archiveHelper.addAnchoredAsset(OpenMetadataType.DATA_FOLDER.typeName, assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, qualifiedName + "_storageLocation", fullName + "_storageLocation", PlaceholderProperty.VERSION_IDENTIFIER.getPlaceholder(), "Location of files for table " + fullName, null, folderProperties, classifications);
        this.archiveHelper.addDataContentForDataSet(folderGUID, assetGUID);
        this.archiveHelper.addPropertyFacet(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, qualifiedName, "Unity Catalog (UC)", "1.0", "vendorProperties", facetProperties);
        String deployedImplementationTypeGUID = this.archiveHelper.getGUID(deployedImplementationType.getQualifiedName());
        this.archiveHelper.addCatalogTemplateRelationship(deployedImplementationTypeGUID, assetGUID);
        this.archiveHelper.addPlaceholderProperties(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, UnityCatalogPlaceholderProperty.getTablePlaceholderPropertyTypes());
    }

    private void addUCFunctionCatalogTemplate() {
        String methodName = "addUCFunctionCatalogTemplate";
        String guid = UnityCatalogTemplateType.OSS_UC_FUNCTION_TEMPLATE.getDefaultTemplateGUID();
        UnityCatalogDeployedImplementationType deployedImplementationType = UnityCatalogDeployedImplementationType.OSS_UC_FUNCTION;
        String fullName = UnityCatalogPlaceholderProperty.CATALOG_NAME.getPlaceholder() + "." + UnityCatalogPlaceholderProperty.SCHEMA_NAME.getPlaceholder() + "." + UnityCatalogPlaceholderProperty.FUNCTION_NAME.getPlaceholder();
        String qualifiedName = deployedImplementationType.getDeployedImplementationType() + ":" + PlaceholderProperty.SERVER_NETWORK_ADDRESS.getPlaceholder() + ":" + fullName;
        HashMap<String, Object> extendedProperties = new HashMap<String, Object>();
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        extendedProperties.put(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, deployedImplementationType.getDeployedImplementationType());
        extendedProperties.put(OpenMetadataProperty.RESOURCE_NAME.name, fullName);
        classifications.add(this.archiveHelper.getTemplateClassification(deployedImplementationType.getDeployedImplementationType() + " template", UnityCatalogTemplateType.OSS_UC_FUNCTION_TEMPLATE.getTemplateDescription(), "V1.0", null, "addUCFunctionCatalogTemplate"));
        this.archiveHelper.setGUID(qualifiedName, guid);
        String assetGUID = this.archiveHelper.addAsset(deployedImplementationType.getAssociatedTypeName(), qualifiedName, UnityCatalogPlaceholderProperty.FUNCTION_NAME.getPlaceholder(), PlaceholderProperty.VERSION_IDENTIFIER.getPlaceholder(), PlaceholderProperty.DESCRIPTION.getPlaceholder(), null, extendedProperties, classifications);
        assert (guid.equals(assetGUID));
        String deployedImplementationTypeGUID = this.archiveHelper.getGUID(deployedImplementationType.getQualifiedName());
        this.archiveHelper.addCatalogTemplateRelationship(deployedImplementationTypeGUID, assetGUID);
        this.archiveHelper.addPlaceholderProperties(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, UnityCatalogPlaceholderProperty.getFunctionPlaceholderPropertyTypes());
    }

    private void addUCRegisteredModelCatalogTemplate() {
        String methodName = "addUCRegisteredModelCatalogTemplate";
        String guid = UnityCatalogTemplateType.OSS_UC_REGISTERED_MODEL_TEMPLATE.getDefaultTemplateGUID();
        UnityCatalogDeployedImplementationType deployedImplementationType = UnityCatalogDeployedImplementationType.OSS_UC_REGISTERED_MODEL;
        String fullName = UnityCatalogPlaceholderProperty.CATALOG_NAME.getPlaceholder() + "." + UnityCatalogPlaceholderProperty.SCHEMA_NAME.getPlaceholder() + "." + UnityCatalogPlaceholderProperty.MODEL_NAME.getPlaceholder();
        String qualifiedName = deployedImplementationType.getDeployedImplementationType() + ":" + PlaceholderProperty.SERVER_NETWORK_ADDRESS.getPlaceholder() + ":" + fullName;
        HashMap<String, Object> extendedProperties = new HashMap<String, Object>();
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        extendedProperties.put(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, deployedImplementationType.getDeployedImplementationType());
        extendedProperties.put(OpenMetadataProperty.RESOURCE_NAME.name, fullName);
        classifications.add(this.archiveHelper.getTemplateClassification(deployedImplementationType.getDeployedImplementationType() + " template", UnityCatalogTemplateType.OSS_UC_REGISTERED_MODEL_TEMPLATE.getTemplateDescription(), "V1.0", null, "addUCRegisteredModelCatalogTemplate"));
        this.archiveHelper.setGUID(qualifiedName, guid);
        String assetGUID = this.archiveHelper.addAsset(deployedImplementationType.getAssociatedTypeName(), qualifiedName, UnityCatalogPlaceholderProperty.MODEL_NAME.getPlaceholder(), PlaceholderProperty.VERSION_IDENTIFIER.getPlaceholder(), PlaceholderProperty.DESCRIPTION.getPlaceholder(), null, extendedProperties, classifications);
        assert (guid.equals(assetGUID));
        String deployedImplementationTypeGUID = this.archiveHelper.getGUID(deployedImplementationType.getQualifiedName());
        this.archiveHelper.addCatalogTemplateRelationship(deployedImplementationTypeGUID, assetGUID);
        this.archiveHelper.addPlaceholderProperties(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, UnityCatalogPlaceholderProperty.getRegisteredModelPlaceholderPropertyTypes());
    }

    private void addUCModelVersionCatalogTemplate() {
        String methodName = "addUCModelVersionCatalogTemplate";
        String guid = UnityCatalogTemplateType.OSS_UC_MODEL_VERSION_TEMPLATE.getDefaultTemplateGUID();
        UnityCatalogDeployedImplementationType deployedImplementationType = UnityCatalogDeployedImplementationType.OSS_UC_REGISTERED_MODEL_VERSION;
        String fullName = UnityCatalogPlaceholderProperty.CATALOG_NAME.getPlaceholder() + "." + UnityCatalogPlaceholderProperty.SCHEMA_NAME.getPlaceholder() + "." + UnityCatalogPlaceholderProperty.MODEL_NAME.getPlaceholder();
        String qualifiedName = deployedImplementationType.getDeployedImplementationType() + ":" + PlaceholderProperty.SERVER_NETWORK_ADDRESS.getPlaceholder() + ":" + fullName + ":" + UnityCatalogPlaceholderProperty.MODEL_VERSION.getPlaceholder();
        HashMap<String, Object> extendedProperties = new HashMap<String, Object>();
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        extendedProperties.put(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, deployedImplementationType.getDeployedImplementationType());
        extendedProperties.put(OpenMetadataProperty.RESOURCE_NAME.name, fullName);
        classifications.add(this.archiveHelper.getTemplateClassification(deployedImplementationType.getDeployedImplementationType() + " template", UnityCatalogTemplateType.OSS_UC_MODEL_VERSION_TEMPLATE.getTemplateDescription(), "V1.0", null, "addUCModelVersionCatalogTemplate"));
        this.archiveHelper.setGUID(qualifiedName, guid);
        String assetGUID = this.archiveHelper.addAsset(deployedImplementationType.getAssociatedTypeName(), qualifiedName, UnityCatalogPlaceholderProperty.MODEL_NAME.getPlaceholder() + ":" + UnityCatalogPlaceholderProperty.MODEL_VERSION.getPlaceholder(), PlaceholderProperty.VERSION_IDENTIFIER.getPlaceholder(), PlaceholderProperty.DESCRIPTION.getPlaceholder(), null, extendedProperties, classifications);
        assert (guid.equals(assetGUID));
        String deployedImplementationTypeGUID = this.archiveHelper.getGUID(deployedImplementationType.getQualifiedName());
        this.archiveHelper.addCatalogTemplateRelationship(deployedImplementationTypeGUID, assetGUID);
        this.archiveHelper.addPlaceholderProperties(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, UnityCatalogPlaceholderProperty.getModelVersionPlaceholderPropertyTypes());
    }

    public static void main(String[] args) {
        try {
            UnityCatalogPackArchiveWriter archiveWriter = new UnityCatalogPackArchiveWriter();
            archiveWriter.writeOpenMetadataArchive();
        }
        catch (Exception error) {
            System.err.println("Exception: " + error);
            System.exit(-1);
        }
    }
}

