/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.archiveutilities.openconnectors;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.postgres.controls.PostgreSQLTemplateType;
import org.odpi.openmetadata.adapters.connectors.postgres.controls.PostgresDeployedImplementationType;
import org.odpi.openmetadata.adapters.connectors.postgres.controls.PostgresPlaceholderProperty;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.JDBCResourceConnectorProvider;
import org.odpi.openmetadata.adapters.connectors.secretsstore.yaml.YAMLSecretsStoreProvider;
import org.odpi.openmetadata.archiveutilities.openconnectors.ContentPackDefinition;
import org.odpi.openmetadata.frameworks.connectors.controls.SecretsStorePurpose;
import org.odpi.openmetadata.frameworks.openmetadata.controls.PlaceholderProperty;
import org.odpi.openmetadata.frameworks.openmetadata.controls.PlaceholderPropertyType;
import org.odpi.openmetadata.frameworks.openmetadata.controls.ReplacementAttributeType;
import org.odpi.openmetadata.frameworks.openmetadata.controls.TemplateDefinition;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationTypeDefinition;

public enum DataAssetTemplateDefinition implements TemplateDefinition
{
    POSTGRES_DATABASE_TEMPLATE(PostgreSQLTemplateType.POSTGRES_DATABASE_TEMPLATE.getDefaultTemplateGUID(), (DeployedImplementationTypeDefinition)PostgresDeployedImplementationType.POSTGRESQL_DATABASE, PostgresPlaceholderProperty.DATABASE_NAME.getPlaceholder(), PostgresPlaceholderProperty.DATABASE_DESCRIPTION.getPlaceholder(), PlaceholderProperty.SERVER_NAME.getPlaceholder(), PostgresPlaceholderProperty.DATABASE_USER_ID.getPlaceholder(), PostgresPlaceholderProperty.DATABASE_PASSWORD.getPlaceholder(), new JDBCResourceConnectorProvider().getConnectorType().getGUID(), "jdbc:postgresql://" + PlaceholderProperty.HOST_IDENTIFIER.getPlaceholder() + ":" + PlaceholderProperty.PORT_NUMBER.getPlaceholder() + "/" + PostgresPlaceholderProperty.DATABASE_NAME.getPlaceholder(), null, SecretsStorePurpose.REST_BASIC_AUTHENTICATION.getName(), new YAMLSecretsStoreProvider().getConnectorType().getGUID(), PlaceholderProperty.SECRETS_STORE.getPlaceholder(), null, PostgresPlaceholderProperty.getPostgresDatabasePlaceholderPropertyTypes(), ContentPackDefinition.POSTGRES_CONTENT_PACK),
    POSTGRES_SCHEMA_TEMPLATE(PostgreSQLTemplateType.POSTGRES_SCHEMA_TEMPLATE.getDefaultTemplateGUID(), (DeployedImplementationTypeDefinition)PostgresDeployedImplementationType.POSTGRESQL_DATABASE_SCHEMA, PostgresPlaceholderProperty.DATABASE_NAME.getPlaceholder(), PostgresPlaceholderProperty.DATABASE_DESCRIPTION.getPlaceholder(), PlaceholderProperty.SERVER_NAME.getPlaceholder(), PostgresPlaceholderProperty.DATABASE_USER_ID.getPlaceholder(), PostgresPlaceholderProperty.DATABASE_PASSWORD.getPlaceholder(), new JDBCResourceConnectorProvider().getConnectorType().getGUID(), "jdbc:postgresql://" + PlaceholderProperty.HOST_IDENTIFIER.getPlaceholder() + ":" + PlaceholderProperty.PORT_NUMBER.getPlaceholder() + "/" + PostgresPlaceholderProperty.DATABASE_NAME.getPlaceholder() + "?currentSchema=" + PostgresPlaceholderProperty.SCHEMA_NAME.getPlaceholder(), null, SecretsStorePurpose.REST_BASIC_AUTHENTICATION.getName(), new YAMLSecretsStoreProvider().getConnectorType().getGUID(), PlaceholderProperty.SECRETS_STORE.getPlaceholder(), null, PostgresPlaceholderProperty.getPostgresSchemaPlaceholderPropertyTypes(), ContentPackDefinition.POSTGRES_CONTENT_PACK);

    private final String guid;
    private final DeployedImplementationTypeDefinition deployedImplementationType;
    private final String assetName;
    private final String assetDescription;
    private final String serverName;
    private final String password;
    private final String userId;
    private final String connectorTypeGUID;
    private final String networkAddress;
    private final Map<String, Object> configurationProperties;
    private final String secretsStorePurpose;
    private final String secretsStoreConnectorTypeGUID;
    private final String secretsStoreFileName;
    private final List<ReplacementAttributeType> replacementAttributeTypes;
    private final List<PlaceholderPropertyType> placeholderPropertyTypes;
    private final ContentPackDefinition contentPackDefinition;

    private DataAssetTemplateDefinition(String guid, DeployedImplementationTypeDefinition deployedImplementationType, String assetName, String assetDescription, String serverName, String userId, String password, String connectorTypeGUID, String networkAddress, Map<String, Object> configurationProperties, String secretsStorePurpose, String secretsStoreConnectorTypeGUID, String secretsStoreFileName, List<ReplacementAttributeType> replacementAttributeTypes, List<PlaceholderPropertyType> placeholderPropertyTypes, ContentPackDefinition contentPackDefinition) {
        this.guid = guid;
        this.deployedImplementationType = deployedImplementationType;
        this.assetName = assetName;
        this.assetDescription = assetDescription;
        this.serverName = serverName;
        this.userId = userId;
        this.password = password;
        this.connectorTypeGUID = connectorTypeGUID;
        this.networkAddress = networkAddress;
        this.configurationProperties = configurationProperties;
        this.secretsStorePurpose = secretsStorePurpose;
        this.secretsStoreConnectorTypeGUID = secretsStoreConnectorTypeGUID;
        this.secretsStoreFileName = secretsStoreFileName;
        this.replacementAttributeTypes = replacementAttributeTypes;
        this.placeholderPropertyTypes = placeholderPropertyTypes;
        this.contentPackDefinition = contentPackDefinition;
    }

    public String getTemplateGUID() {
        return this.guid;
    }

    public String getQualifiedName() {
        return this.deployedImplementationType.getDeployedImplementationType() + ":" + this.serverName;
    }

    public String getTemplateName() {
        return this.deployedImplementationType.getDeployedImplementationType() + " template";
    }

    public String getTemplateDescription() {
        return "Create a " + this.deployedImplementationType.getDeployedImplementationType() + " asset with an associated Connection.";
    }

    public String getTemplateVersionIdentifier() {
        return "V1.0";
    }

    public DeployedImplementationTypeDefinition getDeployedImplementationType() {
        return this.deployedImplementationType;
    }

    public String getAssetName() {
        return this.assetName;
    }

    public String getAssetDescription() {
        return this.assetDescription;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getConnectorTypeGUID() {
        return this.connectorTypeGUID;
    }

    public String getNetworkAddress() {
        return this.networkAddress;
    }

    public Map<String, Object> getConfigurationProperties() {
        return this.configurationProperties;
    }

    public String getSecretsStorePurpose() {
        return this.secretsStorePurpose;
    }

    public String getSecretsStoreConnectorTypeGUID() {
        return this.secretsStoreConnectorTypeGUID;
    }

    public String getSecretsStoreFileName() {
        return this.secretsStoreFileName;
    }

    public List<PlaceholderPropertyType> getPlaceholders() {
        return this.placeholderPropertyTypes;
    }

    public List<ReplacementAttributeType> getReplacementAttributes() {
        return this.replacementAttributeTypes;
    }

    public ContentPackDefinition getContentPackDefinition() {
        return this.contentPackDefinition;
    }

    public String toString() {
        return "TemplateDefinition{templateName='" + this.getTemplateName() + "'}";
    }
}

