/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.archiveutilities.openconnectors.apachekafka;

import org.odpi.openmetadata.adapters.connectors.apachekafka.control.KafkaDeployedImplementationType;
import org.odpi.openmetadata.adapters.connectors.apachekafka.integration.KafkaTopicIntegrationProvider;
import org.odpi.openmetadata.adapters.connectors.apachekafka.resource.ApacheKafkaAdminProvider;
import org.odpi.openmetadata.adapters.connectors.apachekafka.survey.SurveyApacheKafkaServerProvider;
import org.odpi.openmetadata.archiveutilities.openconnectors.ContentPackDefinition;
import org.odpi.openmetadata.archiveutilities.openconnectors.GovernanceEngineDefinition;
import org.odpi.openmetadata.archiveutilities.openconnectors.IntegrationGroupDefinition;
import org.odpi.openmetadata.archiveutilities.openconnectors.RequestTypeDefinition;
import org.odpi.openmetadata.archiveutilities.openconnectors.base.ContentPackBaseArchiveWriter;
import org.odpi.openmetadata.archiveutilities.openconnectors.core.CorePackArchiveWriter;
import org.odpi.openmetadata.frameworks.connectors.ConnectorProvider;
import org.odpi.openmetadata.frameworks.integration.connectors.IntegrationConnectorProvider;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;

public class ApacheKafkaPackArchiveWriter
extends ContentPackBaseArchiveWriter {
    public ApacheKafkaPackArchiveWriter() {
        super(ContentPackDefinition.APACHE_KAFKA_CONTENT_PACK.getArchiveGUID(), ContentPackDefinition.APACHE_KAFKA_CONTENT_PACK.getArchiveName(), ContentPackDefinition.APACHE_KAFKA_CONTENT_PACK.getArchiveDescription(), ContentPackDefinition.APACHE_KAFKA_CONTENT_PACK.getArchiveFileName(), new OpenMetadataArchive[]{new CorePackArchiveWriter().getOpenMetadataArchive()});
    }

    public void getArchiveContent() {
        for (KafkaDeployedImplementationType deployedImplementationType : KafkaDeployedImplementationType.values()) {
            this.addDeployedImplementationType(deployedImplementationType.getDeployedImplementationType(), deployedImplementationType.getAssociatedTypeName(), deployedImplementationType.getQualifiedName(), deployedImplementationType.getCategory(), deployedImplementationType.getDescription(), deployedImplementationType.getWikiLink(), deployedImplementationType.getIsATypeOf());
        }
        this.archiveHelper.addConnectorType(null, (ConnectorProvider)new ApacheKafkaAdminProvider());
        this.archiveHelper.addConnectorType(null, (IntegrationConnectorProvider)new KafkaTopicIntegrationProvider());
        this.archiveHelper.addConnectorType(null, (ConnectorProvider)new SurveyApacheKafkaServerProvider());
        this.addSoftwareServerCatalogTemplates(ContentPackDefinition.APACHE_KAFKA_CONTENT_PACK);
        super.addIntegrationGroups(ContentPackDefinition.APACHE_KAFKA_CONTENT_PACK);
        super.addIntegrationConnectors(ContentPackDefinition.APACHE_KAFKA_CONTENT_PACK, IntegrationGroupDefinition.APACHE_KAFKA);
        super.createGovernanceEngines(ContentPackDefinition.APACHE_KAFKA_CONTENT_PACK);
        super.createGovernanceServices(ContentPackDefinition.APACHE_KAFKA_CONTENT_PACK);
        super.createRequestTypes(ContentPackDefinition.APACHE_KAFKA_CONTENT_PACK);
        this.createAndSurveyServerGovernanceActionProcess("ApacheKafkaServer", KafkaDeployedImplementationType.APACHE_KAFKA_SERVER.getDeployedImplementationType(), RequestTypeDefinition.CREATE_KAFKA_SERVER, GovernanceEngineDefinition.KAFKA_GOVERNANCE_ENGINE, RequestTypeDefinition.SURVEY_KAFKA_SERVER, GovernanceEngineDefinition.KAFKA_SURVEY_ENGINE, KafkaDeployedImplementationType.APACHE_KAFKA_SERVER.getQualifiedName());
        this.createAndCatalogServerGovernanceActionProcess("ApacheKafkaServer", KafkaDeployedImplementationType.APACHE_KAFKA_SERVER.getDeployedImplementationType(), RequestTypeDefinition.CREATE_KAFKA_SERVER, GovernanceEngineDefinition.KAFKA_GOVERNANCE_ENGINE, RequestTypeDefinition.CATALOG_KAFKA_SERVER, GovernanceEngineDefinition.KAFKA_GOVERNANCE_ENGINE, KafkaDeployedImplementationType.APACHE_KAFKA_SERVER.getQualifiedName());
        this.deleteAsCatalogTargetGovernanceActionProcess("ApacheKafkaServer", KafkaDeployedImplementationType.APACHE_KAFKA_SERVER.getAssociatedTypeName(), KafkaDeployedImplementationType.APACHE_KAFKA_SERVER.getDeployedImplementationType(), RequestTypeDefinition.DELETE_KAFKA_SERVER, GovernanceEngineDefinition.KAFKA_GOVERNANCE_ENGINE, KafkaDeployedImplementationType.APACHE_KAFKA_SERVER.getQualifiedName());
        this.archiveHelper.saveGUIDs();
        this.archiveHelper.saveUsedGUIDs();
    }

    public static void main(String[] args) {
        try {
            ApacheKafkaPackArchiveWriter archiveWriter = new ApacheKafkaPackArchiveWriter();
            archiveWriter.writeOpenMetadataArchive();
        }
        catch (Exception error) {
            System.err.println("Exception: " + error);
            System.exit(-1);
        }
    }
}

