/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.archiveutilities.openconnectors.base;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.control.EgeriaDeployedImplementationType;
import org.odpi.openmetadata.adapters.connectors.governanceactions.stewardship.ManageAssetGuard;
import org.odpi.openmetadata.archiveutilities.openconnectors.ContentPackDefinition;
import org.odpi.openmetadata.archiveutilities.openconnectors.DataAssetTemplateDefinition;
import org.odpi.openmetadata.archiveutilities.openconnectors.EndpointTemplateDefinition;
import org.odpi.openmetadata.archiveutilities.openconnectors.GovernanceEngineDefinition;
import org.odpi.openmetadata.archiveutilities.openconnectors.GovernanceServiceDefinition;
import org.odpi.openmetadata.archiveutilities.openconnectors.IntegrationConnectorDefinition;
import org.odpi.openmetadata.archiveutilities.openconnectors.IntegrationGroupDefinition;
import org.odpi.openmetadata.archiveutilities.openconnectors.RequestTypeDefinition;
import org.odpi.openmetadata.archiveutilities.openconnectors.SoftwareServerTemplateDefinition;
import org.odpi.openmetadata.frameworks.connectors.controls.SecretsStoreConfigurationProperty;
import org.odpi.openmetadata.frameworks.governanceaction.properties.NewActionTarget;
import org.odpi.openmetadata.frameworks.openmetadata.controls.PlaceholderProperty;
import org.odpi.openmetadata.frameworks.openmetadata.controls.PlaceholderPropertyType;
import org.odpi.openmetadata.frameworks.openmetadata.controls.ReplacementAttributeType;
import org.odpi.openmetadata.frameworks.openmetadata.mapper.OpenMetadataValidValues;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.AssociationType;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationType;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationTypeDefinition;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.ResourceUse;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworks.surveyaction.controls.SurveyActionGuard;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.samples.archiveutilities.EgeriaBaseArchiveWriter;
import org.odpi.openmetadata.samples.archiveutilities.GovernanceActionDescription;

public abstract class ContentPackBaseArchiveWriter
extends EgeriaBaseArchiveWriter {
    private static final Date creationDate = new Date(1639984840038L);
    protected final Map<String, String> deployedImplementationTypeQNAMEs = new HashMap<String, String>();
    private final Map<String, String> parentValidValueQNameToGUIDMap = new HashMap<String, String>();

    public ContentPackBaseArchiveWriter(String archiveGUID, String archiveName, String archiveDescription, String archiveFileName, OpenMetadataArchive[] additionalDependencies) {
        super(archiveGUID, archiveName, archiveDescription, creationDate, archiveFileName, additionalDependencies);
        for (DeployedImplementationType deployedImplementationType : DeployedImplementationType.values()) {
            this.deployedImplementationTypeQNAMEs.put(deployedImplementationType.getDeployedImplementationType(), deployedImplementationType.getQualifiedName());
        }
        for (DeployedImplementationType deployedImplementationType : EgeriaDeployedImplementationType.values()) {
            this.deployedImplementationTypeQNAMEs.put(deployedImplementationType.getDeployedImplementationType(), deployedImplementationType.getQualifiedName());
        }
    }

    protected void createDataFileCatalogTemplate(DeployedImplementationType deployedImplementationType, String connectorTypeGUID, Map<String, Object> configurationProperties) {
        String methodName = "createDataFileCatalogTemplate";
        String qualifiedName = deployedImplementationType.getDeployedImplementationType() + ":" + PlaceholderProperty.FILE_SYSTEM_NAME.getPlaceholder() + ":" + PlaceholderProperty.FILE_PATH_NAME.getPlaceholder();
        String versionIdentifier = "V1.0";
        HashMap<String, String> extendedProperties = new HashMap<String, String>();
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        extendedProperties.put(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, deployedImplementationType.getDeployedImplementationType());
        extendedProperties.put(OpenMetadataProperty.RESOURCE_NAME.name, PlaceholderProperty.FILE_PATH_NAME.getPlaceholder());
        extendedProperties.put(OpenMetadataProperty.PATH_NAME.name, PlaceholderProperty.FILE_PATH_NAME.getPlaceholder());
        extendedProperties.put(OpenMetadataProperty.FILE_TYPE.name, PlaceholderProperty.FILE_TYPE.getPlaceholder());
        extendedProperties.put(OpenMetadataProperty.FILE_EXTENSION.name, PlaceholderProperty.FILE_EXTENSION.getPlaceholder());
        extendedProperties.put(OpenMetadataProperty.FILE_NAME.name, PlaceholderProperty.FILE_NAME.getPlaceholder());
        classifications.add(this.archiveHelper.getTemplateClassification(deployedImplementationType.getDeployedImplementationType() + " template", "Create an asset of type " + deployedImplementationType.getAssociatedTypeName() + " with an associated Connection.", "V1.0", null, "createDataFileCatalogTemplate"));
        classifications.add(this.archiveHelper.getDataAssetEncodingClassification(PlaceholderProperty.FILE_ENCODING.getPlaceholder(), null, null, null));
        String assetGUID = this.archiveHelper.addAsset(deployedImplementationType.getAssociatedTypeName(), qualifiedName, PlaceholderProperty.FILE_NAME.getPlaceholder(), versionIdentifier, null, null, extendedProperties, classifications);
        String endpointGUID = this.archiveHelper.addEndpoint(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, qualifiedName + ":Endpoint", PlaceholderProperty.FILE_PATH_NAME.getPlaceholder() + " endpoint", null, PlaceholderProperty.FILE_PATH_NAME.getPlaceholder(), null, null);
        String connectionGUID = this.archiveHelper.addConnection(qualifiedName + ":Connection", PlaceholderProperty.FILE_PATH_NAME.getPlaceholder() + " connection", null, null, null, null, null, configurationProperties, null, connectorTypeGUID, endpointGUID, assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName);
        this.archiveHelper.addConnectionForAsset(assetGUID, null, connectionGUID);
        String deployedImplementationTypeGUID = this.archiveHelper.getGUID(deployedImplementationType.getQualifiedName());
        this.archiveHelper.addCatalogTemplateRelationship(deployedImplementationTypeGUID, assetGUID);
        this.archiveHelper.addPlaceholderProperties(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, PlaceholderProperty.getDataFilesPlaceholderPropertyTypes());
    }

    protected void createFolderCatalogTemplate(DeployedImplementationType deployedImplementationType, String connectorTypeGUID) {
        String methodName = "createFolderCatalogTemplate";
        String qualifiedName = deployedImplementationType.getDeployedImplementationType() + ":" + PlaceholderProperty.FILE_SYSTEM_NAME.getPlaceholder() + ":" + PlaceholderProperty.DIRECTORY_PATH_NAME.getPlaceholder();
        HashMap<String, String> extendedProperties = new HashMap<String, String>();
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        extendedProperties.put(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, deployedImplementationType.getDeployedImplementationType());
        extendedProperties.put(OpenMetadataProperty.PATH_NAME.name, PlaceholderProperty.DIRECTORY_PATH_NAME.getPlaceholder());
        extendedProperties.put(OpenMetadataProperty.RESOURCE_NAME.name, PlaceholderProperty.DIRECTORY_PATH_NAME.getPlaceholder());
        classifications.add(this.archiveHelper.getTemplateClassification(deployedImplementationType.getDeployedImplementationType() + " template", "Create an asset of type " + deployedImplementationType.getAssociatedTypeName() + " with an associated Connection.", "V1.0", null, "createFolderCatalogTemplate"));
        String assetGUID = this.archiveHelper.addAsset(deployedImplementationType.getAssociatedTypeName(), qualifiedName, PlaceholderProperty.DIRECTORY_NAME.getPlaceholder(), PlaceholderProperty.VERSION_IDENTIFIER.getPlaceholder(), PlaceholderProperty.DESCRIPTION.getPlaceholder(), null, extendedProperties, classifications);
        if (connectorTypeGUID != null) {
            String endpointGUID = this.archiveHelper.addEndpoint(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, qualifiedName + ":Endpoint", PlaceholderProperty.DIRECTORY_PATH_NAME.getPlaceholder() + " endpoint", null, PlaceholderProperty.DIRECTORY_PATH_NAME.getPlaceholder(), null, null);
            String connectionGUID = this.archiveHelper.addConnection(qualifiedName + ":Connection", PlaceholderProperty.DIRECTORY_PATH_NAME.getPlaceholder() + " connection", null, null, null, null, null, null, null, connectorTypeGUID, endpointGUID, assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName);
            this.archiveHelper.addConnectionForAsset(assetGUID, null, connectionGUID);
        }
        String deployedImplementationTypeGUID = this.archiveHelper.getGUID(deployedImplementationType.getQualifiedName());
        this.archiveHelper.addCatalogTemplateRelationship(deployedImplementationTypeGUID, assetGUID);
        this.archiveHelper.addPlaceholderProperties(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, PlaceholderProperty.getFolderPlaceholderPropertyTypes());
    }

    protected void createDataSetCatalogTemplate(DeployedImplementationType deployedImplementationType, String qualifiedName, String connectorTypeGUID) {
        String methodName = "createDataSetCatalogTemplate";
        HashMap<String, String> extendedProperties = new HashMap<String, String>();
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        extendedProperties.put(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, deployedImplementationType.getDeployedImplementationType());
        classifications.add(this.archiveHelper.getTemplateClassification(deployedImplementationType.getDeployedImplementationType() + " template", "Create an asset of type " + deployedImplementationType.getAssociatedTypeName() + " with an associated Connection.", "V1.0", null, "createDataSetCatalogTemplate"));
        String assetGUID = this.archiveHelper.addAsset(deployedImplementationType.getAssociatedTypeName(), qualifiedName, PlaceholderProperty.DISPLAY_NAME.getPlaceholder(), PlaceholderProperty.VERSION_IDENTIFIER.getPlaceholder(), PlaceholderProperty.DESCRIPTION.getPlaceholder(), null, extendedProperties, classifications);
        if (connectorTypeGUID != null) {
            String connectionGUID = this.archiveHelper.addConnection(qualifiedName + ":Connection", PlaceholderProperty.DISPLAY_NAME.getPlaceholder() + " connection", null, null, null, null, null, null, null, connectorTypeGUID, null, assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName);
            this.archiveHelper.addConnectionForAsset(assetGUID, null, connectionGUID);
        }
        String deployedImplementationTypeGUID = this.archiveHelper.getGUID(deployedImplementationType.getQualifiedName());
        this.archiveHelper.addCatalogTemplateRelationship(deployedImplementationTypeGUID, assetGUID);
        this.archiveHelper.addPlaceholderProperties(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, PlaceholderProperty.getDataSetPlaceholderPropertyTypes());
    }

    protected void createSoftwareFileCatalogTemplate(DeployedImplementationType deployedImplementationType, String connectorTypeGUID) {
        String methodName = "createSoftwareFileCatalogTemplate";
        String qualifiedName = deployedImplementationType.getDeployedImplementationType() + ":" + PlaceholderProperty.FILE_SYSTEM_NAME.getPlaceholder() + ":" + PlaceholderProperty.FILE_PATH_NAME.getPlaceholder();
        HashMap<String, String> extendedProperties = new HashMap<String, String>();
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        extendedProperties.put(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, deployedImplementationType.getDeployedImplementationType());
        extendedProperties.put(OpenMetadataProperty.RESOURCE_NAME.name, PlaceholderProperty.FILE_PATH_NAME.getPlaceholder());
        extendedProperties.put(OpenMetadataProperty.PATH_NAME.name, PlaceholderProperty.FILE_PATH_NAME.getPlaceholder());
        extendedProperties.put(OpenMetadataProperty.FILE_TYPE.name, PlaceholderProperty.FILE_TYPE.getPlaceholder());
        extendedProperties.put(OpenMetadataProperty.FILE_EXTENSION.name, PlaceholderProperty.FILE_EXTENSION.getPlaceholder());
        extendedProperties.put(OpenMetadataProperty.FILE_NAME.name, PlaceholderProperty.FILE_NAME.getPlaceholder());
        classifications.add(this.archiveHelper.getTemplateClassification(deployedImplementationType.getDeployedImplementationType() + " template", "Create an asset of type " + deployedImplementationType.getAssociatedTypeName() + " with an associated Connection.", "V1.0", null, "createSoftwareFileCatalogTemplate"));
        classifications.add(this.archiveHelper.getDataAssetEncodingClassification(PlaceholderProperty.FILE_ENCODING.getPlaceholder(), PlaceholderProperty.PROGRAMMING_LANGUAGE.getPlaceholder(), null, null));
        String assetGUID = this.archiveHelper.addAsset(deployedImplementationType.getAssociatedTypeName(), qualifiedName, PlaceholderProperty.FILE_NAME.getPlaceholder(), PlaceholderProperty.VERSION_IDENTIFIER.getPlaceholder(), PlaceholderProperty.DESCRIPTION.getPlaceholder(), null, extendedProperties, classifications);
        if (connectorTypeGUID != null) {
            String endpointGUID = this.archiveHelper.addEndpoint(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, qualifiedName + ":Endpoint", PlaceholderProperty.FILE_PATH_NAME.getPlaceholder() + " endpoint", null, PlaceholderProperty.FILE_PATH_NAME.getPlaceholder(), null, null);
            String connectionGUID = this.archiveHelper.addConnection(qualifiedName + ":Connection", PlaceholderProperty.FILE_PATH_NAME.getPlaceholder() + " connection", null, null, null, null, null, null, null, connectorTypeGUID, endpointGUID, assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName);
            this.archiveHelper.addConnectionForAsset(assetGUID, null, connectionGUID);
        }
        String deployedImplementationTypeGUID = this.archiveHelper.getGUID(deployedImplementationType.getQualifiedName());
        this.archiveHelper.addCatalogTemplateRelationship(deployedImplementationTypeGUID, assetGUID);
        this.archiveHelper.addPlaceholderProperties(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, PlaceholderProperty.getSoftwareFilesPlaceholderPropertyTypes());
    }

    protected void addSoftwareServerCatalogTemplates(ContentPackDefinition contentPackDefinition) {
        for (SoftwareServerTemplateDefinition templateDefinition : SoftwareServerTemplateDefinition.values()) {
            if (templateDefinition.getContentPackDefinition() != contentPackDefinition) continue;
            this.createSoftwareServerCatalogTemplate(templateDefinition.getTemplateGUID(), templateDefinition.getQualifiedName(), templateDefinition.getTemplateName(), templateDefinition.getTemplateDescription(), templateDefinition.getTemplateVersionIdentifier(), templateDefinition.getDeployedImplementationType(), templateDefinition.getSoftwareCapabilityType(), templateDefinition.getSoftwareCapabilityName(), templateDefinition.getServerName(), templateDefinition.getServerDescription(), templateDefinition.getUserId(), templateDefinition.getConnectorTypeGUID(), templateDefinition.getNetworkAddress(), templateDefinition.getConfigurationProperties(), templateDefinition.getSecretsStorePurpose(), templateDefinition.getSecretsStoreConnectorTypeGUID(), templateDefinition.getSecretsStoreFileName(), templateDefinition.getReplacementAttributes(), templateDefinition.getPlaceholders());
        }
    }

    protected void addDataAssetCatalogTemplates(ContentPackDefinition contentPackDefinition) {
        for (DataAssetTemplateDefinition templateDefinition : DataAssetTemplateDefinition.values()) {
            if (templateDefinition.getContentPackDefinition() != contentPackDefinition) continue;
            this.createDataAssetCatalogTemplate(templateDefinition.getTemplateGUID(), templateDefinition.getDeployedImplementationType(), templateDefinition.getAssetName(), templateDefinition.getAssetDescription(), templateDefinition.getServerName(), templateDefinition.getUserId(), templateDefinition.getPassword(), templateDefinition.getConnectorTypeGUID(), templateDefinition.getNetworkAddress(), templateDefinition.getConfigurationProperties(), templateDefinition.getSecretsStorePurpose(), templateDefinition.getSecretsStoreConnectorTypeGUID(), templateDefinition.getSecretsStoreFileName(), templateDefinition.getReplacementAttributes(), templateDefinition.getPlaceholders());
        }
    }

    protected void createSoftwareServerCatalogTemplate(String guid, String qualifiedName, String templateName, String templateDescription, String templateVersion, DeployedImplementationTypeDefinition deployedImplementationType, DeployedImplementationTypeDefinition softwareCapabilityType, String softwareCapabilityName, String serverName, String description, String userId, String connectorTypeGUID, String networkAddress, Map<String, Object> configurationProperties, String secretsStorePurpose, String secretsStoreConnectorTypeGUID, String secretsStoreFileName, List<ReplacementAttributeType> replacementAttributeTypes, List<PlaceholderPropertyType> placeholderPropertyTypes) {
        String connectionGUID;
        String methodName = "createSoftwareServerCatalogTemplate";
        HashMap<String, String> extendedProperties = new HashMap<String, String>();
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        extendedProperties.put(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, deployedImplementationType.getDeployedImplementationType());
        extendedProperties.put(OpenMetadataProperty.RESOURCE_NAME.name, serverName);
        if (deployedImplementationType.getAssociatedClassification() != null) {
            classifications.add(this.archiveHelper.getServerPurposeClassification(deployedImplementationType.getAssociatedClassification(), null));
        }
        classifications.add(this.archiveHelper.getTemplateClassification(templateName, templateDescription, templateVersion, null, "createSoftwareServerCatalogTemplate"));
        this.archiveHelper.setGUID(qualifiedName, guid);
        String assetGUID = this.archiveHelper.addAsset(deployedImplementationType.getAssociatedTypeName(), qualifiedName, serverName, PlaceholderProperty.VERSION_IDENTIFIER.getPlaceholder(), description, null, extendedProperties, classifications);
        assert (guid.equals(assetGUID));
        if (softwareCapabilityType != null) {
            this.archiveHelper.addSoftwareCapability(softwareCapabilityType.getAssociatedTypeName(), qualifiedName + ":" + softwareCapabilityName, softwareCapabilityName, null, softwareCapabilityType.getDeployedImplementationType(), null, null, null, null, null, (Classification)null, assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName);
            this.archiveHelper.addSupportedSoftwareCapabilityRelationship(qualifiedName + ":" + softwareCapabilityName, qualifiedName, null, null, null, null, 1);
        }
        String endpointGUID = this.archiveHelper.addEndpoint(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, qualifiedName + ":Endpoint", serverName + " endpoint", null, networkAddress, null, null);
        this.archiveHelper.addServerEndpointRelationship(assetGUID, endpointGUID);
        if (secretsStoreConnectorTypeGUID == null) {
            connectionGUID = this.archiveHelper.addConnection(qualifiedName + ":Connection", serverName + " connection", null, userId, null, null, null, configurationProperties, null, connectorTypeGUID, endpointGUID, assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName);
        } else {
            connectionGUID = this.archiveHelper.addConnection(OpenMetadataType.VIRTUAL_CONNECTION.typeName, qualifiedName + ":Connection", serverName + " connection", null, userId, null, null, null, configurationProperties, null, connectorTypeGUID, endpointGUID, assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName);
            HashMap<String, String> secretsStoreConfigurationProperties = new HashMap<String, String>();
            secretsStoreConfigurationProperties.put(SecretsStoreConfigurationProperty.SECRETS_COLLECTION_NAME.getName(), qualifiedName);
            String secretStoreEndpointGUID = this.archiveHelper.addEndpoint(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, qualifiedName + ":SecretStoreEndpoint", serverName + " secret store endpoint", null, secretsStoreFileName, null, null);
            String secretsStoreConnectionGUID = this.archiveHelper.addConnection(OpenMetadataType.CONNECTION.typeName, qualifiedName + ":SecretsStoreConnection", serverName + " secrets store connection", null, null, null, null, null, secretsStoreConfigurationProperties, null, secretsStoreConnectorTypeGUID, secretStoreEndpointGUID, assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName);
            this.archiveHelper.addEmbeddedConnection(connectionGUID, 0, secretsStorePurpose, null, secretsStoreConnectionGUID);
        }
        this.archiveHelper.addConnectionForAsset(assetGUID, null, connectionGUID);
        String deployedImplementationTypeGUID = this.archiveHelper.getGUID(deployedImplementationType.getQualifiedName());
        this.archiveHelper.addCatalogTemplateRelationship(deployedImplementationTypeGUID, assetGUID);
        this.archiveHelper.addReplacementAttributes(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, replacementAttributeTypes);
        this.archiveHelper.addPlaceholderProperties(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, placeholderPropertyTypes);
    }

    private void addEndpointCatalogTemplates() {
        for (EndpointTemplateDefinition templateDefinition : EndpointTemplateDefinition.values()) {
            this.createEndpointCatalogTemplate(templateDefinition.getTemplateGUID(), templateDefinition.getTemplateName(), templateDefinition.getTemplateDescription(), templateDefinition.getTemplateVersionIdentifier(), templateDefinition.getDeployedImplementationType(), templateDefinition.getServerName(), templateDefinition.getEndpointDescription(), templateDefinition.getNetworkAddress(), templateDefinition.getProtocol(), templateDefinition.getPlaceholders());
        }
    }

    protected void createEndpointCatalogTemplate(String guid, String templateName, String templateDescription, String templateVersion, DeployedImplementationTypeDefinition deployedImplementationType, String serverName, String description, String networkAddress, String protocol, List<PlaceholderPropertyType> placeholderPropertyTypes) {
        String methodName = "createEndpointCatalogTemplate";
        String qualifiedName = deployedImplementationType.getDeployedImplementationType() + ":" + serverName;
        Classification templateClassification = this.archiveHelper.getTemplateClassification(templateName, templateDescription, templateVersion, null, "createEndpointCatalogTemplate");
        this.archiveHelper.setGUID(qualifiedName, guid);
        String endpointGUID = this.archiveHelper.addEndpoint(null, OpenMetadataType.ENDPOINT.typeName, OpenMetadataType.ENDPOINT.typeName, qualifiedName, serverName + " endpoint", description, networkAddress, protocol, null, templateClassification);
        assert (guid.equals(endpointGUID));
        String deployedImplementationTypeGUID = this.archiveHelper.getGUID(deployedImplementationType.getQualifiedName());
        this.archiveHelper.addCatalogTemplateRelationship(deployedImplementationTypeGUID, endpointGUID);
        this.archiveHelper.addPlaceholderProperties(endpointGUID, OpenMetadataType.ENDPOINT.typeName, OpenMetadataType.ENDPOINT.typeName, placeholderPropertyTypes);
    }

    protected void createHostCatalogTemplate(String guid, DeployedImplementationType deployedImplementationType, DeployedImplementationType softwareCapabilityType, String softwareCapabilityName, Classification softwareCapabilityClassification) {
        String methodName = "createHostCatalogTemplate";
        String qualifiedName = deployedImplementationType.getDeployedImplementationType() + ":" + PlaceholderProperty.HOST_URL.getPlaceholder();
        HashMap<String, String> extendedProperties = new HashMap<String, String>();
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        extendedProperties.put(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, deployedImplementationType.getDeployedImplementationType());
        extendedProperties.put(OpenMetadataProperty.RESOURCE_NAME.name, PlaceholderProperty.HOST_URL.getPlaceholder());
        classifications.add(this.archiveHelper.getTemplateClassification(deployedImplementationType.getDeployedImplementationType() + " template", "Create a " + deployedImplementationType.getDeployedImplementationType() + " Host with an associated SoftwareCapability.", "V1.0", null, "createHostCatalogTemplate"));
        this.archiveHelper.setGUID(qualifiedName, guid);
        String assetGUID = this.archiveHelper.addAsset(deployedImplementationType.getAssociatedTypeName(), qualifiedName, PlaceholderProperty.DISPLAY_NAME.getPlaceholder(), PlaceholderProperty.VERSION_IDENTIFIER.getPlaceholder(), PlaceholderProperty.DESCRIPTION.getPlaceholder(), null, extendedProperties, classifications);
        assert (guid.equals(assetGUID));
        if (softwareCapabilityType != null) {
            this.archiveHelper.addSoftwareCapability(softwareCapabilityType.getAssociatedTypeName(), qualifiedName + ":" + softwareCapabilityName, softwareCapabilityName, null, softwareCapabilityType.getDeployedImplementationType(), null, null, null, null, null, softwareCapabilityClassification, assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName);
            this.archiveHelper.addSupportedSoftwareCapabilityRelationship(qualifiedName + ":" + softwareCapabilityName, qualifiedName, null, null, null, null, 1);
        }
        String deployedImplementationTypeGUID = this.archiveHelper.getGUID(deployedImplementationType.getQualifiedName());
        this.archiveHelper.addCatalogTemplateRelationship(deployedImplementationTypeGUID, assetGUID);
        this.archiveHelper.addPlaceholderProperties(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, PlaceholderProperty.getHostPlaceholderPropertyTypes());
    }

    protected void createSoftwareCapabilityCatalogTemplate(String guid, DeployedImplementationType deployedImplementationType, String serverQualifiedName, String softwareCapabilityName, String softwareCapabilityDescription, Classification softwareCapabilityClassification, List<ReplacementAttributeType> replacementAttributeTypes, List<PlaceholderPropertyType> placeholderPropertyTypes) {
        String methodName = "createSoftwareCapabilityCatalogTemplate";
        String qualifiedName = deployedImplementationType.getAssociatedTypeName() + ":" + deployedImplementationType.getDeployedImplementationType() + ":" + serverQualifiedName + ":" + softwareCapabilityName;
        HashMap<String, String> extendedProperties = new HashMap<String, String>();
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        extendedProperties.put(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, deployedImplementationType.getDeployedImplementationType());
        classifications.add(this.archiveHelper.getTemplateClassification(deployedImplementationType.getDeployedImplementationType() + " template", "Create a " + deployedImplementationType.getDeployedImplementationType() + " SoftwareCapability.", "V1.0", null, "createSoftwareCapabilityCatalogTemplate"));
        if (softwareCapabilityClassification != null) {
            classifications.add(softwareCapabilityClassification);
        }
        this.archiveHelper.setGUID(qualifiedName, guid);
        String capabilityGUID = this.archiveHelper.addSoftwareCapability(deployedImplementationType.getAssociatedTypeName(), qualifiedName, softwareCapabilityName, softwareCapabilityDescription, deployedImplementationType.getDeployedImplementationType(), PlaceholderProperty.VERSION_IDENTIFIER.getPlaceholder(), null, null, null, extendedProperties, classifications, null, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.SOFTWARE_CAPABILITY.typeName);
        assert (guid.equals(capabilityGUID));
        String deployedImplementationTypeGUID = this.archiveHelper.getGUID(deployedImplementationType.getQualifiedName());
        this.archiveHelper.addCatalogTemplateRelationship(deployedImplementationTypeGUID, capabilityGUID);
        this.archiveHelper.addReplacementAttributes(capabilityGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.SOFTWARE_CAPABILITY.typeName, replacementAttributeTypes);
        this.archiveHelper.addPlaceholderProperties(capabilityGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.SOFTWARE_CAPABILITY.typeName, placeholderPropertyTypes);
    }

    protected void createDataAssetCatalogTemplate(String guid, DeployedImplementationTypeDefinition deployedImplementationType, String assetName, String assetDescription, String serverName, String userId, String password, String connectorTypeGUID, String networkAddress, Map<String, Object> configurationProperties, String secretsStorePurpose, String secretsStoreConnectorTypeGUID, String secretsStoreFileName, List<ReplacementAttributeType> replacementAttributeTypes, List<PlaceholderPropertyType> placeholderPropertyTypes) {
        String connectionGUID;
        String methodName = "createDataAssetCatalogTemplate";
        String qualifiedName = serverName == null ? deployedImplementationType.getDeployedImplementationType() + ":" + assetName : deployedImplementationType.getDeployedImplementationType() + ":" + serverName + ":" + assetName;
        String versionIdentifier = "V1.0";
        HashMap<String, String> extendedProperties = new HashMap<String, String>();
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        extendedProperties.put(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, deployedImplementationType.getDeployedImplementationType());
        classifications.add(this.archiveHelper.getTemplateClassification(deployedImplementationType.getDeployedImplementationType() + " template", null, "V1.0", null, "createDataAssetCatalogTemplate"));
        this.archiveHelper.setGUID(qualifiedName, guid);
        String assetGUID = this.archiveHelper.addAsset(deployedImplementationType.getAssociatedTypeName(), qualifiedName, assetName, versionIdentifier, assetDescription, null, extendedProperties, classifications);
        assert (guid.equals(assetGUID));
        String endpointGUID = this.archiveHelper.addEndpoint(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, qualifiedName + ":Endpoint", assetName + " endpoint", null, networkAddress, null, null);
        if (secretsStoreConnectorTypeGUID == null) {
            connectionGUID = this.archiveHelper.addConnection(qualifiedName + ":Connection", serverName + " connection", null, userId, password, null, null, configurationProperties, null, connectorTypeGUID, endpointGUID, assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName);
        } else {
            connectionGUID = this.archiveHelper.addConnection(OpenMetadataType.VIRTUAL_CONNECTION.typeName, qualifiedName + ":Connection", serverName + " connection", null, userId, password, null, null, configurationProperties, null, connectorTypeGUID, endpointGUID, assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName);
            HashMap<String, CallSite> secretsStoreConfigurationProperties = new HashMap<String, CallSite>();
            secretsStoreConfigurationProperties.put(SecretsStoreConfigurationProperty.SECRETS_COLLECTION_NAME.getName(), (CallSite)((Object)qualifiedName));
            String secretStoreEndpointGUID = this.archiveHelper.addEndpoint(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, qualifiedName + ":SecretStoreEndpoint", serverName + " secret store endpoint", null, secretsStoreFileName, null, null);
            String secretsStoreConnectionGUID = this.archiveHelper.addConnection(OpenMetadataType.CONNECTION.typeName, qualifiedName + ":SecretsStoreConnection", serverName + " secrets store connection", null, null, null, null, null, secretsStoreConfigurationProperties, null, secretsStoreConnectorTypeGUID, secretStoreEndpointGUID, assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName);
            this.archiveHelper.addEmbeddedConnection(connectionGUID, 0, secretsStorePurpose, null, secretsStoreConnectionGUID);
        }
        this.archiveHelper.addConnectionForAsset(assetGUID, null, connectionGUID);
        String deployedImplementationTypeGUID = this.archiveHelper.getGUID(deployedImplementationType.getQualifiedName());
        this.archiveHelper.addCatalogTemplateRelationship(deployedImplementationTypeGUID, assetGUID);
        this.archiveHelper.addReplacementAttributes(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, replacementAttributeTypes);
        this.archiveHelper.addPlaceholderProperties(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, placeholderPropertyTypes);
    }

    protected void createDataAssetCatalogTemplate(String guid, DeployedImplementationTypeDefinition deployedImplementationType, String assetName, String assetDescription, String serverName, String userId, String password, String connectorTypeGUID, String networkAddress, Map<String, Object> configurationProperties, List<ReplacementAttributeType> replacementAttributeTypes, List<PlaceholderPropertyType> placeholderPropertyTypes) {
        String methodName = "createDataAssetCatalogTemplate";
        String qualifiedName = serverName == null ? deployedImplementationType.getDeployedImplementationType() + ":" + assetName : deployedImplementationType.getDeployedImplementationType() + ":" + serverName + ":" + assetName;
        String versionIdentifier = "V1.0";
        HashMap<String, String> extendedProperties = new HashMap<String, String>();
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        extendedProperties.put(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, deployedImplementationType.getDeployedImplementationType());
        classifications.add(this.archiveHelper.getTemplateClassification(deployedImplementationType.getDeployedImplementationType() + " template", null, "V1.0", null, "createDataAssetCatalogTemplate"));
        this.archiveHelper.setGUID(qualifiedName, guid);
        String assetGUID = this.archiveHelper.addAsset(deployedImplementationType.getAssociatedTypeName(), qualifiedName, assetName, versionIdentifier, assetDescription, null, extendedProperties, classifications);
        assert (guid.equals(assetGUID));
        String endpointGUID = this.archiveHelper.addEndpoint(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, qualifiedName + ":Endpoint", assetName + " endpoint", null, networkAddress, null, null);
        String connectionGUID = this.archiveHelper.addConnection(qualifiedName + ":Connection", assetName + " connection", null, userId, password, null, null, configurationProperties, null, connectorTypeGUID, endpointGUID, assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName);
        this.archiveHelper.addConnectionForAsset(assetGUID, null, connectionGUID);
        String deployedImplementationTypeGUID = this.archiveHelper.getGUID(deployedImplementationType.getQualifiedName());
        this.archiveHelper.addCatalogTemplateRelationship(deployedImplementationTypeGUID, assetGUID);
        this.archiveHelper.addReplacementAttributes(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, replacementAttributeTypes);
        this.archiveHelper.addPlaceholderProperties(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, placeholderPropertyTypes);
    }

    protected String addDeployedImplementationType(String deployedImplementationType, String associatedTypeName, String qualifiedName, String category, String description, String wikiLink, DeployedImplementationTypeDefinition isATypeOf) {
        String parentSetGUID = this.getParentSet(null, associatedTypeName, OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, null);
        HashMap<String, String> additionalProperties = new HashMap<String, String>();
        additionalProperties.put(OpenMetadataProperty.OPEN_METADATA_TYPE_NAME.name, associatedTypeName);
        String validValueGUID = this.archiveHelper.addValidValue(null, parentSetGUID, parentSetGUID, OpenMetadataType.VALID_VALUE_SET.typeName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, OpenMetadataType.VALID_VALUE_SET.typeName, qualifiedName, deployedImplementationType, description, category, "Used to control valid values in open metadata.", "string", "Open Metadata Ecosystem", deployedImplementationType, false, false, additionalProperties);
        if (wikiLink != null) {
            String externalReferenceGUID = this.archiveHelper.addExternalReference(null, validValueGUID, OpenMetadataType.VALID_VALUE_SET.typeName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, qualifiedName + "_wikiLink", "More information about deployedImplementationType: " + deployedImplementationType, null, null, null, null, 0, null, null, null, null, null, null, wikiLink, null, null, null, null, null, null, null, null, null, null, null, null);
            this.archiveHelper.addExternalReferenceLink(validValueGUID, externalReferenceGUID, null, null, null);
        }
        if (isATypeOf != null) {
            this.archiveHelper.addValidValueAssociationRelationship(qualifiedName, isATypeOf.getQualifiedName(), "isATypeOf", AssociationType.INHERITANCE.getName(), null);
        }
        return validValueGUID;
    }

    protected String getParentSet(String requestedGUID, String typeName, String propertyName, String mapName) {
        String parentDescription = "Organizing set for valid metadata values";
        String parentQualifiedName = OpenMetadataValidValues.constructValidValueQualifiedName((String)typeName, (String)propertyName, (String)mapName, null);
        String parentSetGUID = this.parentValidValueQNameToGUIDMap.get(parentQualifiedName);
        if (parentSetGUID == null) {
            String grandParentSetGUID = null;
            String parentDisplayName = parentQualifiedName.substring(26);
            if (mapName != null) {
                grandParentSetGUID = this.getParentSet(null, typeName, propertyName, null);
            } else if (propertyName != null) {
                grandParentSetGUID = this.getParentSet(null, typeName, null, null);
            } else if (typeName != null) {
                grandParentSetGUID = this.getParentSet(null, null, null, null);
            }
            parentSetGUID = this.archiveHelper.addValidValue(requestedGUID, grandParentSetGUID, grandParentSetGUID, OpenMetadataType.VALID_VALUE_SET.typeName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, OpenMetadataType.VALID_VALUE_SET.typeName, parentQualifiedName, parentDisplayName, "Organizing set for valid metadata values", OpenMetadataValidValues.constructValidValueCategory((String)typeName, (String)propertyName, (String)mapName), "Used to control valid values in open metadata.", null, "Open Metadata Ecosystem", null, false, false, null);
            this.parentValidValueQNameToGUIDMap.put(parentQualifiedName, parentSetGUID);
            return parentSetGUID;
        }
        return parentSetGUID;
    }

    protected void addIntegrationGroups(ContentPackDefinition contentPackDefinition) {
        for (IntegrationGroupDefinition integrationGroupDefinition : IntegrationGroupDefinition.values()) {
            if (integrationGroupDefinition.getContentPackDefinition() != contentPackDefinition) continue;
            this.archiveHelper.setGUID(integrationGroupDefinition.getQualifiedName(), integrationGroupDefinition.getGUID());
            String integrationGroupGUID = this.archiveHelper.addIntegrationGroup(integrationGroupDefinition.getQualifiedName(), integrationGroupDefinition.getName(), integrationGroupDefinition.getDescription(), null, null, contentPackDefinition.getArchiveFileName(), null, null);
            assert (integrationGroupDefinition.getGUID().equals(integrationGroupGUID));
        }
    }

    protected void addIntegrationConnectors(ContentPackDefinition contentPackDefinition, IntegrationGroupDefinition integrationGroupDefinition) {
        for (IntegrationConnectorDefinition integrationConnectorDefinition : IntegrationConnectorDefinition.values()) {
            if (!contentPackDefinition.equals((Object)integrationConnectorDefinition.getContentPackDefinition())) continue;
            this.archiveHelper.setGUID(integrationConnectorDefinition.getQualifiedName(integrationGroupDefinition.getQualifiedName()), integrationConnectorDefinition.getGUID());
            String guid = this.archiveHelper.addIntegrationConnector(integrationConnectorDefinition.getConnectorProviderClassName(), integrationConnectorDefinition.getConfigurationProperties(), integrationConnectorDefinition.getQualifiedName(integrationGroupDefinition.getQualifiedName()), integrationConnectorDefinition.getDisplayName(), integrationConnectorDefinition.getDescription(), integrationConnectorDefinition.getEndpointAddress(), null);
            assert (integrationConnectorDefinition.getGUID().equals(guid));
            this.archiveHelper.addRegisteredIntegrationConnector(integrationGroupDefinition.getGUID(), integrationConnectorDefinition.getConnectorName(), integrationConnectorDefinition.getConnectorUserId(), integrationConnectorDefinition.getMetadataSourceQualifiedName(), integrationConnectorDefinition.getRefreshTimeInterval(), integrationConnectorDefinition.getGUID());
            this.archiveHelper.addITProfile(integrationConnectorDefinition.getGUID(), integrationConnectorDefinition.getConnectorUserId(), integrationConnectorDefinition.getQualifiedName(integrationGroupDefinition.getQualifiedName()) + ":ActorProfile", integrationConnectorDefinition.getConnectorName(), integrationConnectorDefinition.getDescription(), null);
            if (integrationConnectorDefinition.getDeployedImplementationTypes() == null) continue;
            for (String deployedImplementationType : integrationConnectorDefinition.getDeployedImplementationTypes()) {
                String deployedImplementationTypeGUID = this.archiveHelper.queryGUID(deployedImplementationType);
                this.archiveHelper.addResourceListRelationshipByGUID(deployedImplementationTypeGUID, integrationConnectorDefinition.getGUID(), integrationConnectorDefinition.getResourceUse().getResourceUse(), integrationConnectorDefinition.getResourceUse().getDescription());
            }
        }
    }

    protected void createGovernanceEngines(ContentPackDefinition contentPackDefinition) {
        for (GovernanceEngineDefinition governanceEngineDefinition : GovernanceEngineDefinition.values()) {
            this.createGovernanceEngine(governanceEngineDefinition, contentPackDefinition);
        }
    }

    private void createGovernanceEngine(GovernanceEngineDefinition governanceEngineDefinition, ContentPackDefinition contentPackDefinition) {
        if (contentPackDefinition.equals((Object)governanceEngineDefinition.getContentPackDefinition())) {
            this.archiveHelper.setGUID(governanceEngineDefinition.getName(), governanceEngineDefinition.getGUID());
            this.archiveHelper.addGovernanceEngine(governanceEngineDefinition.getType(), governanceEngineDefinition.getName(), governanceEngineDefinition.getDisplayName(), governanceEngineDefinition.getDescription(), null, null, null, null, governanceEngineDefinition.getUserId(), null, null);
        }
    }

    protected void createGovernanceServices(ContentPackDefinition contentPackDefinition) {
        for (GovernanceServiceDefinition governanceServiceDefinition : GovernanceServiceDefinition.values()) {
            this.addGovernanceServiceDefinition(governanceServiceDefinition, contentPackDefinition);
        }
    }

    private void addGovernanceServiceDefinition(GovernanceServiceDefinition governanceServiceDefinition, ContentPackDefinition contentPackDefinition) {
        if (contentPackDefinition.equals((Object)governanceServiceDefinition.getContentPackDefinition())) {
            this.archiveHelper.setGUID(governanceServiceDefinition.getName(), governanceServiceDefinition.getGUID());
            this.archiveHelper.addGovernanceService(governanceServiceDefinition.getOpenMetadataTypeName(), governanceServiceDefinition.getDeployedImplementationType(), governanceServiceDefinition.getConnectorProviderClassName(), null, governanceServiceDefinition.getName(), governanceServiceDefinition.getDisplayName(), governanceServiceDefinition.getDescription(), null);
        }
    }

    protected void createRequestTypes(ContentPackDefinition contentPackDefinition) {
        for (RequestTypeDefinition requestTypeDefinition : RequestTypeDefinition.values()) {
            if (!contentPackDefinition.equals((Object)requestTypeDefinition.getContentPackDefinition())) continue;
            this.addRequestType(requestTypeDefinition.getGovernanceEngine().getGUID(), requestTypeDefinition.getGovernanceEngine().getName(), requestTypeDefinition.getGovernanceEngine().getType(), requestTypeDefinition.getGovernanceRequestType(), requestTypeDefinition.getServiceRequestType(), requestTypeDefinition.getRequestParameters(), requestTypeDefinition.getActionTargets(), requestTypeDefinition.getGovernanceService().getGovernanceActionDescription(), requestTypeDefinition.getGovernanceActionTypeGUID(), requestTypeDefinition.getSupportedElementQualifiedName());
        }
    }

    protected void addRequestType(String governanceEngineGUID, String governanceEngineName, String governanceEngineTypeName, String governanceRequestType, String serviceRequestType, Map<String, String> requestParameters, List<NewActionTarget> actionTargets, GovernanceActionDescription governanceActionDescription, String governanceActionTypeGUID, String supportedElementQualifiedName) {
        this.archiveHelper.addSupportedGovernanceService(governanceEngineGUID, governanceRequestType, serviceRequestType, requestParameters, governanceActionDescription.governanceServiceGUID);
        this.addGovernanceActionType(governanceEngineGUID, governanceEngineName, governanceEngineTypeName, governanceRequestType, requestParameters, actionTargets, governanceActionDescription, governanceActionTypeGUID, supportedElementQualifiedName);
    }

    protected void addGovernanceActionType(String governanceEngineGUID, String governanceEngineName, String governanceEngineTypeName, String governanceRequestType, Map<String, String> requestParameters, List<NewActionTarget> actionTargets, GovernanceActionDescription governanceActionDescription, String governanceActionTypeGUID, String supportedElementQualifiedName) {
        String governanceActionTypeQualifiedName = governanceEngineName + ":" + governanceRequestType;
        this.archiveHelper.setGUID(governanceActionTypeQualifiedName, governanceActionTypeGUID);
        String guid = this.archiveHelper.addGovernanceActionType(null, governanceEngineGUID, governanceEngineTypeName, OpenMetadataType.SOFTWARE_CAPABILITY.typeName, governanceEngineName + ":" + governanceRequestType, governanceRequestType + " (" + governanceEngineName + ")", governanceActionDescription.governanceServiceDescription, 0, governanceActionDescription.supportedRequestParameters, governanceActionDescription.supportedActionTargets, governanceActionDescription.supportedAnalysisSteps, governanceActionDescription.supportedAnnotationTypes, governanceActionDescription.producedRequestParameters, governanceActionDescription.producedActionTargets, governanceActionDescription.producedGuards, 0, null, null, null);
        assert (governanceActionTypeGUID.equals(guid));
        this.archiveHelper.addGovernanceActionExecutor(governanceActionTypeGUID, governanceRequestType, requestParameters, null, null, null, null, governanceEngineGUID);
        if (actionTargets != null) {
            for (NewActionTarget actionTarget : actionTargets) {
                if (actionTarget == null) continue;
                this.archiveHelper.addTargetForActionType(governanceActionTypeGUID, actionTarget);
            }
        }
        if (supportedElementQualifiedName != null) {
            String supportedElementGUID = this.archiveHelper.queryGUID(supportedElementQualifiedName);
            this.archiveHelper.addResourceListRelationshipByGUID(supportedElementGUID, governanceActionTypeGUID, governanceActionDescription.resourceUse.getResourceUse(), governanceActionDescription.governanceServiceDescription, requestParameters, false);
        }
    }

    protected void createAndSurveyServerGovernanceActionProcess(String assetType, String technologyType, RequestTypeDefinition createRequestType, GovernanceEngineDefinition createEngineDefinition, RequestTypeDefinition surveyRequestType, GovernanceEngineDefinition surveyEngineDefinition, String supportedElementQualifiedName) {
        String step3GUID;
        String step2GUID;
        String description = "Create a " + technologyType + ", run a survey against it, and print out the resulting report.";
        String processGUID = this.archiveHelper.addGovernanceActionProcess("GovernanceActionProcess", assetType + ":CreateAndSurveyGovernanceActionProcess", assetType + ":CreateAndSurvey", null, description, null, 0, null, null, null);
        String step1GUID = this.archiveHelper.addGovernanceActionProcessStep("GovernanceActionProcessStep", processGUID, "GovernanceActionProcess", OpenMetadataType.ASSET.typeName, assetType + ":CreateAndSurvey:Step1", "Create the asset entity", "Create the description of the " + technologyType, 0, null, null, null, null, null, null, null, 0, true, null, null, null);
        if (step1GUID != null) {
            this.addStepExecutor(step1GUID, createRequestType, createEngineDefinition);
            this.archiveHelper.addGovernanceActionProcessFlow(processGUID, null, null, step1GUID);
        }
        if ((step2GUID = this.archiveHelper.addGovernanceActionProcessStep("GovernanceActionProcessStep", processGUID, "GovernanceActionProcess", OpenMetadataType.ASSET.typeName, assetType + ":CreateAndSurvey:Step2", "Run the survey.", "Create a survey report detailing the contents of the " + technologyType + ".", 0, null, null, null, null, null, null, null, 0, true, null, null, null)) != null) {
            this.addStepExecutor(step2GUID, surveyRequestType, surveyEngineDefinition);
            this.archiveHelper.addNextGovernanceActionProcessStep(step1GUID, ManageAssetGuard.SET_UP_COMPLETE.getName(), false, step2GUID);
        }
        if ((step3GUID = this.archiveHelper.addGovernanceActionProcessStep("GovernanceActionProcessStep", processGUID, "GovernanceActionProcess", OpenMetadataType.ASSET.typeName, assetType + ":CreateAndSurvey:Step3", "Print the survey report.", "Print a survey report detailing the contents of the " + technologyType + ".", 0, null, null, null, null, null, null, null, 0, true, null, null, null)) != null) {
            this.addStepExecutor(step3GUID, RequestTypeDefinition.PRINT_SURVEY_REPORT, GovernanceEngineDefinition.STEWARDSHIP_ENGINE);
            this.archiveHelper.addNextGovernanceActionProcessStep(step2GUID, SurveyActionGuard.SURVEY_COMPLETED.getName(), false, step3GUID);
        }
        if (supportedElementQualifiedName != null) {
            String supportedElementGUID = this.archiveHelper.queryGUID(supportedElementQualifiedName);
            this.archiveHelper.addResourceListRelationshipByGUID(supportedElementGUID, processGUID, ResourceUse.SURVEY_RESOURCE.getResourceUse(), description, createRequestType.getRequestParameters(), false);
        }
    }

    protected void createAndCatalogServerGovernanceActionProcess(String serverType, String technologyType, RequestTypeDefinition createRequestType, GovernanceEngineDefinition createEngineDefinition, RequestTypeDefinition catalogRequestType, GovernanceEngineDefinition catalogEngineDefinition, String supportedElementQualifiedName) {
        this.createAsCatalogTargetGovernanceActionProcess(serverType, OpenMetadataType.SOFTWARE_SERVER.typeName, technologyType, "catalog", createRequestType, createEngineDefinition, catalogRequestType, catalogEngineDefinition, supportedElementQualifiedName);
    }

    protected void createAndCatalogAssetGovernanceActionProcess(String assetType, String openMetadataType, String technologyType, RequestTypeDefinition createRequestType, GovernanceEngineDefinition createEngineDefinition, RequestTypeDefinition catalogRequestType, GovernanceEngineDefinition catalogEngineDefinition, String supportedElementQualifiedName) {
        this.createAsCatalogTargetGovernanceActionProcess(assetType, openMetadataType, technologyType, "catalog", createRequestType, createEngineDefinition, catalogRequestType, catalogEngineDefinition, supportedElementQualifiedName);
    }

    protected void createAndHarvestToAssetGovernanceActionProcess(String assetType, String openMetadataType, String technologyType, RequestTypeDefinition createRequestType, GovernanceEngineDefinition createEngineDefinition, RequestTypeDefinition catalogRequestType, GovernanceEngineDefinition catalogEngineDefinition, String supportedElementQualifiedName) {
        this.createAsCatalogTargetGovernanceActionProcess(assetType, openMetadataType, technologyType, "harvest", createRequestType, createEngineDefinition, catalogRequestType, catalogEngineDefinition, supportedElementQualifiedName);
    }

    protected void createAsCatalogTargetGovernanceActionProcess(String assetType, String openMetadataType, String technologyType, String actionName, RequestTypeDefinition createRequestType, GovernanceEngineDefinition createEngineDefinition, RequestTypeDefinition catalogRequestType, GovernanceEngineDefinition catalogEngineDefinition, String supportedElementQualifiedName) {
        String step2GUID;
        String description = "Create a " + technologyType + " and configure an integration connector to " + actionName + " its contents.";
        String processGUID = this.archiveHelper.addGovernanceActionProcess("GovernanceActionProcess", assetType + ":CreateAsCatalogTargetGovernanceActionProcess", assetType + ":CreateAsCatalogTarget", null, description, null, 0, null, null, null);
        String step1GUID = this.archiveHelper.addGovernanceActionProcessStep("GovernanceActionProcessStep", processGUID, "GovernanceActionProcess", OpenMetadataType.ASSET.typeName, assetType + ":CreateAsCatalogTarget:Step1", "Create the " + openMetadataType + " entity", "Create the description of the " + technologyType, 0, null, null, null, null, null, null, null, 0, true, null, null, null);
        if (step1GUID != null) {
            this.addStepExecutor(step1GUID, createRequestType, createEngineDefinition);
            this.archiveHelper.addGovernanceActionProcessFlow(processGUID, null, null, step1GUID);
        }
        if ((step2GUID = this.archiveHelper.addGovernanceActionProcessStep("GovernanceActionProcessStep", processGUID, "GovernanceActionProcess", OpenMetadataType.ASSET.typeName, assetType + ":CreateAsCatalogTarget:Step2", "Connect new asset to integration connector.", "Connect the asset entity for the " + technologyType + " to the appropriate integration connector.", 0, null, null, null, null, null, null, null, 0, true, null, null, null)) != null) {
            this.addStepExecutor(step2GUID, catalogRequestType, catalogEngineDefinition);
            this.archiveHelper.addNextGovernanceActionProcessStep(step1GUID, ManageAssetGuard.SET_UP_COMPLETE.getName(), false, step2GUID);
        }
        if (supportedElementQualifiedName != null) {
            String supportedElementGUID = this.archiveHelper.queryGUID(supportedElementQualifiedName);
            this.archiveHelper.addResourceListRelationshipByGUID(supportedElementGUID, processGUID, ResourceUse.SURVEY_RESOURCE.getResourceUse(), description, createRequestType.getRequestParameters(), false);
        }
    }

    protected void deleteAsCatalogTargetGovernanceActionProcess(String assetType, String openMetadataType, String technologyType, RequestTypeDefinition deleteRequestType, GovernanceEngineDefinition deleteEngineDefinition, String supportedElementQualifiedName) {
        String description = "Delete the asset for " + technologyType + " using the same template properties that were used to create it.  This will delete all of the metadata anchored to the asset and relationships to other entities such as the catalog target relationships.";
        String processGUID = this.archiveHelper.addGovernanceActionProcess("GovernanceActionProcess", assetType + ":DeleteAssetWithTemplateGovernanceActionProcess", assetType + ":DeleteAsset", null, description, null, 0, null, null, null);
        String step1GUID = this.archiveHelper.addGovernanceActionProcessStep("GovernanceActionProcessStep", processGUID, "GovernanceActionProcess", OpenMetadataType.ASSET.typeName, assetType + ":Delete Asset:Step1", "Delete the " + openMetadataType + " entity", "Delete asset for " + technologyType + " using the same template properties as was used to create it.", 0, null, null, null, null, null, null, null, 0, true, null, null, null);
        if (step1GUID != null) {
            this.addStepExecutor(step1GUID, deleteRequestType, deleteEngineDefinition);
            this.archiveHelper.addGovernanceActionProcessFlow(processGUID, null, null, step1GUID);
        }
        if (supportedElementQualifiedName != null) {
            String supportedElementGUID = this.archiveHelper.queryGUID(supportedElementQualifiedName);
            this.archiveHelper.addResourceListRelationshipByGUID(supportedElementGUID, processGUID, ResourceUse.SURVEY_RESOURCE.getResourceUse(), description, deleteRequestType.getRequestParameters(), false);
        }
    }

    protected void addStepExecutor(String stepGUID, RequestTypeDefinition requestTypeDefinition, GovernanceEngineDefinition governanceEngineDefinition) {
        this.archiveHelper.addGovernanceActionExecutor(stepGUID, requestTypeDefinition.getGovernanceRequestType(), requestTypeDefinition.getRequestParameters(), null, null, null, null, governanceEngineDefinition.getGUID());
        if (requestTypeDefinition.getActionTargets() != null) {
            for (NewActionTarget actionTarget : requestTypeDefinition.getActionTargets()) {
                if (actionTarget == null) continue;
                this.archiveHelper.addTargetForActionType(stepGUID, actionTarget);
            }
        }
    }

    public void writeOpenMetadataArchive() {
        try {
            System.out.println("Writing to file: " + this.archiveFileName);
            super.writeOpenMetadataArchive(this.archiveFileName, this.getOpenMetadataArchive());
        }
        catch (Exception error) {
            System.out.println("error is " + error);
        }
    }
}

