/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.datastore.csvfile;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.odpi.openmetadata.adapters.connectors.datastore.basicfile.BasicFileStoreConnector;
import org.odpi.openmetadata.adapters.connectors.datastore.basicfile.ffdc.exception.FileException;
import org.odpi.openmetadata.adapters.connectors.datastore.csvfile.CSVFileStore;
import org.odpi.openmetadata.adapters.connectors.datastore.csvfile.ffdc.CSVFileConnectorErrorCode;
import org.odpi.openmetadata.adapters.connectors.datastore.csvfile.ffdc.exception.FileReadException;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVFileStoreConnector
extends BasicFileStoreConnector
implements CSVFileStore {
    private List<String> columnNames = null;
    private char delimiterChar = (char)44;
    private char quoteChar = (char)34;
    private static final Logger log = LoggerFactory.getLogger(CSVFileStoreConnector.class);

    public void initialize(String connectorInstanceId, ConnectionProperties connectionProperties) {
        super.initialize(connectorInstanceId, connectionProperties);
        Map configurationProperties = connectionProperties.getConfigurationProperties();
        EndpointProperties endpoint = connectionProperties.getEndpoint();
        if (configurationProperties != null) {
            Object columnNamesProperty = configurationProperties.get("columnNames");
            Object delimiterCharProperty = configurationProperties.get("delimiterCharacter");
            Object quoteCharProperty = configurationProperties.get("quoteCharacter");
            if (columnNamesProperty != null && columnNamesProperty instanceof List) {
                this.columnNames = new ArrayList<String>();
                for (Object columnNameProperty : (List)columnNamesProperty) {
                    if (columnNameProperty == null) continue;
                    this.columnNames.add(columnNameProperty.toString());
                }
            }
            if (delimiterCharProperty instanceof Character) {
                this.delimiterChar = ((Character)delimiterCharProperty).charValue();
            }
            if (quoteCharProperty instanceof Character) {
                this.quoteChar = ((Character)quoteCharProperty).charValue();
            }
        }
        if (endpoint != null) {
            this.fileStoreName = endpoint.getAddress();
        } else {
            log.error("Null endpoint");
        }
    }

    @Override
    public String getFileName() throws FileException {
        String methodName = "getFileName";
        this.getFile("getFileName");
        return this.fileStoreName;
    }

    @Override
    public Date getLastUpdateDate() throws FileException {
        String methodName = "getLastUpdateDate";
        File fileStore = this.getFile("getLastUpdateDate");
        return new Date(fileStore.lastModified());
    }

    @Override
    public long getRecordCount() throws FileException, FileReadException {
        String methodName = "getRecordCount";
        long rowCount = 0L;
        File fileStore = this.getFile("getRecordCount");
        try {
            Scanner scanner = new Scanner(fileStore);
            while (scanner.hasNext()) {
                scanner.nextLine();
                ++rowCount;
            }
            scanner.close();
            if (rowCount > 0L && this.columnNames == null) {
                --rowCount;
            }
        }
        catch (IOException error) {
            throw new FileReadException(CSVFileConnectorErrorCode.UNEXPECTED_IO_EXCEPTION.getMessageDefinition(this.fileStoreName, error.getMessage()), this.getClass().getName(), "getRecordCount", error, this.fileStoreName);
        }
        return rowCount;
    }

    @Override
    public List<String> getColumnNames() throws FileException, FileReadException {
        String methodName = "getColumnNames";
        super.getFile("getColumnNames");
        if (this.columnNames != null) {
            return this.columnNames;
        }
        return this.readRow(0, "getColumnNames");
    }

    @Override
    public List<String> readRecord(int dataRecordNumber) throws FileException, FileReadException {
        String methodName = "readRecord";
        if (this.columnNames == null) {
            return this.readRow(dataRecordNumber + 1, "readRecord");
        }
        return this.readRow(dataRecordNumber, "readRecord");
    }

    private List<String> readRow(int recordLocation, String methodName) throws FileException, FileReadException {
        File fileStore = super.getFile(methodName);
        try {
            Scanner scanner = new Scanner(fileStore);
            int rowCounter = 0;
            while (scanner.hasNext()) {
                if (rowCounter == recordLocation) {
                    return this.parseRecord(scanner.nextLine());
                }
                scanner.nextLine();
                ++rowCounter;
            }
            scanner.close();
            throw new FileReadException(CSVFileConnectorErrorCode.FILE_TOO_SHORT.getMessageDefinition(this.fileStoreName, Integer.toString(recordLocation)), this.getClass().getName(), methodName, this.fileStoreName);
        }
        catch (IOException error) {
            throw new FileReadException(CSVFileConnectorErrorCode.UNEXPECTED_IO_EXCEPTION.getMessageDefinition(this.fileStoreName, error.getMessage()), this.getClass().getName(), methodName, error, this.fileStoreName);
        }
    }

    private List<String> parseRecord(String fileRecord) {
        char[] characters;
        if (fileRecord == null || fileRecord.isEmpty()) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        StringBuffer currentValue = new StringBuffer();
        boolean inQuotes = false;
        boolean startCollectingCharacters = false;
        boolean doubleQuotesInColumn = false;
        for (char character : characters = fileRecord.toCharArray()) {
            if (inQuotes) {
                startCollectingCharacters = true;
                if (character == this.quoteChar) {
                    inQuotes = false;
                    doubleQuotesInColumn = false;
                    continue;
                }
                if (character == '\"') {
                    if (doubleQuotesInColumn) continue;
                    currentValue.append(character);
                    doubleQuotesInColumn = true;
                    continue;
                }
                currentValue.append(character);
                continue;
            }
            if (character == this.quoteChar) {
                inQuotes = true;
                if (characters[0] != '\"' && this.quoteChar == '\"') {
                    currentValue.append('\"');
                }
                if (!startCollectingCharacters) continue;
                currentValue.append('\"');
                continue;
            }
            if (character == this.delimiterChar) {
                result.add(currentValue.toString());
                currentValue = new StringBuffer();
                startCollectingCharacters = false;
                continue;
            }
            if (character == '\n') break;
            if (character == '\r') continue;
            currentValue.append(character);
        }
        result.add(currentValue.toString());
        return result;
    }

    public void disconnect() {
        try {
            super.disconnect();
        }
        catch (Throwable exec) {
            log.debug("Ignoring unexpected exception " + exec.getClass().getSimpleName() + " with message " + exec.getMessage());
        }
        log.debug("Closing Structured File Store");
    }
}

