/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.datadesigner.server;

import java.util.Date;
import org.odpi.openmetadata.accessservices.designmodel.client.DataDesignManager;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.DataClassResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.DataClassesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.DataFieldResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.DataFieldsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.DataStructureResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.DataStructuresResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FilterRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.MemberDataFieldRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.MetadataSourceRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NewDataClassRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NewDataFieldRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NewDataStructureRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.TemplateRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.UpdateDataClassRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.UpdateDataFieldRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.UpdateDataStructureRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.enums.SequencingOrder;
import org.odpi.openmetadata.frameworkservices.omf.rest.AnyTimeRequestBody;
import org.odpi.openmetadata.tokencontroller.TokenController;
import org.odpi.openmetadata.viewservices.datadesigner.server.DataDesignerInstanceHandler;
import org.slf4j.LoggerFactory;

public class DataDesignerRESTServices
extends TokenController {
    private static final DataDesignerInstanceHandler instanceHandler = new DataDesignerInstanceHandler();
    private static final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(DataDesignerRESTServices.class), instanceHandler.getServiceName());

    public GUIDResponse createDataStructure(String serverName, NewDataStructureRequestBody requestBody) {
        String methodName = "createDataStructure";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "createDataStructure");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "createDataStructure");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDataStructure");
            if (requestBody != null) {
                DataDesignManager handler = instanceHandler.getDataDesignManagerClient(userId, serverName, "createDataStructure");
                response.setGUID(handler.createDataStructure(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getAnchorGUID(), requestBody.getIsOwnAnchor(), requestBody.getAnchorScopeGUID(), requestBody.getProperties(), requestBody.getParentGUID(), requestBody.getParentRelationshipTypeName(), requestBody.getParentRelationshipProperties(), requestBody.getParentAtEnd1(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createDataStructure", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createDataStructure", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDataStructureFromTemplate(String serverName, TemplateRequestBody requestBody) {
        String methodName = "createDataStructureFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "createDataStructureFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "createDataStructureFromTemplate");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDataStructureFromTemplate");
            if (requestBody != null) {
                DataDesignManager handler = instanceHandler.getDataDesignManagerClient(userId, serverName, "createDataStructureFromTemplate");
                response.setGUID(handler.createDataStructureFromTemplate(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getAnchorGUID(), requestBody.getIsOwnAnchor(), requestBody.getAnchorScopeGUID(), null, null, requestBody.getTemplateGUID(), requestBody.getReplacementProperties(), requestBody.getPlaceholderPropertyValues(), requestBody.getParentGUID(), requestBody.getParentRelationshipTypeName(), requestBody.getParentRelationshipProperties(), requestBody.getParentAtEnd1(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createDataStructureFromTemplate", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createDataStructureFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateDataStructure(String serverName, String dataStructureGUID, boolean replaceAllProperties, UpdateDataStructureRequestBody requestBody) {
        String methodName = "updateDataStructure";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "updateDataStructure");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "updateDataStructure");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateDataStructure");
            if (requestBody != null) {
                DataDesignManager handler = instanceHandler.getDataDesignManagerClient(userId, serverName, "updateDataStructure");
                handler.updateDataStructure(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), dataStructureGUID, replaceAllProperties, requestBody.getProperties(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime());
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateDataStructure", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "updateDataStructure", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse linkMemberDataField(String serverName, String parentDataStructureGUID, String nestedDataFieldGUID, MemberDataFieldRequestBody requestBody) {
        String methodName = "linkMemberDataField";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "linkMemberDataField");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "linkMemberDataField");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "linkMemberDataField");
            DataDesignManager handler = instanceHandler.getDataDesignManagerClient(userId, serverName, "linkMemberDataField");
            if (requestBody != null) {
                handler.linkMemberDataField(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), parentDataStructureGUID, nestedDataFieldGUID, requestBody.getProperties(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime());
            } else {
                handler.linkMemberDataField(userId, null, null, parentDataStructureGUID, nestedDataFieldGUID, null, false, false, new Date());
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "linkMemberDataField", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse detachMemberDataField(String serverName, String parentDataStructureGUID, String nestedDataFieldGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "detachMemberDataField";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "detachMemberDataField");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "detachMemberDataField");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "detachMemberDataField");
            DataDesignManager handler = instanceHandler.getDataDesignManagerClient(userId, serverName, "detachMemberDataField");
            if (requestBody != null) {
                handler.detachMemberDataField(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), parentDataStructureGUID, nestedDataFieldGUID, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime());
            } else {
                handler.detachMemberDataField(userId, null, null, parentDataStructureGUID, nestedDataFieldGUID, false, false, new Date());
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "detachMemberDataField", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteDataStructure(String serverName, String dataStructureGUID, boolean cascadedDelete, MetadataSourceRequestBody requestBody) {
        String methodName = "deleteDataStructure";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "deleteDataStructure");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "deleteDataStructure");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteDataStructure");
            DataDesignManager handler = instanceHandler.getDataDesignManagerClient(userId, serverName, "deleteDataStructure");
            if (requestBody != null) {
                handler.deleteDataStructure(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), dataStructureGUID, cascadedDelete, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime());
            } else {
                handler.deleteDataStructure(userId, null, null, dataStructureGUID, cascadedDelete, false, false, new Date());
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "deleteDataStructure", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DataStructuresResponse getDataStructuresByName(String serverName, int startFrom, int pageSize, FilterRequestBody requestBody) {
        String methodName = "getDataStructuresByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getDataStructuresByName");
        DataStructuresResponse response = new DataStructuresResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getDataStructuresByName");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDataStructuresByName");
            DataDesignManager handler = instanceHandler.getDataDesignManagerClient(userId, serverName, "getDataStructuresByName");
            if (requestBody != null) {
                response.setElements(handler.getDataStructuresByName(userId, requestBody.getFilter(), requestBody.getLimitResultsByStatus(), requestBody.getAsOfTime(), requestBody.getSequencingOrder(), requestBody.getSequencingProperty(), startFrom, pageSize, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getDataStructuresByName", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getDataStructuresByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DataStructuresResponse findDataStructures(String serverName, boolean startsWith, boolean endsWith, boolean ignoreCase, int startFrom, int pageSize, FilterRequestBody requestBody) {
        String methodName = "findDataStructures";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "findDataStructures");
        DataStructuresResponse response = new DataStructuresResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "findDataStructures");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findDataStructures");
            DataDesignManager handler = instanceHandler.getDataDesignManagerClient(userId, serverName, "findDataStructures");
            if (requestBody != null) {
                response.setElements(handler.findDataStructures(userId, instanceHandler.getSearchString(requestBody.getFilter(), startsWith, endsWith, ignoreCase), requestBody.getLimitResultsByStatus(), requestBody.getAsOfTime(), requestBody.getSequencingOrder(), requestBody.getSequencingProperty(), startFrom, pageSize, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime()));
            } else {
                response.setElements(handler.findDataStructures(userId, instanceHandler.getSearchString(null, startsWith, endsWith, ignoreCase), null, null, SequencingOrder.CREATION_DATE_RECENT, null, startFrom, pageSize, false, false, new Date()));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "findDataStructures", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DataStructureResponse getDataStructureByGUID(String serverName, String dataStructureGUID, AnyTimeRequestBody requestBody) {
        String methodName = "getDataStructureByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getDataStructureByGUID");
        DataStructureResponse response = new DataStructureResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getDataStructureByGUID");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDataStructureByGUID");
            DataDesignManager handler = instanceHandler.getDataDesignManagerClient(userId, serverName, "getDataStructureByGUID");
            if (requestBody != null) {
                response.setElement(handler.getDataStructureByGUID(userId, dataStructureGUID, requestBody.getAsOfTime(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime()));
            } else {
                response.setElement(handler.getDataStructureByGUID(userId, dataStructureGUID, null, false, false, new Date()));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getDataStructureByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDataField(String serverName, NewDataFieldRequestBody requestBody) {
        String methodName = "createDataField";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "createDataField");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "createDataField");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDataField");
            if (requestBody != null) {
                DataDesignManager handler = instanceHandler.getDataDesignManagerClient(userId, serverName, "createDataField");
                response.setGUID(handler.createDataField(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getAnchorGUID(), requestBody.getIsOwnAnchor(), requestBody.getAnchorScopeGUID(), requestBody.getProperties(), requestBody.getParentGUID(), requestBody.getParentRelationshipTypeName(), requestBody.getParentRelationshipProperties(), requestBody.getParentAtEnd1(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createDataField", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createDataField", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDataFieldFromTemplate(String serverName, TemplateRequestBody requestBody) {
        String methodName = "createDataFieldFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "createDataFieldFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "createDataFieldFromTemplate");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDataFieldFromTemplate");
            if (requestBody != null) {
                DataDesignManager handler = instanceHandler.getDataDesignManagerClient(userId, serverName, "createDataFieldFromTemplate");
                response.setGUID(handler.createDataFieldFromTemplate(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getAnchorGUID(), requestBody.getIsOwnAnchor(), requestBody.getAnchorScopeGUID(), null, null, requestBody.getTemplateGUID(), requestBody.getReplacementProperties(), requestBody.getPlaceholderPropertyValues(), requestBody.getParentGUID(), requestBody.getParentRelationshipTypeName(), requestBody.getParentRelationshipProperties(), requestBody.getParentAtEnd1(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createDataFieldFromTemplate", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createDataFieldFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateDataField(String serverName, String dataFieldGUID, boolean replaceAllProperties, UpdateDataFieldRequestBody requestBody) {
        String methodName = "updateDataField";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "updateDataField");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "updateDataField");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateDataField");
            if (requestBody != null) {
                DataDesignManager handler = instanceHandler.getDataDesignManagerClient(userId, serverName, "updateDataField");
                handler.updateDataField(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), dataFieldGUID, replaceAllProperties, requestBody.getProperties(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime());
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateDataField", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "updateDataField", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse linkNestedDataFields(String serverName, String parentDataFieldGUID, String nestedDataFieldGUID, MemberDataFieldRequestBody requestBody) {
        String methodName = "linkNestedDataFields";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "linkNestedDataFields");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "linkNestedDataFields");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "linkNestedDataFields");
            DataDesignManager handler = instanceHandler.getDataDesignManagerClient(userId, serverName, "linkNestedDataFields");
            if (requestBody != null) {
                handler.linkNestedDataFields(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), parentDataFieldGUID, nestedDataFieldGUID, requestBody.getProperties(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime());
            } else {
                handler.linkNestedDataFields(userId, null, null, parentDataFieldGUID, nestedDataFieldGUID, null, false, false, new Date());
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "linkNestedDataFields", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse detachNestedDataFields(String serverName, String parentDataFieldGUID, String nestedDataFieldGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "detachNestedDataClass";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "detachNestedDataClass");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "detachNestedDataClass");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "detachNestedDataClass");
            DataDesignManager handler = instanceHandler.getDataDesignManagerClient(userId, serverName, "detachNestedDataClass");
            if (requestBody != null) {
                handler.detachNestedDataFields(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), parentDataFieldGUID, nestedDataFieldGUID, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime());
            } else {
                handler.detachNestedDataFields(userId, null, null, parentDataFieldGUID, nestedDataFieldGUID, false, false, new Date());
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "detachNestedDataClass", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteDataField(String serverName, String dataFieldGUID, boolean cascadedDelete, MetadataSourceRequestBody requestBody) {
        String methodName = "deleteDataField";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "deleteDataField");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "deleteDataField");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteDataField");
            DataDesignManager handler = instanceHandler.getDataDesignManagerClient(userId, serverName, "deleteDataField");
            if (requestBody != null) {
                handler.deleteDataField(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), dataFieldGUID, cascadedDelete, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime());
            } else {
                handler.deleteDataField(userId, null, null, dataFieldGUID, cascadedDelete, false, false, new Date());
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "deleteDataField", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DataFieldsResponse getDataFieldsByName(String serverName, int startFrom, int pageSize, FilterRequestBody requestBody) {
        String methodName = "getDataFieldsByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getDataFieldsByName");
        DataFieldsResponse response = new DataFieldsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getDataFieldsByName");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDataFieldsByName");
            DataDesignManager handler = instanceHandler.getDataDesignManagerClient(userId, serverName, "getDataFieldsByName");
            if (requestBody != null) {
                response.setElements(handler.getDataFieldsByName(userId, requestBody.getFilter(), requestBody.getLimitResultsByStatus(), requestBody.getAsOfTime(), requestBody.getSequencingOrder(), requestBody.getSequencingProperty(), startFrom, pageSize, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getDataFieldsByName", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getDataFieldsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DataFieldsResponse findDataFields(String serverName, boolean startsWith, boolean endsWith, boolean ignoreCase, int startFrom, int pageSize, FilterRequestBody requestBody) {
        String methodName = "findDataFields";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "findDataFields");
        DataFieldsResponse response = new DataFieldsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "findDataFields");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findDataFields");
            DataDesignManager handler = instanceHandler.getDataDesignManagerClient(userId, serverName, "findDataFields");
            if (requestBody != null) {
                response.setElements(handler.findDataFields(userId, instanceHandler.getSearchString(requestBody.getFilter(), startsWith, endsWith, ignoreCase), requestBody.getLimitResultsByStatus(), requestBody.getAsOfTime(), requestBody.getSequencingOrder(), requestBody.getSequencingProperty(), startFrom, pageSize, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime()));
            } else {
                response.setElements(handler.findDataFields(userId, instanceHandler.getSearchString(null, startsWith, endsWith, ignoreCase), null, null, SequencingOrder.CREATION_DATE_RECENT, null, startFrom, pageSize, false, false, new Date()));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "findDataFields", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DataFieldResponse getDataFieldByGUID(String serverName, String dataFieldGUID, AnyTimeRequestBody requestBody) {
        String methodName = "getDataFieldByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getDataFieldByGUID");
        DataFieldResponse response = new DataFieldResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getDataFieldByGUID");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDataFieldByGUID");
            DataDesignManager handler = instanceHandler.getDataDesignManagerClient(userId, serverName, "getDataFieldByGUID");
            if (requestBody != null) {
                response.setElement(handler.getDataFieldByGUID(userId, dataFieldGUID, requestBody.getAsOfTime(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime()));
            } else {
                response.setElement(handler.getDataFieldByGUID(userId, dataFieldGUID, null, false, false, new Date()));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getDataFieldByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDataClass(String serverName, NewDataClassRequestBody requestBody) {
        String methodName = "createDataClass";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "createDataClass");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "createDataClass");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDataClass");
            if (requestBody != null) {
                DataDesignManager handler = instanceHandler.getDataDesignManagerClient(userId, serverName, "createDataClass");
                response.setGUID(handler.createDataClass(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getAnchorGUID(), requestBody.getIsOwnAnchor(), requestBody.getAnchorScopeGUID(), requestBody.getProperties(), requestBody.getParentGUID(), requestBody.getParentRelationshipTypeName(), requestBody.getParentRelationshipProperties(), requestBody.getParentAtEnd1(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createDataClass", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createDataClass", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createDataClassFromTemplate(String serverName, TemplateRequestBody requestBody) {
        String methodName = "createDataClassFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "createDataClassFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "createDataClassFromTemplate");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDataClassFromTemplate");
            if (requestBody != null) {
                DataDesignManager handler = instanceHandler.getDataDesignManagerClient(userId, serverName, "createDataClassFromTemplate");
                response.setGUID(handler.createDataClassFromTemplate(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getAnchorGUID(), requestBody.getIsOwnAnchor(), requestBody.getAnchorScopeGUID(), null, null, requestBody.getTemplateGUID(), requestBody.getReplacementProperties(), requestBody.getPlaceholderPropertyValues(), requestBody.getParentGUID(), requestBody.getParentRelationshipTypeName(), requestBody.getParentRelationshipProperties(), requestBody.getParentAtEnd1(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createDataClassFromTemplate", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createDataClassFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateDataClass(String serverName, String dataClassGUID, boolean replaceAllProperties, UpdateDataClassRequestBody requestBody) {
        String methodName = "updateDataClass";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "updateDataClass");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "updateDataClass");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateDataClass");
            if (requestBody != null) {
                DataDesignManager handler = instanceHandler.getDataDesignManagerClient(userId, serverName, "updateDataClass");
                handler.updateDataClass(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), dataClassGUID, replaceAllProperties, requestBody.getProperties(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime());
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateDataClass", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "updateDataClass", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse linkNestedDataClass(String serverName, String parentDataClassGUID, String childDataClassGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "linkNestedDataClass";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "linkNestedDataClass");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "linkNestedDataClass");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "linkNestedDataClass");
            DataDesignManager handler = instanceHandler.getDataDesignManagerClient(userId, serverName, "linkNestedDataClass");
            if (requestBody != null) {
                handler.linkNestedDataClass(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), parentDataClassGUID, childDataClassGUID, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime());
            } else {
                handler.linkNestedDataClass(userId, null, null, parentDataClassGUID, childDataClassGUID, false, false, new Date());
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "linkNestedDataClass", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse detachNestedDataClass(String serverName, String parentDataClassGUID, String childDataClassGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "detachNestedDataClass";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "detachNestedDataClass");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "detachNestedDataClass");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "detachNestedDataClass");
            DataDesignManager handler = instanceHandler.getDataDesignManagerClient(userId, serverName, "detachNestedDataClass");
            if (requestBody != null) {
                handler.detachNestedDataClass(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), parentDataClassGUID, childDataClassGUID, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime());
            } else {
                handler.detachNestedDataClass(userId, null, null, parentDataClassGUID, childDataClassGUID, false, false, new Date());
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "detachNestedDataClass", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse linkSpecialistDataClass(String serverName, String parentDataClassGUID, String childDataClassGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "linkSpecialistDataClass";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "linkSpecialistDataClass");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "linkSpecialistDataClass");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "linkSpecialistDataClass");
            DataDesignManager handler = instanceHandler.getDataDesignManagerClient(userId, serverName, "linkSpecialistDataClass");
            if (requestBody != null) {
                handler.linkSpecialistDataClass(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), parentDataClassGUID, childDataClassGUID, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime());
            } else {
                handler.linkSpecialistDataClass(userId, null, null, parentDataClassGUID, childDataClassGUID, false, false, new Date());
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "linkSpecialistDataClass", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse detachSpecialistDataClass(String serverName, String parentDataClassGUID, String childDataClassGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "detachSpecialistDataClass";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "detachSpecialistDataClass");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "detachSpecialistDataClass");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "detachSpecialistDataClass");
            DataDesignManager handler = instanceHandler.getDataDesignManagerClient(userId, serverName, "detachSpecialistDataClass");
            if (requestBody != null) {
                handler.detachSpecialistDataClass(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), parentDataClassGUID, childDataClassGUID, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime());
            } else {
                handler.detachSpecialistDataClass(userId, null, null, parentDataClassGUID, childDataClassGUID, false, false, new Date());
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "detachSpecialistDataClass", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteDataClass(String serverName, String dataClassGUID, boolean cascadedDelete, MetadataSourceRequestBody requestBody) {
        String methodName = "deleteDataClass";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "deleteDataClass");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "deleteDataClass");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteDataClass");
            DataDesignManager handler = instanceHandler.getDataDesignManagerClient(userId, serverName, "deleteDataClass");
            if (requestBody != null) {
                handler.deleteDataClass(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), dataClassGUID, cascadedDelete, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime());
            } else {
                handler.deleteDataClass(userId, null, null, dataClassGUID, cascadedDelete, false, false, new Date());
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "deleteDataClass", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DataClassesResponse getDataClassesByName(String serverName, int startFrom, int pageSize, FilterRequestBody requestBody) {
        String methodName = "getDataClassesByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getDataClassesByName");
        DataClassesResponse response = new DataClassesResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getDataClassesByName");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDataClassesByName");
            DataDesignManager handler = instanceHandler.getDataDesignManagerClient(userId, serverName, "getDataClassesByName");
            if (requestBody != null) {
                response.setElements(handler.getDataClassesByName(userId, requestBody.getFilter(), requestBody.getLimitResultsByStatus(), requestBody.getAsOfTime(), requestBody.getSequencingOrder(), requestBody.getSequencingProperty(), startFrom, pageSize, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getDataClassesByName", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getDataClassesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DataClassesResponse findDataClasses(String serverName, boolean startsWith, boolean endsWith, boolean ignoreCase, int startFrom, int pageSize, FilterRequestBody requestBody) {
        String methodName = "findDataClasses";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "findDataClasses");
        DataClassesResponse response = new DataClassesResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "findDataClasses");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findDataClasses");
            DataDesignManager handler = instanceHandler.getDataDesignManagerClient(userId, serverName, "findDataClasses");
            if (requestBody != null) {
                response.setElements(handler.findDataClasses(userId, instanceHandler.getSearchString(requestBody.getFilter(), startsWith, endsWith, ignoreCase), requestBody.getLimitResultsByStatus(), requestBody.getAsOfTime(), requestBody.getSequencingOrder(), requestBody.getSequencingProperty(), startFrom, pageSize, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime()));
            } else {
                response.setElements(handler.findDataClasses(userId, instanceHandler.getSearchString(null, startsWith, endsWith, ignoreCase), null, null, SequencingOrder.CREATION_DATE_RECENT, null, startFrom, pageSize, false, false, new Date()));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "findDataClasses", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DataClassResponse getDataClassByGUID(String serverName, String dataClassGUID, AnyTimeRequestBody requestBody) {
        String methodName = "getDataClassByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getDataClassByGUID");
        DataClassResponse response = new DataClassResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getDataClassByGUID");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDataClassByGUID");
            DataDesignManager handler = instanceHandler.getDataDesignManagerClient(userId, serverName, "getDataClassByGUID");
            if (requestBody != null) {
                response.setElement(handler.getDataClassByGUID(userId, dataClassGUID, requestBody.getAsOfTime(), requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime()));
            } else {
                response.setElement(handler.getDataClassByGUID(userId, dataClassGUID, null, false, false, new Date()));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getDataClassByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse linkDataClassDefinition(String serverName, String dataDefinitionGUID, String dataClassGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "linkDataClassDefinition";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "linkDataClassDefinition");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "linkDataClassDefinition");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "linkDataClassDefinition");
            if (requestBody != null) {
                DataDesignManager handler = instanceHandler.getDataDesignManagerClient(userId, serverName, "linkDataClassDefinition");
                handler.linkDataClassDefinition(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), dataDefinitionGUID, dataClassGUID, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime());
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "linkDataClassDefinition", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "linkDataClassDefinition", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse detachDataClassDefinition(String serverName, String dataDefinitionGUID, String dataClassGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "detachDataClassDefinition";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "detachDataClassDefinition");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "detachDataClassDefinition");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "detachDataClassDefinition");
            DataDesignManager handler = instanceHandler.getDataDesignManagerClient(userId, serverName, "detachDataClassDefinition");
            if (requestBody != null) {
                handler.detachDataClassDefinition(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), dataDefinitionGUID, dataClassGUID, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime());
            } else {
                handler.detachDataClassDefinition(userId, null, null, dataDefinitionGUID, dataClassGUID, false, false, new Date());
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "detachDataClassDefinition", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse linkSemanticDefinition(String serverName, String dataDefinitionGUID, String glossaryTermGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "linkSemanticDefinition";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "linkSemanticDefinition");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "linkSemanticDefinition");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "linkSemanticDefinition");
            DataDesignManager handler = instanceHandler.getDataDesignManagerClient(userId, serverName, "linkSemanticDefinition");
            if (requestBody != null) {
                handler.linkSemanticDefinition(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), dataDefinitionGUID, glossaryTermGUID, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime());
            } else {
                handler.linkSemanticDefinition(userId, null, null, dataDefinitionGUID, glossaryTermGUID, false, false, new Date());
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "linkSemanticDefinition", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse detachSemanticDefinition(String serverName, String dataDefinitionGUID, String glossaryTermGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "detachSemanticDefinition";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "detachSemanticDefinition");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "detachSemanticDefinition");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "detachSemanticDefinition");
            DataDesignManager handler = instanceHandler.getDataDesignManagerClient(userId, serverName, "detachSemanticDefinition");
            if (requestBody != null) {
                handler.detachSemanticDefinition(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), dataDefinitionGUID, glossaryTermGUID, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime());
            } else {
                handler.detachSemanticDefinition(userId, null, null, dataDefinitionGUID, glossaryTermGUID, false, false, new Date());
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "detachSemanticDefinition", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse linkCertificationTypeToDataStructure(String serverName, String certificationTypeGUID, String dataStructureGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "linkCertificationTypeToDataStructure";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "linkCertificationTypeToDataStructure");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "linkCertificationTypeToDataStructure");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "linkCertificationTypeToDataStructure");
            DataDesignManager handler = instanceHandler.getDataDesignManagerClient(userId, serverName, "linkCertificationTypeToDataStructure");
            if (requestBody != null) {
                handler.linkCertificationTypeToDataStructure(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), certificationTypeGUID, dataStructureGUID, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime());
            } else {
                handler.linkCertificationTypeToDataStructure(userId, null, null, certificationTypeGUID, dataStructureGUID, false, false, new Date());
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "linkCertificationTypeToDataStructure", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse detachCertificationTypeToDataStructure(String serverName, String certificationTypeGUID, String dataStructureGUID, MetadataSourceRequestBody requestBody) {
        String methodName = "detachCertificationTypeToDataStructure";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "detachCertificationTypeToDataStructure");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "detachCertificationTypeToDataStructure");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "detachCertificationTypeToDataStructure");
            DataDesignManager handler = instanceHandler.getDataDesignManagerClient(userId, serverName, "detachCertificationTypeToDataStructure");
            if (requestBody != null) {
                handler.detachCertificationTypeToDataStructure(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), certificationTypeGUID, dataStructureGUID, requestBody.getForLineage(), requestBody.getForDuplicateProcessing(), requestBody.getEffectiveTime());
            } else {
                handler.detachCertificationTypeToDataStructure(userId, null, null, certificationTypeGUID, dataStructureGUID, false, false, new Date());
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "detachCertificationTypeToDataStructure", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

