/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.datadesigner.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.commonservices.ffdc.rest.DataClassResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.DataClassesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.DataFieldResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.DataFieldsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.DataStructureResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.DataStructuresResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FilterRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.MemberDataFieldRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.MetadataSourceRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NewDataClassRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NewDataFieldRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NewDataStructureRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.TemplateRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.UpdateDataClassRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.UpdateDataFieldRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.UpdateDataStructureRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworkservices.omf.rest.AnyTimeRequestBody;
import org.odpi.openmetadata.viewservices.datadesigner.server.DataDesignerRESTServices;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/api/open-metadata/data-designer"})
@Tag(name="API: Data Designer OMVS", description="The Data Designer OMVS provides APIs for building schemas for new data assets.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omvs/data-designer/overview/"))
public class DataDesignerResource {
    private final DataDesignerRESTServices restAPI = new DataDesignerRESTServices();

    @PostMapping(path={"/data-structures"})
    @Operation(summary="createDataStructure", description="Create a data structure.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/data-structure"))
    public GUIDResponse createDataStructure(@PathVariable String serverName, @RequestBody(required=false) NewDataStructureRequestBody requestBody) {
        return this.restAPI.createDataStructure(serverName, requestBody);
    }

    @PostMapping(path={"/data-structures/from-template"})
    @Operation(summary="createDataStructureFromTemplate", description="Create a new metadata element to represent a data structure using an existing metadata element as a template.  The template defines additional classifications and relationships that should be added to the new element.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/data-structure"))
    public GUIDResponse createDataStructureFromTemplate(@PathVariable String serverName, @RequestBody(required=false) TemplateRequestBody requestBody) {
        return this.restAPI.createDataStructureFromTemplate(serverName, requestBody);
    }

    @PostMapping(path={"/data-structures/{dataStructureGUID}/update"})
    @Operation(summary="updateDataStructure", description="Update the properties of a data structure.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/data-structure"))
    public VoidResponse updateDataStructure(@PathVariable String serverName, @PathVariable String dataStructureGUID, @RequestParam(required=false, defaultValue="false") boolean replaceAllProperties, @RequestBody(required=false) UpdateDataStructureRequestBody requestBody) {
        return this.restAPI.updateDataStructure(serverName, dataStructureGUID, replaceAllProperties, requestBody);
    }

    @PostMapping(path={"/data-structures/{parentDataStructureGUID}/member-data-fields/{memberDataFieldGUID}/attach"})
    @Operation(summary="linkMemberDataField", description="Attach a data field to a data structure.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/data-structure"))
    public VoidResponse linkMemberDataField(@PathVariable String serverName, @PathVariable String parentDataStructureGUID, @PathVariable String memberDataFieldGUID, @RequestBody(required=false) MemberDataFieldRequestBody requestBody) {
        return this.restAPI.linkMemberDataField(serverName, parentDataStructureGUID, memberDataFieldGUID, requestBody);
    }

    @PostMapping(path={"/data-structures/{parentDataStructureGUID}/member-data-fields/{memberDataFieldGUID}/detach"})
    @Operation(summary="detachMemberDataField", description="Detach a data field from a data structure.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/data-structure"))
    public VoidResponse detachMemberDataField(@PathVariable String serverName, @PathVariable String parentDataStructureGUID, @PathVariable String memberDataFieldGUID, @RequestBody(required=false) MetadataSourceRequestBody requestBody) {
        return this.restAPI.detachMemberDataField(serverName, parentDataStructureGUID, memberDataFieldGUID, requestBody);
    }

    @PostMapping(path={"/data-structures/{dataStructureGUID}/delete"})
    @Operation(summary="deleteDataStructure", description="Delete a data structure.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/data-structure"))
    public VoidResponse deleteDataStructure(@PathVariable String serverName, @PathVariable String dataStructureGUID, @RequestParam(required=false, defaultValue="false") boolean cascadedDelete, @RequestBody(required=false) MetadataSourceRequestBody requestBody) {
        return this.restAPI.deleteDataStructure(serverName, dataStructureGUID, cascadedDelete, requestBody);
    }

    @PostMapping(path={"/data-structures/by-name"})
    @Operation(summary="getDataStructuresByName", description="Returns the list of data structures with a particular name.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/data-structure"))
    public DataStructuresResponse getDataStructuresByName(@PathVariable String serverName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestBody(required=false) FilterRequestBody requestBody) {
        return this.restAPI.getDataStructuresByName(serverName, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/data-structures/by-search-string"})
    @Operation(summary="findDataStructures", description="Retrieve the list of data structure metadata elements that contain the search string.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/data-structure"))
    public DataStructuresResponse findDataStructures(@PathVariable String serverName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean startsWith, @RequestParam(required=false, defaultValue="false") boolean endsWith, @RequestParam(required=false, defaultValue="false") boolean ignoreCase, @RequestBody(required=false) FilterRequestBody requestBody) {
        return this.restAPI.findDataStructures(serverName, startsWith, endsWith, ignoreCase, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/data-structures/{dataStructureGUID}/retrieve"})
    @Operation(summary="getDataStructureByGUID", description="Return the properties of a specific data structure.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/data-structure"))
    public DataStructureResponse getDataStructureByGUID(@PathVariable String serverName, @PathVariable String dataStructureGUID, @RequestBody(required=false) AnyTimeRequestBody requestBody) {
        return this.restAPI.getDataStructureByGUID(serverName, dataStructureGUID, requestBody);
    }

    @PostMapping(path={"/data-fields"})
    @Operation(summary="createDataField", description="Create a data field.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/data-field"))
    public GUIDResponse createDataField(@PathVariable String serverName, @RequestBody(required=false) NewDataFieldRequestBody requestBody) {
        return this.restAPI.createDataField(serverName, requestBody);
    }

    @PostMapping(path={"/data-fields/from-template"})
    @Operation(summary="createDataFieldFromTemplate", description="Create a new metadata element to represent a data field using an existing metadata element as a template.  The template defines additional classifications and relationships that should be added to the new element.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/data-field"))
    public GUIDResponse createDataFieldFromTemplate(@PathVariable String serverName, @RequestBody(required=false) TemplateRequestBody requestBody) {
        return this.restAPI.createDataFieldFromTemplate(serverName, requestBody);
    }

    @PostMapping(path={"/data-fields/{dataFieldGUID}/update"})
    @Operation(summary="updateDataField", description="Update the properties of a data field.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/data-field"))
    public VoidResponse updateDataField(@PathVariable String serverName, @PathVariable String dataFieldGUID, @RequestParam(required=false, defaultValue="false") boolean replaceAllProperties, @RequestBody(required=false) UpdateDataFieldRequestBody requestBody) {
        return this.restAPI.updateDataField(serverName, dataFieldGUID, replaceAllProperties, requestBody);
    }

    @PostMapping(path={"/data-fields/{parentDataFieldGUID}/nested-data-fields/{nestedDataFieldGUID}/attach"})
    @Operation(summary="linkNestedDataFields", description="Connect two data field as parent and child.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/data-field"))
    public VoidResponse linkNestedDataFields(@PathVariable String serverName, @PathVariable String parentDataFieldGUID, @PathVariable String nestedDataFieldGUID, @RequestBody(required=false) MemberDataFieldRequestBody requestBody) {
        return this.restAPI.linkNestedDataFields(serverName, parentDataFieldGUID, nestedDataFieldGUID, requestBody);
    }

    @PostMapping(path={"/data-fields/{parentDataFieldGUID}/nested-data-fields/{nestedDataFieldGUID}/detach"})
    @Operation(summary="detachNestedDataFields", description="Detach two data fields from one another.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/data-field"))
    public VoidResponse detachNestedDataFields(@PathVariable String serverName, @PathVariable String parentDataFieldGUID, @PathVariable String nestedDataFieldGUID, @RequestBody(required=false) MetadataSourceRequestBody requestBody) {
        return this.restAPI.detachNestedDataFields(serverName, parentDataFieldGUID, nestedDataFieldGUID, requestBody);
    }

    @PostMapping(path={"/data-fields/{dataFieldGUID}/delete"})
    @Operation(summary="deleteDataField", description="Delete a data field.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/data-field"))
    public VoidResponse deleteDataField(@PathVariable String serverName, @PathVariable String dataFieldGUID, @RequestParam(required=false, defaultValue="false") boolean cascadedDelete, @RequestBody(required=false) MetadataSourceRequestBody requestBody) {
        return this.restAPI.deleteDataField(serverName, dataFieldGUID, cascadedDelete, requestBody);
    }

    @PostMapping(path={"/data-fields/by-name"})
    @Operation(summary="getDataFieldsByName", description="Returns the list of data fields with a particular name.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/data-field"))
    public DataFieldsResponse getDataFieldsByName(@PathVariable String serverName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestBody(required=false) FilterRequestBody requestBody) {
        return this.restAPI.getDataFieldsByName(serverName, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/data-fields/by-search-string"})
    @Operation(summary="findDataFields", description="Retrieve the list of data field metadata elements that contain the search string.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/data-field"))
    public DataFieldsResponse findDataFields(@PathVariable String serverName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean startsWith, @RequestParam(required=false, defaultValue="false") boolean endsWith, @RequestParam(required=false, defaultValue="false") boolean ignoreCase, @RequestBody(required=false) FilterRequestBody requestBody) {
        return this.restAPI.findDataFields(serverName, startsWith, endsWith, ignoreCase, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/data-fields/{dataFieldGUID}/retrieve"})
    @Operation(summary="getDataFieldByGUID", description="Return the properties of a specific data field.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/data-field"))
    public DataFieldResponse getDataFieldByGUID(@PathVariable String serverName, @PathVariable String dataFieldGUID, @RequestBody(required=false) AnyTimeRequestBody requestBody) {
        return this.restAPI.getDataFieldByGUID(serverName, dataFieldGUID, requestBody);
    }

    @PostMapping(path={"/data-classes"})
    @Operation(summary="createDataClass", description="Create a data class.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/data-class"))
    public GUIDResponse createDataClass(@PathVariable String serverName, @RequestBody(required=false) NewDataClassRequestBody requestBody) {
        return this.restAPI.createDataClass(serverName, requestBody);
    }

    @PostMapping(path={"/data-classes/from-template"})
    @Operation(summary="createDataClassFromTemplate", description="Create a new metadata element to represent a data class using an existing metadata element as a template.  The template defines additional classifications and relationships that should be added to the new element.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/data-class"))
    public GUIDResponse createDataClassFromTemplate(@PathVariable String serverName, @RequestBody(required=false) TemplateRequestBody requestBody) {
        return this.restAPI.createDataClassFromTemplate(serverName, requestBody);
    }

    @PostMapping(path={"/data-classes/{dataClassGUID}/update"})
    @Operation(summary="updateDataClass", description="Update the properties of a data class.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/data-class"))
    public VoidResponse updateDataClass(@PathVariable String serverName, @PathVariable String dataClassGUID, @RequestParam(required=false, defaultValue="false") boolean replaceAllProperties, @RequestBody(required=false) UpdateDataClassRequestBody requestBody) {
        return this.restAPI.updateDataClass(serverName, dataClassGUID, replaceAllProperties, requestBody);
    }

    @PostMapping(path={"/data-classes/{parentDataClassGUID}/nested-data-classes/{childDataClassGUID}/attach"})
    @Operation(summary="linkNestedDataClass", description="Connect two data classes to show that one is used by the other when it is validating (typically a complex data item).", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/data-class"))
    public VoidResponse linkNestedDataClass(@PathVariable String serverName, @PathVariable String parentDataClassGUID, @PathVariable String childDataClassGUID, @RequestBody(required=false) MetadataSourceRequestBody requestBody) {
        return this.restAPI.linkNestedDataClass(serverName, parentDataClassGUID, childDataClassGUID, requestBody);
    }

    @PostMapping(path={"/data-classes/{parentDataClassGUID}/nested-data-classes/{childDataClassGUID}/detach"})
    @Operation(summary="detachNestedDataClass", description="Detach two nested data classes from one another.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/data-class"))
    public VoidResponse detachNestedDataClass(@PathVariable String serverName, @PathVariable String parentDataClassGUID, @PathVariable String childDataClassGUID, @RequestBody(required=false) MetadataSourceRequestBody requestBody) {
        return this.restAPI.detachNestedDataClass(serverName, parentDataClassGUID, childDataClassGUID, requestBody);
    }

    @PostMapping(path={"/data-classes/{parentDataClassGUID}/specializeddata-classes/{childDataClassGUID}/attach"})
    @Operation(summary="linkSpecialistDataClass", description="Connect two data classes to show that one provides a more specialist evaluation.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/data-class"))
    public VoidResponse linkSpecialistDataClass(@PathVariable String serverName, @PathVariable String parentDataClassGUID, @PathVariable String childDataClassGUID, @RequestBody(required=false) MetadataSourceRequestBody requestBody) {
        return this.restAPI.linkSpecialistDataClass(serverName, parentDataClassGUID, childDataClassGUID, requestBody);
    }

    @PostMapping(path={"/data-classes/{parentDataClassGUID}/specializeddata-classes/{childDataClassGUID}/detach"})
    @Operation(summary="detachSpecialistDataClass", description="Detach two data classes from one another.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/data-class"))
    public VoidResponse detachSpecialistDataClass(@PathVariable String serverName, @PathVariable String parentDataClassGUID, @PathVariable String childDataClassGUID, @RequestBody(required=false) MetadataSourceRequestBody requestBody) {
        return this.restAPI.detachSpecialistDataClass(serverName, parentDataClassGUID, childDataClassGUID, requestBody);
    }

    @PostMapping(path={"/data-classes/{dataClassGUID}/delete"})
    @Operation(summary="deleteDataClass", description="Delete a data class.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/data-class"))
    public VoidResponse deleteDataClass(@PathVariable String serverName, @PathVariable String dataClassGUID, @RequestParam(required=false, defaultValue="false") boolean cascadedDelete, @RequestBody(required=false) MetadataSourceRequestBody requestBody) {
        return this.restAPI.deleteDataClass(serverName, dataClassGUID, cascadedDelete, requestBody);
    }

    @PostMapping(path={"/data-classes/by-name"})
    @Operation(summary="getDataClassesByName", description="Returns the list of data classes with a particular name.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/data-class"))
    public DataClassesResponse getDataClassesByName(@PathVariable String serverName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestBody(required=false) FilterRequestBody requestBody) {
        return this.restAPI.getDataClassesByName(serverName, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/data-classes/by-search-string"})
    @Operation(summary="findDataClasses", description="Retrieve the list of data class metadata elements that contain the search string.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/data-class"))
    public DataClassesResponse findDataClasses(@PathVariable String serverName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean startsWith, @RequestParam(required=false, defaultValue="false") boolean endsWith, @RequestParam(required=false, defaultValue="false") boolean ignoreCase, @RequestBody(required=false) FilterRequestBody requestBody) {
        return this.restAPI.findDataClasses(serverName, startsWith, endsWith, ignoreCase, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/data-classes/{dataClassGUID}/retrieve"})
    @Operation(summary="getDataClassByGUID", description="Return the properties of a specific data class.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/data-class"))
    public DataClassResponse getDataClassByGUID(@PathVariable String serverName, @PathVariable String dataClassGUID, @RequestBody(required=false) AnyTimeRequestBody requestBody) {
        return this.restAPI.getDataClassByGUID(serverName, dataClassGUID, requestBody);
    }

    @PostMapping(path={"/data-definitions/{dataDefinitionGUID}/data-class-definition/{dataClassGUID}/attach"})
    @Operation(summary="linkDataClassDefinition", description="Connect an element that is part of a data design to a data class to show that the data class should be used as the specification for the data values when interpreting the data definition.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/data-specification"))
    public VoidResponse linkDataClassDefinition(@PathVariable String serverName, @PathVariable String dataDefinitionGUID, @PathVariable String dataClassGUID, @RequestBody(required=false) MetadataSourceRequestBody requestBody) {
        return this.restAPI.linkDataClassDefinition(serverName, dataDefinitionGUID, dataClassGUID, requestBody);
    }

    @PostMapping(path={"/data-definitions/{dataDefinitionGUID}/data-class-definition/{dataClassGUID}/detach"})
    @Operation(summary="detachDataClassDefinition", description="Detach a data definition from a data class.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/data-specification"))
    public VoidResponse detachDataClassDefinition(@PathVariable String serverName, @PathVariable String dataDefinitionGUID, @PathVariable String dataClassGUID, @RequestBody(required=false) MetadataSourceRequestBody requestBody) {
        return this.restAPI.detachDataClassDefinition(serverName, dataDefinitionGUID, dataClassGUID, requestBody);
    }

    @PostMapping(path={"/data-definitions/{dataDefinitionGUID}/semantic-definition/{glossaryTermGUID}/attach"})
    @Operation(summary="linkSemanticDefinition", description="Connect an element that is part of a data design to a glossary term to show that the term should be used as the semantic definition for the data values when interpreting the data definition.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/data-specification"))
    public VoidResponse linkSemanticDefinition(@PathVariable String serverName, @PathVariable String dataDefinitionGUID, @PathVariable String glossaryTermGUID, @RequestBody(required=false) MetadataSourceRequestBody requestBody) {
        return this.restAPI.linkSemanticDefinition(serverName, dataDefinitionGUID, glossaryTermGUID, requestBody);
    }

    @PostMapping(path={"/data-definitions/{dataDefinitionGUID}/semantic-definition/{glossaryTermGUID}/detach"})
    @Operation(summary="detachSemanticDefinition", description="Detach a data definition from a glossary term.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/data-specification"))
    public VoidResponse detachSemanticDefinition(@PathVariable String serverName, @PathVariable String dataDefinitionGUID, @PathVariable String glossaryTermGUID, @RequestBody(required=false) MetadataSourceRequestBody requestBody) {
        return this.restAPI.detachSemanticDefinition(serverName, dataDefinitionGUID, glossaryTermGUID, requestBody);
    }

    @PostMapping(path={"/certification-types/{certificationTypeGUID}/data-structure-definition/{dataStructureGUID}/attach"})
    @Operation(summary="linkCertificationTypeToDataStructure", description="Connect a certification type to a data structure to guide the survey action service (that checks the data quality of a data resource as part of certifying it with the supplied certification type) to the definition of the data structure to use as a specification of how the data should be both structured and (if data classes are attached to the associated data fields using the DataClassDefinition relationship) contain the valid values.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/data-specification"))
    public VoidResponse linkCertificationTypeToDataStructure(@PathVariable String serverName, @PathVariable String certificationTypeGUID, @PathVariable String dataStructureGUID, @RequestBody(required=false) MetadataSourceRequestBody requestBody) {
        return this.restAPI.linkCertificationTypeToDataStructure(serverName, certificationTypeGUID, dataStructureGUID, requestBody);
    }

    @PostMapping(path={"/certification-types/{certificationTypeGUID}/data-structure-definition/{dataStructureGUID}/detach"})
    @Operation(summary="detachCertificationTypeToDataStructure", description="Detach a data structure from a certification type.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/data-specification"))
    public VoidResponse detachCertificationTypeToDataStructure(@PathVariable String serverName, @PathVariable String certificationTypeGUID, @PathVariable String dataStructureGUID, @RequestBody(required=false) MetadataSourceRequestBody requestBody) {
        return this.restAPI.detachCertificationTypeToDataStructure(serverName, certificationTypeGUID, dataStructureGUID, requestBody);
    }
}

