/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.ffdc;

import java.text.MessageFormat;

public enum DataEngineErrorCode {
    OMRS_NOT_INITIALIZED(404, "OMAS-DATA-ENGINE-404-001 ", "The open metadata repository services are not initialized for server {0}", "The system is unable to connect to the open metadata property server.", "Check that the server initialized correctly.  Correct any errors discovered and retry the request when the open metadata services are available."),
    INVALID_PORT_TYPE(400, "OMAS-DATA-ENGINE-400-005 ", "The port type passed for the {1} is invalid, or different from {2}", "The system is unable to create a new PortDelegation relation the request without equal types between the ports.", "Correct the code in the caller to provide the correct port type."),
    NO_SCHEMA_ATTRIBUTE(404, "OMAS-DATA-ENGINE-404-002 ", "No schema attribute found for qualifiedName {0}", "The system is unable to retrieve a schema attribute for the specified qualifiedName.", "Correct the code in the caller to provide the qualified name.");

    private int HTTPErrorCode;
    private String errorMessageId;
    private String errorMessage;
    private String systemAction;
    private String userAction;

    private DataEngineErrorCode(int newHTTPErrorCode, String newErrorMessageId, String newErrorMessage, String newSystemAction, String newUserAction) {
        this.HTTPErrorCode = newHTTPErrorCode;
        this.errorMessageId = newErrorMessageId;
        this.errorMessage = newErrorMessage;
        this.systemAction = newSystemAction;
        this.userAction = newUserAction;
    }

    public String getFormattedErrorMessage(String ... params) {
        MessageFormat mf = new MessageFormat(this.errorMessage);
        return mf.format(params);
    }

    public int getHTTPErrorCode() {
        return this.HTTPErrorCode;
    }

    public String getErrorMessageId() {
        return this.errorMessageId;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getSystemAction() {
        return this.systemAction;
    }

    public String getUserAction() {
        return this.userAction;
    }
}

