/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.ffdc;

import java.text.MessageFormat;

public enum DataEngineErrorCode {
    OMRS_NOT_INITIALIZED(404, "OMAS-DATA-ENGINE-404-001 ", "The open metadata repository services are not initialized for server {0}", "The system is unable to connect to the open metadata property server.", "Check that the server initialized correctly.  Correct any errors discovered and retry the request when the open metadata services are available."),
    INVALID_PORT_TYPE(400, "OMAS-DATA-ENGINE-400-001 ", "The port type passed for the {0} is invalid, or different from {1}", "The system is unable to create a new PortDelegation relation the request without equal types between the ports.", "Correct the code in the caller to provide the correct port type."),
    PROCESS_EVENT_EXCEPTION(400, "OMAS-DATA-ENGINE-400-002", "The data engine event {0} could not be processed. Error: {1}", "The system is unable to process the event.", "Verify the topic configuration or the event schema."),
    PARSE_EVENT_EXCEPTION(400, "OMAS-DATA-ENGINE-400-003", "The data engine event {0} could not be parsed. Error: {1}", "The system is unable to process the event.", "Verify the topic configuration or the event schema."),
    DATA_ENGINE_EXCEPTION(400, "OMAS-DATA-ENGINE-400-004", "Exception while processing the data engine event {0}", "The system is unable to process the event.", "Verify the topic configuration or the event schema.");

    private int httpErrorCode;
    private String errorMessageId;
    private String errorMessage;
    private String systemAction;
    private String userAction;

    private DataEngineErrorCode(int newHTTPErrorCode, String newErrorMessageId, String newErrorMessage, String newSystemAction, String newUserAction) {
        this.httpErrorCode = newHTTPErrorCode;
        this.errorMessageId = newErrorMessageId;
        this.errorMessage = newErrorMessage;
        this.systemAction = newSystemAction;
        this.userAction = newUserAction;
    }

    public String getFormattedErrorMessage(String ... params) {
        MessageFormat mf = new MessageFormat(this.errorMessage);
        return mf.format(params);
    }

    public int getHttpErrorCode() {
        return this.httpErrorCode;
    }

    public String getErrorMessageId() {
        return this.errorMessageId;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getSystemAction() {
        return this.systemAction;
    }

    public String getUserAction() {
        return this.userAction;
    }

    private static class Constants {
        static final String SYSTEM_ACTION_EVENT_EXCEPTION = "The system is unable to process the event.";
        static final String USER_ACTION_EVENT_EXCEPTION = "Verify the topic configuration or the event schema.";

        private Constants() {
        }
    }
}

