// Generated by delombok at Wed Jun 02 14:11:13 UTC 2021
/* SPDX-License-Identifier: Apache-2.0 */
/* Copyright Contributors to the ODPi Egeria project. */
package org.odpi.openmetadata.accessservices.dataengine.event;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.odpi.openmetadata.accessservices.dataengine.model.DeleteSemantic;
import static com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility.NONE;
import static com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility.PUBLIC_ONLY;

/**
 * The delete event of Data Engine OMAS.
 */
@JsonAutoDetect(getterVisibility = PUBLIC_ONLY, setterVisibility = PUBLIC_ONLY, fieldVisibility = NONE)
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class DeleteEvent extends DataEngineEventHeader {
    /**
     * The qualified name of the entity
     */
    private String qualifiedName;
    /**
     * The unique identifier of the entity
     */
    private String guid;
    /**
     * The delete semantic
     */
    private DeleteSemantic deleteSemantic = DeleteSemantic.HARD;

    /**
     * Return the entity qualified name
     *
     * @return String - qualified name of the entity
     */
    @java.lang.SuppressWarnings("all")
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    /**
     * Return the entity unique identifier
     *
     * @return String - unique identifier of the entity
     */
    @java.lang.SuppressWarnings("all")
    public String getGuid() {
        return this.guid;
    }

    /**
     * Return the delete semantic
     *
     * @return String - unique identifier of the entity
     */
    @java.lang.SuppressWarnings("all")
    public DeleteSemantic getDeleteSemantic() {
        return this.deleteSemantic;
    }

    /**
     * Set up the qualified name of the entity
     * @param qualifiedName of the entity
     */
    @java.lang.SuppressWarnings("all")
    public void setQualifiedName(final String qualifiedName) {
        this.qualifiedName = qualifiedName;
    }

    /**
     * Set up the unique identifier of the entity
     * @param guid of the entity
     */
    @java.lang.SuppressWarnings("all")
    public void setGuid(final String guid) {
        this.guid = guid;
    }

    /**
     * Set up the delete semantic
     * @param deleteSemantic of the entity
     */
    @java.lang.SuppressWarnings("all")
    public void setDeleteSemantic(final DeleteSemantic deleteSemantic) {
        this.deleteSemantic = deleteSemantic;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof DeleteEvent)) return false;
        final DeleteEvent other = (DeleteEvent) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$qualifiedName = this.getQualifiedName();
        final java.lang.Object other$qualifiedName = other.getQualifiedName();
        if (this$qualifiedName == null ? other$qualifiedName != null : !this$qualifiedName.equals(other$qualifiedName)) return false;
        final java.lang.Object this$guid = this.getGuid();
        final java.lang.Object other$guid = other.getGuid();
        if (this$guid == null ? other$guid != null : !this$guid.equals(other$guid)) return false;
        final java.lang.Object this$deleteSemantic = this.getDeleteSemantic();
        final java.lang.Object other$deleteSemantic = other.getDeleteSemantic();
        if (this$deleteSemantic == null ? other$deleteSemantic != null : !this$deleteSemantic.equals(other$deleteSemantic)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof DeleteEvent;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $qualifiedName = this.getQualifiedName();
        result = result * PRIME + ($qualifiedName == null ? 43 : $qualifiedName.hashCode());
        final java.lang.Object $guid = this.getGuid();
        result = result * PRIME + ($guid == null ? 43 : $guid.hashCode());
        final java.lang.Object $deleteSemantic = this.getDeleteSemantic();
        result = result * PRIME + ($deleteSemantic == null ? 43 : $deleteSemantic.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString() {
        return "DeleteEvent(qualifiedName=" + this.getQualifiedName() + ", guid=" + this.getGuid() + ", deleteSemantic=" + this.getDeleteSemantic() + ")";
    }
}
