// Generated by delombok at Wed Jun 02 14:11:13 UTC 2021
/* SPDX-License-Identifier: Apache-2.0 */
/* Copyright Contributors to the ODPi Egeria project. */
package org.odpi.openmetadata.accessservices.dataengine.event;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.odpi.openmetadata.accessservices.dataengine.model.DeleteSemantic;
import java.util.List;
import static com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility.NONE;
import static com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility.PUBLIC_ONLY;

/**
 * The delete processes event of Data Engine OMAS.
 */
@JsonAutoDetect(getterVisibility = PUBLIC_ONLY, setterVisibility = PUBLIC_ONLY, fieldVisibility = NONE)
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ProcessesDeleteEvent extends DataEngineEventHeader {
    /**
     * The list of qualified names of the processes
     */
    private List<String> qualifiedNames;
    /**
     * The list of unique identifiers of the processes
     */
    private List<String> guids;
    /**
     * The delete semantic
     */
    private DeleteSemantic deleteSemantic = DeleteSemantic.HARD;

    /**
     * Return the list of qualified names of the processes
     * @return String - list of qualified names of the processes
     */
    @java.lang.SuppressWarnings("all")
    public List<String> getQualifiedNames() {
        return this.qualifiedNames;
    }

    /**
     * Return the list of unique identifiers of the processes
     * @return String - list of unique identifiers of the processes
     */
    @java.lang.SuppressWarnings("all")
    public List<String> getGuids() {
        return this.guids;
    }

    /**
     * Return the delete semantic
     * @return String - unique identifier of the entity
     */
    @java.lang.SuppressWarnings("all")
    public DeleteSemantic getDeleteSemantic() {
        return this.deleteSemantic;
    }

    /**
     * Set up the list of qualified names of the processes
     * @param qualifiedNames list of qualified names of the processes
     */
    @java.lang.SuppressWarnings("all")
    public void setQualifiedNames(final List<String> qualifiedNames) {
        this.qualifiedNames = qualifiedNames;
    }

    /**
     * Set up the list of unique identifiers of the processes
     * @param guids list of unique identifiers of the processes
     */
    @java.lang.SuppressWarnings("all")
    public void setGuids(final List<String> guids) {
        this.guids = guids;
    }

    /**
     * Set up the delete semantic
     * @param deleteSemantic of the entity
     */
    @java.lang.SuppressWarnings("all")
    public void setDeleteSemantic(final DeleteSemantic deleteSemantic) {
        this.deleteSemantic = deleteSemantic;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ProcessesDeleteEvent)) return false;
        final ProcessesDeleteEvent other = (ProcessesDeleteEvent) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$qualifiedNames = this.getQualifiedNames();
        final java.lang.Object other$qualifiedNames = other.getQualifiedNames();
        if (this$qualifiedNames == null ? other$qualifiedNames != null : !this$qualifiedNames.equals(other$qualifiedNames)) return false;
        final java.lang.Object this$guids = this.getGuids();
        final java.lang.Object other$guids = other.getGuids();
        if (this$guids == null ? other$guids != null : !this$guids.equals(other$guids)) return false;
        final java.lang.Object this$deleteSemantic = this.getDeleteSemantic();
        final java.lang.Object other$deleteSemantic = other.getDeleteSemantic();
        if (this$deleteSemantic == null ? other$deleteSemantic != null : !this$deleteSemantic.equals(other$deleteSemantic)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ProcessesDeleteEvent;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $qualifiedNames = this.getQualifiedNames();
        result = result * PRIME + ($qualifiedNames == null ? 43 : $qualifiedNames.hashCode());
        final java.lang.Object $guids = this.getGuids();
        result = result * PRIME + ($guids == null ? 43 : $guids.hashCode());
        final java.lang.Object $deleteSemantic = this.getDeleteSemantic();
        result = result * PRIME + ($deleteSemantic == null ? 43 : $deleteSemantic.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString() {
        return "ProcessesDeleteEvent(qualifiedNames=" + this.getQualifiedNames() + ", guids=" + this.getGuids() + ", deleteSemantic=" + this.getDeleteSemantic() + ")";
    }
}
