/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.ffdc;

import java.text.MessageFormat;

public enum DataEngineErrorCode {
    OMRS_NOT_INITIALIZED(404, "OMAS-DATA-ENGINE-404-001 ", "The open metadata repository services are not initialized for server {0}", "The system is unable to connect to the open metadata property server.", "Check that the server initialized correctly.  Correct any errors discovered and retry the request when the open metadata services are available."),
    INVALID_PORT_TYPE(400, "OMAS-DATA-ENGINE-400-001 ", "The port type passed for the {0} is invalid, or different from {1}", "The system is unable to create a new PortDelegation relation without equal types between the ports.", "Correct the code in the caller to provide the correct port type."),
    PROCESS_EVENT_EXCEPTION(400, "OMAS-DATA-ENGINE-400-002", "The data engine event {0} could not be processed. Error: {1}", "The system is unable to process the event.", "Verify the topic configuration or the event schema."),
    PARSE_EVENT_EXCEPTION(400, "OMAS-DATA-ENGINE-400-003", "The data engine event {0} could not be parsed. Error: {1}", "The system is unable to process the event.", "Verify the topic configuration or the event schema."),
    DATA_ENGINE_EXCEPTION(400, "OMAS-DATA-ENGINE-400-004", "Exception while processing the data engine event {0}", "The system is unable to process the event.", "Verify the topic configuration or the event schema."),
    SCHEMA_ATTRIBUTE_NOT_FOUND(400, "OMAS-DATA-ENGINE-400-005 ", "SchemaAttribute with qualifiedName {0} was not found", "The system is unable to create a new LineageMapping relation.", "Correct the code in the caller to provide the correct schema attribute qualified name."),
    PORT_NOT_FOUND(400, "OMAS-DATA-ENGINE-400-006 ", "Port with qualifiedName {0} was not found", "The system is unable to create a new PortDelegation relation.", "Correct the code in the caller to provide the correct port qualified name."),
    NULL_TOPIC_CONNECTOR(400, "OMAS-DATA-ENGINE-400-007", "Unable to send or receive events for source {0} because the connector to the OMRS Topic failed to initialize", "The local server will not connect to the cohort.", "The connection to the connector is configured in the server configuration.  Review previous error messages to determine the precise error in the start up configuration. Correct the configuration and reconnect the server to the cohort. "),
    PROCESS_NOT_FOUND(400, "OMAS-DATA-ENGINE-400-008 ", "Process with qualifiedName {0} was not found", "The system is unable to create a new ProcessHierarchy relation.", "Correct the code in the caller to provide the correct port qualified name.");

    private int httpErrorCode;
    private String errorMessageId;
    private String errorMessage;
    private String systemAction;
    private String userAction;

    private DataEngineErrorCode(int newHTTPErrorCode, String newErrorMessageId, String newErrorMessage, String newSystemAction, String newUserAction) {
        this.httpErrorCode = newHTTPErrorCode;
        this.errorMessageId = newErrorMessageId;
        this.errorMessage = newErrorMessage;
        this.systemAction = newSystemAction;
        this.userAction = newUserAction;
    }

    public String getFormattedErrorMessage(String ... params) {
        MessageFormat mf = new MessageFormat(this.errorMessage);
        return mf.format(params);
    }

    public int getHttpErrorCode() {
        return this.httpErrorCode;
    }

    public String getErrorMessageId() {
        return this.errorMessageId;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getSystemAction() {
        return this.systemAction;
    }

    public String getUserAction() {
        return this.userAction;
    }
}

