/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.event;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum DataEngineEventType implements Serializable
{
    UNKNOWN_DATA_ENGINE_EVENT(0, "Unknown Data Engine Job Event", "An event that is not recognized by the local server."),
    DATA_ENGINE_REGISTRATION_EVENT(1, "DataEngineRegistrationEvent", "An event that register a data engine as external source."),
    LINEAGE_MAPPINGS_EVENT(2, "LineageMappingsEvent", "An event that add or update lineage mappings."),
    PORT_ALIAS_EVENT(3, "PortAliasEvent", "An event that add or update port alias"),
    PORT_IMPLEMENTATION_EVENT(4, "PortImplementationEvent", "An event that create or update port implementations."),
    PROCESS_TO_PORT_LIST_EVENT(5, "ProcessToPortListEvent", "An event that assign process to a port list."),
    PROCESSES_EVENT(6, "ProcessesEvent", "An event that create or update processes."),
    SCHEMA_TYPE_EVENT(7, "SchemaTypeEvent", "An event that create or update schema types."),
    PROCESS_HIERARCHY_EVENT(8, "ProcessHierarchyEvent", "An event to setup a process hierarchy.");

    private static final long serialVersionUID = 1L;
    private int eventTypeCode;
    private String eventTypeName;
    private String eventTypeDescription;

    private DataEngineEventType(int eventTypeCode, String eventTypeName, String eventTypeDescription) {
        this.eventTypeCode = eventTypeCode;
        this.eventTypeName = eventTypeName;
        this.eventTypeDescription = eventTypeDescription;
    }

    public int getEventTypeCode() {
        return this.eventTypeCode;
    }

    public String getEventTypeName() {
        return this.eventTypeName;
    }

    public String getEventTypeDescription() {
        return this.eventTypeDescription;
    }

    public String toString() {
        return "DataEngineEventType{eventTypeCode=" + this.eventTypeCode + ", eventTypeName='" + this.eventTypeName + '\'' + ", eventTypeDescription='" + this.eventTypeDescription + '\'' + '}';
    }
}

