/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageSet;

public enum DataEngineErrorCode implements ExceptionMessageSet
{
    OMRS_NOT_INITIALIZED(404, "OMAS-DATA-ENGINE-404-001 ", "The open metadata repository services are not initialized for server {0}", "The system is unable to connect to the open metadata property server.", "Check that the server initialized correctly.  Correct any errors discovered and retry the request when the open metadata services are available."),
    INVALID_PORT_TYPE(400, "OMAS-DATA-ENGINE-400-001", "The port type passed for the entity with qualifiedName {0} is invalid, or different from expected type {1}", "The system is unable to create a new PortDelegation relation without equal types between the ports.", "Correct the code in the caller to provide the correct port type."),
    PROCESS_EVENT_EXCEPTION(400, "OMAS-DATA-ENGINE-400-002", "The data engine event {0} could not be processed. Error: {1}", "The system is unable to process the event.", "Verify the topic configuration or the event schema."),
    DATA_ENGINE_EXCEPTION(400, "OMAS-DATA-ENGINE-400-004", "Exception while processing the data engine event {0}", "The system is unable to process the event.", "Verify the topic configuration or the event schema."),
    SCHEMA_ATTRIBUTE_NOT_FOUND(400, "OMAS-DATA-ENGINE-400-005", "SchemaAttribute with qualifiedName {0} was not found", "The system is unable to create a new LineageMapping relation.", "Correct the code in the caller to provide the correct schema attribute qualified name."),
    PORT_NOT_FOUND(400, "OMAS-DATA-ENGINE-400-006", "Port with qualifiedName {0} was not found", "The system is unable to create a new PortDelegation relation.", "Correct the code in the caller to provide the correct port qualified name."),
    NULL_TOPIC_CONNECTOR(400, "OMAS-DATA-ENGINE-400-007", "Unable to send or receive events for source {0} because the connector to the OMRS Topic failed to initialize", "The local server will not connect to the cohort.", "The connection to the connector is configured in the server configuration.  Review previous error messages to determine the precise error in the start up configuration. Correct the configuration and reconnect the server to the cohort. "),
    PROCESS_NOT_FOUND(400, "OMAS-DATA-ENGINE-400-008", "Process with qualifiedName {0} was not found", "The system is unable to create a new ProcessHierarchy relation.", "Correct the code in the caller to provide the correct port qualified name."),
    DATABASE_NOT_FOUND(400, "OMAS-DATA-ENGINE-400-009", "Database with qualifiedName {0} was not found", "The system is unable to create a new table attached to database", "Correct the code in the caller to provide the correct database qualified name."),
    UNABLE_TO_SEND_EVENT(500, "OMAS-DATA-ENGINE-500-001", "An unexpected exception occurred when sending an event through connector {0} to the Data Engine OMAS out topic.  The failing event was {1}, the exception was {2} with message {2}", "The system has issued a call to an open metadata access service input topic using event message broker", "Look for errors in the remote server's audit log and console to understand and correct the source of the error.");

    private static final long serialVersionUID = 1L;
    private ExceptionMessageDefinition messageDefinition;

    private DataEngineErrorCode(int httpErrorCode, String errorMessageId, String errorMessage, String systemAction, String userAction) {
        this.messageDefinition = new ExceptionMessageDefinition(httpErrorCode, errorMessageId, errorMessage, systemAction, userAction);
    }

    public ExceptionMessageDefinition getMessageDefinition() {
        return this.messageDefinition;
    }

    public ExceptionMessageDefinition getMessageDefinition(String ... params) {
        this.messageDefinition.setMessageParameters(params);
        return this.messageDefinition;
    }
}

