/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.dataengine.model.OwnerType;
import org.odpi.openmetadata.accessservices.dataengine.model.Referenceable;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Asset
extends Referenceable {
    private static final long serialVersionUID = 1L;
    private String displayName;
    private String description;
    private String owner;
    private OwnerType ownerType;
    private List<String> zoneMembership;
    private String GUID;
    private String originOrganizationGUID;
    private String originBusinessCapabilityGUID;
    private Map<String, String> otherOriginValues;

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public OwnerType getOwnerType() {
        return this.ownerType;
    }

    public void setOwnerType(OwnerType ownerType) {
        this.ownerType = ownerType;
    }

    public List<String> getZoneMembership() {
        return this.zoneMembership;
    }

    public void setZoneMembership(List<String> zoneMembership) {
        this.zoneMembership = zoneMembership;
    }

    public String getOriginOrganizationGUID() {
        return this.originOrganizationGUID;
    }

    public void setOriginOrganizationGUID(String originOrganizationGUID) {
        this.originOrganizationGUID = originOrganizationGUID;
    }

    public String getOriginBusinessCapabilityGUID() {
        return this.originBusinessCapabilityGUID;
    }

    public void setOriginBusinessCapabilityGUID(String originBusinessCapabilityGUID) {
        this.originBusinessCapabilityGUID = originBusinessCapabilityGUID;
    }

    public Map<String, String> getOtherOriginValues() {
        return this.otherOriginValues;
    }

    public void setOtherOriginValues(Map<String, String> otherOriginValues) {
        this.otherOriginValues = otherOriginValues;
    }

    public String getGUID() {
        return this.GUID;
    }

    public void setGUID(String GUID) {
        this.GUID = GUID;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Asset asset = (Asset)o;
        return Objects.equals(this.displayName, asset.displayName) && Objects.equals(this.description, asset.description) && Objects.equals(this.owner, asset.owner) && this.ownerType == asset.ownerType && Objects.equals(this.zoneMembership, asset.zoneMembership) && Objects.equals(this.GUID, asset.GUID) && Objects.equals(this.originOrganizationGUID, asset.originOrganizationGUID) && Objects.equals(this.originBusinessCapabilityGUID, asset.originBusinessCapabilityGUID) && Objects.equals(this.otherOriginValues, asset.otherOriginValues);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.displayName, this.description, this.owner, this.ownerType, this.zoneMembership, this.GUID, this.originOrganizationGUID, this.originBusinessCapabilityGUID, this.otherOriginValues);
    }

    @Override
    public String toString() {
        return "Asset{displayName='" + this.displayName + '\'' + ", description='" + this.description + '\'' + ", owner='" + this.owner + '\'' + ", ownerType=" + this.ownerType + ", zoneMembership=" + this.zoneMembership + ", GUID='" + this.GUID + '\'' + ", originOrganizationGUID='" + this.originOrganizationGUID + '\'' + ", originBusinessCapabilityGUID='" + this.originBusinessCapabilityGUID + '\'' + ", otherOriginValues=" + this.otherOriginValues + '}';
    }
}

