/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.dataengine.event;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum DataEngineEventType implements Serializable
{
    UNKNOWN_DATA_ENGINE_EVENT(0, "Unknown Data Engine Job Event", "An event that is not recognized by the local server."),
    DATA_ENGINE_REGISTRATION_EVENT(1, "DataEngineRegistrationEvent", "An event that register a data engine as external source."),
    LINEAGE_MAPPINGS_EVENT(2, "LineageMappingsEvent", "An event that add or update lineage mappings."),
    PORT_ALIAS_EVENT(3, "PortAliasEvent", "An event that add or update port alias"),
    PORT_IMPLEMENTATION_EVENT(4, "PortImplementationEvent", "An event that create or update port implementations."),
    SCHEMA_TYPE_EVENT(5, "SchemaTypeEvent", "An event that create or update schema types."),
    PROCESS_HIERARCHY_EVENT(6, "ProcessHierarchyEvent", "An event to setup a process hierarchy."),
    DELETE_DATA_ENGINE_EVENT(7, "DeleteDataEngineEvent", "An event that deletes an external data engine."),
    DELETE_SCHEMA_TYPE_EVENT(8, "DeleteSchemaTypeEvent", "An event that deletes a schema type."),
    DELETE_PORT_IMPLEMENTATION_EVENT(9, "DeletePortImplementationEvent", "An event that deletes a port implementation."),
    DELETE_PORT_ALIAS_EVENT(10, "DeletePortAliasesEvent", "An event that deletes a port alias."),
    DATABASE_EVENT(11, "DatabaseEvent", "An event that create or update databases."),
    RELATIONAL_TABLE_EVENT(12, "RelationalTableEvent", "An event that create or update relational tables."),
    DATA_FILE_EVENT(13, "DataFileEvent", "An event that create or update data files."),
    DELETE_DATABASE_EVENT(14, "DeleteDatabaseEvent", "An event that deletes a database."),
    DELETE_RELATIONAL_TABLE_EVENT(15, "DeleteRelationalTableEvent", "An event that deletes a relational table."),
    DELETE_DATA_FILE_EVENT(16, "DeleteDataFileEvent", "An event that deletes a data file."),
    DELETE_FOLDER_EVENT(17, "DeleteFolderEvent", "An event that deletes a folder."),
    DELETE_CONNECTION_EVENT(18, "DeleteConnectionEvent", "An event that deletes a connection."),
    DELETE_ENDPOINT_EVENT(19, "DeleteEndpointEvent", "An event that deletes an endpoint."),
    PROCESS_EVENT(20, "ProcessEvent", "An event that create or update a process."),
    DELETE_PROCESS_EVENT(21, "DeleteProcessEvent", "An event that deletes a process.");

    private static final long serialVersionUID = 1L;
    private final int eventTypeCode;
    private final String eventTypeName;
    private final String eventTypeDescription;

    private DataEngineEventType(int eventTypeCode, String eventTypeName, String eventTypeDescription) {
        this.eventTypeCode = eventTypeCode;
        this.eventTypeName = eventTypeName;
        this.eventTypeDescription = eventTypeDescription;
    }

    public String toString() {
        return "DataEngineEventType." + this.name() + "(eventTypeCode=" + this.getEventTypeCode() + ", eventTypeName=" + this.getEventTypeName() + ", eventTypeDescription=" + this.getEventTypeDescription() + ")";
    }

    public int getEventTypeCode() {
        return this.eventTypeCode;
    }

    public String getEventTypeName() {
        return this.eventTypeName;
    }

    public String getEventTypeDescription() {
        return this.eventTypeDescription;
    }
}

